/*
 * Decompiled with CFR 0.152.
 */
package treeminer;

public class Scope
implements Comparable<Scope> {
    private int upperBound;
    private int lowerBound;

    public Scope(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public Scope() {
        this.lowerBound = -1;
        this.upperBound = -1;
    }

    public boolean contains(Scope other) {
        if (this.lowerBound <= other.lowerBound && other.upperBound <= this.upperBound) {
            return other.upperBound != this.upperBound || other.lowerBound != this.lowerBound;
        }
        return false;
    }

    public boolean isStrictlyLessThan(Scope other) {
        return this.upperBound < other.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.lowerBound);
        builder.append(", ");
        builder.append(this.upperBound);
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int compareTo(Scope o) {
        if (this.lowerBound < o.lowerBound) {
            return -1;
        }
        if (this.lowerBound == o.lowerBound) {
            if (this.upperBound < o.upperBound) {
                return -1;
            }
            if (this.upperBound == o.upperBound) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Scope other = (Scope)o;
        return other.upperBound == this.upperBound && other.lowerBound == this.lowerBound;
    }

    public int hashCode() {
        int result = 42;
        result = result * 37 + this.upperBound;
        result = result * 37 + this.lowerBound;
        return result;
    }

    public Scope clone() {
        return new Scope(this.lowerBound, this.upperBound);
    }
}

