/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.core.net.interception.logging;

import android.text.TextUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.hgj.jetpackmvvm.core.net.interception.LogInterceptor;
import me.hgj.jetpackmvvm.core.net.interception.logging.FormatPrinter;
import me.hgj.jetpackmvvm.core.net.interception.logging.util.CharacterHandler;
import me.hgj.jetpackmvvm.core.net.interception.logging.util.LogUtils;
import okhttp3.MediaType;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\\\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0016JH\u0010\u0019\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0016\u00a8\u0006\u001b"}, d2={"Lme/hgj/jetpackmvvm/core/net/interception/logging/DefaultFormatPrinter;", "Lme/hgj/jetpackmvvm/core/net/interception/logging/FormatPrinter;", "<init>", "()V", "printJsonRequest", "", "request", "Lokhttp3/Request;", "bodyString", "", "printFileRequest", "printJsonResponse", "chainMs", "", "isSuccessful", "", "code", "", "headers", "contentType", "Lokhttp3/MediaType;", "segments", "", "message", "responseUrl", "printFileResponse", "Companion", "JetpackMvvm_release"})
@SourceDebugExtension(value={"SMAP\nDefaultFormatPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFormatPrinter.kt\nme/hgj/jetpackmvvm/core/net/interception/logging/DefaultFormatPrinter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,360:1\n37#2:361\n36#2,3:362\n37#2:365\n36#2,3:366\n*S KotlinDebug\n*F\n+ 1 DefaultFormatPrinter.kt\nme/hgj/jetpackmvvm/core/net/interception/logging/DefaultFormatPrinter\n*L\n44#1:361\n44#1:362,3\n132#1:365\n132#1:366,3\n*E\n"})
public final class DefaultFormatPrinter
implements FormatPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "HttpLog";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @NotNull
    private static final String DOUBLE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;
    @NotNull
    private static final String[] OMITTED_RESPONSE;
    @NotNull
    private static final String[] OMITTED_REQUEST;
    @NotNull
    private static final String N = "\n";
    @NotNull
    private static final String T = "\t";
    @NotNull
    private static final String REQUEST_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Request \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    @NotNull
    private static final String END_LINE = "   \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    @NotNull
    private static final String RESPONSE_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Response \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    @NotNull
    private static final String BODY_TAG = "Body:";
    @NotNull
    private static final String URL_TAG = "URL: ";
    @NotNull
    private static final String METHOD_TAG = "Method: @";
    @NotNull
    private static final String HEADERS_TAG = "Headers:";
    @NotNull
    private static final String STATUS_CODE_TAG = "Status Code: ";
    @NotNull
    private static final String RECEIVED_TAG = "Received in: ";
    @NotNull
    private static final String CORNER_UP = "\u250c ";
    @NotNull
    private static final String CORNER_BOTTOM = "\u2514 ";
    @NotNull
    private static final String CENTER_LINE = "\u251c ";
    @NotNull
    private static final String DEFAULT_LINE = "\u2502 ";
    @NotNull
    private static final String[] ARMS;
    @NotNull
    private static final ThreadLocal<Integer> last;

    @Override
    public void printJsonRequest(@NotNull Request request, @NotNull String bodyString) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)bodyString, (String)"bodyString");
        String requestBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString;
        String tag = DefaultFormatPrinter.Companion.getTag(true);
        LogUtils.Companion.debugInfo(tag, REQUEST_UP_LINE);
        String[] stringArray = new String[]{URL_TAG + request.url()};
        DefaultFormatPrinter.Companion.logLines(tag, stringArray, false);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getRequest(request), true);
        CharSequence charSequence = requestBody;
        stringArray = new String[1];
        Intrinsics.checkNotNull((Object)LINE_SEPARATOR);
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DefaultFormatPrinter.Companion.logLines(tag, thisCollection$iv.toArray(new String[0]), true);
        LogUtils.Companion.debugInfo(tag, END_LINE);
    }

    @Override
    public void printFileRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String tag = DefaultFormatPrinter.Companion.getTag(true);
        LogUtils.Companion.debugInfo(tag, REQUEST_UP_LINE);
        String[] stringArray = new String[]{URL_TAG + request.url()};
        DefaultFormatPrinter.Companion.logLines(tag, stringArray, false);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getRequest(request), true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.OMITTED_REQUEST, true);
        LogUtils.Companion.debugInfo(tag, END_LINE);
    }

    @Override
    public void printJsonResponse(long chainMs, boolean isSuccessful, int code, @NotNull String headers, @Nullable MediaType contentType, @Nullable String bodyString, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)responseUrl, (String)"responseUrl");
        String bodyString2 = bodyString;
        if (LogInterceptor.Companion.isJson(contentType)) {
            String string3 = bodyString2;
            Intrinsics.checkNotNull((Object)string3);
            string2 = CharacterHandler.Companion.jsonFormat(string3);
        } else {
            string2 = LogInterceptor.Companion.isXml(contentType) ? CharacterHandler.Companion.xmlFormat(bodyString2) : bodyString2;
        }
        bodyString2 = string2;
        String responseBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString2;
        String tag = DefaultFormatPrinter.Companion.getTag(false);
        String[] stringArray = new String[]{URL_TAG + responseUrl, N};
        String[] urlLine = stringArray;
        LogUtils.Companion.debugInfo(tag, RESPONSE_UP_LINE);
        DefaultFormatPrinter.Companion.logLines(tag, urlLine, true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getResponse(headers, chainMs, code, isSuccessful, segments, message), true);
        CharSequence charSequence = responseBody;
        stringArray = new String[1];
        Intrinsics.checkNotNull((Object)LINE_SEPARATOR);
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DefaultFormatPrinter.Companion.logLines(tag, thisCollection$iv.toArray(new String[0]), true);
        LogUtils.Companion.debugInfo(tag, END_LINE);
    }

    @Override
    public void printFileResponse(long chainMs, boolean isSuccessful, int code, @NotNull String headers, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)responseUrl, (String)"responseUrl");
        String tag = DefaultFormatPrinter.Companion.getTag(false);
        String[] stringArray = new String[]{URL_TAG + responseUrl, N};
        String[] urlLine = stringArray;
        LogUtils.Companion.debugInfo(tag, RESPONSE_UP_LINE);
        DefaultFormatPrinter.Companion.logLines(tag, urlLine, true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getResponse(headers, chainMs, code, isSuccessful, segments, message), true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.OMITTED_RESPONSE, true);
        LogUtils.Companion.debugInfo(tag, END_LINE);
    }

    static {
        String[] stringArray = new String[]{LINE_SEPARATOR, "Omitted response body"};
        OMITTED_RESPONSE = stringArray;
        stringArray = new String[]{LINE_SEPARATOR, "Omitted request body"};
        OMITTED_REQUEST = stringArray;
        stringArray = new String[]{"-A-", "-R-", "-M-", "-S-"};
        ARMS = stringArray;
        last = new ThreadLocal<Integer>(){

            protected Integer initialValue() {
                return 0;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0002J-\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\n2\u0006\u0010'\u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\u001d\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\n2\u0006\u0010,\u001a\u00020-H\u0002\u00a2\u0006\u0002\u0010.JM\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\n2\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020!2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0005062\u0006\u00107\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020\u00052\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000506H\u0002J\u0010\u0010:\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005H\u0002J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00050\u00050\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001e\u0010\f\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00050\u00050\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lme/hgj/jetpackmvvm/core/net/interception/logging/DefaultFormatPrinter$Companion;", "", "<init>", "()V", "TAG", "", "LINE_SEPARATOR", "kotlin.jvm.PlatformType", "DOUBLE_SEPARATOR", "OMITTED_RESPONSE", "", "[Ljava/lang/String;", "OMITTED_REQUEST", "N", "T", "REQUEST_UP_LINE", "END_LINE", "RESPONSE_UP_LINE", "BODY_TAG", "URL_TAG", "METHOD_TAG", "HEADERS_TAG", "STATUS_CODE_TAG", "RECEIVED_TAG", "CORNER_UP", "CORNER_BOTTOM", "CENTER_LINE", "DEFAULT_LINE", "ARMS", "last", "Ljava/lang/ThreadLocal;", "", "isEmpty", "", "line", "logLines", "", "tag", "lines", "withLineSize", "(Ljava/lang/String;[Ljava/lang/String;Z)V", "computeKey", "resolveTag", "getRequest", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;)[Ljava/lang/String;", "getResponse", "header", "tookMs", "", "code", "isSuccessful", "segments", "", "message", "(Ljava/lang/String;JIZLjava/util/List;Ljava/lang/String;)[Ljava/lang/String;", "slashSegments", "dotHeaders", "getTag", "isRequest", "JetpackMvvm_release"})
    @SourceDebugExtension(value={"SMAP\nDefaultFormatPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFormatPrinter.kt\nme/hgj/jetpackmvvm/core/net/interception/logging/DefaultFormatPrinter$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,360:1\n106#2:361\n78#2,22:362\n37#3:384\n36#3,3:385\n37#3:388\n36#3,3:389\n37#3:392\n36#3,3:393\n*S KotlinDebug\n*F\n+ 1 DefaultFormatPrinter.kt\nme/hgj/jetpackmvvm/core/net/interception/logging/DefaultFormatPrinter$Companion\n*L\n226#1:361\n226#1:362,22\n293#1:384\n293#1:385,3\n311#1:388\n311#1:389,3\n330#1:392\n330#1:393,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmpty(String line) {
            if (TextUtils.isEmpty((CharSequence)line)) return true;
            if (Intrinsics.areEqual((Object)DefaultFormatPrinter.N, (Object)line)) return true;
            if (Intrinsics.areEqual((Object)DefaultFormatPrinter.T, (Object)line)) return true;
            String $this$trim$iv = line;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!TextUtils.isEmpty((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) return false;
            return true;
        }

        private final void logLines(String tag, String[] lines, boolean withLineSize) {
            int n = lines.length;
            block0: for (int i = 0; i < n; ++i) {
                String line;
                String string2 = line = lines[i];
                Intrinsics.checkNotNull((Object)string2);
                int lineLength = string2.length();
                int maxLongSize = withLineSize ? 110 : lineLength;
                int i2 = 0;
                int n2 = lineLength / maxLongSize;
                if (i2 > n2) continue;
                while (true) {
                    int start = i2 * maxLongSize;
                    int end = (i2 + 1) * maxLongSize;
                    end = end > line.length() ? line.length() : end;
                    String string3 = this.resolveTag(tag);
                    String string4 = line.substring(start, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    LogUtils.Companion.debugInfo(string3, DefaultFormatPrinter.DEFAULT_LINE + string4);
                    if (i2 == n2) continue block0;
                    ++i2;
                }
            }
        }

        private final String computeKey() {
            Object t = last.get();
            Intrinsics.checkNotNull(t);
            if (((Number)t).intValue() >= 4) {
                last.set(0);
            }
            String[] stringArray = ARMS;
            Object t2 = last.get();
            Intrinsics.checkNotNull(t2);
            String s = stringArray[((Number)t2).intValue()];
            ThreadLocal threadLocal = last;
            Object t3 = last.get();
            Intrinsics.checkNotNull(t3);
            threadLocal.set(((Number)t3).intValue() + 1);
            return s;
        }

        private final String resolveTag(String tag) {
            return this.computeKey() + tag;
        }

        private final String[] getRequest(Request request) {
            String log = null;
            String header = request.headers().toString();
            log = DefaultFormatPrinter.METHOD_TAG + request.method() + DOUBLE_SEPARATOR + (String)(this.isEmpty(header) ? "" : DefaultFormatPrinter.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(header));
            CharSequence charSequence = log;
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull((Object)LINE_SEPARATOR);
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        private final String[] getResponse(String header, long tookMs, int code, boolean isSuccessful, List<String> segments, String message) {
            String log = null;
            String segmentString = this.slashSegments(segments);
            log = (String)(!TextUtils.isEmpty((CharSequence)segmentString) ? segmentString + " - " : "") + "is success : " + isSuccessful + " - Received in: " + tookMs + "ms" + DOUBLE_SEPARATOR + DefaultFormatPrinter.STATUS_CODE_TAG + code + " / " + message + DOUBLE_SEPARATOR + (String)(this.isEmpty(header) ? "" : DefaultFormatPrinter.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(header));
            CharSequence charSequence = log;
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull((Object)LINE_SEPARATOR);
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        private final String slashSegments(List<String> segments) {
            StringBuilder segmentString = new StringBuilder();
            for (String segment : segments) {
                segmentString.append("/").append(segment);
            }
            String string2 = segmentString.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private final String dotHeaders(String header) {
            CharSequence charSequence = header;
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull((Object)LINE_SEPARATOR);
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] headers = thisCollection$iv.toArray(new String[0]);
            StringBuilder builder = new StringBuilder();
            String tag = "\u2500 ";
            if (headers.length > 1) {
                int n = headers.length;
                for (int i = 0; i < n; ++i) {
                    tag = i == 0 ? DefaultFormatPrinter.CORNER_UP : (i == headers.length - 1 ? DefaultFormatPrinter.CORNER_BOTTOM : DefaultFormatPrinter.CENTER_LINE);
                    builder.append(tag).append(headers[i]).append(DefaultFormatPrinter.N);
                }
            } else {
                for (String item : headers) {
                    builder.append(tag).append(item).append(DefaultFormatPrinter.N);
                }
            }
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private final String getTag(boolean isRequest) {
            return isRequest ? "HttpLog-Request" : "HttpLog-Response";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

