/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.ext.util;

import android.os.Parcelable;
import com.tencent.mmkv.MMKV;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import me.hgj.jetpackmvvm.ext.util.CacheKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B-\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\f\u001a\u0004\u0018\u00018\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u00032\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0014\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0005H\u0002\u00a2\u0006\u0002\u0010\u0015J.\u0010\u0016\u001a\u00020\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u00032\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/hgj/jetpackmvvm/ext/util/CacheNullable;", "T", "Lkotlin/properties/ReadWriteProperty;", "", "clazz", "Ljava/lang/Class;", "default", "key", "", "<init>", "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/String;)V", "Ljava/lang/Object;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "decodeWithDefault", "R", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "decodeByClass", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "setValue", "", "value", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "JetpackMvvm_release"})
public final class CacheNullable<T>
implements ReadWriteProperty<Object, T> {
    @NotNull
    private final Class<T> clazz;
    @Nullable
    private final T default;
    @Nullable
    private final String key;

    public CacheNullable(@NotNull Class<T> clazz, @Nullable T t, @Nullable String key) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.clazz = clazz;
        this.default = t;
        this.key = key;
    }

    public /* synthetic */ CacheNullable(Class clazz, Object object, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(clazz, object, string2);
    }

    @Nullable
    public T getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        String actualKey;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        String string2 = this.key;
        if (string2 == null) {
            string2 = actualKey = property.getName();
        }
        if (this.default != null) {
            return this.decodeWithDefault(actualKey, this.default);
        }
        return this.decodeByClass(actualKey, this.clazz);
    }

    private final <R> R decodeWithDefault(String key, R r) {
        Object object;
        R r2 = r;
        if (r2 instanceof Boolean) {
            object = CacheKt.getMmkv().decodeBool(key, ((Boolean)r).booleanValue());
        } else if (r2 instanceof Integer) {
            object = CacheKt.getMmkv().decodeInt(key, ((Number)r).intValue());
        } else if (r2 instanceof Long) {
            object = CacheKt.getMmkv().decodeLong(key, ((Number)r).longValue());
        } else if (r2 instanceof Float) {
            object = Float.valueOf(CacheKt.getMmkv().decodeFloat(key, ((Number)r).floatValue()));
        } else if (r2 instanceof Double) {
            object = CacheKt.getMmkv().decodeDouble(key, ((Number)r).doubleValue());
        } else if (r2 instanceof String) {
            object = CacheKt.getMmkv().decodeString(key, (String)r);
        } else if (r2 instanceof byte[]) {
            object = CacheKt.getMmkv().decodeBytes(key, (byte[])r);
        } else if (r2 instanceof Set) {
            MMKV mMKV = CacheKt.getMmkv();
            R r3 = r;
            Intrinsics.checkNotNull(r3, (String)"null cannot be cast to non-null type kotlin.collections.Set<kotlin.String>");
            object = mMKV.decodeStringSet(key, (Set)r3);
        } else if (r2 instanceof Parcelable) {
            MMKV mMKV = CacheKt.getMmkv();
            Class<?> clazz = r.getClass();
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<android.os.Parcelable>");
            object = mMKV.decodeParcelable(key, clazz, (Parcelable)r);
        } else {
            R r4 = r;
            Intrinsics.checkNotNull(r4);
            throw new IllegalArgumentException("Unsupported type: " + r4.getClass());
        }
        return (R)object;
    }

    private final <R> R decodeByClass(String key, Class<R> clazz) {
        Object object;
        if (!CacheKt.getMmkv().contains(key)) {
            return null;
        }
        if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
            object = CacheKt.getMmkv().decodeBool(key, false);
        } else if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            object = CacheKt.getMmkv().decodeInt(key, 0);
        } else if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            object = CacheKt.getMmkv().decodeLong(key, 0L);
        } else if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            object = Float.valueOf(CacheKt.getMmkv().decodeFloat(key, 0.0f));
        } else if (Intrinsics.areEqual(clazz, Double.TYPE)) {
            object = CacheKt.getMmkv().decodeDouble(key, 0.0);
        } else if (Intrinsics.areEqual(clazz, String.class)) {
            object = CacheKt.getMmkv().decodeString(key, null);
        } else if (Intrinsics.areEqual(clazz, byte[].class)) {
            object = CacheKt.getMmkv().decodeBytes(key, null);
        } else if (Set.class.isAssignableFrom(clazz)) {
            object = CacheKt.getMmkv().decodeStringSet(key, null);
        } else if (Parcelable.class.isAssignableFrom(clazz)) {
            MMKV mMKV = CacheKt.getMmkv();
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<android.os.Parcelable>");
            object = mMKV.decodeParcelable(key, clazz, null);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + clazz);
        }
        return (R)object;
    }

    public void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, @Nullable T value) {
        String actualKey;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        String string2 = this.key;
        if (string2 == null) {
            string2 = actualKey = property.getName();
        }
        if (value == null) {
            CacheKt.getMmkv().removeValueForKey(actualKey);
            return;
        }
        T t = value;
        if (t instanceof Boolean) {
            v1 = CacheKt.getMmkv().encode(actualKey, ((Boolean)value).booleanValue());
        } else if (t instanceof Integer) {
            v1 = CacheKt.getMmkv().encode(actualKey, ((Number)value).intValue());
        } else if (t instanceof Long) {
            v1 = CacheKt.getMmkv().encode(actualKey, ((Number)value).longValue());
        } else if (t instanceof Float) {
            v1 = CacheKt.getMmkv().encode(actualKey, ((Number)value).floatValue());
        } else if (t instanceof Double) {
            v1 = CacheKt.getMmkv().encode(actualKey, ((Number)value).doubleValue());
        } else if (t instanceof String) {
            v1 = CacheKt.getMmkv().encode(actualKey, (String)value);
        } else if (t instanceof byte[]) {
            v1 = CacheKt.getMmkv().encode(actualKey, (byte[])value);
        } else if (t instanceof Set) {
            v1 = CacheKt.getMmkv().encode(actualKey, (Set)value);
        } else if (t instanceof Parcelable) {
            v1 = CacheKt.getMmkv().encode(actualKey, (Parcelable)value);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass());
        }
    }
}

