/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.network.interceptor.logging;

import android.text.TextUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.hgj.jetpackmvvm.network.interceptor.logging.FormatPrinter;
import me.hgj.jetpackmvvm.network.interceptor.logging.LogInterceptor;
import me.hgj.jetpackmvvm.util.CharacterHandler;
import me.hgj.jetpackmvvm.util.LogUtils;
import okhttp3.MediaType;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JH\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\\\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016\u00a8\u0006\u001a"}, d2={"Lme/hgj/jetpackmvvm/network/interceptor/logging/DefaultFormatPrinter;", "Lme/hgj/jetpackmvvm/network/interceptor/logging/FormatPrinter;", "()V", "printFileRequest", "", "request", "Lokhttp3/Request;", "printFileResponse", "chainMs", "", "isSuccessful", "", "code", "", "headers", "", "segments", "", "message", "responseUrl", "printJsonRequest", "bodyString", "printJsonResponse", "contentType", "Lokhttp3/MediaType;", "Companion", "JetpackMvvm_debug"})
public final class DefaultFormatPrinter
implements FormatPrinter {
    private static final String TAG = "HttpLog";
    private static final String LINE_SEPARATOR;
    private static final String DOUBLE_SEPARATOR;
    private static final String[] OMITTED_RESPONSE;
    private static final String[] OMITTED_REQUEST;
    private static final String N = "\n";
    private static final String T = "\t";
    private static final String REQUEST_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Request \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String END_LINE = "   \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String RESPONSE_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Response \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BODY_TAG = "Body:";
    private static final String URL_TAG = "URL: ";
    private static final String METHOD_TAG = "Method: @";
    private static final String HEADERS_TAG = "Headers:";
    private static final String STATUS_CODE_TAG = "Status Code: ";
    private static final String RECEIVED_TAG = "Received in: ";
    private static final String CORNER_UP = "\u250c ";
    private static final String CORNER_BOTTOM = "\u2514 ";
    private static final String CENTER_LINE = "\u251c ";
    private static final String DEFAULT_LINE = "\u2502 ";
    private static final String[] ARMS;
    private static final ThreadLocal<Integer> last;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    public void printJsonRequest(@NotNull Request request2, @NotNull String bodyString) {
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)bodyString, (String)"bodyString");
        String requestBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString;
        String tag = DefaultFormatPrinter.Companion.getTag(true);
        LogUtils.INSTANCE.debugInfo(tag, REQUEST_UP_LINE);
        DefaultFormatPrinter.Companion.logLines(tag, new String[]{URL_TAG + request2.url()}, false);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getRequest(request2), true);
        CharSequence charSequence = requestBody;
        String[] stringArray = new String[1];
        String string = LINE_SEPARATOR;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        stringArray[0] = string;
        Collection collection = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string2 = tag;
        Companion companion = Companion;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray2;
        companion.logLines(string2, stringArray3, true);
        LogUtils.INSTANCE.debugInfo(tag, END_LINE);
    }

    @Override
    public void printFileRequest(@NotNull Request request2) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        String tag = DefaultFormatPrinter.Companion.getTag(true);
        LogUtils.INSTANCE.debugInfo(tag, REQUEST_UP_LINE);
        DefaultFormatPrinter.Companion.logLines(tag, new String[]{URL_TAG + request2.url()}, false);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getRequest(request2), true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.OMITTED_REQUEST, true);
        LogUtils.INSTANCE.debugInfo(tag, END_LINE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printJsonResponse(long chainMs, boolean isSuccessful, int code, @NotNull String headers, @Nullable MediaType contentType, @Nullable String bodyString, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
        void $this$toTypedArray$iv;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull(segments, (String)"segments");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)responseUrl, (String)"responseUrl");
        String bodyString2 = bodyString;
        if (LogInterceptor.Companion.isJson(contentType)) {
            String string2 = bodyString2;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = CharacterHandler.Companion.jsonFormat(string2);
        } else {
            string = LogInterceptor.Companion.isXml(contentType) ? CharacterHandler.Companion.xmlFormat(bodyString2) : bodyString2;
        }
        bodyString2 = string;
        String responseBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString2;
        String tag = DefaultFormatPrinter.Companion.getTag(false);
        String[] urlLine = new String[]{URL_TAG + responseUrl, N};
        LogUtils.INSTANCE.debugInfo(tag, RESPONSE_UP_LINE);
        DefaultFormatPrinter.Companion.logLines(tag, urlLine, true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getResponse(headers, chainMs, code, isSuccessful, segments, message), true);
        CharSequence charSequence = responseBody;
        String[] stringArray = new String[1];
        String string3 = LINE_SEPARATOR;
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        stringArray[0] = string3;
        Collection collection = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string4 = tag;
        Companion companion = Companion;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray2;
        companion.logLines(string4, stringArray3, true);
        LogUtils.INSTANCE.debugInfo(tag, END_LINE);
    }

    @Override
    public void printFileResponse(long chainMs, boolean isSuccessful, int code, @NotNull String headers, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull(segments, (String)"segments");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)responseUrl, (String)"responseUrl");
        String tag = DefaultFormatPrinter.Companion.getTag(false);
        String[] urlLine = new String[]{URL_TAG + responseUrl, N};
        LogUtils.INSTANCE.debugInfo(tag, RESPONSE_UP_LINE);
        DefaultFormatPrinter.Companion.logLines(tag, urlLine, true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.Companion.getResponse(headers, chainMs, code, isSuccessful, segments, message), true);
        DefaultFormatPrinter.Companion.logLines(tag, DefaultFormatPrinter.OMITTED_RESPONSE, true);
        LogUtils.INSTANCE.debugInfo(tag, END_LINE);
    }

    static {
        Companion = new Companion(null);
        LINE_SEPARATOR = System.getProperty("line.separator");
        DOUBLE_SEPARATOR = Intrinsics.stringPlus((String)LINE_SEPARATOR, (Object)LINE_SEPARATOR);
        OMITTED_RESPONSE = new String[]{LINE_SEPARATOR, "Omitted response body"};
        OMITTED_REQUEST = new String[]{LINE_SEPARATOR, "Omitted request body"};
        ARMS = new String[]{"-A-", "-R-", "-M-", "-S-"};
        last = new ThreadLocal<Integer>(){

            @NotNull
            protected Integer initialValue() {
                return 0;
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001d\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$JM\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010 \u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050,2\u0006\u0010-\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020*H\u0002J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\u0005H\u0002J-\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00052\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u00107\u001a\u00020*H\u0002\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005H\u0002J\u0018\u0010:\u001a\u00020\u00052\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050,H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lme/hgj/jetpackmvvm/network/interceptor/logging/DefaultFormatPrinter$Companion;", "", "()V", "ARMS", "", "", "[Ljava/lang/String;", "BODY_TAG", "CENTER_LINE", "CORNER_BOTTOM", "CORNER_UP", "DEFAULT_LINE", "DOUBLE_SEPARATOR", "END_LINE", "HEADERS_TAG", "LINE_SEPARATOR", "METHOD_TAG", "N", "OMITTED_REQUEST", "OMITTED_RESPONSE", "RECEIVED_TAG", "REQUEST_UP_LINE", "RESPONSE_UP_LINE", "STATUS_CODE_TAG", "T", "TAG", "URL_TAG", "last", "Ljava/lang/ThreadLocal;", "", "computeKey", "dotHeaders", "header", "getRequest", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;)[Ljava/lang/String;", "getResponse", "tookMs", "", "code", "isSuccessful", "", "segments", "", "message", "(Ljava/lang/String;JIZLjava/util/List;Ljava/lang/String;)[Ljava/lang/String;", "getTag", "isRequest", "isEmpty", "line", "logLines", "", "tag", "lines", "withLineSize", "(Ljava/lang/String;[Ljava/lang/String;Z)V", "resolveTag", "slashSegments", "JetpackMvvm_debug"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmpty(String line) {
            if (TextUtils.isEmpty((CharSequence)line)) return true;
            if (Intrinsics.areEqual((Object)DefaultFormatPrinter.N, (Object)line)) return true;
            if (Intrinsics.areEqual((Object)DefaultFormatPrinter.T, (Object)line)) return true;
            String $this$trim$iv = line;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!TextUtils.isEmpty((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final void logLines(String tag, String[] lines, boolean withLineSize) {
            String[] stringArray = lines;
            int n = stringArray.length;
            block0: for (int i = 0; i < n; ++i) {
                int maxLongSize;
                int lineLength;
                int n2;
                int n3;
                String line;
                String string = line = stringArray[i];
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((n3 = 0) > (n2 = (lineLength = string.length()) / (maxLongSize = withLineSize ? 110 : lineLength))) continue;
                while (true) {
                    String string2;
                    void i2;
                    void start = i2 * maxLongSize;
                    int end = (i2 + true) * maxLongSize;
                    end = end > line.length() ? line.length() : end;
                    String string3 = line;
                    StringBuilder stringBuilder = new StringBuilder().append(DefaultFormatPrinter.DEFAULT_LINE);
                    String string4 = this.resolveTag(tag);
                    LogUtils logUtils = LogUtils.INSTANCE;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring((int)start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    logUtils.debugInfo(string4, stringBuilder.append(string2).toString());
                    if (i2 == n2) continue block0;
                    ++i2;
                }
            }
        }

        private final String computeKey() {
            Object t = last.get();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.compare((int)((Number)t).intValue(), (int)4) >= 0) {
                last.set(0);
            }
            String[] stringArray = ARMS;
            Object t2 = last.get();
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"last.get()!!");
            String s = stringArray[((Number)t2).intValue()];
            ThreadLocal threadLocal = last;
            Object t3 = last.get();
            if (t3 == null) {
                Intrinsics.throwNpe();
            }
            threadLocal.set(((Number)t3).intValue() + 1);
            return s;
        }

        private final String resolveTag(String tag) {
            return this.computeKey() + tag;
        }

        private final String[] getRequest(Request request2) {
            String log = null;
            String string = request2.headers().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.headers().toString()");
            String header = string;
            log = DefaultFormatPrinter.METHOD_TAG + request2.method() + DOUBLE_SEPARATOR + (this.isEmpty(header) ? "" : DefaultFormatPrinter.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(header));
            CharSequence charSequence = log;
            String[] stringArray = new String[1];
            String string2 = LINE_SEPARATOR;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            stringArray[0] = string2;
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray2;
        }

        private final String[] getResponse(String header, long tookMs, int code, boolean isSuccessful, List<String> segments, String message) {
            String log = null;
            String segmentString = this.slashSegments(segments);
            log = (!TextUtils.isEmpty((CharSequence)segmentString) ? segmentString + " - " : "") + "is success : " + isSuccessful + " - " + DefaultFormatPrinter.RECEIVED_TAG + tookMs + "ms" + DOUBLE_SEPARATOR + DefaultFormatPrinter.STATUS_CODE_TAG + code + " / " + message + DOUBLE_SEPARATOR + (this.isEmpty(header) ? "" : DefaultFormatPrinter.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(header));
            CharSequence charSequence = log;
            String[] stringArray = new String[1];
            String string = LINE_SEPARATOR;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            stringArray[0] = string;
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray2;
        }

        private final String slashSegments(List<String> segments) {
            StringBuilder segmentString = new StringBuilder();
            for (String segment : segments) {
                segmentString.append("/").append(segment);
            }
            String string = segmentString.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"segmentString.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String dotHeaders(String header) {
            CharSequence charSequence = header;
            String[] stringArray = new String[1];
            String string = LINE_SEPARATOR;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            stringArray[0] = string;
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] headers = stringArray2;
            StringBuilder builder = new StringBuilder();
            String tag = "\u2500 ";
            if (headers.length > 1) {
                int thisCollection$iv2 = 0;
                int n = headers.length;
                while (thisCollection$iv2 < n) {
                    void i;
                    tag = i == false ? DefaultFormatPrinter.CORNER_UP : (i == headers.length - 1 ? DefaultFormatPrinter.CORNER_BOTTOM : DefaultFormatPrinter.CENTER_LINE);
                    builder.append(tag).append(headers[i]).append(DefaultFormatPrinter.N);
                    ++i;
                }
            } else {
                for (String item : headers) {
                    builder.append(tag).append(item).append(DefaultFormatPrinter.N);
                }
            }
            String string2 = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
            return string2;
        }

        private final String getTag(boolean isRequest) {
            return isRequest ? "HttpLog-Request" : "HttpLog-Response";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

