/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.internals;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import com.obsez.android.lib.filechooser.internals.UiUtil;

public class WrappedDrawable
extends Drawable {
    private final Drawable _drawable;

    protected Drawable getDrawable() {
        return this._drawable;
    }

    public WrappedDrawable(Drawable drawable2) {
        this._drawable = drawable2;
    }

    public WrappedDrawable(Drawable drawable2, float widthInDp, float heightInDp) {
        this._drawable = drawable2;
        this.setBounds(0, 0, (int)UiUtil.dip2px(widthInDp), (int)UiUtil.dip2px(heightInDp));
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.setBounds(left, top, right, bottom);
        }
    }

    public void setBoundsInDp(float left, float top, float right, float bottom) {
        super.setBounds((int)UiUtil.dip2px(left), (int)UiUtil.dip2px(top), (int)UiUtil.dip2px(right), (int)UiUtil.dip2px(bottom));
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.setBounds((int)UiUtil.dip2px(left), (int)UiUtil.dip2px(top), (int)UiUtil.dip2px(right), (int)UiUtil.dip2px(bottom));
        }
    }

    public void setAlpha(int alpha) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.setAlpha(alpha);
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.setColorFilter(colorFilter);
        }
    }

    public int getOpacity() {
        Drawable drawable2 = this.getDrawable();
        return drawable2 != null ? drawable2.getOpacity() : 0;
    }

    public void draw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.draw(canvas);
        }
    }

    public int getIntrinsicWidth() {
        Drawable drawable2 = this.getDrawable();
        return drawable2 != null ? drawable2.getBounds().width() : 0;
    }

    public int getIntrinsicHeight() {
        Drawable drawable2 = this.getDrawable();
        return drawable2 != null ? drawable2.getBounds().height() : 0;
    }
}

