/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.obsez.android.lib.filechooser.R;
import com.obsez.android.lib.filechooser.internals.ExtFileFilter;
import com.obsez.android.lib.filechooser.internals.RegexFileFilter;
import com.obsez.android.lib.filechooser.tool.DirAdapter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ChooserDialog
implements AdapterView.OnItemClickListener,
DialogInterface.OnClickListener {
    private List<File> _entries = new ArrayList<File>();
    private File _currentDir;
    private Context _context;
    private AlertDialog _alertDialog;
    private ListView _list;
    private Result _result = null;
    private boolean _dirOnly;
    private FileFilter _fileFilter;
    @StringRes
    private int _titleRes = R.string.choose_file;
    @StringRes
    private int _okRes = R.string.title_choose;
    @StringRes
    private int _negativeRes = R.string.dialog_cancel;
    @DrawableRes
    private int _iconRes = -1;
    @LayoutRes
    private int _layoutRes = -1;
    @LayoutRes
    private int _rowLayoutRes = -1;
    private String _dateFormat;
    private DialogInterface.OnClickListener _negativeListener;
    private DialogInterface.OnCancelListener _cancelListener2;
    private AdapterSetter _adapterSetter = null;
    private static final FileFilter filterDirectoriesOnly = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static final FileFilter filterFiles = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isHidden();
        }
    };
    private CanNavigateUp _folderNavUpCB;
    private CanNavigateTo _folderNavToCB;
    private static final CanNavigateUp _defaultNavUpCB = new CanNavigateUp(){

        @Override
        public boolean canUpTo(File dir) {
            return dir != null && dir.canRead();
        }
    };
    private static final CanNavigateTo _defaultNavToCB = new CanNavigateTo(){

        @Override
        public boolean canNavigate(File dir) {
            return true;
        }
    };

    public ChooserDialog() {
    }

    public ChooserDialog(Context cxt) {
        this._context = cxt;
    }

    public ChooserDialog with(Context cxt) {
        this._context = cxt;
        return this;
    }

    public ChooserDialog withFilter(FileFilter ff) {
        this.withFilter(false, false, (String[])null);
        this._fileFilter = ff;
        return this;
    }

    public ChooserDialog withFilter(boolean dirOnly, boolean allowHidden, FileFilter ff) {
        this.withFilter(dirOnly, allowHidden, (String[])null);
        this._fileFilter = ff;
        return this;
    }

    public ChooserDialog withFilter(boolean allowHidden, String ... suffixes) {
        return this.withFilter(false, allowHidden, suffixes);
    }

    public ChooserDialog withFilter(boolean dirOnly, boolean allowHidden, String ... suffixes) {
        this._dirOnly = dirOnly;
        this._fileFilter = suffixes == null ? (dirOnly ? filterDirectoriesOnly : filterFiles) : new ExtFileFilter(this._dirOnly, allowHidden, suffixes);
        return this;
    }

    public ChooserDialog withFilterRegex(boolean dirOnly, boolean allowHidden, String pattern, int flags) {
        this._dirOnly = dirOnly;
        this._fileFilter = new RegexFileFilter(this._dirOnly, allowHidden, pattern, flags);
        return this;
    }

    public ChooserDialog withFilterRegex(boolean dirOnly, boolean allowHidden, String pattern) {
        this._dirOnly = dirOnly;
        this._fileFilter = new RegexFileFilter(this._dirOnly, allowHidden, pattern, 2);
        return this;
    }

    public ChooserDialog withStartFile(String startFile) {
        this._currentDir = startFile != null ? new File(startFile) : Environment.getExternalStorageDirectory();
        if (!this._currentDir.isDirectory()) {
            this._currentDir = this._currentDir.getParentFile();
        }
        if (this._currentDir == null) {
            this._currentDir = Environment.getExternalStorageDirectory();
        }
        return this;
    }

    public ChooserDialog withChosenListener(Result r) {
        this._result = r;
        return this;
    }

    public ChooserDialog withResources(@StringRes int titleRes, @StringRes int okRes, @StringRes int cancelRes) {
        this._titleRes = titleRes;
        this._okRes = okRes;
        this._negativeRes = cancelRes;
        return this;
    }

    public ChooserDialog withIcon(@DrawableRes int iconId) {
        this._iconRes = iconId;
        return this;
    }

    public ChooserDialog withLayoutView(@LayoutRes int layoutResId) {
        this._layoutRes = layoutResId;
        return this;
    }

    public ChooserDialog withRowLayoutView(@LayoutRes int layoutResId) {
        this._rowLayoutRes = layoutResId;
        return this;
    }

    public ChooserDialog withDateFormat() {
        return this.withDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public ChooserDialog withDateFormat(String format) {
        this._dateFormat = format;
        return this;
    }

    public ChooserDialog withNegativeButton(@StringRes int cancelTitle, DialogInterface.OnClickListener listener) {
        this._negativeRes = cancelTitle;
        this._negativeListener = listener;
        return this;
    }

    public ChooserDialog withNegativeButtonListener(DialogInterface.OnClickListener listener) {
        this._negativeListener = listener;
        return this;
    }

    public ChooserDialog withOnCancelListener(DialogInterface.OnCancelListener listener) {
        this._cancelListener2 = listener;
        return this;
    }

    public ChooserDialog withFileIcons(final boolean tryResolveFileTypeAndIcon, final Drawable fileIcon, final Drawable folderIcon) {
        this._adapterSetter = new AdapterSetter(){

            @Override
            public void apply(DirAdapter adapter) {
                if (fileIcon != null) {
                    adapter.setDefaultFileIcon(fileIcon);
                }
                if (folderIcon != null) {
                    adapter.setDefaultFolderIcon(folderIcon);
                }
                adapter.setResolveFileType(tryResolveFileTypeAndIcon);
            }
        };
        return this;
    }

    public ChooserDialog withFileIconsRes(final boolean tryResolveFileTypeAndIcon, final int fileIcon, final int folderIcon) {
        this._adapterSetter = new AdapterSetter(){

            @Override
            public void apply(DirAdapter adapter) {
                if (fileIcon != -1) {
                    adapter.setDefaultFileIcon(ContextCompat.getDrawable((Context)ChooserDialog.this._context, (int)fileIcon));
                }
                if (folderIcon != -1) {
                    adapter.setDefaultFolderIcon(ContextCompat.getDrawable((Context)ChooserDialog.this._context, (int)folderIcon));
                }
                adapter.setResolveFileType(tryResolveFileTypeAndIcon);
            }
        };
        return this;
    }

    public ChooserDialog withAdapterSetter(AdapterSetter setter) {
        this._adapterSetter = setter;
        return this;
    }

    public ChooserDialog withNavigateUpTo(CanNavigateUp cb) {
        this._folderNavUpCB = cb;
        return this;
    }

    public ChooserDialog withNavigateTo(CanNavigateTo cb) {
        this._folderNavToCB = cb;
        return this;
    }

    public ChooserDialog build() {
        if (this._titleRes == 0 || this._okRes == 0 || this._negativeRes == 0) {
            throw new RuntimeException("withResources() should be called at first.");
        }
        DirAdapter adapter = this.refreshDirs();
        if (this._adapterSetter != null) {
            this._adapterSetter.apply(adapter);
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this._context);
        builder.setTitle(this._titleRes);
        builder.setAdapter((ListAdapter)adapter, (DialogInterface.OnClickListener)this);
        if (this._iconRes != -1) {
            builder.setIcon(this._iconRes);
        }
        if (-1 != this._layoutRes && Build.VERSION.SDK_INT >= 21) {
            builder.setView(this._layoutRes);
        }
        if (this._dirOnly) {
            builder.setPositiveButton(this._okRes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    if (ChooserDialog.this._result != null && ChooserDialog.this._dirOnly) {
                        ChooserDialog.this._result.onChoosePath(ChooserDialog.this._currentDir.getAbsolutePath(), ChooserDialog.this._currentDir);
                    }
                    dialog.dismiss();
                }
            });
        }
        if (this._negativeListener == null) {
            this._negativeListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    dialog.cancel();
                }
            };
        }
        builder.setNegativeButton(this._negativeRes, this._negativeListener);
        if (this._cancelListener2 != null) {
            builder.setOnCancelListener(this._cancelListener2);
        }
        this._alertDialog = builder.create();
        this._list = this._alertDialog.getListView();
        this._list.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        return this;
    }

    public ChooserDialog show() {
        if (this._alertDialog == null || this._list == null) {
            throw new RuntimeException("call build() before show().");
        }
        if (Build.VERSION.SDK_INT >= 23) {
            boolean PERMISSION_REQUEST_READ_EXTERNAL_STORAGE = false;
            ActivityCompat.requestPermissions((Activity)((Activity)this._context), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)0);
            int permissionCheck = ContextCompat.checkSelfPermission((Context)this._context, (String)"android.permission.READ_EXTERNAL_STORAGE");
            if (permissionCheck == 0) {
                this._alertDialog.show();
            }
        } else {
            this._alertDialog.show();
        }
        return this;
    }

    private void listDirs() {
        this._entries.clear();
        File[] files = this._currentDir.listFiles(this._fileFilter);
        if (this._currentDir.getParent() != null) {
            this._entries.add(new File(".."));
        }
        if (files != null) {
            LinkedList<File> dirList = new LinkedList<File>();
            for (File f : files) {
                if (!f.isDirectory() || f.getName().startsWith(".")) continue;
                dirList.add(f);
            }
            this.sortByName(dirList);
            this._entries.addAll(dirList);
            LinkedList<File> fileList = new LinkedList<File>();
            for (File f : files) {
                if (f.isDirectory() || f.getName().startsWith(".")) continue;
                fileList.add(f);
            }
            this.sortByName(fileList);
            this._entries.addAll(fileList);
        }
    }

    void sortByName(List<File> list) {
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
            }
        });
    }

    private void listDirs2() {
        this._entries.clear();
        File[] files = this._currentDir.listFiles();
        if (this._currentDir.getParent() != null) {
            this._entries.add(new File(".."));
        }
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this._entries.add(file);
            }
        }
        Collections.sort(this._entries, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
            }
        });
    }

    public void onItemClick(AdapterView<?> parent, View list, int pos, long id2) {
        if (pos < 0 || pos >= this._entries.size()) {
            return;
        }
        File file = this._entries.get(pos);
        if (file.getName().equals("..")) {
            File f = this._currentDir.getParentFile();
            if (this._folderNavUpCB == null) {
                this._folderNavUpCB = _defaultNavUpCB;
            }
            if (this._folderNavUpCB.canUpTo(f)) {
                this._currentDir = f;
            }
        } else if (file.isDirectory()) {
            if (this._folderNavToCB == null) {
                this._folderNavToCB = _defaultNavToCB;
            }
            if (this._folderNavToCB.canNavigate(file)) {
                this._currentDir = file;
            }
        } else if (!this._dirOnly && this._result != null) {
            this._result.onChoosePath(file.getAbsolutePath(), file);
            this._alertDialog.dismiss();
            return;
        }
        this.refreshDirs();
    }

    public void onClick(DialogInterface dialog, int which) {
    }

    private DirAdapter refreshDirs() {
        this.listDirs();
        DirAdapter adapter = new DirAdapter(this._context, this._entries, this._rowLayoutRes != -1 ? this._rowLayoutRes : R.layout.li_row_textview, this._dateFormat);
        if (this._adapterSetter != null) {
            this._adapterSetter.apply(adapter);
        }
        if (this._list != null) {
            this._list.setAdapter((ListAdapter)adapter);
        }
        return adapter;
    }

    public static interface CanNavigateTo {
        public boolean canNavigate(File var1);
    }

    public static interface CanNavigateUp {
        public boolean canUpTo(File var1);
    }

    public static interface AdapterSetter {
        public void apply(DirAdapter var1);
    }

    public static interface Result {
        public void onChoosePath(String var1, File var2);
    }
}

