/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.tool;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.obsez.android.lib.filechooser.R;
import com.obsez.android.lib.filechooser.internals.FileUtil;
import com.obsez.android.lib.filechooser.internals.UiUtil;
import com.obsez.android.lib.filechooser.internals.WrappedDrawable;
import com.obsez.android.lib.filechooser.tool.RootFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;

public class DirAdapter
extends ArrayAdapter<File> {
    private SimpleDateFormat _formatter;
    private Drawable _defaultFolderIcon = null;
    private Drawable _defaultFileIcon = null;
    private boolean _resolveFileType = false;
    private PorterDuffColorFilter _colorFilter;
    private SparseArray<File> _selected = new SparseArray();
    private GetView _getView = null;
    private Stack<Integer> _indexStack = new Stack();

    public DirAdapter(Context cxt, String dateFormat) {
        super(cxt, R.layout.li_row_textview, R.id.text, new ArrayList());
        this.init(dateFormat);
    }

    public DirAdapter(Context cxt, List<File> entries, int resId, String dateFormat) {
        super(cxt, resId, R.id.text, entries);
        this.init(dateFormat);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private void init(String dateFormat) {
        this._formatter = new SimpleDateFormat(dateFormat != null && !"".equals(dateFormat.trim()) ? dateFormat.trim() : "yyyy/MM/dd HH:mm:ss");
        this._defaultFolderIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_folder);
        this._defaultFileIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_file);
        TypedArray ta = this.getContext().obtainStyledAttributes(R.styleable.FileChooser);
        int colorFilter = ta.getColor(R.styleable.FileChooser_fileListItemSelectedTint, this.getContext().getResources().getColor(R.color.li_row_background_tint));
        ta.recycle();
        this._colorFilter = new PorterDuffColorFilter(colorFilter, PorterDuff.Mode.MULTIPLY);
    }

    public void overrideGetView(GetView getView) {
        this._getView = getView;
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        Drawable icon;
        boolean isSelected;
        File file = (File)super.getItem(position);
        if (file == null) {
            return super.getView(position, convertView, parent);
        }
        boolean bl = isSelected = this._selected.get(file.hashCode(), null) != null;
        if (this._getView != null) {
            return this._getView.getView(file, isSelected, false, convertView, parent, LayoutInflater.from((Context)this.getContext()));
        }
        ViewGroup view = (ViewGroup)super.getView(position, convertView, parent);
        TextView tvName = (TextView)view.findViewById(R.id.text);
        TextView tvSize = (TextView)view.findViewById(R.id.txt_size);
        TextView tvDate = (TextView)view.findViewById(R.id.txt_date);
        tvDate.setVisibility(0);
        tvName.setText((CharSequence)file.getName());
        if (file.isDirectory()) {
            icon = this._defaultFolderIcon.getConstantState().newDrawable();
            tvSize.setText((CharSequence)"");
            if (file.lastModified() != 0L) {
                tvDate.setText((CharSequence)this._formatter.format(new Date(file.lastModified())));
            } else {
                tvDate.setVisibility(8);
            }
        } else {
            Drawable d = null;
            if (this._resolveFileType && (d = UiUtil.resolveFileTypeIcon(this.getContext(), Uri.fromFile((File)file))) != null) {
                d = new WrappedDrawable(d, 24.0f, 24.0f);
            }
            if (d == null) {
                d = this._defaultFileIcon;
            }
            icon = d.getConstantState().newDrawable();
            tvSize.setText((CharSequence)FileUtil.getReadableFileSize(file.length()));
            tvDate.setText((CharSequence)this._formatter.format(new Date(file.lastModified())));
        }
        if (file.isHidden()) {
            PorterDuffColorFilter filter = new PorterDuffColorFilter(-2130706433, PorterDuff.Mode.SRC_ATOP);
            icon.mutate().setColorFilter((ColorFilter)filter);
        }
        tvName.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
        View root = view.findViewById(R.id.root);
        if (root.getBackground() == null) {
            root.setBackgroundResource(R.color.li_row_background);
        }
        if (!isSelected) {
            root.getBackground().clearColorFilter();
        } else {
            root.getBackground().setColorFilter((ColorFilter)this._colorFilter);
        }
        return view;
    }

    public Drawable getDefaultFolderIcon() {
        return this._defaultFolderIcon;
    }

    public void setDefaultFolderIcon(Drawable defaultFolderIcon) {
        this._defaultFolderIcon = defaultFolderIcon;
    }

    public Drawable getDefaultFileIcon() {
        return this._defaultFileIcon;
    }

    public void setDefaultFileIcon(Drawable defaultFileIcon) {
        this._defaultFileIcon = defaultFileIcon;
    }

    public boolean isResolveFileType() {
        return this._resolveFileType;
    }

    public void setResolveFileType(boolean resolveFileType) {
        this._resolveFileType = resolveFileType;
    }

    public void setEntries(List<File> entries) {
        this.setNotifyOnChange(false);
        super.clear();
        this.setNotifyOnChange(true);
        super.addAll(entries);
    }

    public long getItemId(int position) {
        try {
            return ((File)this.getItem(position)).hashCode();
        }
        catch (IndexOutOfBoundsException e) {
            try {
                return ((File)this.getItem(0)).hashCode();
            }
            catch (IndexOutOfBoundsException ex) {
                return 0L;
            }
        }
    }

    public void selectItem(int position) {
        int id2 = (int)this.getItemId(position);
        if (this._selected.get(id2, null) == null) {
            this._selected.append(id2, this.getItem(position));
        } else {
            this._selected.delete(id2);
        }
        this.notifyDataSetChanged();
    }

    public boolean isSelected(int position) {
        return this.isSelectedById((int)this.getItemId(position));
    }

    public boolean isSelectedById(int id2) {
        return this._selected.get(id2, null) != null;
    }

    public boolean isAnySelected() {
        return this._selected.size() > 0;
    }

    public boolean isOneSelected() {
        return this._selected.size() == 1;
    }

    public List<File> getSelected() {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < this._selected.size(); ++i) {
            list.add((File)this._selected.valueAt(i));
        }
        return list;
    }

    public void clearSelected() {
        this._selected.clear();
    }

    public boolean isEmpty() {
        return this.getCount() == 0 || this.getCount() == 1 && this.getItem(0) instanceof RootFile;
    }

    public Stack<Integer> getIndexStack() {
        return this._indexStack;
    }

    @FunctionalInterface
    public static interface GetView {
        @NonNull
        public View getView(@NonNull File var1, boolean var2, @Deprecated boolean var3, View var4, @NonNull ViewGroup var5, @NonNull LayoutInflater var6);
    }
}

