/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.internals;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.widget.ListView;
import java.util.Iterator;
import java.util.List;

public final class UiUtil {
    public static float dip2px(float dipValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return dipValue * scale + 0.5f;
    }

    public static int px2dip(int pxValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)((float)pxValue / scale + 0.5f);
    }

    public static Drawable resolveFileTypeIcon(@NonNull Context ctx, Uri fileUri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(fileUri);
        intent.setType(UiUtil.getMimeType(ctx, fileUri));
        PackageManager pm = ctx.getPackageManager();
        List matches = pm.queryIntentActivities(intent, 0);
        Iterator iterator = matches.iterator();
        if (iterator.hasNext()) {
            ResolveInfo match = (ResolveInfo)iterator.next();
            return match.loadIcon(pm);
        }
        return null;
    }

    public static String getMimeType(@NonNull Context ctx, Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            ContentResolver cr = ctx.getApplicationContext().getContentResolver();
            mimeType = cr.getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        return mimeType;
    }

    public static int getThemeAccentColor(@NonNull Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }

    public static void hideKeyboard(@NonNull Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static int getListYScroll(@NonNull ListView list) {
        View child = list.getChildAt(0);
        return list.getFirstVisiblePosition() * child.getHeight() - child.getTop() + list.getPaddingTop();
    }

    public static void hideKeyboardFrom(@NonNull Context context, @NonNull View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void ensureVisible(@Nullable ListView listView, int pos) {
        if (listView == null || listView.getAdapter() == null) {
            return;
        }
        if (pos < 0 || pos >= listView.getAdapter().getCount()) {
            return;
        }
        int first = listView.getFirstVisiblePosition();
        int last = listView.getLastVisiblePosition();
        if (pos < first) {
            listView.setSelection(pos);
            return;
        }
        if (pos >= last) {
            listView.setSelection(1 + pos - (last - first));
        }
    }
}

