/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk;

import android.os.Handler;
import android.util.Log;
import android.webkit.JavascriptInterface;
import androidx.annotation.Nullable;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hcaptcha.sdk.HCaptchaConfig;
import com.hcaptcha.sdk.HCaptchaError;
import com.hcaptcha.sdk.HCaptchaException;
import com.hcaptcha.sdk.HCaptchaLog;
import com.hcaptcha.sdk.IHCaptchaVerifier;
import java.io.Serializable;
import lombok.NonNull;

class HCaptchaJSInterface
implements Serializable {
    public static final String JS_INTERFACE_TAG = "JSInterface";
    @NonNull
    private final transient Handler handler;
    @Nullable
    private final String config;
    @NonNull
    private final transient IHCaptchaVerifier captchaVerifier;

    public HCaptchaJSInterface(@NonNull Handler object, @NonNull HCaptchaConfig hCaptchaConfig, @NonNull IHCaptchaVerifier iHCaptchaVerifier) {
        if (object != null) {
            if (hCaptchaConfig != null) {
                if (iHCaptchaVerifier != null) {
                    HCaptchaJSInterface hCaptchaJSInterface = this;
                    hCaptchaJSInterface.handler = object;
                    hCaptchaJSInterface.captchaVerifier = iHCaptchaVerifier;
                    object = null;
                    try {
                        object = new ObjectMapper().writeValueAsString((Object)hCaptchaConfig);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        Log.w((String)JS_INTERFACE_TAG, (String)"Cannot prepare config for passing to WebView. A fallback config will be used");
                    }
                    this.config = object;
                    return;
                }
                throw new NullPointerException("captchaVerifier is marked non-null but is null");
            }
            throw new NullPointerException("config is marked non-null but is null");
        }
        throw new NullPointerException("handler is marked non-null but is null");
    }

    @JavascriptInterface
    @Nullable
    public String getConfig() {
        return this.config;
    }

    @JavascriptInterface
    public void onPass(String string) {
        HCaptchaLog.d("JSInterface.onPass");
        this.handler.post(() -> this.captchaVerifier.onSuccess(string));
    }

    @JavascriptInterface
    public void onError(int n) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        HCaptchaLog.d("JSInterface.onError %d", objectArray2);
        HCaptchaError hCaptchaError = HCaptchaError.fromId(n);
        this.handler.post(() -> this.captchaVerifier.onFailure(new HCaptchaException(hCaptchaError)));
    }

    @JavascriptInterface
    public void onLoaded() {
        HCaptchaLog.d("JSInterface.onLoaded");
        this.handler.post(this.captchaVerifier::onLoaded);
    }

    @JavascriptInterface
    public void onOpen() {
        HCaptchaLog.d("JSInterface.onOpen");
        this.handler.post(this.captchaVerifier::onOpen);
    }
}

