/*
 * Decompiled with CFR 0.152.
 */
package timber.log;

import android.os.Build;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00042\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Ltimber/log/Timber;", "", "()V", "DebugTree", "Forest", "HyperlinkedDebugTree", "Tree", "timber_release"})
public final class Timber {
    @NotNull
    public static final Forest Forest = new Forest(null);
    @NotNull
    private static final ArrayList<Tree> trees = new ArrayList();
    @NotNull
    private static volatile Tree[] treeArray;

    private Timber() {
        throw new AssertionError();
    }

    @JvmStatic
    public static void v(@NonNls @Nullable String message, Object ... args) {
        Forest.v(message, args);
    }

    @JvmStatic
    public static void v(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
        Forest.v(t, message, args);
    }

    @JvmStatic
    public static void v(@Nullable Throwable t) {
        Forest.v(t);
    }

    @JvmStatic
    public static void d(@NonNls @Nullable String message, Object ... args) {
        Forest.d(message, args);
    }

    @JvmStatic
    public static void d(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
        Forest.d(t, message, args);
    }

    @JvmStatic
    public static void d(@Nullable Throwable t) {
        Forest.d(t);
    }

    @JvmStatic
    public static void i(@NonNls @Nullable String message, Object ... args) {
        Forest.i(message, args);
    }

    @JvmStatic
    public static void i(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
        Forest.i(t, message, args);
    }

    @JvmStatic
    public static void i(@Nullable Throwable t) {
        Forest.i(t);
    }

    @JvmStatic
    public static void w(@NonNls @Nullable String message, Object ... args) {
        Forest.w(message, args);
    }

    @JvmStatic
    public static void w(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
        Forest.w(t, message, args);
    }

    @JvmStatic
    public static void w(@Nullable Throwable t) {
        Forest.w(t);
    }

    @JvmStatic
    public static void e(@NonNls @Nullable String message, Object ... args) {
        Forest.e(message, args);
    }

    @JvmStatic
    public static void e(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
        Forest.e(t, message, args);
    }

    @JvmStatic
    public static void e(@Nullable Throwable t) {
        Forest.e(t);
    }

    @JvmStatic
    public static void wtf(@NonNls @Nullable String message, Object ... args) {
        Forest.wtf(message, args);
    }

    @JvmStatic
    public static void wtf(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
        Forest.wtf(t, message, args);
    }

    @JvmStatic
    public static void wtf(@Nullable Throwable t) {
        Forest.wtf(t);
    }

    @JvmStatic
    public static void log(int priority, @NonNls @Nullable String message, Object ... args) {
        Forest.log(priority, message, args);
    }

    @JvmStatic
    public static void log(int priority, @Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
        Forest.log(priority, t, message, args);
    }

    @JvmStatic
    public static void log(int priority, @Nullable Throwable t) {
        Forest.log(priority, t);
    }

    @JvmStatic
    @NotNull
    public static Tree asTree() {
        return Forest.asTree();
    }

    @JvmStatic
    @NotNull
    public static final Tree tag(@NotNull String tag) {
        return Forest.tag(tag);
    }

    @JvmStatic
    public static final void plant(@NotNull Tree tree) {
        Forest.plant(tree);
    }

    @JvmStatic
    public static final void plant(Tree ... trees) {
        Forest.plant(trees);
    }

    @JvmStatic
    public static final void uproot(@NotNull Tree tree) {
        Forest.uproot(tree);
    }

    @JvmStatic
    public static final void uprootAll() {
        Forest.uprootAll();
    }

    @JvmStatic
    @NotNull
    public static final List<Tree> forest() {
        return Forest.forest();
    }

    @JvmStatic
    @JvmName(name="treeCount")
    public static final int treeCount() {
        return Forest.treeCount();
    }

    static {
        boolean $i$f$emptyArray = false;
        treeArray = (Tree[])((Object[])new Tree[0]);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010\u0014\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0010\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000fH\u0014\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J/\u0010\u0018\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010\u0018\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0015J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J7\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016JA\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJI\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H$\u00a2\u0006\u0002\u0010!JA\u0010\"\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001fJ/\u0010#\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010#\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010#\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010$\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010$\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010$\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010%\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010%\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J9\u0010%\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Ltimber/log/Timber$Tree;", "", "()V", "explicitTag", "Ljava/lang/ThreadLocal;", "", "getExplicitTag$timber_release", "()Ljava/lang/ThreadLocal;", "tag", "getTag$timber_release", "()Ljava/lang/String;", "d", "", "message", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "e", "formatMessage", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getStackTraceString", "i", "isLoggable", "", "priority", "", "log", "(ILjava/lang/String;[Ljava/lang/Object;)V", "(ILjava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "logMessage", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/Object;)V", "prepareLog", "v", "w", "wtf", "timber_release"})
    public static abstract class Tree {
        @NotNull
        private final ThreadLocal<String> explicitTag = new ThreadLocal();

        public final /* synthetic */ ThreadLocal getExplicitTag$timber_release() {
            return this.explicitTag;
        }

        public /* synthetic */ String getTag$timber_release() {
            String tag = this.explicitTag.get();
            if (tag != null) {
                this.explicitTag.remove();
            }
            return tag;
        }

        public void v(@Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(2, null, message, Arrays.copyOf(args, args.length));
        }

        public void v(@Nullable Throwable t, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(2, t, message, Arrays.copyOf(args, args.length));
        }

        public void v(@Nullable Throwable t) {
            this.prepareLog(2, t, null, new Object[0]);
        }

        public void d(@Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(3, null, message, Arrays.copyOf(args, args.length));
        }

        public void d(@Nullable Throwable t, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(3, t, message, Arrays.copyOf(args, args.length));
        }

        public void d(@Nullable Throwable t) {
            this.prepareLog(3, t, null, new Object[0]);
        }

        public void i(@Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(4, null, message, Arrays.copyOf(args, args.length));
        }

        public void i(@Nullable Throwable t, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(4, t, message, Arrays.copyOf(args, args.length));
        }

        public void i(@Nullable Throwable t) {
            this.prepareLog(4, t, null, new Object[0]);
        }

        public void w(@Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(5, null, message, Arrays.copyOf(args, args.length));
        }

        public void w(@Nullable Throwable t, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(5, t, message, Arrays.copyOf(args, args.length));
        }

        public void w(@Nullable Throwable t) {
            this.prepareLog(5, t, null, new Object[0]);
        }

        public void e(@Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(6, null, message, Arrays.copyOf(args, args.length));
        }

        public void e(@Nullable Throwable t, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(6, t, message, Arrays.copyOf(args, args.length));
        }

        public void e(@Nullable Throwable t) {
            this.prepareLog(6, t, null, new Object[0]);
        }

        public void wtf(@Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(7, null, message, Arrays.copyOf(args, args.length));
        }

        public void wtf(@Nullable Throwable t, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(7, t, message, Arrays.copyOf(args, args.length));
        }

        public void wtf(@Nullable Throwable t) {
            this.prepareLog(7, t, null, new Object[0]);
        }

        public void log(int priority, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(priority, null, message, Arrays.copyOf(args, args.length));
        }

        public void log(int priority, @Nullable Throwable t, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.prepareLog(priority, t, message, Arrays.copyOf(args, args.length));
        }

        public void log(int priority, @Nullable Throwable t) {
            this.prepareLog(priority, t, null, new Object[0]);
        }

        @Deprecated(message="Use isLoggable(String, int)", replaceWith=@ReplaceWith(expression="this.isLoggable(null, priority)", imports={}))
        protected boolean isLoggable(int priority) {
            return true;
        }

        protected boolean isLoggable(@Nullable String tag, int priority) {
            return this.isLoggable(priority);
        }

        private final void prepareLog(int priority, Throwable t, String message, Object ... args) {
            String tag = this.getTag$timber_release();
            if (!this.isLoggable(tag, priority)) {
                return;
            }
            String message2 = message;
            Object[] objectArray = (Object[])message2;
            if (objectArray == null || objectArray.length() == 0) {
                if (t == null) {
                    return;
                }
                message2 = this.getStackTraceString(t);
            } else {
                if (!(args.length == 0)) {
                    message2 = this.formatMessage(message2, args);
                }
                if (t != null) {
                    message2 = message2 + '\n' + this.getStackTraceString(t);
                }
            }
            objectArray = new Object[]{args};
            this.logMessage(priority, tag, message2, t, objectArray);
        }

        @NotNull
        protected String formatMessage(@NotNull String message, @NotNull Object[] args) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Object[] objectArray = Arrays.copyOf(args, args.length);
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
            return string;
        }

        private final String getStackTraceString(Throwable t) {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            t.printStackTrace(pw);
            pw.flush();
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
            return string;
        }

        protected abstract void logMessage(int var1, @Nullable String var2, @NotNull String var3, @Nullable Throwable var4, Object ... var5);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0014JI\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u0016\"\u0004\u0018\u00010\u0017H\u0014\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00078PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Ltimber/log/Timber$DebugTree;", "Ltimber/log/Timber$Tree;", "delegator", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "fqcnIgnore", "", "", "tag", "getTag$timber_release", "()Ljava/lang/String;", "createStackElementTag", "element", "Ljava/lang/StackTraceElement;", "logMessage", "", "priority", "", "message", "t", "", "args", "", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/Object;)V", "Companion", "timber_release"})
    public static class DebugTree
    extends Tree {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<String> fqcnIgnore;
        private static final int MAX_LOG_LENGTH = 4000;
        private static final int MAX_TAG_LENGTH = 23;
        private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");

        public DebugTree(@Nullable Class<?> delegator) {
            block0: {
                Object[] objectArray = new String[]{Timber.class.getName(), Forest.class.getName(), Tree.class.getName(), DebugTree.class.getName()};
                this.fqcnIgnore = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object[])objectArray));
                Class<?> clazz = delegator;
                if (clazz == null) break block0;
                Class<?> it = clazz;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                this.fqcnIgnore.add(string);
            }
        }

        public /* synthetic */ DebugTree(Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                clazz = null;
            }
            this(clazz);
        }

        @Override
        @Nullable
        public String getTag$timber_release() {
            String string = super.getTag$timber_release();
            if (string == null) {
                Object element$iv2;
                block3: {
                    StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"Throwable().stackTrace");
                    Object[] $this$first$iv = stackTraceElementArray;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        StackTraceElement it = (StackTraceElement)element$iv2;
                        boolean bl = false;
                        if (!(!this.fqcnIgnore.contains(it.getClassName()))) {
                            continue;
                        }
                        break block3;
                    }
                    throw new NoSuchElementException("Array contains no element matching the predicate.");
                }
                StackTraceElement p0 = (StackTraceElement)element$iv2;
                boolean bl = false;
                string = this.createStackElementTag(p0);
            }
            return string;
        }

        @Nullable
        protected String createStackElementTag(@NotNull StackTraceElement element) {
            String string;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string2 = element.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.className");
            String tag = StringsKt.substringAfterLast$default((String)string2, (char)'.', null, (int)2, null);
            Matcher m = ANONYMOUS_CLASS.matcher(tag);
            if (m.find()) {
                String string3 = m.replaceAll("");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"m.replaceAll(\"\")");
                tag = string3;
            }
            if (tag.length() <= 23 || Build.VERSION.SDK_INT >= 26) {
                string = tag;
            } else {
                String string4 = tag.substring(0, 23);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            return string;
        }

        @Override
        protected void logMessage(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (message.length() < 4000) {
                if (priority == 7) {
                    Log.wtf((String)tag, (String)message);
                } else {
                    Log.println((int)priority, (String)tag, (String)message);
                }
                return;
            }
            int length = message.length();
            for (int i = 0; i < length; ++i) {
                int end;
                int newline = StringsKt.indexOf$default((CharSequence)message, (char)'\n', (int)i, (boolean)false, (int)4, null);
                newline = newline != -1 ? newline : length;
                do {
                    String part;
                    end = Math.min(newline, i + 4000);
                    Intrinsics.checkNotNullExpressionValue((Object)message.substring(i, end), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (priority == 7) {
                        Log.wtf((String)tag, (String)part);
                        continue;
                    }
                    Log.println((int)priority, (String)tag, (String)part);
                } while ((i = end) < newline);
            }
        }

        public DebugTree() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltimber/log/Timber$DebugTree$Companion;", "", "()V", "ANONYMOUS_CLASS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MAX_LOG_LENGTH", "", "MAX_TAG_LENGTH", "timber_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltimber/log/Timber$HyperlinkedDebugTree;", "Ltimber/log/Timber$DebugTree;", "showMethodName", "", "(Z)V", "createStackElementTag", "", "element", "Ljava/lang/StackTraceElement;", "timber_release"})
    public static final class HyperlinkedDebugTree
    extends DebugTree {
        private final boolean showMethodName;

        public HyperlinkedDebugTree(boolean showMethodName) {
            super(null, 1, null);
            this.showMethodName = showMethodName;
        }

        public /* synthetic */ HyperlinkedDebugTree(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        @Override
        @NotNull
        protected String createStackElementTag(@NotNull StackTraceElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            StackTraceElement $this$createStackElementTag_u24lambda_u2d0 = element;
            boolean bl = false;
            return '(' + $this$createStackElementTag_u24lambda_u2d0.getFileName() + ':' + $this$createStackElementTag_u24lambda_u2d0.getLineNumber() + ") " + (this.showMethodName ? ' ' + $this$createStackElementTag_u24lambda_u2d0.getMethodName() + "()" : "");
        }

        public HyperlinkedDebugTree() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u000b\u001a\u00020\u0001H\u0097\bJ1\u0010\f\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J1\u0010\u0016\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0016\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010\u0016\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0007J1\u0010\u0019\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0019\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010\u0019\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J9\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017JC\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u001dJI\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0014\u00a2\u0006\u0002\u0010 J!\u0010!\u001a\u00020\r2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\"J\u0010\u0010!\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0001H\u0007J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u000fH\u0007J\u0010\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0001H\u0007J\b\u0010%\u001a\u00020\rH\u0007J1\u0010&\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010&\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010&\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J1\u0010'\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010'\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010'\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015J1\u0010(\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010(\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J;\u0010(\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0004\"\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0015R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ltimber/log/Timber$Forest;", "Ltimber/log/Timber$Tree;", "()V", "treeArray", "", "[Ltimber/log/Timber$Tree;", "treeCount", "", "()I", "trees", "Ljava/util/ArrayList;", "asTree", "d", "", "message", "", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "e", "forest", "", "i", "log", "priority", "(ILjava/lang/String;[Ljava/lang/Object;)V", "(ILjava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "logMessage", "tag", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/Object;)V", "plant", "([Ltimber/log/Timber$Tree;)V", "tree", "uproot", "uprootAll", "v", "w", "wtf", "timber_release"})
    public static final class Forest
    extends Tree {
        private Forest() {
        }

        @Override
        @JvmStatic
        public void v(@NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.v(message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void v(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.v(t, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void v(@Nullable Throwable t) {
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.v(t);
            }
        }

        @Override
        @JvmStatic
        public void d(@NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.d(message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void d(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.d(t, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void d(@Nullable Throwable t) {
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.d(t);
            }
        }

        @Override
        @JvmStatic
        public void i(@NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.i(message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void i(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.i(t, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void i(@Nullable Throwable t) {
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.i(t);
            }
        }

        @Override
        @JvmStatic
        public void w(@NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.w(message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void w(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.w(t, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void w(@Nullable Throwable t) {
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.w(t);
            }
        }

        @Override
        @JvmStatic
        public void e(@NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.e(message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void e(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.e(t, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void e(@Nullable Throwable t) {
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.e(t);
            }
        }

        @Override
        @JvmStatic
        public void wtf(@NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.wtf(message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void wtf(@Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.wtf(t, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void wtf(@Nullable Throwable t) {
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.wtf(t);
            }
        }

        @Override
        @JvmStatic
        public void log(int priority, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.log(priority, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void log(int priority, @Nullable Throwable t, @NonNls @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.log(priority, t, message, Arrays.copyOf(args, args.length));
            }
        }

        @Override
        @JvmStatic
        public void log(int priority, @Nullable Throwable t) {
            Tree[] $this$forEach$iv = treeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Tree element$iv;
                Tree it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.log(priority, t);
            }
        }

        @Override
        protected void logMessage(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            throw new AssertionError();
        }

        @JvmStatic
        @NotNull
        public Tree asTree() {
            boolean $i$f$asTree = false;
            return this;
        }

        @JvmStatic
        @NotNull
        public final Tree tag(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            for (Tree tree : treeArray) {
                tree.getExplicitTag$timber_release().set(tag);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void plant(@NotNull Tree tree) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            if (!(tree != this)) {
                boolean bl = false;
                String string = "Cannot plant Timber into itself.";
                throw new IllegalArgumentException(string.toString());
            }
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                boolean bl = false;
                trees.add(tree);
                Collection $this$toTypedArray$iv = trees;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Tree[] treeArray = thisCollection$iv.toArray(new Tree[0]);
                if (treeArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                Timber.treeArray = treeArray;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void plant(Tree ... trees) {
            Intrinsics.checkNotNullParameter((Object)trees, (String)"trees");
            int n = trees.length;
            for (int i = 0; i < n; ++i) {
                Tree tree = trees[i];
                if (tree == null) {
                    boolean $i$a$-requireNotNull-Timber$Forest$plant$42 = false;
                    String $i$a$-requireNotNull-Timber$Forest$plant$42 = "trees contained null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-Timber$Forest$plant$42.toString());
                }
                if (tree != this) continue;
                boolean $i$a$-require-Timber$Forest$plant$52 = false;
                String $i$a$-require-Timber$Forest$plant$52 = "Cannot plant Timber into itself.";
                throw new IllegalArgumentException($i$a$-require-Timber$Forest$plant$52.toString());
            }
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                boolean bl = false;
                Collections.addAll(trees, Arrays.copyOf(trees, trees.length));
                Collection $this$toTypedArray$iv = trees;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Tree[] treeArray = thisCollection$iv.toArray(new Tree[0]);
                if (treeArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                Timber.treeArray = treeArray;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void uproot(@NotNull Tree tree) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                boolean bl = false;
                if (!trees.remove(tree)) {
                    boolean $i$a$-require-Timber$Forest$uproot$1$22 = false;
                    String $i$a$-require-Timber$Forest$uproot$1$22 = "Cannot uproot tree which is not planted: " + tree;
                    throw new IllegalArgumentException($i$a$-require-Timber$Forest$uproot$1$22.toString());
                }
                Collection $this$toTypedArray$iv = trees;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Tree[] treeArray = thisCollection$iv.toArray(new Tree[0]);
                if (treeArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                Timber.treeArray = treeArray;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void uprootAll() {
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                boolean bl = false;
                trees.clear();
                boolean $i$f$emptyArray = false;
                Timber.treeArray = (Tree[])((Object[])new Tree[0]);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final List<Tree> forest() {
            ArrayList arrayList = trees;
            synchronized (arrayList) {
                boolean bl = false;
                List<Tree> list = Collections.unmodifiableList(CollectionsKt.toList((Iterable)trees));
                Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(trees.toList())");
                List<Tree> list2 = list;
                return list2;
            }
        }

        @JvmStatic
        @JvmName(name="treeCount")
        public final int treeCount() {
            return treeArray.length;
        }

        public /* synthetic */ Forest(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

