/*
 * Decompiled with CFR 0.152.
 */
package timber.lint;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0001DB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J,\u0010#\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00182\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0007H\u0002J,\u0010(\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00182\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J$\u0010+\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u0018\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\fH\u0002J\u0010\u00108\u001a\u0002032\u0006\u00109\u001a\u00020\fH\u0002J\u0018\u0010:\u001a\u0002032\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0018H\u0002J&\u0010=\u001a\u0002032\u0006\u0010\u000b\u001a\u00020\f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010?\u001a\u00020\u0007H\u0002J\u0010\u0010@\u001a\u0002032\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u0002032\u0006\u0010'\u001a\u00020\u0007H\u0002J \u0010B\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010C\u001a\u00020\f2\u0006\u0010.\u001a\u00020/H\u0016\u00a8\u0006E"}, d2={"Ltimber/lint/WrongTimberUsageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "canEvaluateExpression", "", "expression", "Lorg/jetbrains/uast/UExpression;", "checkConditionalUsage", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "element", "Lorg/jetbrains/uast/UElement;", "checkElement", "checkExceptionLogging", "", "checkFormatArguments", "checkMethodArguments", "checkNestedStringFormat", "checkTagLengthIfMinSdkLessThan26", "getApplicableMethodNames", "", "", "getFormatArgumentCount", "", "s", "getStringArgumentTypes", "formatString", "getType", "Ljava/lang/Class;", "getTypeClass", "type", "Lcom/intellij/psi/PsiType;", "isCallFromMethodInSubclassOf", "methodName", "classType", "isLoggingExceptionMessage", "arg", "isPropertyOnSubclassOf", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "propertyName", "isSubclassOf", "cls", "isTimberLogMethod", "method", "Lcom/intellij/psi/PsiMethod;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "quickFixIssueBinary", "Lcom/android/tools/lint/detector/api/LintFix;", "binaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "quickFixIssueFormat", "stringFormatCall", "quickFixIssueLog", "logCall", "quickFixIssueTagLength", "argument", "tag", "quickFixIssueThrowable", "arguments", "throwable", "quickFixRemoveRedundantArgument", "quickFixReplaceMessageWithThrowable", "visitMethodCall", "node", "Companion", "timber-lint"})
public final class WrongTimberUsageDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String GET_STRING_METHOD = "getString";
    @NotNull
    private static final String TIMBER_TREE_LOG_METHOD_REGEXP = "(v|d|i|w|e|wtf)";
    @NotNull
    private static final Issue ISSUE_LOG = Issue.Companion.create("LogNotTimber", "Logging call to Log instead of Timber", "Since Timber is included in the project, it is likely that calls to Log should instead be going to Timber.", Category.MESSAGES, 5, Severity.WARNING, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_FORMAT = Issue.Companion.create("StringFormatInTimber", "Logging call with Timber contains String#format()", "Since Timber handles String.format automatically, you may not use String#format().", Category.MESSAGES, 5, Severity.WARNING, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_THROWABLE = Issue.Companion.create("ThrowableNotAtBeginning", "Exception in Timber not at the beginning", "In Timber you have to pass a Throwable at the beginning of the call.", Category.MESSAGES, 5, Severity.WARNING, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_BINARY = Issue.Companion.create("BinaryOperationInTimber", "Use String#format()", "Since Timber handles String#format() automatically, use this instead of String concatenation.", Category.MESSAGES, 5, Severity.WARNING, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_ARG_COUNT = Issue.Companion.create("TimberArgCount", "Formatting argument types incomplete or inconsistent", "When a formatted string takes arguments, you need to pass at least that amount of arguments to the formatting call.", Category.MESSAGES, 9, Severity.ERROR, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_ARG_TYPES = Issue.Companion.create("TimberArgTypes", "Formatting string doesn't match passed arguments", "The argument types that you specified in your formatting string does not match the types of the arguments that you passed to your formatting call.", Category.MESSAGES, 9, Severity.ERROR, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_TAG_LENGTH = Issue.Companion.create("TimberTagLength", "Too Long Log Tags", "Log tags are only allowed to be at most 23 tag characters long.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue ISSUE_EXCEPTION_LOGGING = Issue.Companion.create("TimberExceptionLogging", "Exception Logging", "Explicitly including the exception message is redundant when supplying an exception to log.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(WrongTimberUsageDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final Issue[] issues;

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"tag", "format", "v", "d", "i", "w", "e", "wtf"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String methodName = node.getMethodName();
        JavaEvaluator evaluator = context.getEvaluator();
        if (Intrinsics.areEqual((Object)"format", (Object)methodName) && (evaluator.isMemberInClass((PsiMember)method, "java.lang.String") || evaluator.isMemberInClass((PsiMember)method, "kotlin.text.StringsKt__StringsJVMKt"))) {
            this.checkNestedStringFormat(context, node);
            return;
        }
        if (Intrinsics.areEqual((Object)"tag", (Object)methodName) && evaluator.isMemberInClass((PsiMember)method, "timber.log.Timber")) {
            this.checkTagLengthIfMinSdkLessThan26(context, node);
        }
        if (evaluator.isMemberInClass((PsiMember)method, "android.util.Log")) {
            context.report(new Incident(ISSUE_LOG, (Object)node, context.getLocation((UElement)node), "Using 'Log' instead of 'Timber'", this.quickFixIssueLog(node)));
            return;
        }
        if (this.isTimberLogMethod(method, evaluator)) {
            this.checkMethodArguments(context, node);
            this.checkFormatArguments(context, node);
            this.checkExceptionLogging(context, node);
        }
    }

    private final boolean isTimberLogMethod(PsiMethod method, JavaEvaluator evaluator) {
        return evaluator.isMemberInClass((PsiMember)method, "timber.log.Timber") || evaluator.isMemberInClass((PsiMember)method, "timber.log.Timber.Companion") || evaluator.isMemberInClass((PsiMember)method, "timber.log.Timber.Tree");
    }

    private final void checkNestedStringFormat(JavaContext context, UCallExpression call) {
        UElement uElement;
        PsiMethod psiMethod;
        UElement current = (UElement)call;
        do {
            UElement uElement2 = current;
            Intrinsics.checkNotNull((Object)uElement2);
            current = Lint.skipParentheses((UElement)uElement2.getUastParent());
            if (current != null && !(current instanceof UMethod)) continue;
            return;
        } while (!UastExpressionUtils.isMethodCall((UElement)current) || (psiMethod = ((UCallExpression)(uElement = current)).resolve()) == null || !Pattern.matches(TIMBER_TREE_LOG_METHOD_REGEXP, psiMethod.getName()) || !this.isTimberLogMethod(psiMethod, context.getEvaluator()));
        context.report(new Incident(ISSUE_FORMAT, (Object)call, context.getLocation((UElement)call), "Using 'String#format' inside of 'Timber'", this.quickFixIssueFormat(call)));
    }

    private final void checkTagLengthIfMinSdkLessThan26(JavaContext context, UCallExpression call) {
        UExpression argument = (UExpression)call.getValueArguments().get(0);
        String tag = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)argument), (boolean)true);
        if (tag != null && tag.length() > 23) {
            context.report(new Incident(ISSUE_TAG_LENGTH, (Object)argument, context.getLocation((UElement)argument), "The logging tag can be at most 23 characters, was " + tag.length() + " (" + tag + ')', this.quickFixIssueTagLength(argument, tag)), Constraints.minSdkLessThan((int)26));
        }
    }

    private final void checkFormatArguments(JavaContext context, UCallExpression call) {
        int passedArgCount;
        String string;
        List arguments = call.getValueArguments();
        int numArguments = arguments.size();
        if (numArguments == 0) {
            return;
        }
        int startIndexOfArguments = 1;
        UExpression formatStringArg = (UExpression)arguments.get(0);
        if (this.isSubclassOf(context, formatStringArg, Throwable.class)) {
            if (numArguments == 1) {
                return;
            }
            formatStringArg = (UExpression)arguments.get(1);
            ++startIndexOfArguments;
        }
        if ((string = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)formatStringArg), (boolean)false)) == null) {
            return;
        }
        String formatString = string;
        int formatArgumentCount = this.getFormatArgumentCount(formatString);
        if (formatArgumentCount < (passedArgCount = numArguments - startIndexOfArguments)) {
            context.report(new Incident(ISSUE_ARG_COUNT, (Object)call, context.getLocation((UElement)call), "Wrong argument count, format string `" + formatString + "` requires `" + formatArgumentCount + "` but format call supplies `" + passedArgCount + '`'));
            return;
        }
        if (formatArgumentCount == 0) {
            return;
        }
        List<String> types = this.getStringArgumentTypes(formatString);
        UExpression argument = null;
        int argumentIndex = startIndexOfArguments;
        boolean valid = false;
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            Class<?> type;
            char c;
            char c2;
            String formatType = types.get(i);
            if (argumentIndex != numArguments) {
                argument = (UExpression)arguments.get(argumentIndex++);
            } else {
                context.report(new Incident(ISSUE_ARG_COUNT, (Object)call, context.getLocation((UElement)call), "Wrong argument count, format string `" + formatString + "` requires `" + formatArgumentCount + "` but format call supplies `" + passedArgCount + '`'));
            }
            if (this.getType(argument) == null) continue;
            char last = StringsKt.last((CharSequence)formatType);
            if (formatType.length() >= 2 && Character.toLowerCase(c2 = formatType.charAt(formatType.length() - 2)) == 't') {
                c = last;
                if ((((((((((((((((((((((((((((((c == 'H' ? true : c == 'I') ? true : c == 'k') ? true : c == 'l') ? true : c == 'M') ? true : c == 'S') ? true : c == 'L') ? true : c == 'N') ? true : c == 'p') ? true : c == 'z') ? true : c == 'Z') ? true : c == 's') ? true : c == 'Q') ? true : c == 'B') ? true : c == 'b') ? true : c == 'h') ? true : c == 'A') ? true : c == 'a') ? true : c == 'C') ? true : c == 'Y') ? true : c == 'y') ? true : c == 'j') ? true : c == 'm') ? true : c == 'd') ? true : c == 'e') ? true : c == 'R') ? true : c == 'T') ? true : c == 'r') ? true : c == 'D') ? true : c == 'F') ? true : c == 'c') {
                    boolean bl = valid = Intrinsics.areEqual(type, Integer.TYPE) || Intrinsics.areEqual(type, Calendar.class) || Intrinsics.areEqual(type, Date.class) || Intrinsics.areEqual(type, Long.TYPE);
                    if (valid) continue;
                    context.report(new Incident(ISSUE_ARG_TYPES, (Object)call, Context.getLocation$default((Context)((Context)context), (Object)argument, null, (int)2, null), "Wrong argument type for date formatting argument '#" + (i + 1) + "' in `" + formatString + "`: conversion is '`" + formatType + "`', received `" + type.getSimpleName() + "` (argument #" + (startIndexOfArguments + i + 1) + " in method call)"));
                    continue;
                }
                context.report(new Incident(ISSUE_FORMAT, (Object)call, Context.getLocation$default((Context)((Context)context), (Object)argument, null, (int)2, null), "Wrong suffix for date format '#" + (i + 1) + "' in `" + formatString + "`: conversion is '`" + formatType + "`', received `" + type.getSimpleName() + "` (argument #" + (startIndexOfArguments + i + 1) + " in method call)"));
                continue;
            }
            c = last;
            boolean bl = (c == 'b' ? true : c == 'B') ? Intrinsics.areEqual(type, Boolean.TYPE) : (((((((((((c == 'x' ? true : c == 'X') ? true : c == 'd') ? true : c == 'o') ? true : c == 'e') ? true : c == 'E') ? true : c == 'f') ? true : c == 'g') ? true : c == 'G') ? true : c == 'a') ? true : c == 'A') ? Intrinsics.areEqual(type, Integer.TYPE) || Intrinsics.areEqual(type, Float.TYPE) || Intrinsics.areEqual(type, Double.TYPE) || Intrinsics.areEqual(type, Long.TYPE) || Intrinsics.areEqual(type, Byte.TYPE) || Intrinsics.areEqual(type, Short.TYPE) : ((c == 'c' ? true : c == 'C') ? Intrinsics.areEqual(type, Character.TYPE) : ((c == 'h' ? true : c == 'H') ? !Intrinsics.areEqual(type, Boolean.TYPE) && !Number.class.isAssignableFrom(type) : (valid = (c == 's' ? true : c == 'S') ? true : true))));
            if (valid) continue;
            context.report(new Incident(ISSUE_ARG_TYPES, (Object)call, Context.getLocation$default((Context)((Context)context), (Object)argument, null, (int)2, null), "Wrong argument type for formatting argument '#" + (i + 1) + "' in `" + formatString + "`: conversion is '`" + formatType + "`', received `" + type.getSimpleName() + "` (argument #" + (startIndexOfArguments + i + 1) + " in method call)"));
        }
    }

    private final Class<?> getType(UExpression expression) {
        PsiType type;
        if (expression == null) {
            return null;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiMethod psiMethod = call.resolveMethod();
            if (psiMethod == null) {
                return null;
            }
            PsiMethod method = psiMethod;
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            String methodName = string;
            if (Intrinsics.areEqual((Object)methodName, (Object)GET_STRING_METHOD)) {
                return String.class;
            }
        } else if (expression instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
            PsiType expressionType = literalExpression.getType();
            PsiType psiType = expressionType;
            Intrinsics.checkNotNull((Object)psiType);
            if (Lint.isString((PsiType)psiType)) {
                return String.class;
            }
            if (expressionType == PsiType.INT) {
                return Integer.TYPE;
            }
            if (expressionType == PsiType.FLOAT) {
                return Float.TYPE;
            }
            if (expressionType == PsiType.CHAR) {
                return Character.TYPE;
            }
            if (expressionType == PsiType.BOOLEAN) {
                return Boolean.TYPE;
            }
            if (expressionType == PsiType.NULL) {
                return Object.class;
            }
        }
        if ((type = expression.getExpressionType()) != null) {
            Class<?> typeClass = this.getTypeClass(type);
            Class<Object> clazz = typeClass;
            if (clazz == null) {
                clazz = Object.class;
            }
            return clazz;
        }
        return null;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Class<?> getTypeClass(PsiType type) {
        Class<Object> clazz;
        block53: {
            block51: {
                block58: {
                    block55: {
                        block52: {
                            block47: {
                                block49: {
                                    block57: {
                                        block54: {
                                            block48: {
                                                block50: {
                                                    block56: {
                                                        String string;
                                                        PsiType psiType = type;
                                                        if (psiType == null) return null;
                                                        String string3 = psiType.getCanonicalText();
                                                        string3 = string = string3;
                                                        if (string3 == null) return null;
                                                        switch (string3.hashCode()) {
                                                            case -527879800: {
                                                                if (!string.equals("java.lang.Float")) {
                                                                    return null;
                                                                }
                                                                break block47;
                                                            }
                                                            case 761287205: {
                                                                if (!string.equals("java.lang.Double")) {
                                                                    return null;
                                                                }
                                                                break block47;
                                                            }
                                                            case 65575278: {
                                                                if (string.equals("java.util.Date")) return Date.class;
                                                                return null;
                                                            }
                                                            case -1808118735: {
                                                                if (string.equals("String")) return String.class;
                                                                return null;
                                                            }
                                                            case 97526364: {
                                                                if (!string.equals("float")) {
                                                                    return null;
                                                                }
                                                                break block48;
                                                            }
                                                            case -2056817302: {
                                                                if (!string.equals("java.lang.Integer")) {
                                                                    return null;
                                                                }
                                                                break block49;
                                                            }
                                                            case 3327612: {
                                                                if (!string.equals("long")) {
                                                                    return null;
                                                                }
                                                                break block50;
                                                            }
                                                            case -1405464277: {
                                                                if (!string.equals("java.math.BigDecimal")) {
                                                                    return null;
                                                                }
                                                                break block51;
                                                            }
                                                            case -861027074: {
                                                                if (string.equals("java.util.Calendar")) return Calendar.class;
                                                                return null;
                                                            }
                                                            case 398795216: {
                                                                if (!string.equals("java.lang.Long")) {
                                                                    return null;
                                                                }
                                                                break block49;
                                                            }
                                                            case -515992664: {
                                                                if (!string.equals("java.lang.Short")) {
                                                                    return null;
                                                                }
                                                                break block49;
                                                            }
                                                            case 344809556: {
                                                                if (!string.equals("java.lang.Boolean")) {
                                                                    return null;
                                                                }
                                                                break block52;
                                                            }
                                                            case -989675752: {
                                                                if (!string.equals("java.math.BigInteger")) {
                                                                    return null;
                                                                }
                                                                break block53;
                                                            }
                                                            case 1195259493: {
                                                                if (string.equals("java.lang.String")) return String.class;
                                                                return null;
                                                            }
                                                            case 398507100: {
                                                                if (!string.equals("java.lang.Byte")) {
                                                                    return null;
                                                                }
                                                                break block49;
                                                            }
                                                            case -1325958191: {
                                                                if (!string.equals("double")) {
                                                                    return null;
                                                                }
                                                                break block54;
                                                            }
                                                            case 3039496: {
                                                                if (!string.equals("byte")) {
                                                                    return null;
                                                                }
                                                                break block55;
                                                            }
                                                            case -113680546: {
                                                                if (string.equals("Calendar")) return Calendar.class;
                                                                return null;
                                                            }
                                                            case 104431: {
                                                                if (string.equals("int")) break;
                                                                return null;
                                                            }
                                                            case 2122702: {
                                                                if (string.equals("Date")) return Date.class;
                                                                return null;
                                                            }
                                                            case 1438607953: {
                                                                if (!string.equals("BigDecimal")) {
                                                                    return null;
                                                                }
                                                                break block51;
                                                            }
                                                            case 64711720: {
                                                                if (!string.equals("boolean")) {
                                                                    return null;
                                                                }
                                                                break block56;
                                                            }
                                                            case 3392903: {
                                                                if (string.equals("null")) return Object.class;
                                                                return null;
                                                            }
                                                            case 3052374: {
                                                                if (!string.equals("char")) {
                                                                    return null;
                                                                }
                                                                break block57;
                                                            }
                                                            case 109413500: {
                                                                if (!string.equals("short")) {
                                                                    return null;
                                                                }
                                                                break block58;
                                                            }
                                                            case 1854396478: {
                                                                if (!string.equals("BigInteger")) {
                                                                    return null;
                                                                }
                                                                break block53;
                                                            }
                                                            case 1063877011: {
                                                                if (string.equals("java.lang.Object")) return null;
                                                                return null;
                                                            }
                                                        }
                                                        clazz = Integer.TYPE;
                                                        return clazz;
                                                    }
                                                    clazz = Boolean.TYPE;
                                                    return clazz;
                                                }
                                                clazz = Long.TYPE;
                                                return clazz;
                                            }
                                            clazz = Float.TYPE;
                                            return clazz;
                                        }
                                        clazz = Double.TYPE;
                                        return clazz;
                                    }
                                    clazz = Character.TYPE;
                                    return clazz;
                                }
                                clazz = Integer.TYPE;
                                return clazz;
                            }
                            clazz = Float.TYPE;
                            return clazz;
                        }
                        clazz = Boolean.TYPE;
                        return clazz;
                    }
                    clazz = Byte.TYPE;
                    return clazz;
                }
                clazz = Short.TYPE;
                return clazz;
            }
            clazz = Float.TYPE;
            return clazz;
        }
        clazz = Integer.TYPE;
        return clazz;
        return null;
    }

    private final boolean isSubclassOf(JavaContext context, UExpression expression, Class<?> cls) {
        PsiType expressionType = expression.getExpressionType();
        if (expressionType instanceof PsiClassType) {
            JavaEvaluator javaEvaluator = context.getEvaluator();
            PsiClass psiClass = ((PsiClassType)expressionType).resolve();
            String string = cls.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cls.name");
            return javaEvaluator.extendsClass(psiClass, string, false);
        }
        return false;
    }

    private final List<String> getStringArgumentTypes(String formatString) {
        List types = new ArrayList();
        Matcher matcher = StringFormatDetector.FORMAT.matcher(formatString);
        int index = 0;
        int prevIndex = 0;
        while (matcher.find(index)) {
            String str;
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = formatString.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            index = matcher.end();
            String string = formatString;
            int n = matcher.end();
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(matchStart, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (Intrinsics.areEqual((Object)"%%", (Object)str) || Intrinsics.areEqual((Object)"%n", (Object)str)) continue;
            String time = matcher.group(5);
            ((Collection)types).add(StringsKt.equals((String)"t", (String)time, (boolean)true) ? time + matcher.group(6) : matcher.group(6));
        }
        return types;
    }

    private final int getFormatArgumentCount(String s) {
        Matcher matcher = StringFormatDetector.FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int max = 0;
        while (matcher.find(index)) {
            String value = matcher.group(6);
            if (Intrinsics.areEqual((Object)"%", (Object)value) || Intrinsics.areEqual((Object)"n", (Object)value)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            int number = 0;
            String numberString = matcher.group(1);
            if (numberString != null) {
                String string = numberString;
                int n = 0;
                int n2 = numberString.length() - 1;
                String string2 = string.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string3 = numberString = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"numberString");
                string = string3;
                number = Integer.parseInt(string);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number > max) {
                max = number;
            }
            index = matcher.end();
        }
        return max;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMethodArguments(JavaContext context, UCallExpression call) {
        Iterable $this$forEachIndexed$iv = call.getValueArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void argument;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            UExpression uExpression = (UExpression)item$iv;
            int i = n;
            boolean bl = false;
            if (this.checkElement(context, call, (UElement)argument) || i <= 0 || !this.isSubclassOf(context, (UExpression)argument, Throwable.class)) continue;
            context.report(new Incident(ISSUE_THROWABLE, (Object)call, context.getLocation((UElement)call), "Throwable should be first argument", this.quickFixIssueThrowable(call, call.getValueArguments(), (UExpression)argument)));
        }
    }

    private final void checkExceptionLogging(JavaContext context, UCallExpression call) {
        UExpression messageArg;
        List arguments = call.getValueArguments();
        int numArguments = arguments.size();
        if (numArguments > 1 && this.isSubclassOf(context, (UExpression)arguments.get(0), Throwable.class)) {
            UExpression messageArg2 = (UExpression)arguments.get(1);
            if (this.isLoggingExceptionMessage(context, messageArg2)) {
                context.report(new Incident(ISSUE_EXCEPTION_LOGGING, (Object)messageArg2, context.getLocation((UElement)call), "Explicitly logging exception message is redundant", this.quickFixRemoveRedundantArgument(messageArg2)));
                return;
            }
            String s = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)messageArg2), (boolean)true);
            if (s == null && !this.canEvaluateExpression(messageArg2)) {
                return;
            }
            if (s == null || ((CharSequence)s).length() == 0) {
                context.report(new Incident(ISSUE_EXCEPTION_LOGGING, (Object)messageArg2, context.getLocation((UElement)call), "Use single-argument log method instead of null/empty message", this.quickFixRemoveRedundantArgument(messageArg2)));
            }
        } else if (numArguments == 1 && !this.isSubclassOf(context, (UExpression)arguments.get(0), Throwable.class) && this.isLoggingExceptionMessage(context, messageArg = (UExpression)arguments.get(0))) {
            context.report(new Incident(ISSUE_EXCEPTION_LOGGING, (Object)messageArg, context.getLocation((UElement)call), "Explicitly logging exception message is redundant", this.quickFixReplaceMessageWithThrowable(messageArg)));
        }
    }

    private final boolean isLoggingExceptionMessage(JavaContext context, UExpression arg) {
        if (!(arg instanceof UQualifiedReferenceExpression)) {
            return false;
        }
        PsiElement psi = arg.getSourcePsi();
        if (psi != null && Lint.isKotlin((Language)psi.getLanguage())) {
            return this.isPropertyOnSubclassOf(context, (UQualifiedReferenceExpression)arg, "message", Throwable.class);
        }
        UExpression selector = ((UQualifiedReferenceExpression)arg).getSelector();
        return !(selector instanceof UCallExpression) ? false : this.isCallFromMethodInSubclassOf(context, (UCallExpression)selector, "getMessage", Throwable.class);
    }

    private final boolean canEvaluateExpression(UExpression expression) {
        if (expression instanceof ULiteralExpression) {
            return true;
        }
        if (!(expression instanceof USimpleNameReferenceExpression)) {
            return false;
        }
        PsiElement resolvedElement = ((USimpleNameReferenceExpression)expression).resolve();
        return !(resolvedElement instanceof PsiField) && !(resolvedElement instanceof PsiParameter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallFromMethodInSubclassOf(JavaContext context, UCallExpression call, String methodName, Class<?> classType) {
        PsiMethod method = call.resolve();
        if (method == null) return false;
        if (!Intrinsics.areEqual((Object)methodName, (Object)call.getMethodName())) return false;
        JavaEvaluator javaEvaluator = context.getEvaluator();
        PsiMember psiMember = (PsiMember)method;
        String string = classType.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classType.canonicalName");
        if (!javaEvaluator.isMemberInSubClassOf(psiMember, string, false)) return false;
        return true;
    }

    private final boolean isPropertyOnSubclassOf(JavaContext context, UQualifiedReferenceExpression expression, String propertyName, Class<?> classType) {
        return this.isSubclassOf(context, expression.getReceiver(), classType) && Intrinsics.areEqual((Object)expression.getSelector().asSourceString(), (Object)propertyName);
    }

    private final boolean checkElement(JavaContext context, UCallExpression call, UElement element) {
        if (element instanceof UBinaryExpression) {
            Class<?> argumentType;
            UastBinaryOperator operator = ((UBinaryExpression)element).getOperator();
            if ((operator == UastBinaryOperator.PLUS || operator == UastBinaryOperator.PLUS_ASSIGN) && Intrinsics.areEqual(argumentType = this.getType((UExpression)element), String.class)) {
                if (UastLiteralUtils.isInjectionHost((UElement)((UElement)((UBinaryExpression)element).getLeftOperand())) && UastLiteralUtils.isInjectionHost((UElement)((UElement)((UBinaryExpression)element).getRightOperand()))) {
                    return false;
                }
                context.report(new Incident(ISSUE_BINARY, (Object)call, context.getLocation(element), "Replace String concatenation with Timber's string formatting", this.quickFixIssueBinary((UBinaryExpression)element)));
                return true;
            }
        } else if (element instanceof UIfExpression) {
            return this.checkConditionalUsage(context, call, element);
        }
        return false;
    }

    private final boolean checkConditionalUsage(JavaContext context, UCallExpression call, UElement element) {
        return element instanceof UIfExpression ? (this.checkElement(context, call, (UElement)((UIfExpression)element).getThenExpression()) ? false : this.checkElement(context, call, (UElement)((UIfExpression)element).getElseExpression())) : false;
    }

    private final LintFix quickFixIssueLog(UCallExpression logCall) {
        List arguments = logCall.getValueArguments();
        String methodName = logCall.getMethodName();
        UExpression tag = (UExpression)arguments.get(0);
        String fixSource1 = "Timber.tag(" + tag.asSourceString() + ").";
        String fixSource2 = "Timber.";
        switch (arguments.size()) {
            case 2: {
                UExpression msgOrThrowable = (UExpression)arguments.get(1);
                fixSource1 = fixSource1 + methodName + '(' + msgOrThrowable.asSourceString() + ')';
                fixSource2 = fixSource2 + methodName + '(' + msgOrThrowable.asSourceString() + ')';
                break;
            }
            case 3: {
                UExpression msg = (UExpression)arguments.get(1);
                UExpression throwable = (UExpression)arguments.get(2);
                PsiElement psiElement = throwable.getSourcePsi();
                fixSource1 = fixSource1 + methodName + '(' + (psiElement != null ? psiElement.getText() : null) + ", " + msg.asSourceString() + ')';
                PsiElement psiElement2 = throwable.getSourcePsi();
                fixSource2 = fixSource2 + methodName + '(' + (psiElement2 != null ? psiElement2.getText() : null) + ", " + msg.asSourceString() + ')';
                break;
            }
            default: {
                throw new IllegalStateException("android.util.Log overloads should have 2 or 3 arguments");
            }
        }
        UElement uElement = logCall.getUastParent();
        Intrinsics.checkNotNull((Object)uElement);
        PsiElement psiElement = uElement.getSourcePsi();
        String logCallSource = psiElement != null ? psiElement.getText() : null;
        return this.fix().group().add(this.fix().replace().text(logCallSource).shortenNames().reformat(true).with(fixSource1).build()).add(this.fix().replace().text(logCallSource).shortenNames().reformat(true).with(fixSource2).build()).build();
    }

    private final LintFix quickFixIssueFormat(UCallExpression stringFormatCall) {
        UExpression callReceiver = stringFormatCall.getReceiver();
        String callSourceString = callReceiver == null ? "" : callReceiver.asSourceString() + '.';
        callSourceString = callSourceString + stringFormatCall.getMethodName();
        return this.fix().name("Remove String.format(...)").composite().add(this.fix().replace().pattern(callSourceString + "\\(.*(\\))").with("").build()).add(this.fix().replace().text(callSourceString + '(').with("").build()).build();
    }

    private final LintFix quickFixIssueThrowable(UCallExpression call, List<? extends UExpression> arguments, UExpression throwable) {
        StringBuilder stringBuilder;
        StringBuilder $this$quickFixIssueThrowable_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$quickFixIssueThrowable_u24lambda_u2d2.append(throwable.asSourceString());
        Iterable $this$forEach$iv = arguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UExpression arg = (UExpression)element$iv;
            boolean bl2 = false;
            if (arg == throwable) continue;
            $this$quickFixIssueThrowable_u24lambda_u2d2.append(", " + arg.asSourceString());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String rearrangedArgs = string;
        return this.fix().replace().pattern("\\." + call.getMethodName() + "\\((.*)\\)").with(rearrangedArgs).build();
    }

    private final LintFix quickFixIssueBinary(UBinaryExpression binaryExpression) {
        UExpression leftOperand = binaryExpression.getLeftOperand();
        UExpression rightOperand = binaryExpression.getRightOperand();
        boolean isLeftLiteral = UastLiteralUtils.isInjectionHost((UElement)((UElement)leftOperand));
        boolean isRightLiteral = UastLiteralUtils.isInjectionHost((UElement)((UElement)rightOperand));
        if (isLeftLiteral && isRightLiteral) {
            return this.fix().replace().text(binaryExpression.asSourceString()).with('\"' + UastUtils.evaluateString((UExpression)((UExpression)binaryExpression)) + '\"').build();
        }
        String args = isLeftLiteral ? '\"' + UastUtils.evaluateString((UExpression)leftOperand) + "%s\", " + rightOperand.asSourceString() : (isRightLiteral ? "\"%s" + UastUtils.evaluateString((UExpression)rightOperand) + "\", " + leftOperand.asSourceString() : "\"%s%s\", " + leftOperand.asSourceString() + ", " + rightOperand.asSourceString());
        return this.fix().replace().text(binaryExpression.asSourceString()).with(args).build();
    }

    private final LintFix quickFixIssueTagLength(UExpression argument, String tag) {
        int numCharsToTrim = tag.length() - 23;
        LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace().name("Strip last " + (numCharsToTrim == 1 ? "char" : numCharsToTrim + " chars")).text(argument.asSourceString());
        StringBuilder stringBuilder = new StringBuilder().append('\"');
        String string = tag;
        int n = 0;
        int n2 = 23;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return replaceStringBuilder.with(stringBuilder.append(string3).append('\"').toString()).build();
    }

    private final LintFix quickFixRemoveRedundantArgument(UExpression arg) {
        return this.fix().replace().name("Remove redundant argument").text(", " + arg.asSourceString()).with("").build();
    }

    private final LintFix quickFixReplaceMessageWithThrowable(UExpression arg) {
        UExpression receiver = ((UQualifiedReferenceExpression)arg).getReceiver();
        return this.fix().replace().name("Replace message with throwable").text(arg.asSourceString()).with(receiver.asSourceString()).build();
    }

    static {
        Issue[] issueArray = new Issue[]{ISSUE_LOG, ISSUE_FORMAT, ISSUE_THROWABLE, ISSUE_BINARY, ISSUE_ARG_COUNT, ISSUE_ARG_TYPES, ISSUE_TAG_LENGTH, ISSUE_EXCEPTION_LOGGING};
        issues = issueArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Ltimber/lint/WrongTimberUsageDetector$Companion;", "", "()V", "GET_STRING_METHOD", "", "ISSUE_ARG_COUNT", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_ARG_COUNT", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_ARG_TYPES", "getISSUE_ARG_TYPES", "ISSUE_BINARY", "getISSUE_BINARY", "ISSUE_EXCEPTION_LOGGING", "getISSUE_EXCEPTION_LOGGING", "ISSUE_FORMAT", "getISSUE_FORMAT", "ISSUE_LOG", "getISSUE_LOG", "ISSUE_TAG_LENGTH", "getISSUE_TAG_LENGTH", "ISSUE_THROWABLE", "getISSUE_THROWABLE", "TIMBER_TREE_LOG_METHOD_REGEXP", "issues", "", "getIssues", "()[Lcom/android/tools/lint/detector/api/Issue;", "[Lcom/android/tools/lint/detector/api/Issue;", "timber-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE_LOG() {
            return ISSUE_LOG;
        }

        @NotNull
        public final Issue getISSUE_FORMAT() {
            return ISSUE_FORMAT;
        }

        @NotNull
        public final Issue getISSUE_THROWABLE() {
            return ISSUE_THROWABLE;
        }

        @NotNull
        public final Issue getISSUE_BINARY() {
            return ISSUE_BINARY;
        }

        @NotNull
        public final Issue getISSUE_ARG_COUNT() {
            return ISSUE_ARG_COUNT;
        }

        @NotNull
        public final Issue getISSUE_ARG_TYPES() {
            return ISSUE_ARG_TYPES;
        }

        @NotNull
        public final Issue getISSUE_TAG_LENGTH() {
            return ISSUE_TAG_LENGTH;
        }

        @NotNull
        public final Issue getISSUE_EXCEPTION_LOGGING() {
            return ISSUE_EXCEPTION_LOGGING;
        }

        @NotNull
        public final Issue[] getIssues() {
            return issues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

