/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.room;

import androidx.lifecycle.LiveData;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteConnectionUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import info.mqtt.android.service.room.PingDao;
import info.mqtt.android.service.room.entity.PingEntity;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\tH\u0016J!\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0018\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007H\u0003\u00a2\u0006\u0002\b\u001aJ\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Linfo/mqtt/android/service/room/PingDao_Impl;", "Linfo/mqtt/android/service/room/PingDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "all", "Landroidx/lifecycle/LiveData;", "", "Linfo/mqtt/android/service/room/entity/PingEntity;", "getAll", "()Landroidx/lifecycle/LiveData;", "__insertAdapterOfPingEntity", "Landroidx/room/EntityInsertAdapter;", "__deleteAdapterOfPingEntity", "Landroidx/room/EntityDeleteOrUpdateAdapter;", "__updateAdapterOfPingEntity", "insert", "", "pingEntity", "delete", "", "updateAll", "pingEntities", "", "([Linfo/mqtt/android/service/room/entity/PingEntity;)V", "_privateGetAll", "allByState", "statePing", "", "deleteState", "", "removeOldData", "keepCount", "Companion", "serviceLibrary_release"})
public final class PingDao_Impl
implements PingDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<PingEntity> __insertAdapterOfPingEntity;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<PingEntity> __deleteAdapterOfPingEntity;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<PingEntity> __updateAdapterOfPingEntity;

    public PingDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__db = __db;
        this.__insertAdapterOfPingEntity = (EntityInsertAdapter)new EntityInsertAdapter<PingEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PingEntity` (`timestamp`,`clientId`,`serverURI`,`success`,`message`) VALUES (?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, PingEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getTimestamp());
                String _tmpClientId = entity.getClientId();
                if (_tmpClientId == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmpClientId);
                }
                String _tmpServerURI = entity.getServerURI();
                if (_tmpServerURI == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmpServerURI);
                }
                int _tmp = entity.getSuccess() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                String _tmpMessage = entity.getMessage();
                if (_tmpMessage == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmpMessage);
                }
            }
        };
        this.__deleteAdapterOfPingEntity = (EntityDeleteOrUpdateAdapter)new EntityDeleteOrUpdateAdapter<PingEntity>(){

            protected String createQuery() {
                return "DELETE FROM `PingEntity` WHERE `timestamp` = ?";
            }

            protected void bind(SQLiteStatement statement, PingEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getTimestamp());
            }
        };
        this.__updateAdapterOfPingEntity = (EntityDeleteOrUpdateAdapter)new EntityDeleteOrUpdateAdapter<PingEntity>(){

            protected String createQuery() {
                return "UPDATE OR ABORT `PingEntity` SET `timestamp` = ?,`clientId` = ?,`serverURI` = ?,`success` = ?,`message` = ? WHERE `timestamp` = ?";
            }

            protected void bind(SQLiteStatement statement, PingEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getTimestamp());
                String _tmpClientId = entity.getClientId();
                if (_tmpClientId == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmpClientId);
                }
                String _tmpServerURI = entity.getServerURI();
                if (_tmpServerURI == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmpServerURI);
                }
                int _tmp = entity.getSuccess() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                String _tmpMessage = entity.getMessage();
                if (_tmpMessage == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmpMessage);
                }
                statement.bindLong(6, entity.getTimestamp());
            }
        };
    }

    @Override
    @NotNull
    public LiveData<List<PingEntity>> getAll() {
        return this._privateGetAll();
    }

    @Override
    public long insert(@NotNull PingEntity pingEntity) {
        Intrinsics.checkNotNullParameter((Object)pingEntity, (String)"pingEntity");
        return ((Number)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PingDao_Impl.insert$lambda$0(this, pingEntity, arg_0))).longValue();
    }

    @Override
    public void delete(@NotNull PingEntity pingEntity) {
        Intrinsics.checkNotNullParameter((Object)pingEntity, (String)"pingEntity");
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PingDao_Impl.delete$lambda$1(this, pingEntity, arg_0));
    }

    @Override
    public void updateAll(PingEntity ... pingEntities) {
        Intrinsics.checkNotNullParameter((Object)pingEntities, (String)"pingEntities");
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PingDao_Impl.updateAll$lambda$2(this, pingEntities, arg_0));
    }

    @JvmName(name="_privateGetAll")
    private final LiveData<List<PingEntity>> _privateGetAll() {
        String _sql = "SELECT * FROM PingEntity ORDER BY timestamp ASC";
        String[] stringArray = new String[]{"PingEntity"};
        return this.__db.getInvalidationTracker().createLiveData(stringArray, false, arg_0 -> PingDao_Impl.getAll$lambda$3(_sql, arg_0));
    }

    @Override
    @NotNull
    public LiveData<List<PingEntity>> allByState(boolean statePing) {
        String _sql = "SELECT * FROM PingEntity WHERE success = ? ORDER BY timestamp ASC";
        String[] stringArray = new String[]{"PingEntity"};
        return this.__db.getInvalidationTracker().createLiveData(stringArray, false, arg_0 -> PingDao_Impl.allByState$lambda$4(_sql, statePing, arg_0));
    }

    @Override
    public int deleteState(boolean statePing) {
        String _sql = "DELETE FROM PingEntity WHERE success = ?";
        return ((Number)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PingDao_Impl.deleteState$lambda$5(_sql, statePing, arg_0))).intValue();
    }

    @Override
    public void removeOldData(int keepCount) {
        String _sql = "DELETE FROM PingEntity WHERE timeStamp IN (SELECT timeStamp FROM PingEntity ORDER BY timeStamp DESC LIMIT 1 OFFSET ?)";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PingDao_Impl.removeOldData$lambda$6(_sql, keepCount, arg_0));
    }

    private static final long insert$lambda$0(PingDao_Impl this$0, PingEntity $pingEntity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        long _result = this$0.__insertAdapterOfPingEntity.insertAndReturnId(_connection, (Object)$pingEntity);
        return _result;
    }

    private static final Unit delete$lambda$1(PingDao_Impl this$0, PingEntity $pingEntity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__deleteAdapterOfPingEntity.handle(_connection, (Object)$pingEntity);
        return Unit.INSTANCE;
    }

    private static final Unit updateAll$lambda$2(PingDao_Impl this$0, PingEntity[] $pingEntities, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__updateAdapterOfPingEntity.handleMultiple(_connection, (Object[])$pingEntities);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getAll$lambda$3(String $_sql, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfTimestamp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"timestamp");
            int _columnIndexOfClientId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"clientId");
            int _columnIndexOfServerURI = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"serverURI");
            int _columnIndexOfSuccess = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"success");
            int _columnIndexOfMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"message");
            List _result = new ArrayList();
            while (_stmt.step()) {
                PingEntity _item = null;
                long _tmpTimestamp = 0L;
                _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp);
                String _tmpClientId = null;
                _tmpClientId = _stmt.isNull(_columnIndexOfClientId) ? null : _stmt.getText(_columnIndexOfClientId);
                String _tmpServerURI = null;
                _tmpServerURI = _stmt.isNull(_columnIndexOfServerURI) ? null : _stmt.getText(_columnIndexOfServerURI);
                boolean _tmpSuccess = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfSuccess);
                _tmpSuccess = _tmp != 0;
                String _tmpMessage = null;
                _tmpMessage = _stmt.isNull(_columnIndexOfMessage) ? null : _stmt.getText(_columnIndexOfMessage);
                _item = new PingEntity(_tmpTimestamp, _tmpClientId, _tmpServerURI, _tmpSuccess, _tmpMessage);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List allByState$lambda$4(String $_sql, boolean $statePing, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            int _tmp = $statePing ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            int _columnIndexOfTimestamp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"timestamp");
            int _columnIndexOfClientId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"clientId");
            int _columnIndexOfServerURI = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"serverURI");
            int _columnIndexOfSuccess = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"success");
            int _columnIndexOfMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"message");
            List _result = new ArrayList();
            while (_stmt.step()) {
                PingEntity _item = null;
                long _tmpTimestamp = 0L;
                _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp);
                String _tmpClientId = null;
                _tmpClientId = _stmt.isNull(_columnIndexOfClientId) ? null : _stmt.getText(_columnIndexOfClientId);
                String _tmpServerURI = null;
                _tmpServerURI = _stmt.isNull(_columnIndexOfServerURI) ? null : _stmt.getText(_columnIndexOfServerURI);
                boolean _tmpSuccess = false;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfSuccess);
                _tmpSuccess = _tmp_1 != 0;
                String _tmpMessage = null;
                _tmpMessage = _stmt.isNull(_columnIndexOfMessage) ? null : _stmt.getText(_columnIndexOfMessage);
                _item = new PingEntity(_tmpTimestamp, _tmpClientId, _tmpServerURI, _tmpSuccess, _tmpMessage);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int deleteState$lambda$5(String $_sql, boolean $statePing, SQLiteConnection _connection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            int _tmp = $statePing ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            _stmt.step();
            n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit removeOldData$lambda$6(String $_sql, int $keepCount, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$keepCount);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Linfo/mqtt/android/service/room/PingDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

