/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.ping;

import android.content.Context;
import androidx.work.CoroutineWorker;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import info.mqtt.android.service.ping.AlarmPingSender;
import info.mqtt.android.service.room.MqMessageDatabase;
import info.mqtt.android.service.room.entity.PingEntity;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Linfo/mqtt/android/service/ping/PingWorker;", "Landroidx/work/CoroutineWorker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "<init>", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "serviceLibrary_release"})
@SourceDebugExtension(value={"SMAP\nPingWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PingWorker.kt\ninfo/mqtt/android/service/ping/PingWorker\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,81:1\n426#2,11:82\n*S KotlinDebug\n*F\n+ 1 PingWorker.kt\ninfo/mqtt/android/service/ping/PingWorker\n*L\n19#1:82,11\n*E\n"})
public final class PingWorker
extends CoroutineWorker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LOGGING = "logging";
    @NotNull
    public static final String KEEP_RECORDS_COUNT = "keepCount";

    public PingWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(context, workerParams);
    }

    @Nullable
    public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super ListenableWorker.Result> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        boolean logging = this.getInputData().getBoolean(LOGGING, false);
        int keepRecords = this.getInputData().getInt(KEEP_RECORDS_COUNT, 1000);
        String key = this.getInputData().getString("id");
        Timber.Forest.d(key + " Sending Ping at: " + AlarmPingSender.Companion.getSdf$serviceLibrary_release().format(new Date(System.currentTimeMillis())), new Object[0]);
        if (key == null) {
            Timber.Forest.e("connection id in ping worker is null!", new Object[0]);
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ListenableWorker.Result.failure()));
        } else if (!AlarmPingSender.Companion.getClientCommsMap$serviceLibrary_release().containsKey(key)) {
            Timber.Forest.e("client comm doesn't exist anymore: " + key, new Object[0]);
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ListenableWorker.Result.failure()));
        } else {
            ClientComms clientComms = AlarmPingSender.Companion.getClientCommsMap$serviceLibrary_release().get(key);
            if (clientComms == null || (clientComms = clientComms.checkForActivity(new IMqttActionListener(key, logging, keepRecords, (CancellableContinuation<? super ListenableWorker.Result>)continuation){
                final /* synthetic */ String $key;
                final /* synthetic */ boolean $logging;
                final /* synthetic */ int $keepRecords;
                final /* synthetic */ CancellableContinuation<ListenableWorker.Result> $continuation;
                {
                    this.$key = $key;
                    this.$logging = $logging;
                    this.$keepRecords = $keepRecords;
                    this.$continuation = $continuation;
                }

                public void onSuccess(IMqttToken asyncActionToken) {
                    IMqttToken iMqttToken = asyncActionToken;
                    Timber.Forest.d(this.$key + " Ping Success " + (iMqttToken != null && (iMqttToken = iMqttToken.getClient()) != null ? iMqttToken.getClientId() : null), new Object[0]);
                    if (this.$logging) {
                        Object object;
                        IMqttToken iMqttToken2;
                        IMqttToken iMqttToken3;
                        PingEntity pingMQ = new PingEntity(System.currentTimeMillis(), (iMqttToken3 = asyncActionToken) != null && (iMqttToken3 = iMqttToken3.getClient()) != null ? iMqttToken3.getClientId() : null, (iMqttToken2 = asyncActionToken) != null && (iMqttToken2 = iMqttToken2.getClient()) != null ? iMqttToken2.getServerURI() : null, true, null, 16, null);
                        Object object2 = AlarmPingSender.Companion.getMessageDatabase$serviceLibrary_release();
                        if (object2 != null && (object2 = object2.pingDao()) != null) {
                            object2.insert(pingMQ);
                        }
                        if ((object = AlarmPingSender.Companion.getMessageDatabase$serviceLibrary_release()) != null && (object = ((MqMessageDatabase)((Object)object)).pingDao()) != null) {
                            object.removeOldData(this.$keepRecords);
                        }
                    }
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ListenableWorker.Result.success()));
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    IMqttToken iMqttToken = asyncActionToken;
                    Timber.Forest.e(this.$key + " Ping Failure " + exception + " " + (iMqttToken != null && (iMqttToken = iMqttToken.getClient()) != null ? iMqttToken.getClientId() : null), new Object[0]);
                    if (this.$logging) {
                        Object object;
                        IMqttToken iMqttToken2;
                        IMqttToken iMqttToken3;
                        Throwable throwable = exception;
                        PingEntity pingMQ = new PingEntity(System.currentTimeMillis(), (iMqttToken3 = asyncActionToken) != null && (iMqttToken3 = iMqttToken3.getClient()) != null ? iMqttToken3.getClientId() : null, (iMqttToken2 = asyncActionToken) != null && (iMqttToken2 = iMqttToken2.getClient()) != null ? iMqttToken2.getServerURI() : null, false, throwable != null ? throwable.getMessage() : null);
                        Object object2 = AlarmPingSender.Companion.getMessageDatabase$serviceLibrary_release();
                        if (object2 != null && (object2 = object2.pingDao()) != null) {
                            object2.insert(pingMQ);
                        }
                        if ((object = AlarmPingSender.Companion.getMessageDatabase$serviceLibrary_release()) != null && (object = ((MqMessageDatabase)((Object)object)).pingDao()) != null) {
                            object.removeOldData(this.$keepRecords);
                        }
                    }
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ListenableWorker.Result.failure()));
                }
            })) == null) {
                boolean bl3 = false;
                ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ListenableWorker.Result.failure()));
                clientComms = Unit.INSTANCE;
            }
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Linfo/mqtt/android/service/ping/PingWorker$Companion;", "", "<init>", "()V", "LOGGING", "", "KEEP_RECORDS_COUNT", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

