/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.ping;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import info.mqtt.android.service.MqttService;
import info.mqtt.android.service.ping.PingWorker;
import info.mqtt.android.service.room.MqMessageDatabase;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Linfo/mqtt/android/service/ping/AlarmPingSender;", "Lorg/eclipse/paho/client/mqttv3/MqttPingSender;", "service", "Linfo/mqtt/android/service/MqttService;", "id", "", "pingLogging", "", "keepPingRecords", "", "<init>", "(Linfo/mqtt/android/service/MqttService;Ljava/lang/String;ZI)V", "getService", "()Linfo/mqtt/android/service/MqttService;", "getId", "()Ljava/lang/String;", "workManager", "Landroidx/work/WorkManager;", "init", "", "comms", "Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;", "start", "stop", "schedule", "delayInMilliseconds", "", "Companion", "serviceLibrary_release"})
@SourceDebugExtension(value={"SMAP\nAlarmPingSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlarmPingSender.kt\ninfo/mqtt/android/service/ping/AlarmPingSender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1740#2,3:97\n*S KotlinDebug\n*F\n+ 1 AlarmPingSender.kt\ninfo/mqtt/android/service/ping/AlarmPingSender\n*L\n60#1:97,3\n*E\n"})
public final class AlarmPingSender
implements MqttPingSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MqttService service;
    @NotNull
    private final String id;
    private final boolean pingLogging;
    private final int keepPingRecords;
    @NotNull
    private final WorkManager workManager;
    @NotNull
    private static ConcurrentHashMap<String, ClientComms> clientCommsMap = new ConcurrentHashMap();
    @NotNull
    private static final String PING_JOB = "PING_JOB";
    @Nullable
    private static MqMessageDatabase messageDatabase;
    @SuppressLint(value={"ConstantLocale"})
    @NotNull
    private static final SimpleDateFormat sdf;

    public AlarmPingSender(@NotNull MqttService service, @NotNull String id, boolean pingLogging, int keepPingRecords) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.service = service;
        this.id = id;
        this.pingLogging = pingLogging;
        this.keepPingRecords = keepPingRecords;
        this.workManager = WorkManager.Companion.getInstance((Context)this.service);
    }

    public /* synthetic */ AlarmPingSender(MqttService mqttService, String string, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 1000;
        }
        this(mqttService, string, bl, n);
    }

    @NotNull
    public final MqttService getService() {
        return this.service;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public void init(@NotNull ClientComms comms) {
        Intrinsics.checkNotNullParameter((Object)comms, (String)"comms");
        ((Map)clientCommsMap).put(this.id, comms);
        messageDatabase = this.service.getMessageDatabase();
        Timber.Forest.w("Init ping job " + this.id, new Object[0]);
    }

    public void start() {
        Timber.Forest.d("Start ping job " + this.id, new Object[0]);
        ClientComms clientComms = clientCommsMap.get(this.id);
        if (clientComms != null && (clientComms = clientComms.getClientState()) != null) {
            ClientComms it = clientComms;
            boolean bl = false;
            ClientComms clientComms2 = clientCommsMap.get(this.id);
            Intrinsics.checkNotNull((Object)clientComms2);
            this.schedule(clientComms2.getKeepAlive());
        } else {
            Timber.Forest.e("FIXME: try to start ping schedule, but clientState null, not able to get keepAlive", new Object[0]);
        }
    }

    public void stop() {
        Timber.Forest.d("Stop ping job " + this.id, new Object[0]);
        this.workManager.cancelUniqueWork("PING_JOB_" + this.id);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void schedule(long delayInMilliseconds) {
        Timber.Forest.d(this.id + ": Schedule next alarm at " + sdf.format(new Date(System.currentTimeMillis() + delayInMilliseconds)), new Object[0]);
        List workInfo = (List)this.workManager.getWorkInfosForUniqueWork("PING_JOB_" + this.id).get();
        if (!workInfo.isEmpty()) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNull((Object)workInfo);
                Iterable $this$all$iv = workInfo;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        WorkInfo it = (WorkInfo)element$iv;
                        boolean bl2 = false;
                        if (it.getState().isFinished()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                Timber.Forest.w(this.id + ": I GOT YOU Ping job already scheduled, skipping", new Object[0]);
                return;
            }
        }
        OneTimeWorkRequest.Builder pingWork = new OneTimeWorkRequest.Builder(PingWorker.class);
        Data.Builder data = new Data.Builder();
        data.putBoolean("logging", this.pingLogging);
        data.putInt("keepRecordCount", this.keepPingRecords);
        data.putString("id", this.id);
        ((OneTimeWorkRequest.Builder)pingWork.setInitialDelay(delayInMilliseconds, TimeUnit.MILLISECONDS)).setInputData(data.build());
        this.workManager.enqueueUniqueWork("PING_JOB_" + this.id, ExistingWorkPolicy.REPLACE, (OneTimeWorkRequest)pingWork.build());
        Timber.Forest.d(this.id + ": Successfully scheduled new ping job", new Object[0]);
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'Z'", Locale.getDefault());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00148\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Linfo/mqtt/android/service/ping/AlarmPingSender$Companion;", "", "<init>", "()V", "clientCommsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;", "getClientCommsMap$serviceLibrary_release", "()Ljava/util/concurrent/ConcurrentHashMap;", "setClientCommsMap$serviceLibrary_release", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "PING_JOB", "messageDatabase", "Linfo/mqtt/android/service/room/MqMessageDatabase;", "getMessageDatabase$serviceLibrary_release", "()Linfo/mqtt/android/service/room/MqMessageDatabase;", "setMessageDatabase$serviceLibrary_release", "(Linfo/mqtt/android/service/room/MqMessageDatabase;)V", "sdf", "Ljava/text/SimpleDateFormat;", "getSdf$serviceLibrary_release", "()Ljava/text/SimpleDateFormat;", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentHashMap<String, ClientComms> getClientCommsMap$serviceLibrary_release() {
            return clientCommsMap;
        }

        public final void setClientCommsMap$serviceLibrary_release(@NotNull ConcurrentHashMap<String, ClientComms> concurrentHashMap) {
            Intrinsics.checkNotNullParameter(concurrentHashMap, (String)"<set-?>");
            clientCommsMap = concurrentHashMap;
        }

        @Nullable
        public final MqMessageDatabase getMessageDatabase$serviceLibrary_release() {
            return messageDatabase;
        }

        public final void setMessageDatabase$serviceLibrary_release(@Nullable MqMessageDatabase mqMessageDatabase) {
            messageDatabase = mqMessageDatabase;
        }

        @NotNull
        public final SimpleDateFormat getSdf$serviceLibrary_release() {
            return sdf;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

