/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import info.mqtt.android.service.Ack;
import info.mqtt.android.service.MqttConnectTokenAndroid;
import info.mqtt.android.service.MqttDeliveryTokenAndroid;
import info.mqtt.android.service.MqttService;
import info.mqtt.android.service.MqttServiceBinder;
import info.mqtt.android.service.MqttTokenAndroid;
import info.mqtt.android.service.MqttTraceHandler;
import info.mqtt.android.service.ParcelableMqttMessage;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.Status;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u0087\u00012\u00020\u0001:\u0004\u0086\u0001\u0087\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010-\u001a\u00020\fH\u0016J\b\u0010.\u001a\u00020\u0005H\u0016J\b\u0010/\u001a\u00020\u0005H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0017H\u0016J\u0010\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u001dH\u0016J\u001c\u00102\u001a\u00020\u00172\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016J$\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u001d2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016J\b\u00108\u001a\u000201H\u0002J\u0018\u00109\u001a\u0002012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010:\u001a\u00020\u0017H\u0016J\u0010\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020<H\u0016J\u001c\u0010:\u001a\u00020\u00172\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016J\"\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020<2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0016J(\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\fH\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00052\u0006\u0010D\u001a\u00020EH\u0016J<\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\f2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016J,\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00052\u0006\u0010D\u001a\u00020E2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u0018\u0010F\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u000eH\u0016J#\u0010F\u001a\u00020\u00172\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050G2\u0006\u0010B\u001a\u00020HH\u0016\u00a2\u0006\u0002\u0010IJ,\u0010F\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016J7\u0010F\u001a\u00020\u00172\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050G2\u0006\u0010B\u001a\u00020H2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016\u00a2\u0006\u0002\u0010JJ4\u0010F\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010L\u001a\u00020MH\u0016J \u0010F\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020MH\u0016J1\u0010F\u001a\u00020\u00172\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00050G2\u0006\u0010B\u001a\u00020H2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020M0GH\u0016\u00a2\u0006\u0002\u0010PJE\u0010F\u001a\u00020\u00172\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00050G2\u0006\u0010B\u001a\u00020H2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u0001072\f\u0010O\u001a\b\u0012\u0004\u0012\u00020M0GH\u0016\u00a2\u0006\u0002\u0010QJ\u0010\u0010R\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u0005H\u0016J\u001b\u0010R\u001a\u00020\u00172\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050GH\u0016\u00a2\u0006\u0002\u0010SJ$\u0010R\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00052\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016J/\u0010R\u001a\u00020\u00172\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050G2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0016\u00a2\u0006\u0002\u0010TJ\u0010\u0010U\u001a\u00020\f2\u0006\u0010V\u001a\u00020>H\u0016J\u0013\u0010W\u001a\b\u0012\u0004\u0012\u00020>0GH\u0016\u00a2\u0006\u0002\u0010XJ\u0010\u0010Y\u001a\u0002012\u0006\u00106\u001a\u00020!H\u0016J\u000e\u0010Z\u001a\u0002012\u0006\u00106\u001a\u00020!J\u000e\u0010[\u001a\u0002012\u0006\u00106\u001a\u00020!J\u0010\u0010\\\u001a\u0002012\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010]\u001a\u0002012\u0006\u0010%\u001a\u00020\fJ\u0010\u0010^\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0002J\u000e\u0010a\u001a\u00020\f2\u0006\u0010b\u001a\u00020\u0005J\u0018\u0010c\u001a\u0002012\u0006\u0010b\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u000eH\u0016J\u0010\u0010d\u001a\u0002012\u0006\u0010e\u001a\u00020\fH\u0016J\b\u0010f\u001a\u000201H\u0016J\u0012\u0010g\u001a\u0002012\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u0010\u0010h\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0002J\u0012\u0010i\u001a\u0002012\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u0012\u0010j\u001a\u0002012\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u001a\u0010k\u001a\u0002012\b\u0010V\u001a\u0004\u0018\u00010\u00172\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010l\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010m\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010n\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010o\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0002J\u0012\u0010p\u001a\u0002012\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u0012\u0010q\u001a\u0002012\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u0012\u0010r\u001a\u0002012\b\u0010V\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010s\u001a\u0004\u0018\u00010\u00172\u0006\u0010_\u001a\u00020`H\u0002J\u0012\u0010t\u001a\u0004\u0018\u00010\u00172\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010u\u001a\u0002012\u0006\u0010v\u001a\u00020wH\u0016J\b\u0010x\u001a\u00020\u000eH\u0016J\u0010\u0010y\u001a\u00020E2\u0006\u0010z\u001a\u00020\u000eH\u0016J\u0010\u0010{\u001a\u0002012\u0006\u0010z\u001a\u00020\u000eH\u0016J\b\u0010|\u001a\u00020\u000eH\u0016J\u001a\u0010}\u001a\u00020~2\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020\u0005J\t\u0010\u0082\u0001\u001a\u000201H\u0016J\u0012\u0010\u0082\u0001\u001a\u0002012\u0007\u0010\u0083\u0001\u001a\u00020<H\u0016J\u001a\u0010\u0082\u0001\u001a\u0002012\u0006\u0010;\u001a\u00020<2\u0007\u0010\u0083\u0001\u001a\u00020<H\u0016J\u0007\u0010\u0084\u0001\u001a\u000201J\u0007\u0010\u0085\u0001\u001a\u000201R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient;", "Lorg/eclipse/paho/client/mqttv3/IMqttAsyncClient;", "context", "Landroid/content/Context;", "serverURI", "", "clientId", "ackType", "Linfo/mqtt/android/service/Ack;", "persistence", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "pingLogging", "", "keepPingRecords", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Linfo/mqtt/android/service/Ack;Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;ZI)V", "getContext", "()Landroid/content/Context;", "serviceConnection", "Linfo/mqtt/android/service/MqttAndroidClient$MyServiceConnection;", "tokenList", "", "Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "messageAck", "mqttService", "Linfo/mqtt/android/service/MqttService;", "clientHandle", "clientConnectOptions", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "connectToken", "callbacksList", "Ljava/util/ArrayList;", "Lorg/eclipse/paho/client/mqttv3/MqttCallback;", "Lkotlin/collections/ArrayList;", "traceCallback", "Linfo/mqtt/android/service/MqttTraceHandler;", "traceEnabled", "receiverRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serviceBound", "clientJob", "Lkotlinx/coroutines/Job;", "clientScope", "Lkotlinx/coroutines/CoroutineScope;", "isConnected", "getClientId", "getServerURI", "close", "", "connect", "options", "userContext", "", "callback", "Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;", "collect", "doConnect", "disconnect", "quiesceTimeout", "", "publish", "Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "topic", "payload", "", "qos", "retained", "message", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "subscribe", "", "", "([Ljava/lang/String;[I)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;[ILjava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "topicFilter", "messageListener", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "topicFilters", "messageListeners", "([Ljava/lang/String;[I[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;[ILjava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "unsubscribe", "([Ljava/lang/String;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;Ljava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "removeMessage", "token", "getPendingDeliveryTokens", "()[Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "setCallback", "addCallback", "removeCallback", "setTraceCallback", "setTraceEnabled", "onReceive", "data", "Landroid/os/Bundle;", "acknowledgeMessage", "messageId", "messageArrivedComplete", "setManualAcks", "manualAcks", "reconnect", "connectAction", "disconnected", "connectionLostAction", "connectExtendedAction", "simpleAction", "sendAction", "subscribeAction", "unSubscribeAction", "messageDeliveredAction", "messageArrivedAction", "traceAction", "storeToken", "removeMqttToken", "getMqttToken", "setBufferOpts", "bufferOpts", "Lorg/eclipse/paho/client/mqttv3/DisconnectedBufferOptions;", "getBufferedMessageCount", "getBufferedMessage", "bufferIndex", "deleteBufferedMessage", "getInFlightMessageCount", "getSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "keyStore", "Ljava/io/InputStream;", "password", "disconnectForcibly", "disconnectTimeout", "unregisterResources", "registerResources", "MyServiceConnection", "Companion", "serviceLibrary_release"})
@SourceDebugExtension(value={"SMAP\nMqttAndroidClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MqttAndroidClient.kt\ninfo/mqtt/android/service/MqttAndroidClient\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 BundleExt.kt\ninfo/mqtt/android/service/extension/BundleExtKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1289:1\n11258#2:1290\n11593#2,3:1291\n37#3:1294\n36#3,3:1295\n18#4,7:1298\n18#4,7:1307\n18#4,7:1318\n18#4,7:1325\n18#4,7:1332\n18#4,7:1339\n10#4,7:1348\n18#4,7:1359\n1869#5,2:1305\n1869#5,2:1314\n1869#5,2:1316\n1869#5,2:1346\n1869#5,2:1355\n1869#5,2:1357\n1#6:1366\n*S KotlinDebug\n*F\n+ 1 MqttAndroidClient.kt\ninfo/mqtt/android/service/MqttAndroidClient\n*L\n708#1:1290\n708#1:1291,3\n708#1:1294\n708#1:1295,3\n885#1:1298,7\n980#1:1307,7\n1005#1:1318,7\n1009#1:1325,7\n1010#1:1332,7\n1059#1:1339,7\n1075#1:1348,7\n1106#1:1359,7\n971#1:1305,2\n981#1:1314,2\n990#1:1316,2\n1062#1:1346,2\n1078#1:1355,2\n1084#1:1357,2\n*E\n"})
public final class MqttAndroidClient
implements IMqttAsyncClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String serverURI;
    @NotNull
    private final String clientId;
    @Nullable
    private MqttClientPersistence persistence;
    private final boolean pingLogging;
    private final int keepPingRecords;
    @NotNull
    private final MyServiceConnection serviceConnection;
    @NotNull
    private final List<IMqttToken> tokenList;
    @NotNull
    private final Ack messageAck;
    @Nullable
    private MqttService mqttService;
    @Nullable
    private String clientHandle;
    @Nullable
    private MqttConnectOptions clientConnectOptions;
    @Nullable
    private IMqttToken connectToken;
    @NotNull
    private ArrayList<MqttCallback> callbacksList;
    @Nullable
    private MqttTraceHandler traceCallback;
    private boolean traceEnabled;
    @NotNull
    private volatile AtomicBoolean receiverRegistered;
    private volatile boolean serviceBound;
    @Nullable
    private Job clientJob;
    @Nullable
    private CoroutineScope clientScope;
    private static final String SERVICE_NAME = MqttService.class.getName();

    public MqttAndroidClient(@NotNull Context context, @NotNull String serverURI, @NotNull String clientId, @NotNull Ack ackType, @Nullable MqttClientPersistence persistence, boolean pingLogging, int keepPingRecords) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)((Object)ackType), (String)"ackType");
        this.context = context;
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        this.pingLogging = pingLogging;
        this.keepPingRecords = keepPingRecords;
        this.serviceConnection = new MyServiceConnection();
        this.tokenList = new ArrayList();
        this.messageAck = ackType;
        this.callbacksList = new ArrayList();
        this.receiverRegistered = new AtomicBoolean(false);
    }

    public /* synthetic */ MqttAndroidClient(Context context, String string, String string2, Ack ack, MqttClientPersistence mqttClientPersistence, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            ack = Ack.AUTO_ACK;
        }
        if ((n2 & 0x10) != 0) {
            mqttClientPersistence = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        if ((n2 & 0x40) != 0) {
            n = 1000;
        }
        this(context, string, string2, ack, mqttClientPersistence, bl, n);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        if (this.clientHandle == null) return false;
        MqttService mqttService = this.mqttService;
        if (mqttService == null) return false;
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        if (!mqttService.isConnected(string)) return false;
        return true;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @NotNull
    public String getServerURI() {
        return this.serverURI;
    }

    public void close() {
        block1: {
            MqttService mqttService = this.mqttService;
            if (mqttService == null) break block1;
            MqttService it = mqttService;
            boolean bl = false;
            if (this.clientHandle == null) {
                String string = this.context.getApplicationInfo().packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
                this.clientHandle = MqttService.getClient$default(it, this.serverURI, this.clientId, string, this.persistence, false, 0, 48, null);
            }
            String string = this.clientHandle;
            Intrinsics.checkNotNull((Object)string);
            it.close(string);
        }
    }

    @NotNull
    public IMqttToken connect() {
        return this.connect(null, null);
    }

    @NotNull
    public IMqttToken connect(@NotNull MqttConnectOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.connect(options, null, null);
    }

    @NotNull
    public IMqttToken connect(@Nullable Object userContext, @Nullable IMqttActionListener callback) {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @NotNull
    public IMqttToken connect(@NotNull MqttConnectOptions options, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        IMqttToken token = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.clientConnectOptions = options;
        this.connectToken = token;
        if (this.mqttService == null) {
            ComponentName service;
            Intent serviceStartIntent;
            block6: {
                serviceStartIntent = new Intent();
                serviceStartIntent.setClassName(this.context, SERVICE_NAME);
                service = null;
                try {
                    service = this.context.startService(serviceStartIntent);
                }
                catch (IllegalStateException ex) {
                    IMqttActionListener listener2;
                    IMqttActionListener iMqttActionListener = listener2 = token.getActionCallback();
                    if (iMqttActionListener == null) break block6;
                    iMqttActionListener.onFailure(token, (Throwable)ex);
                }
            }
            if (service == null) {
                IMqttActionListener listener3;
                IMqttActionListener iMqttActionListener = listener3 = token.getActionCallback();
                if (iMqttActionListener != null) {
                    iMqttActionListener.onFailure(token, (Throwable)new RuntimeException("cannot start service " + SERVICE_NAME));
                }
            }
            v2 = this.context.bindService(serviceStartIntent, (ServiceConnection)this.serviceConnection, 1);
        } else {
            v2 = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MqttAndroidClient this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MqttAndroidClient.access$doConnect(this.this$0, MqttAndroidClient.access$getPingLogging$p(this.this$0), MqttAndroidClient.access$getKeepPingRecords$p(this.this$0));
                            if (!MqttAndroidClient.access$getReceiverRegistered$p(this.this$0).get()) {
                                MqttAndroidClient.access$collect(this.this$0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return token;
    }

    private final void collect() {
        if (this.mqttService == null) {
            return;
        }
        CompletableJob supervisorJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.clientJob = (Job)supervisorJob;
        CoroutineScope coroutineScope = this.clientScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)supervisorJob));
        if (coroutineScope != null) {
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MqttAndroidClient this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MqttService mqttService = MqttAndroidClient.access$getMqttService$p(this.this$0);
                            if (mqttService == null) break;
                            this.label = 1;
                            Object object3 = mqttService.collect((Function1<? super Bundle, Unit>)((Function1)new Function1<Bundle, Unit>((Object)this.this$0){

                                public final void invoke(Bundle p0) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    MqttAndroidClient.access$onReceive((MqttAndroidClient)this.receiver, p0);
                                }
                            }), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 == object2) {
                                return object2;
                            }
                            break;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            break;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        this.receiverRegistered.set(true);
    }

    private final void doConnect(boolean pingLogging, int keepPingRecords) {
        block3: {
            if (this.clientHandle == null) {
                MqttService mqttService = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService);
                String string = this.context.getApplicationInfo().packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
                this.clientHandle = mqttService.getClient(this.serverURI, this.clientId, string, this.persistence, pingLogging, keepPingRecords);
            }
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.setTraceEnabled(this.traceEnabled);
            MqttService mqttService2 = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService2);
            mqttService2.setTraceCallbackId(this.clientHandle);
            this.storeToken(this.connectToken);
            try {
                MqttService mqttService3 = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService3);
                String string = this.clientHandle;
                Intrinsics.checkNotNull((Object)string);
                mqttService3.connect(string, this.clientConnectOptions, this.connectToken);
            }
            catch (Exception e) {
                IMqttActionListener listener2;
                IMqttToken iMqttToken = this.connectToken;
                Intrinsics.checkNotNull((Object)iMqttToken);
                IMqttActionListener iMqttActionListener = listener2 = iMqttToken.getActionCallback();
                if (iMqttActionListener == null) break block3;
                iMqttActionListener.onFailure(this.connectToken, (Throwable)e);
            }
        }
    }

    @NotNull
    public IMqttToken disconnect() {
        IMqttToken token = new MqttTokenAndroid(this, null, null, null, 8, null);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, null, token);
        return token;
    }

    @NotNull
    public IMqttToken disconnect(long quiesceTimeout) {
        IMqttToken token = new MqttTokenAndroid(this, null, null, null, 8, null);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, quiesceTimeout, null, token);
        return token;
    }

    @NotNull
    public IMqttToken disconnect(@Nullable Object userContext, @Nullable IMqttActionListener callback) {
        IMqttToken token;
        block0: {
            token = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
            this.storeToken(token);
            MqttService mqttService = this.mqttService;
            if (mqttService == null) break block0;
            String string = this.clientHandle;
            Intrinsics.checkNotNull((Object)string);
            mqttService.disconnect(string, null, token);
        }
        return token;
    }

    @NotNull
    public IMqttToken disconnect(long quiesceTimeout, @Nullable Object userContext, @NotNull IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IMqttToken token = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, quiesceTimeout, null, token);
        return token;
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull byte[] payload, int qos, boolean retained) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull MqttMessage message) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.publish(topic, message, null, null);
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull byte[] payload, int qos, boolean retained, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        MqttDeliveryTokenAndroid token = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        IMqttDeliveryToken internalToken = mqttService.publish(string, topic, payload, QoS.Companion.valueOf(qos), retained, null, token);
        token.setDelegate((IMqttToken)internalToken);
        return token;
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull MqttMessage message, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MqttDeliveryTokenAndroid token = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        IMqttDeliveryToken internalToken = mqttService.publish(string, topic, message, null, token);
        token.setDelegate((IMqttToken)internalToken);
        return token;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topic, int qos) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.subscribe(topic, qos, null, null);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topic, @NotNull int[] qos) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        return this.subscribe(topic, qos, null, null);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topic, int qos, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        String[] stringArray = new String[]{topic};
        IMqttToken token = new MqttTokenAndroid(this, userContext, callback, stringArray);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.subscribe(string, topic, QoS.Companion.valueOf(qos), null, token);
        return token;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topic, @NotNull int[] qos, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        IMqttToken token = new MqttTokenAndroid(this, userContext, callback, topic);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.subscribe(string, topic, qos, null, token);
        return token;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topicFilter, int qos, @Nullable Object userContext, @Nullable IMqttActionListener callback, @NotNull IMqttMessageListener messageListener) {
        Intrinsics.checkNotNullParameter((Object)topicFilter, (String)"topicFilter");
        Intrinsics.checkNotNullParameter((Object)messageListener, (String)"messageListener");
        Object[] objectArray = new String[]{topicFilter};
        String[] stringArray = objectArray;
        objectArray = new int[1];
        objectArray[0] = (String)qos;
        Object[] objectArray2 = objectArray;
        objectArray = new IMqttMessageListener[]{messageListener};
        return this.subscribe(stringArray, (int[])objectArray2, userContext, callback, (IMqttMessageListener[])objectArray);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topicFilter, int qos, @NotNull IMqttMessageListener messageListener) {
        Intrinsics.checkNotNullParameter((Object)topicFilter, (String)"topicFilter");
        Intrinsics.checkNotNullParameter((Object)messageListener, (String)"messageListener");
        return this.subscribe(topicFilter, qos, null, null, messageListener);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topicFilters, @NotNull int[] qos, @NotNull IMqttMessageListener[] messageListeners) {
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)messageListeners, (String)"messageListeners");
        return this.subscribe(topicFilters, qos, null, null, messageListeners);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IMqttToken subscribe(@NotNull String[] topicFilters, @NotNull int[] qos, @Nullable Object userContext, @Nullable IMqttActionListener callback, @NotNull IMqttMessageListener[] messageListeners) {
        void $this$toTypedArray$iv;
        Collection<QoS> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)messageListeners, (String)"messageListeners");
        IMqttToken token = new MqttTokenAndroid(this, userContext, callback, topicFilters);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        int[] nArray = qos;
        String[] stringArray = topicFilters;
        String string2 = string;
        MqttService mqttService2 = mqttService;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_18 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(QoS.Companion.valueOf((int)it));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        mqttService2.subscribe(string2, stringArray, thisCollection$iv.toArray(new QoS[0]), null, token, messageListeners);
        return token;
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.unsubscribe(topic, null, null);
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String[] topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.unsubscribe(topic, null, null);
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String topic, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        IMqttToken token = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.unsubscribe(string, topic, null, token);
        return token;
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String[] topic, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        IMqttToken token = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.storeToken(token);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.unsubscribe(string, topic, null, token);
        return token;
    }

    public boolean removeMessage(@NotNull IMqttDeliveryToken token) throws MqttException {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return false;
    }

    @NotNull
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getPendingDeliveryTokens(string);
    }

    public void setCallback(@NotNull MqttCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacksList.clear();
        this.callbacksList.add(callback);
    }

    public final void addCallback(@NotNull MqttCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacksList.add(callback);
    }

    public final void removeCallback(@NotNull MqttCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacksList.remove(callback);
    }

    public final void setTraceCallback(@Nullable MqttTraceHandler traceCallback) {
        this.traceCallback = traceCallback;
    }

    public final void setTraceEnabled(boolean traceEnabled) {
        block0: {
            this.traceEnabled = traceEnabled;
            MqttService mqttService = this.mqttService;
            if (mqttService == null) break block0;
            mqttService.setTraceEnabled(traceEnabled);
        }
    }

    private final void onReceive(Bundle data) {
        Status status;
        Serializable serializable;
        String $this$serializable$iv;
        Bundle bundle = data;
        String key$iv = ".callbackStatus";
        boolean $i$f$serializable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable = $this$serializable$iv.getSerializable(key$iv, Status.class);
        } else {
            Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
            if (!(serializable2 instanceof Status)) {
                serializable2 = null;
            }
            serializable = (Serializable)((Object)((Status)((Object)serializable2)));
        }
        if ((status = (Status)((Object)serializable)) == Status.ERROR) {
            Timber.Forest.e(status + " " + data, new Object[0]);
        } else {
            String string = data.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            $this$serializable$iv = string2;
            if ($this$serializable$iv.contentEquals("exception")) {
                Timber.Forest.w(status + " " + data, new Object[0]);
            } else {
                Timber.Forest.v(status + " " + data, new Object[0]);
            }
        }
        String handleFromIntent = data.getString(".clientHandle");
        if (handleFromIntent == null || !Intrinsics.areEqual((Object)handleFromIntent, (Object)this.clientHandle)) {
            return;
        }
        String action = data.getString(".callbackAction");
        if (Intrinsics.areEqual((Object)"connect", (Object)action)) {
            this.connectAction(data);
        } else if (Intrinsics.areEqual((Object)"connectExtended", (Object)action)) {
            this.connectExtendedAction(data);
        } else if (Intrinsics.areEqual((Object)"messageArrived", (Object)action)) {
            this.messageArrivedAction(data);
        } else if (Intrinsics.areEqual((Object)"subscribe", (Object)action)) {
            this.subscribeAction(data);
        } else if (Intrinsics.areEqual((Object)"unsubscribe", (Object)action)) {
            this.unSubscribeAction(data);
        } else if (Intrinsics.areEqual((Object)"send", (Object)action)) {
            this.sendAction(data);
        } else if (Intrinsics.areEqual((Object)"messageDelivered", (Object)action)) {
            this.messageDeliveredAction(data);
        } else if (Intrinsics.areEqual((Object)"onConnectionLost", (Object)action)) {
            this.connectionLostAction(data);
        } else if (Intrinsics.areEqual((Object)"disconnect", (Object)action)) {
            this.disconnected(data);
        } else if (Intrinsics.areEqual((Object)"trace", (Object)action)) {
            this.traceAction(data);
        } else {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("Callback action doesn't exist.");
        }
    }

    public final boolean acknowledgeMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        if (this.messageAck == Ack.MANUAL_ACK) {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            String string = this.clientHandle;
            Intrinsics.checkNotNull((Object)string);
            Status status = mqttService.acknowledgeMessageArrival(string, messageId);
            return status == Status.OK;
        }
        return false;
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void setManualAcks(boolean manualAcks) {
        throw new UnsupportedOperationException();
    }

    public void reconnect() throws MqttException {
    }

    private final void connectAction(Bundle data) {
        IMqttToken token = this.connectToken;
        MqttTokenAndroid mqttTokenAndroid = (MqttTokenAndroid)token;
        Intrinsics.checkNotNull((Object)mqttTokenAndroid);
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        mqttTokenAndroid.setDelegate(new MqttConnectTokenAndroid(bundle.getBoolean("sessionPresent")));
        this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private final void disconnected(Bundle data) {
        IMqttToken token;
        this.clientHandle = null;
        IMqttToken iMqttToken = token = this.removeMqttToken(data);
        if (iMqttToken != null) {
            IMqttToken it = iMqttToken;
            boolean bl = false;
            ((MqttTokenAndroid)it).notifyComplete();
        }
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback it = (MqttCallback)element$iv;
            boolean bl = false;
            it.connectionLost(null);
        }
    }

    private final void connectionLostAction(Bundle data) {
        Exception exception;
        Bundle bundle = data;
        if (bundle != null) {
            Serializable serializable;
            Bundle bundle2 = bundle;
            String key$iv = ".exception";
            boolean $i$f$serializable = false;
            if (Build.VERSION.SDK_INT >= 33) {
                serializable = $this$serializable$iv.getSerializable(key$iv, Exception.class);
            } else {
                Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
                if (!(serializable2 instanceof Exception)) {
                    serializable2 = null;
                }
                serializable = (Exception)serializable2;
            }
            exception = (Exception)serializable;
        } else {
            exception = null;
        }
        Exception reason = exception;
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback it = (MqttCallback)element$iv;
            boolean bl = false;
            it.connectionLost((Throwable)reason);
        }
    }

    private final void connectExtendedAction(Bundle data) {
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        boolean reconnect2 = bundle.getBoolean(".reconnect", false);
        String serverURI = data.getString(".serverURI");
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback callback = (MqttCallback)element$iv;
            boolean bl = false;
            if (!(callback instanceof MqttCallbackExtended)) continue;
            ((MqttCallbackExtended)callback).connectComplete(reconnect2, serverURI);
        }
    }

    private final void simpleAction(IMqttToken token, Bundle data) {
        if (token != null) {
            Status status;
            Serializable serializable;
            Bundle bundle = data;
            String key$iv = ".callbackStatus";
            boolean $i$f$serializable = false;
            if (Build.VERSION.SDK_INT >= 33) {
                serializable = $this$serializable$iv.getSerializable(key$iv, Status.class);
            } else {
                Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
                if (!(serializable2 instanceof Status)) {
                    serializable2 = null;
                }
                serializable = (Serializable)((Object)((Status)((Object)serializable2)));
            }
            if ((status = (Status)((Object)serializable)) == Status.OK) {
                ((MqttTokenAndroid)token).notifyComplete();
            } else {
                Throwable exceptionThrown;
                Serializable serializable3;
                Serializable serializable4;
                key$iv = data;
                String key$iv2 = ".errorMessage";
                boolean $i$f$serializable2 = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    serializable4 = $this$serializable$iv.getSerializable(key$iv2, String.class);
                } else {
                    Serializable serializable5 = $this$serializable$iv.getSerializable(key$iv2);
                    if (!(serializable5 instanceof String)) {
                        serializable5 = null;
                    }
                    serializable4 = (Serializable)((Object)((String)((Object)serializable5)));
                }
                String errorMessage = (String)((Object)serializable4);
                key$iv2 = data;
                String key$iv3 = ".exception";
                boolean $i$f$serializable3 = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    serializable3 = $this$serializable$iv.getSerializable(key$iv3, Throwable.class);
                } else {
                    Serializable serializable6 = $this$serializable$iv.getSerializable(key$iv3);
                    if (!(serializable6 instanceof Throwable)) {
                        serializable6 = null;
                    }
                    serializable3 = (Throwable)serializable6;
                }
                if ((exceptionThrown = (Throwable)serializable3) == null && errorMessage != null) {
                    exceptionThrown = new Throwable(errorMessage);
                } else if (exceptionThrown == null) {
                    Set set = data.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
                    String bundleToString = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, arg_0 -> MqttAndroidClient.simpleAction$lambda$6(data, arg_0), (int)24, null);
                    exceptionThrown = new Throwable("No Throwable given\n" + bundleToString);
                }
                ((MqttTokenAndroid)token).notifyFailure(exceptionThrown);
            }
        } else {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("simpleAction : token is null");
        }
    }

    private final void sendAction(Bundle data) {
        IMqttToken token = this.getMqttToken(data);
        this.simpleAction(token, data);
    }

    private final void subscribeAction(Bundle data) {
        IMqttToken token = this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private final void unSubscribeAction(Bundle data) {
        IMqttToken token = this.removeMqttToken(data);
        this.simpleAction(token, data);
    }

    private final void messageDeliveredAction(Bundle data) {
        Serializable serializable;
        IMqttToken token = this.removeMqttToken(data);
        Bundle bundle = data;
        String key$iv = ".callbackStatus";
        boolean $i$f$serializable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable = $this$serializable$iv.getSerializable(key$iv, Status.class);
        } else {
            Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
            if (!(serializable2 instanceof Status)) {
                serializable2 = null;
            }
            serializable = (Serializable)((Object)((Status)((Object)serializable2)));
        }
        Status status = (Status)((Object)serializable);
        if (token != null && status == Status.OK && token instanceof IMqttDeliveryToken) {
            Iterable $this$forEach$iv = this.callbacksList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MqttCallback callback = (MqttCallback)element$iv;
                boolean bl = false;
                callback.deliveryComplete((IMqttDeliveryToken)token);
            }
        }
    }

    private final void messageArrivedAction(Bundle data) {
        Parcelable parcelable;
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        String string = bundle.getString("messageId");
        Intrinsics.checkNotNull((Object)string);
        String messageId = string;
        String destinationName = data.getString("destinationName");
        Bundle bundle2 = data;
        String key$iv = ".PARCEL";
        boolean $i$f$parcelable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            parcelable = (Parcelable)$this$parcelable$iv.getParcelable(key$iv, ParcelableMqttMessage.class);
        } else {
            Parcelable parcelable2 = $this$parcelable$iv.getParcelable(key$iv);
            if (!(parcelable2 instanceof ParcelableMqttMessage)) {
                parcelable2 = null;
            }
            parcelable = (ParcelableMqttMessage)parcelable2;
        }
        Intrinsics.checkNotNull((Object)parcelable);
        ParcelableMqttMessage message = (ParcelableMqttMessage)parcelable;
        try {
            if (this.messageAck == Ack.AUTO_ACK) {
                $this$forEach$iv = this.callbacksList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MqttCallback callback = (MqttCallback)element$iv;
                    boolean bl = false;
                    callback.messageArrived(destinationName, (MqttMessage)message);
                }
                MqttService mqttService = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService);
                String string2 = this.clientHandle;
                Intrinsics.checkNotNull((Object)string2);
                mqttService.acknowledgeMessageArrival(string2, messageId);
            } else {
                message.setMessageId(messageId);
                $this$forEach$iv = this.callbacksList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MqttCallback callback = (MqttCallback)element$iv;
                    boolean bl = false;
                    callback.messageArrived(destinationName, (MqttMessage)message);
                }
            }
        }
        catch (Exception e) {
            Timber.Forest.e("failed: " + e, new Object[0]);
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("messageArrivedAction failed: " + e);
        }
    }

    private final void traceAction(Bundle data) {
        block7: {
            MqttTraceHandler mqttTraceHandler = this.traceCallback;
            if (mqttTraceHandler == null) break block7;
            MqttTraceHandler it = mqttTraceHandler;
            boolean bl = false;
            Bundle bundle = data;
            Intrinsics.checkNotNull((Object)bundle);
            String severity = bundle.getString(".traceSeverity");
            String message = data.getString(".errorMessage");
            String string = severity;
            if (Intrinsics.areEqual((Object)string, (Object)"debug")) {
                it.traceDebug(message);
            } else if (Intrinsics.areEqual((Object)string, (Object)"error")) {
                it.traceError(message);
            } else {
                Serializable serializable;
                Bundle bundle2 = data;
                String key$iv = ".exception";
                boolean $i$f$serializable = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    serializable = $this$serializable$iv.getSerializable(key$iv, Exception.class);
                } else {
                    Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
                    if (!(serializable2 instanceof Exception)) {
                        serializable2 = null;
                    }
                    serializable = (Exception)serializable2;
                }
                Exception e = (Exception)serializable;
                it.traceException(message, e);
            }
        }
    }

    private final synchronized void storeToken(IMqttToken token) {
        block3: {
            Object v1;
            block2: {
                IMqttToken iMqttToken = token;
                if (iMqttToken == null) break block3;
                IMqttToken it = iMqttToken;
                boolean bl = false;
                Iterable iterable = this.tokenList;
                for (Object t : iterable) {
                    IMqttToken it2 = (IMqttToken)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2, (Object)token)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            IMqttToken tokenFound = v1;
            if (tokenFound == null) {
                this.tokenList.add(token);
                Timber.Forest.d(token + " size=" + this.tokenList.size(), new Object[0]);
            }
        }
    }

    private final synchronized IMqttToken removeMqttToken(Bundle data) {
        String activityToken = data.getString(".activityToken");
        if (activityToken != null && !Intrinsics.areEqual((Object)activityToken, (Object)"null")) {
            Object v0;
            block2: {
                Iterable iterable = this.tokenList;
                for (Object t : iterable) {
                    IMqttToken it = (IMqttToken)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.toString(), (Object)activityToken)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            IMqttToken token = v0;
            TypeIntrinsics.asMutableCollection((Object)this.tokenList).remove(token);
            Timber.Forest.d("search=" + activityToken + " " + this.tokenList.size(), new Object[0]);
            return token;
        }
        return null;
    }

    private final synchronized IMqttToken getMqttToken(Bundle data) {
        Object v0;
        block1: {
            String activityToken = data.getString(".activityToken");
            Iterable iterable = this.tokenList;
            for (Object t : iterable) {
                IMqttToken it = (IMqttToken)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.toString(), (Object)activityToken)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        IMqttToken token = v0;
        return token;
    }

    public void setBufferOpts(@NotNull DisconnectedBufferOptions bufferOpts) {
        Intrinsics.checkNotNullParameter((Object)bufferOpts, (String)"bufferOpts");
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.setBufferOpts(string, bufferOpts);
    }

    public int getBufferedMessageCount() {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getBufferedMessageCount(string);
    }

    @NotNull
    public MqttMessage getBufferedMessage(int bufferIndex) {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getBufferedMessage(string, bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.deleteBufferedMessage(string, bufferIndex);
    }

    public int getInFlightMessageCount() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SSLSocketFactory getSSLSocketFactory(@Nullable InputStream keyStore, @NotNull String password) throws MqttSecurityException {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            SSLSocketFactory sslSockFactory = null;
            KeyStore keyStore2 = KeyStore.getInstance("BKS");
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"getInstance(...)");
            KeyStore ts = keyStore2;
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            ts.load(keyStore, cArray);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(ts);
            TrustManager[] tm = tmf.getTrustManagers();
            SSLContext sSLContext = SSLContext.getInstance("TLSv1");
            Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"getInstance(...)");
            SSLContext ctx = sSLContext;
            ctx.init(null, tm, null);
            sslSockFactory = ctx.getSocketFactory();
        }
        catch (KeyStoreException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (IOException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        return var3_3;
    }

    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterResources() {
        if (this.receiverRegistered.get()) {
            MqttAndroidClient mqttAndroidClient = this;
            synchronized (mqttAndroidClient) {
                boolean bl = false;
                Job job = this.clientJob;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                }
                this.clientJob = null;
                this.clientScope = null;
                this.receiverRegistered.set(false);
                Unit unit = Unit.INSTANCE;
            }
            if (this.serviceBound) {
                try {
                    this.context.unbindService((ServiceConnection)this.serviceConnection);
                    this.serviceBound = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public final void registerResources() {
        if (!this.receiverRegistered.get()) {
            this.collect();
        }
    }

    private static final CharSequence simpleAction$lambda$6(Bundle $data, String key) {
        return key + "=" + $data.getString(key);
    }

    public static final /* synthetic */ AtomicBoolean access$getReceiverRegistered$p(MqttAndroidClient $this) {
        return $this.receiverRegistered;
    }

    public static final /* synthetic */ MqttService access$getMqttService$p(MqttAndroidClient $this) {
        return $this.mqttService;
    }

    public static final /* synthetic */ void access$onReceive(MqttAndroidClient $this, Bundle data) {
        $this.onReceive(data);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient$Companion;", "", "<init>", "()V", "SERVICE_NAME", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient$MyServiceConnection;", "Landroid/content/ServiceConnection;", "<init>", "(Linfo/mqtt/android/service/MqttAndroidClient;)V", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "binder", "Landroid/os/IBinder;", "onServiceDisconnected", "serviceLibrary_release"})
    private final class MyServiceConnection
    implements ServiceConnection {
        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder binder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            if (MqttServiceBinder.class.isAssignableFrom(binder.getClass())) {
                MqttAndroidClient.this.mqttService = ((MqttServiceBinder)binder).getService();
                MqttAndroidClient.this.serviceBound = true;
                MqttAndroidClient.this.collect();
                MqttAndroidClient.this.doConnect(MqttAndroidClient.this.pingLogging, MqttAndroidClient.this.keepPingRecords);
            }
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Timber.Forest.d("Service disconnected", new Object[0]);
            MqttAndroidClient.this.mqttService = null;
        }
    }
}

