package info.mqtt.android.service.room

import androidx.lifecycle.LiveData
import androidx.room.EntityDeleteOrUpdateAdapter
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.getTotalChangedRows
import androidx.room.util.performBlocking
import androidx.sqlite.SQLiteStatement
import info.mqtt.android.service.room.entity.PingEntity
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.jvm.JvmName
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PingDao_Impl(
  __db: RoomDatabase,
) : PingDao {
  private val __db: RoomDatabase

  public override val all: LiveData<List<PingEntity>>
    get() = getAll()

  private val __insertAdapterOfPingEntity: EntityInsertAdapter<PingEntity>

  private val __deleteAdapterOfPingEntity: EntityDeleteOrUpdateAdapter<PingEntity>

  private val __updateAdapterOfPingEntity: EntityDeleteOrUpdateAdapter<PingEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfPingEntity = object : EntityInsertAdapter<PingEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `PingEntity` (`timestamp`,`clientId`,`serverURI`,`success`,`message`) VALUES (?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PingEntity) {
        statement.bindLong(1, entity.timestamp)
        val _tmpClientId: String? = entity.clientId
        if (_tmpClientId == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmpClientId)
        }
        val _tmpServerURI: String? = entity.serverURI
        if (_tmpServerURI == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmpServerURI)
        }
        val _tmp: Int = if (entity.success) 1 else 0
        statement.bindLong(4, _tmp.toLong())
        val _tmpMessage: String? = entity.message
        if (_tmpMessage == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpMessage)
        }
      }
    }
    this.__deleteAdapterOfPingEntity = object : EntityDeleteOrUpdateAdapter<PingEntity>() {
      protected override fun createQuery(): String =
          "DELETE FROM `PingEntity` WHERE `timestamp` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: PingEntity) {
        statement.bindLong(1, entity.timestamp)
      }
    }
    this.__updateAdapterOfPingEntity = object : EntityDeleteOrUpdateAdapter<PingEntity>() {
      protected override fun createQuery(): String =
          "UPDATE OR ABORT `PingEntity` SET `timestamp` = ?,`clientId` = ?,`serverURI` = ?,`success` = ?,`message` = ? WHERE `timestamp` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: PingEntity) {
        statement.bindLong(1, entity.timestamp)
        val _tmpClientId: String? = entity.clientId
        if (_tmpClientId == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmpClientId)
        }
        val _tmpServerURI: String? = entity.serverURI
        if (_tmpServerURI == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmpServerURI)
        }
        val _tmp: Int = if (entity.success) 1 else 0
        statement.bindLong(4, _tmp.toLong())
        val _tmpMessage: String? = entity.message
        if (_tmpMessage == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpMessage)
        }
        statement.bindLong(6, entity.timestamp)
      }
    }
  }

  public override fun insert(pingEntity: PingEntity): Long = performBlocking(__db, false, true) {
      _connection ->
    val _result: Long = __insertAdapterOfPingEntity.insertAndReturnId(_connection, pingEntity)
    _result
  }

  public override fun delete(pingEntity: PingEntity): Unit = performBlocking(__db, false, true) {
      _connection ->
    __deleteAdapterOfPingEntity.handle(_connection, pingEntity)
  }

  public override fun updateAll(vararg pingEntities: PingEntity): Unit = performBlocking(__db,
      false, true) { _connection ->
    __updateAdapterOfPingEntity.handleMultiple(_connection, pingEntities)
  }

  @JvmName("_privateGetAll")
  private fun getAll(): LiveData<List<PingEntity>> {
    val _sql: String = "SELECT * FROM PingEntity ORDER BY timestamp ASC"
    return __db.invalidationTracker.createLiveData(arrayOf("PingEntity"), false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfTimestamp: Int = getColumnIndexOrThrow(_stmt, "timestamp")
        val _columnIndexOfClientId: Int = getColumnIndexOrThrow(_stmt, "clientId")
        val _columnIndexOfServerURI: Int = getColumnIndexOrThrow(_stmt, "serverURI")
        val _columnIndexOfSuccess: Int = getColumnIndexOrThrow(_stmt, "success")
        val _columnIndexOfMessage: Int = getColumnIndexOrThrow(_stmt, "message")
        val _result: MutableList<PingEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PingEntity
          val _tmpTimestamp: Long
          _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp)
          val _tmpClientId: String?
          if (_stmt.isNull(_columnIndexOfClientId)) {
            _tmpClientId = null
          } else {
            _tmpClientId = _stmt.getText(_columnIndexOfClientId)
          }
          val _tmpServerURI: String?
          if (_stmt.isNull(_columnIndexOfServerURI)) {
            _tmpServerURI = null
          } else {
            _tmpServerURI = _stmt.getText(_columnIndexOfServerURI)
          }
          val _tmpSuccess: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfSuccess).toInt()
          _tmpSuccess = _tmp != 0
          val _tmpMessage: String?
          if (_stmt.isNull(_columnIndexOfMessage)) {
            _tmpMessage = null
          } else {
            _tmpMessage = _stmt.getText(_columnIndexOfMessage)
          }
          _item = PingEntity(_tmpTimestamp,_tmpClientId,_tmpServerURI,_tmpSuccess,_tmpMessage)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun allByState(statePing: Boolean): LiveData<List<PingEntity>> {
    val _sql: String = "SELECT * FROM PingEntity WHERE success = ? ORDER BY timestamp ASC"
    return __db.invalidationTracker.createLiveData(arrayOf("PingEntity"), false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: Int = if (statePing) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        val _columnIndexOfTimestamp: Int = getColumnIndexOrThrow(_stmt, "timestamp")
        val _columnIndexOfClientId: Int = getColumnIndexOrThrow(_stmt, "clientId")
        val _columnIndexOfServerURI: Int = getColumnIndexOrThrow(_stmt, "serverURI")
        val _columnIndexOfSuccess: Int = getColumnIndexOrThrow(_stmt, "success")
        val _columnIndexOfMessage: Int = getColumnIndexOrThrow(_stmt, "message")
        val _result: MutableList<PingEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PingEntity
          val _tmpTimestamp: Long
          _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp)
          val _tmpClientId: String?
          if (_stmt.isNull(_columnIndexOfClientId)) {
            _tmpClientId = null
          } else {
            _tmpClientId = _stmt.getText(_columnIndexOfClientId)
          }
          val _tmpServerURI: String?
          if (_stmt.isNull(_columnIndexOfServerURI)) {
            _tmpServerURI = null
          } else {
            _tmpServerURI = _stmt.getText(_columnIndexOfServerURI)
          }
          val _tmpSuccess: Boolean
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfSuccess).toInt()
          _tmpSuccess = _tmp_1 != 0
          val _tmpMessage: String?
          if (_stmt.isNull(_columnIndexOfMessage)) {
            _tmpMessage = null
          } else {
            _tmpMessage = _stmt.getText(_columnIndexOfMessage)
          }
          _item = PingEntity(_tmpTimestamp,_tmpClientId,_tmpServerURI,_tmpSuccess,_tmpMessage)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun deleteState(statePing: Boolean): Int {
    val _sql: String = "DELETE FROM PingEntity WHERE success = ?"
    return performBlocking(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: Int = if (statePing) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        _stmt.step()
        getTotalChangedRows(_connection)
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun removeOldData(keepCount: Int) {
    val _sql: String =
        "DELETE FROM PingEntity WHERE timeStamp IN (SELECT timeStamp FROM PingEntity ORDER BY timeStamp DESC LIMIT 1 OFFSET ?)"
    return performBlocking(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, keepCount.toLong())
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
