package info.mqtt.android.service.room

import androidx.room.InvalidationTracker
import androidx.room.RoomOpenDelegate
import androidx.room.migration.AutoMigrationSpec
import androidx.room.migration.Migration
import androidx.room.util.TableInfo
import androidx.room.util.TableInfo.Companion.read
import androidx.room.util.dropFtsSyncTriggers
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.execSQL
import javax.`annotation`.processing.Generated
import kotlin.Lazy
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.collections.MutableSet
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf
import kotlin.collections.mutableSetOf
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class MqMessageDatabase_Impl : MqMessageDatabase() {
  private val _mqMessageDao: Lazy<MqMessageDao> = lazy {
    MqMessageDao_Impl(this)
  }

  private val _pingDao: Lazy<PingDao> = lazy {
    PingDao_Impl(this)
  }

  protected override fun createOpenDelegate(): RoomOpenDelegate {
    val _openDelegate: RoomOpenDelegate = object : RoomOpenDelegate(2,
        "28d9483c66f87d7f10041b140dac8fe9", "7da52c069a3cbc0057ed55a080456c33") {
      public override fun createAllTables(connection: SQLiteConnection) {
        connection.execSQL("CREATE TABLE IF NOT EXISTS `MqMessageEntity` (`messageId` TEXT NOT NULL, `clientHandle` TEXT NOT NULL, `topic` TEXT NOT NULL, `mqttMessage` TEXT NOT NULL, `qos` INTEGER NOT NULL, `retained` INTEGER NOT NULL, `duplicate` INTEGER NOT NULL, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`messageId`))")
        connection.execSQL("CREATE INDEX IF NOT EXISTS `index_MqMessageEntity_clientHandle` ON `MqMessageEntity` (`clientHandle`)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PingEntity` (`timestamp` INTEGER NOT NULL, `clientId` TEXT, `serverURI` TEXT, `success` INTEGER NOT NULL, `message` TEXT, PRIMARY KEY(`timestamp`))")
        connection.execSQL("CREATE INDEX IF NOT EXISTS `index_PingEntity_timestamp` ON `PingEntity` (`timestamp`)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)")
        connection.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '28d9483c66f87d7f10041b140dac8fe9')")
      }

      public override fun dropAllTables(connection: SQLiteConnection) {
        connection.execSQL("DROP TABLE IF EXISTS `MqMessageEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `PingEntity`")
      }

      public override fun onCreate(connection: SQLiteConnection) {
      }

      public override fun onOpen(connection: SQLiteConnection) {
        internalInitInvalidationTracker(connection)
      }

      public override fun onPreMigrate(connection: SQLiteConnection) {
        dropFtsSyncTriggers(connection)
      }

      public override fun onPostMigrate(connection: SQLiteConnection) {
      }

      public override fun onValidateSchema(connection: SQLiteConnection):
          RoomOpenDelegate.ValidationResult {
        val _columnsMqMessageEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsMqMessageEntity.put("messageId", TableInfo.Column("messageId", "TEXT", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsMqMessageEntity.put("clientHandle", TableInfo.Column("clientHandle", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsMqMessageEntity.put("topic", TableInfo.Column("topic", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsMqMessageEntity.put("mqttMessage", TableInfo.Column("mqttMessage", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsMqMessageEntity.put("qos", TableInfo.Column("qos", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsMqMessageEntity.put("retained", TableInfo.Column("retained", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsMqMessageEntity.put("duplicate", TableInfo.Column("duplicate", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsMqMessageEntity.put("timestamp", TableInfo.Column("timestamp", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysMqMessageEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesMqMessageEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        _indicesMqMessageEntity.add(TableInfo.Index("index_MqMessageEntity_clientHandle", false,
            listOf("clientHandle"), listOf("ASC")))
        val _infoMqMessageEntity: TableInfo = TableInfo("MqMessageEntity", _columnsMqMessageEntity,
            _foreignKeysMqMessageEntity, _indicesMqMessageEntity)
        val _existingMqMessageEntity: TableInfo = read(connection, "MqMessageEntity")
        if (!_infoMqMessageEntity.equals(_existingMqMessageEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |MqMessageEntity(info.mqtt.android.service.room.entity.MqMessageEntity).
              | Expected:
              |""".trimMargin() + _infoMqMessageEntity + """
              |
              | Found:
              |""".trimMargin() + _existingMqMessageEntity)
        }
        val _columnsPingEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPingEntity.put("timestamp", TableInfo.Column("timestamp", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPingEntity.put("clientId", TableInfo.Column("clientId", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPingEntity.put("serverURI", TableInfo.Column("serverURI", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPingEntity.put("success", TableInfo.Column("success", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPingEntity.put("message", TableInfo.Column("message", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPingEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPingEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        _indicesPingEntity.add(TableInfo.Index("index_PingEntity_timestamp", false,
            listOf("timestamp"), listOf("ASC")))
        val _infoPingEntity: TableInfo = TableInfo("PingEntity", _columnsPingEntity,
            _foreignKeysPingEntity, _indicesPingEntity)
        val _existingPingEntity: TableInfo = read(connection, "PingEntity")
        if (!_infoPingEntity.equals(_existingPingEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PingEntity(info.mqtt.android.service.room.entity.PingEntity).
              | Expected:
              |""".trimMargin() + _infoPingEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPingEntity)
        }
        return RoomOpenDelegate.ValidationResult(true, null)
      }
    }
    return _openDelegate
  }

  protected override fun createInvalidationTracker(): InvalidationTracker {
    val _shadowTablesMap: MutableMap<String, String> = mutableMapOf()
    val _viewTables: MutableMap<String, Set<String>> = mutableMapOf()
    return InvalidationTracker(this, _shadowTablesMap, _viewTables, "MqMessageEntity", "PingEntity")
  }

  public override fun clearAllTables() {
    super.performClear(false, "MqMessageEntity", "PingEntity")
  }

  protected override fun getRequiredTypeConverterClasses(): Map<KClass<*>, List<KClass<*>>> {
    val _typeConvertersMap: MutableMap<KClass<*>, List<KClass<*>>> = mutableMapOf()
    _typeConvertersMap.put(MqMessageDao::class, MqMessageDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(PingDao::class, PingDao_Impl.getRequiredConverters())
    return _typeConvertersMap
  }

  public override fun getRequiredAutoMigrationSpecClasses(): Set<KClass<out AutoMigrationSpec>> {
    val _autoMigrationSpecsSet: MutableSet<KClass<out AutoMigrationSpec>> = mutableSetOf()
    return _autoMigrationSpecsSet
  }

  public override
      fun createAutoMigrations(autoMigrationSpecs: Map<KClass<out AutoMigrationSpec>, AutoMigrationSpec>):
      List<Migration> {
    val _autoMigrations: MutableList<Migration> = mutableListOf()
    return _autoMigrations
  }

  public override fun persistenceDao(): MqMessageDao = _mqMessageDao.value

  public override fun pingDao(): PingDao = _pingDao.value
}
