package info.mqtt.android.service.room

import androidx.room.EntityDeleteOrUpdateAdapter
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.getTotalChangedRows
import androidx.room.util.performBlocking
import androidx.sqlite.SQLiteStatement
import info.mqtt.android.service.QoS
import info.mqtt.android.service.room.entity.MqMessageEntity
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.jvm.JvmName
import kotlin.reflect.KClass
import org.eclipse.paho.client.mqttv3.MqttMessage

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class MqMessageDao_Impl(
  __db: RoomDatabase,
) : MqMessageDao {
  private val __db: RoomDatabase

  public override val all: List<MqMessageEntity>
    get() = getAll()

  private val __insertAdapterOfMqMessageEntity: EntityInsertAdapter<MqMessageEntity>

  private val __converters: Converters = Converters()

  private val __deleteAdapterOfMqMessageEntity: EntityDeleteOrUpdateAdapter<MqMessageEntity>

  private val __updateAdapterOfMqMessageEntity: EntityDeleteOrUpdateAdapter<MqMessageEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfMqMessageEntity = object : EntityInsertAdapter<MqMessageEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `MqMessageEntity` (`messageId`,`clientHandle`,`topic`,`mqttMessage`,`qos`,`retained`,`duplicate`,`timestamp`) VALUES (?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: MqMessageEntity) {
        statement.bindText(1, entity.messageId)
        statement.bindText(2, entity.clientHandle)
        statement.bindText(3, entity.topic)
        val _tmp: String = __converters.fromMqttMessage(entity.mqttMessage)
        statement.bindText(4, _tmp)
        val _tmp_1: Int = __converters.fromQoS(entity.qos)
        statement.bindLong(5, _tmp_1.toLong())
        val _tmp_2: Int = if (entity.retained) 1 else 0
        statement.bindLong(6, _tmp_2.toLong())
        val _tmp_3: Int = if (entity.duplicate) 1 else 0
        statement.bindLong(7, _tmp_3.toLong())
        statement.bindLong(8, entity.timestamp)
      }
    }
    this.__deleteAdapterOfMqMessageEntity = object : EntityDeleteOrUpdateAdapter<MqMessageEntity>()
        {
      protected override fun createQuery(): String =
          "DELETE FROM `MqMessageEntity` WHERE `messageId` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: MqMessageEntity) {
        statement.bindText(1, entity.messageId)
      }
    }
    this.__updateAdapterOfMqMessageEntity = object : EntityDeleteOrUpdateAdapter<MqMessageEntity>()
        {
      protected override fun createQuery(): String =
          "UPDATE OR ABORT `MqMessageEntity` SET `messageId` = ?,`clientHandle` = ?,`topic` = ?,`mqttMessage` = ?,`qos` = ?,`retained` = ?,`duplicate` = ?,`timestamp` = ? WHERE `messageId` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: MqMessageEntity) {
        statement.bindText(1, entity.messageId)
        statement.bindText(2, entity.clientHandle)
        statement.bindText(3, entity.topic)
        val _tmp: String = __converters.fromMqttMessage(entity.mqttMessage)
        statement.bindText(4, _tmp)
        val _tmp_1: Int = __converters.fromQoS(entity.qos)
        statement.bindLong(5, _tmp_1.toLong())
        val _tmp_2: Int = if (entity.retained) 1 else 0
        statement.bindLong(6, _tmp_2.toLong())
        val _tmp_3: Int = if (entity.duplicate) 1 else 0
        statement.bindLong(7, _tmp_3.toLong())
        statement.bindLong(8, entity.timestamp)
        statement.bindText(9, entity.messageId)
      }
    }
  }

  public override fun insert(mqMessageEntity: MqMessageEntity): Long = performBlocking(__db, false,
      true) { _connection ->
    val _result: Long = __insertAdapterOfMqMessageEntity.insertAndReturnId(_connection,
        mqMessageEntity)
    _result
  }

  public override fun delete(mqMessageEntity: MqMessageEntity): Unit = performBlocking(__db, false,
      true) { _connection ->
    __deleteAdapterOfMqMessageEntity.handle(_connection, mqMessageEntity)
  }

  public override fun updateAll(vararg mqMessageEntity: MqMessageEntity): Unit =
      performBlocking(__db, false, true) { _connection ->
    __updateAdapterOfMqMessageEntity.handleMultiple(_connection, mqMessageEntity)
  }

  @JvmName("_privateGetAll")
  private fun getAll(): List<MqMessageEntity> {
    val _sql: String = "SELECT * FROM MQMessageEntity"
    return performBlocking(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfMessageId: Int = getColumnIndexOrThrow(_stmt, "messageId")
        val _columnIndexOfClientHandle: Int = getColumnIndexOrThrow(_stmt, "clientHandle")
        val _columnIndexOfTopic: Int = getColumnIndexOrThrow(_stmt, "topic")
        val _columnIndexOfMqttMessage: Int = getColumnIndexOrThrow(_stmt, "mqttMessage")
        val _columnIndexOfQos: Int = getColumnIndexOrThrow(_stmt, "qos")
        val _columnIndexOfRetained: Int = getColumnIndexOrThrow(_stmt, "retained")
        val _columnIndexOfDuplicate: Int = getColumnIndexOrThrow(_stmt, "duplicate")
        val _columnIndexOfTimestamp: Int = getColumnIndexOrThrow(_stmt, "timestamp")
        val _result: MutableList<MqMessageEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: MqMessageEntity
          val _tmpMessageId: String
          _tmpMessageId = _stmt.getText(_columnIndexOfMessageId)
          val _tmpClientHandle: String
          _tmpClientHandle = _stmt.getText(_columnIndexOfClientHandle)
          val _tmpTopic: String
          _tmpTopic = _stmt.getText(_columnIndexOfTopic)
          val _tmpMqttMessage: MqttMessage
          val _tmp: String
          _tmp = _stmt.getText(_columnIndexOfMqttMessage)
          _tmpMqttMessage = __converters.toMqttMessage(_tmp)
          val _tmpQos: QoS
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfQos).toInt()
          _tmpQos = __converters.toQoS(_tmp_1)
          val _tmpRetained: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfRetained).toInt()
          _tmpRetained = _tmp_2 != 0
          val _tmpDuplicate: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfDuplicate).toInt()
          _tmpDuplicate = _tmp_3 != 0
          val _tmpTimestamp: Long
          _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp)
          _item =
              MqMessageEntity(_tmpMessageId,_tmpClientHandle,_tmpTopic,_tmpMqttMessage,_tmpQos,_tmpRetained,_tmpDuplicate,_tmpTimestamp)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun allArrived(clientHandle: String): List<MqMessageEntity> {
    val _sql: String = "SELECT * FROM MQMessageEntity WHERE clientHandle = ? ORDER BY timestamp ASC"
    return performBlocking(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, clientHandle)
        val _columnIndexOfMessageId: Int = getColumnIndexOrThrow(_stmt, "messageId")
        val _columnIndexOfClientHandle: Int = getColumnIndexOrThrow(_stmt, "clientHandle")
        val _columnIndexOfTopic: Int = getColumnIndexOrThrow(_stmt, "topic")
        val _columnIndexOfMqttMessage: Int = getColumnIndexOrThrow(_stmt, "mqttMessage")
        val _columnIndexOfQos: Int = getColumnIndexOrThrow(_stmt, "qos")
        val _columnIndexOfRetained: Int = getColumnIndexOrThrow(_stmt, "retained")
        val _columnIndexOfDuplicate: Int = getColumnIndexOrThrow(_stmt, "duplicate")
        val _columnIndexOfTimestamp: Int = getColumnIndexOrThrow(_stmt, "timestamp")
        val _result: MutableList<MqMessageEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: MqMessageEntity
          val _tmpMessageId: String
          _tmpMessageId = _stmt.getText(_columnIndexOfMessageId)
          val _tmpClientHandle: String
          _tmpClientHandle = _stmt.getText(_columnIndexOfClientHandle)
          val _tmpTopic: String
          _tmpTopic = _stmt.getText(_columnIndexOfTopic)
          val _tmpMqttMessage: MqttMessage
          val _tmp: String
          _tmp = _stmt.getText(_columnIndexOfMqttMessage)
          _tmpMqttMessage = __converters.toMqttMessage(_tmp)
          val _tmpQos: QoS
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfQos).toInt()
          _tmpQos = __converters.toQoS(_tmp_1)
          val _tmpRetained: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfRetained).toInt()
          _tmpRetained = _tmp_2 != 0
          val _tmpDuplicate: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfDuplicate).toInt()
          _tmpDuplicate = _tmp_3 != 0
          val _tmpTimestamp: Long
          _tmpTimestamp = _stmt.getLong(_columnIndexOfTimestamp)
          _item =
              MqMessageEntity(_tmpMessageId,_tmpClientHandle,_tmpTopic,_tmpMqttMessage,_tmpQos,_tmpRetained,_tmpDuplicate,_tmpTimestamp)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun deleteId(clientHandle: String, id: String): Int {
    val _sql: String = "DELETE FROM MqMessageEntity WHERE clientHandle = ? AND messageId = ?"
    return performBlocking(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, clientHandle)
        _argIndex = 2
        _stmt.bindText(_argIndex, id)
        _stmt.step()
        getTotalChangedRows(_connection)
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun deleteClientHandle(clientHandle: String): Int {
    val _sql: String = "DELETE FROM MqMessageEntity WHERE clientHandle = ?"
    return performBlocking(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, clientHandle)
        _stmt.step()
        getTotalChangedRows(_connection)
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
