/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.ping;

import android.content.Context;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import info.mqtt.android.service.MqttService;
import info.mqtt.android.service.ping.PingWorker;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Linfo/mqtt/android/service/ping/AlarmPingSender;", "Lorg/eclipse/paho/client/mqttv3/MqttPingSender;", "service", "Linfo/mqtt/android/service/MqttService;", "(Linfo/mqtt/android/service/MqttService;)V", "getService", "()Linfo/mqtt/android/service/MqttService;", "workManager", "Landroidx/work/WorkManager;", "init", "", "comms", "Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;", "schedule", "delayInMilliseconds", "", "start", "stop", "Companion", "serviceLibrary_release"})
public final class AlarmPingSender
implements MqttPingSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MqttService service;
    @NotNull
    private final WorkManager workManager;
    @NotNull
    private static final String PING_JOB = "PING_JOB";
    @Nullable
    private static ClientComms clientComms;

    public AlarmPingSender(@NotNull MqttService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        WorkManager workManager = WorkManager.getInstance((Context)((Context)this.service));
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(...)");
        this.workManager = workManager;
    }

    @NotNull
    public final MqttService getService() {
        return this.service;
    }

    public void init(@NotNull ClientComms comms) {
        Intrinsics.checkNotNullParameter((Object)comms, (String)"comms");
        clientComms = comms;
    }

    public void start() {
        ClientComms clientComms = AlarmPingSender.clientComms;
        Intrinsics.checkNotNull((Object)clientComms);
        this.schedule(clientComms.getKeepAlive());
    }

    public void stop() {
        this.workManager.cancelUniqueWork(PING_JOB);
    }

    public void schedule(long delayInMilliseconds) {
        Timber.Forest.d("Schedule next alarm at " + (System.currentTimeMillis() + delayInMilliseconds), new Object[0]);
        this.workManager.enqueueUniqueWork(PING_JOB, ExistingWorkPolicy.REPLACE, (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PingWorker.class).setInitialDelay(delayInMilliseconds, TimeUnit.MILLISECONDS)).build());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Linfo/mqtt/android/service/ping/AlarmPingSender$Companion;", "", "()V", "PING_JOB", "", "clientComms", "Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;", "getClientComms$serviceLibrary_release", "()Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;", "setClientComms$serviceLibrary_release", "(Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;)V", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ClientComms getClientComms$serviceLibrary_release() {
            return clientComms;
        }

        public final void setClientComms$serviceLibrary_release(@Nullable ClientComms clientComms) {
            AlarmPingSender.clientComms = clientComms;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

