/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import info.mqtt.android.service.Ack;
import info.mqtt.android.service.MqttConnectTokenAndroid;
import info.mqtt.android.service.MqttDeliveryTokenAndroid;
import info.mqtt.android.service.MqttService;
import info.mqtt.android.service.MqttServiceBinder;
import info.mqtt.android.service.MqttTokenAndroid;
import info.mqtt.android.service.MqttTraceHandler;
import info.mqtt.android.service.ParcelableMqttMessage;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.Status;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u0085\u00012\u00020\u00012\u00020\u0002:\u0004\u0085\u0001\u0086\u0001B5\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000fJ\b\u0010,\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020\u0015H\u0016J\u001c\u0010-\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0012H\u0016J$\u0010-\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00122\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016J\u0012\u00102\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0012\u00105\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0012\u00106\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0010\u00107\u001a\u00020*2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0015H\u0016J\u001c\u0010:\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<H\u0016J\"\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010+\u001a\u000200H\u0016J\b\u0010=\u001a\u00020*H\u0016J\u0010\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020*2\u0006\u0010;\u001a\u00020<2\u0006\u0010>\u001a\u00020<H\u0016J\u0010\u0010?\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0002J\b\u0010@\u001a\u00020*H\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u00108\u001a\u000209H\u0016J\b\u0010C\u001a\u000209H\u0016J\b\u0010D\u001a\u00020\u0006H\u0016J\b\u0010E\u001a\u000209H\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u000204H\u0002J\u0013\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0016\u00a2\u0006\u0002\u0010JJ\u0018\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020\u0006J\b\u0010P\u001a\u00020\u0006H\u0016J\b\u0010Q\u001a\u00020\u001eH\u0016J\u0012\u0010R\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0018\u0010S\u001a\u00020*2\u0006\u0010(\u001a\u0002092\u0006\u0010T\u001a\u000209H\u0016J\u0010\u0010U\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0002J\u0018\u0010V\u001a\u00020*2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010W\u001a\u00020XH\u0016J(\u0010Y\u001a\u00020I2\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010[\u001a\u00020\\2\u0006\u0010T\u001a\u0002092\u0006\u0010]\u001a\u00020\u001eH\u0016J<\u0010Y\u001a\u00020I2\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010[\u001a\u00020\\2\u0006\u0010T\u001a\u0002092\u0006\u0010]\u001a\u00020\u001e2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016J\u0018\u0010Y\u001a\u00020I2\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010^\u001a\u00020BH\u0016J,\u0010Y\u001a\u00020I2\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010^\u001a\u00020B2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016J\b\u0010_\u001a\u00020*H\u0016J\u0010\u0010`\u001a\u00020*2\u0006\u0010a\u001a\u00020\u0001H\u0002J\u0006\u0010b\u001a\u00020*J\u0010\u0010c\u001a\u00020\u001e2\u0006\u0010d\u001a\u00020IH\u0016J\u0012\u0010e\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010f\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010g\u001a\u00020*2\u0006\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000fH\u0016J\u000e\u0010k\u001a\u00020*2\u0006\u0010l\u001a\u00020\u0019J\u0010\u0010m\u001a\u00020*2\u0006\u0010n\u001a\u00020\u001eH\u0016J\u0010\u0010o\u001a\u00020*2\b\u0010$\u001a\u0004\u0018\u00010%J\u000e\u0010p\u001a\u00020*2\u0006\u0010&\u001a\u00020\u001eJ\u001a\u0010q\u001a\u00020*2\b\u0010d\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u000204H\u0002J\u0012\u0010r\u001a\u00020*2\b\u0010d\u001a\u0004\u0018\u00010\u0015H\u0002J#\u0010s\u001a\u00020\u00152\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00060H2\u0006\u0010T\u001a\u00020tH\u0016\u00a2\u0006\u0002\u0010uJ7\u0010s\u001a\u00020\u00152\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00060H2\u0006\u0010T\u001a\u00020t2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016\u00a2\u0006\u0002\u0010vJE\u0010s\u001a\u00020\u00152\f\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00060H2\u0006\u0010T\u001a\u00020t2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u0001002\f\u0010x\u001a\b\u0012\u0004\u0012\u00020y0HH\u0016\u00a2\u0006\u0002\u0010zJ1\u0010s\u001a\u00020\u00152\f\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00060H2\u0006\u0010T\u001a\u00020t2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020y0HH\u0016\u00a2\u0006\u0002\u0010{J\u0018\u0010s\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010T\u001a\u000209H\u0016J,\u0010s\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010T\u001a\u0002092\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016J4\u0010s\u001a\u00020\u00152\u0006\u0010|\u001a\u00020\u00062\u0006\u0010T\u001a\u0002092\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u0001002\u0006\u0010}\u001a\u00020yH\u0016J \u0010s\u001a\u00020\u00152\u0006\u0010|\u001a\u00020\u00062\u0006\u0010T\u001a\u0002092\u0006\u0010}\u001a\u00020yH\u0016J\u0010\u0010~\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0002J\u0012\u0010\u007f\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0011\u0010\u0080\u0001\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0002J\u0007\u0010\u0081\u0001\u001a\u00020*J\u001d\u0010\u0082\u0001\u001a\u00020\u00152\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00060HH\u0016\u00a2\u0006\u0003\u0010\u0083\u0001J1\u0010\u0082\u0001\u001a\u00020\u00152\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00060H2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016\u00a2\u0006\u0003\u0010\u0084\u0001J\u0011\u0010\u0082\u0001\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\u0006H\u0016J%\u0010\u0082\u0001\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\u00062\b\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u000100H\u0016R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00060!R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0087\u0001"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient;", "Landroid/content/BroadcastReceiver;", "Lorg/eclipse/paho/client/mqttv3/IMqttAsyncClient;", "context", "Landroid/content/Context;", "serverURI", "", "clientId", "ackType", "Linfo/mqtt/android/service/Ack;", "persistence", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Linfo/mqtt/android/service/Ack;Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;)V", "callbacksList", "Ljava/util/ArrayList;", "Lorg/eclipse/paho/client/mqttv3/MqttCallback;", "Lkotlin/collections/ArrayList;", "clientConnectOptions", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "clientHandle", "connectToken", "Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "getContext", "()Landroid/content/Context;", "foregroundServiceNotification", "Landroid/app/Notification;", "messageAck", "mqttService", "Linfo/mqtt/android/service/MqttService;", "receiverRegistered", "", "serviceBound", "serviceConnection", "Linfo/mqtt/android/service/MqttAndroidClient$MyServiceConnection;", "tokenList", "", "traceCallback", "Linfo/mqtt/android/service/MqttTraceHandler;", "traceEnabled", "acknowledgeMessage", "messageId", "addCallback", "", "callback", "close", "connect", "userContext", "", "Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;", "options", "connectAction", "data", "Landroid/os/Bundle;", "connectExtendedAction", "connectionLostAction", "deleteBufferedMessage", "bufferIndex", "", "disconnect", "quiesceTimeout", "", "disconnectForcibly", "disconnectTimeout", "disconnected", "doConnect", "getBufferedMessage", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "getBufferedMessageCount", "getClientId", "getInFlightMessageCount", "getMqttToken", "getPendingDeliveryTokens", "", "Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "()[Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "getSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "keyStore", "Ljava/io/InputStream;", "password", "getServerURI", "isConnected", "messageArrivedAction", "messageArrivedComplete", "qos", "messageDeliveredAction", "onReceive", "intent", "Landroid/content/Intent;", "publish", "topic", "payload", "", "retained", "message", "reconnect", "registerReceiver", "receiver", "registerResources", "removeMessage", "token", "removeMqttToken", "sendAction", "setBufferOpts", "bufferOpts", "Lorg/eclipse/paho/client/mqttv3/DisconnectedBufferOptions;", "setCallback", "setForegroundService", "notification", "setManualAcks", "manualAcks", "setTraceCallback", "setTraceEnabled", "simpleAction", "storeToken", "subscribe", "", "([Ljava/lang/String;[I)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;[ILjava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "topicFilters", "messageListeners", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "([Ljava/lang/String;[ILjava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;[I[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "topicFilter", "messageListener", "subscribeAction", "traceAction", "unSubscribeAction", "unregisterResources", "unsubscribe", "([Ljava/lang/String;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;Ljava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "Companion", "MyServiceConnection", "serviceLibrary_release"})
@SourceDebugExtension(value={"SMAP\nMqttAndroidClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MqttAndroidClient.kt\ninfo/mqtt/android/service/MqttAndroidClient\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 BundleExt.kt\ninfo/mqtt/android/service/extension/BundleExtKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1294:1\n11365#2:1295\n11700#2,3:1296\n37#3,2:1299\n1855#4,2:1301\n1855#4,2:1310\n1855#4,2:1312\n1855#4,2:1342\n1855#4,2:1351\n1855#4,2:1353\n9#5,7:1303\n17#5,7:1314\n17#5,7:1321\n17#5,7:1328\n17#5,7:1335\n9#5,7:1344\n17#5,7:1355\n1#6:1362\n*S KotlinDebug\n*F\n+ 1 MqttAndroidClient.kt\ninfo/mqtt/android/service/MqttAndroidClient\n*L\n711#1:1295\n711#1:1296,3\n711#1:1299,2\n964#1:1301,2\n974#1:1310,2\n983#1:1312,2\n1055#1:1342,2\n1071#1:1351,2\n1077#1:1353,2\n973#1:1303,7\n998#1:1314,7\n1002#1:1321,7\n1003#1:1328,7\n1052#1:1335,7\n1068#1:1344,7\n1098#1:1355,7\n*E\n"})
public final class MqttAndroidClient
extends BroadcastReceiver
implements IMqttAsyncClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String serverURI;
    @NotNull
    private final String clientId;
    @Nullable
    private MqttClientPersistence persistence;
    @NotNull
    private final MyServiceConnection serviceConnection;
    @NotNull
    private final List<IMqttToken> tokenList;
    @NotNull
    private final Ack messageAck;
    @Nullable
    private MqttService mqttService;
    @Nullable
    private String clientHandle;
    @Nullable
    private MqttConnectOptions clientConnectOptions;
    @Nullable
    private IMqttToken connectToken;
    @NotNull
    private ArrayList<MqttCallback> callbacksList;
    @Nullable
    private MqttTraceHandler traceCallback;
    private boolean traceEnabled;
    private volatile boolean receiverRegistered;
    private volatile boolean serviceBound;
    @Nullable
    private Notification foregroundServiceNotification;
    private static final String SERVICE_NAME = MqttService.class.getName();
    private static final int FOREGROUND_ID = 0x4D0000;

    @JvmOverloads
    public MqttAndroidClient(@NotNull Context context, @NotNull String serverURI, @NotNull String clientId, @NotNull Ack ackType, @Nullable MqttClientPersistence persistence) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)((Object)ackType), (String)"ackType");
        this.context = context;
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        this.serviceConnection = new MyServiceConnection();
        this.tokenList = new ArrayList();
        this.messageAck = ackType;
        this.callbacksList = new ArrayList();
    }

    public /* synthetic */ MqttAndroidClient(Context context, String string, String string2, Ack ack, MqttClientPersistence mqttClientPersistence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ack = Ack.AUTO_ACK;
        }
        if ((n & 0x10) != 0) {
            mqttClientPersistence = null;
        }
        this(context, string, string2, ack, mqttClientPersistence);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        if (this.clientHandle == null) return false;
        if (this.mqttService == null) return false;
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        if (!mqttService.isConnected(string)) return false;
        return true;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @NotNull
    public String getServerURI() {
        return this.serverURI;
    }

    public void close() {
        block1: {
            MqttService mqttService = this.mqttService;
            if (mqttService == null) break block1;
            MqttService it = mqttService;
            boolean bl = false;
            if (this.clientHandle == null) {
                String string = this.context.getApplicationInfo().packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.applicationInfo.packageName");
                this.clientHandle = it.getClient(this.serverURI, this.clientId, string, this.persistence);
            }
            String string = this.clientHandle;
            Intrinsics.checkNotNull((Object)string);
            it.close(string);
        }
    }

    @NotNull
    public IMqttToken connect() {
        return this.connect(null, null);
    }

    @NotNull
    public IMqttToken connect(@NotNull MqttConnectOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.connect(options, null, null);
    }

    @NotNull
    public IMqttToken connect(@Nullable Object userContext, @Nullable IMqttActionListener callback) {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @NotNull
    public IMqttToken connect(@NotNull MqttConnectOptions options, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.clientConnectOptions = options;
        this.connectToken = token2;
        if (this.mqttService == null) {
            ComponentName service;
            Intent serviceStartIntent;
            block9: {
                serviceStartIntent = new Intent();
                serviceStartIntent.setClassName(this.context, SERVICE_NAME);
                service = null;
                if (Build.VERSION.SDK_INT >= 26 && this.foregroundServiceNotification != null) {
                    serviceStartIntent.putExtra(MqttService.Companion.getMQTT_FOREGROUND_SERVICE_NOTIFICATION(), (Parcelable)this.foregroundServiceNotification);
                    serviceStartIntent.putExtra(MqttService.Companion.getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID(), 0x4D0000);
                    service = this.context.startForegroundService(serviceStartIntent);
                } else {
                    try {
                        service = this.context.startService(serviceStartIntent);
                    }
                    catch (IllegalStateException ex) {
                        IMqttActionListener listener2;
                        IMqttActionListener iMqttActionListener = listener2 = token2.getActionCallback();
                        if (iMqttActionListener == null) break block9;
                        iMqttActionListener.onFailure(token2, (Throwable)ex);
                    }
                }
            }
            if (service == null) {
                IMqttActionListener listener3;
                IMqttActionListener iMqttActionListener = listener3 = token2.getActionCallback();
                if (iMqttActionListener != null) {
                    iMqttActionListener.onFailure(token2, (Throwable)new RuntimeException("cannot start service " + SERVICE_NAME));
                }
            }
            this.context.bindService(serviceStartIntent, (ServiceConnection)this.serviceConnection, 1);
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        } else {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MqttAndroidClient this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MqttAndroidClient.access$doConnect(this.this$0);
                            if (!MqttAndroidClient.access$getReceiverRegistered$p(this.this$0)) {
                                MqttAndroidClient.access$registerReceiver(this.this$0, this.this$0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return token2;
    }

    private final void registerReceiver(BroadcastReceiver receiver) {
        IntentFilter filter = new IntentFilter();
        filter.addAction(".callbackToActivity.v0");
        if (Build.VERSION.SDK_INT >= 33) {
            this.context.registerReceiver(receiver, filter, 4);
        } else {
            this.context.registerReceiver(receiver, filter);
        }
        this.receiverRegistered = true;
    }

    private final void doConnect() {
        block3: {
            if (this.clientHandle == null) {
                MqttService mqttService = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService);
                String string = this.context.getApplicationInfo().packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.applicationInfo.packageName");
                this.clientHandle = mqttService.getClient(this.serverURI, this.clientId, string, this.persistence);
            }
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.setTraceEnabled(this.traceEnabled);
            MqttService mqttService2 = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService2);
            mqttService2.setTraceCallbackId(this.clientHandle);
            this.storeToken(this.connectToken);
            try {
                MqttService mqttService3 = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService3);
                String string = this.clientHandle;
                Intrinsics.checkNotNull((Object)string);
                mqttService3.connect(string, this.clientConnectOptions, this.connectToken);
            }
            catch (Exception e) {
                IMqttActionListener listener2;
                IMqttToken iMqttToken = this.connectToken;
                Intrinsics.checkNotNull((Object)iMqttToken);
                IMqttActionListener iMqttActionListener = listener2 = iMqttToken.getActionCallback();
                if (iMqttActionListener == null) break block3;
                iMqttActionListener.onFailure(this.connectToken, (Throwable)e);
            }
        }
    }

    @NotNull
    public IMqttToken disconnect() {
        IMqttToken token2 = new MqttTokenAndroid(this, null, null, null, 8, null);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, null, token2);
        return token2;
    }

    @NotNull
    public IMqttToken disconnect(long quiesceTimeout) {
        IMqttToken token2 = new MqttTokenAndroid(this, null, null, null, 8, null);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, quiesceTimeout, null, token2);
        return token2;
    }

    @NotNull
    public IMqttToken disconnect(@Nullable Object userContext, @Nullable IMqttActionListener callback) {
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, null, token2);
        return token2;
    }

    @NotNull
    public IMqttToken disconnect(long quiesceTimeout, @Nullable Object userContext, @NotNull IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, quiesceTimeout, null, token2);
        return token2;
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull byte[] payload, int qos, boolean retained) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull MqttMessage message) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.publish(topic, message, null, null);
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull byte[] payload, int qos, boolean retained, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        MqttDeliveryTokenAndroid token2 = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        IMqttDeliveryToken internalToken = mqttService.publish(string, topic, payload, QoS.Companion.valueOf(qos), retained, null, token2);
        token2.setDelegate((IMqttToken)internalToken);
        return token2;
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull MqttMessage message, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MqttDeliveryTokenAndroid token2 = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        IMqttDeliveryToken internalToken = mqttService.publish(string, topic, message, null, token2);
        token2.setDelegate((IMqttToken)internalToken);
        return token2;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topic, int qos) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.subscribe(topic, qos, null, null);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topic, @NotNull int[] qos) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        return this.subscribe(topic, qos, null, null);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topic, int qos, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        String[] stringArray = new String[]{topic};
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, stringArray);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.subscribe(string, topic, QoS.Companion.valueOf(qos), null, token2);
        return token2;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topic, @NotNull int[] qos, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, topic);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.subscribe(string, topic, qos, null, token2);
        return token2;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topicFilter, int qos, @Nullable Object userContext, @Nullable IMqttActionListener callback, @NotNull IMqttMessageListener messageListener) {
        Intrinsics.checkNotNullParameter((Object)topicFilter, (String)"topicFilter");
        Intrinsics.checkNotNullParameter((Object)messageListener, (String)"messageListener");
        Object[] objectArray = new String[]{topicFilter};
        String[] stringArray = objectArray;
        objectArray = new int[1];
        objectArray[0] = (String)qos;
        Object[] objectArray2 = objectArray;
        objectArray = new IMqttMessageListener[]{messageListener};
        return this.subscribe(stringArray, (int[])objectArray2, userContext, callback, (IMqttMessageListener[])objectArray);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topicFilter, int qos, @NotNull IMqttMessageListener messageListener) {
        Intrinsics.checkNotNullParameter((Object)topicFilter, (String)"topicFilter");
        Intrinsics.checkNotNullParameter((Object)messageListener, (String)"messageListener");
        return this.subscribe(topicFilter, qos, null, null, messageListener);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topicFilters, @NotNull int[] qos, @NotNull IMqttMessageListener[] messageListeners) {
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)messageListeners, (String)"messageListeners");
        return this.subscribe(topicFilters, qos, null, null, messageListeners);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IMqttToken subscribe(@NotNull String[] topicFilters, @NotNull int[] qos, @Nullable Object userContext, @Nullable IMqttActionListener callback, @NotNull IMqttMessageListener[] messageListeners) {
        void $this$toTypedArray$iv;
        Collection<QoS> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)messageListeners, (String)"messageListeners");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, topicFilters);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        int[] nArray = qos;
        String[] stringArray = topicFilters;
        String string2 = string;
        MqttService mqttService2 = mqttService;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_18 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(QoS.Companion.valueOf((int)it));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        mqttService2.subscribe(string2, stringArray, thisCollection$iv.toArray(new QoS[0]), null, token2, messageListeners);
        return token2;
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.unsubscribe(topic, null, null);
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String[] topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.unsubscribe(topic, null, null);
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String topic, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.unsubscribe(string, topic, null, token2);
        return token2;
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String[] topic, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.unsubscribe(string, topic, null, token2);
        return token2;
    }

    public boolean removeMessage(@NotNull IMqttDeliveryToken token2) throws MqttException {
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        return false;
    }

    @NotNull
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getPendingDeliveryTokens(string);
    }

    public void setCallback(@NotNull MqttCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacksList.clear();
        this.callbacksList.add(callback);
    }

    public final void addCallback(@NotNull MqttCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacksList.add(callback);
    }

    public final void setTraceCallback(@Nullable MqttTraceHandler traceCallback) {
        this.traceCallback = traceCallback;
    }

    public final void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        MqttService mqttService = this.mqttService;
        if (mqttService != null) {
            mqttService.setTraceEnabled(traceEnabled);
        }
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Bundle data;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Bundle bundle = data = intent.getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        String handleFromIntent = bundle.getString(".clientHandle");
        if (handleFromIntent == null || !Intrinsics.areEqual((Object)handleFromIntent, (Object)this.clientHandle)) {
            return;
        }
        String action = data.getString(".callbackAction");
        if (Intrinsics.areEqual((Object)"connect", (Object)action)) {
            this.connectAction(data);
        } else if (Intrinsics.areEqual((Object)"connectExtended", (Object)action)) {
            this.connectExtendedAction(data);
        } else if (Intrinsics.areEqual((Object)"messageArrived", (Object)action)) {
            this.messageArrivedAction(data);
        } else if (Intrinsics.areEqual((Object)"subscribe", (Object)action)) {
            this.subscribeAction(data);
        } else if (Intrinsics.areEqual((Object)"unsubscribe", (Object)action)) {
            this.unSubscribeAction(data);
        } else if (Intrinsics.areEqual((Object)"send", (Object)action)) {
            this.sendAction(data);
        } else if (Intrinsics.areEqual((Object)"messageDelivered", (Object)action)) {
            this.messageDeliveredAction(data);
        } else if (Intrinsics.areEqual((Object)"onConnectionLost", (Object)action)) {
            this.connectionLostAction(data);
        } else if (Intrinsics.areEqual((Object)"disconnect", (Object)action)) {
            this.disconnected(data);
        } else if (Intrinsics.areEqual((Object)"trace", (Object)action)) {
            this.traceAction(data);
        } else {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("Callback action doesn't exist.");
        }
    }

    public final boolean acknowledgeMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        if (this.messageAck == Ack.MANUAL_ACK) {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            String string = this.clientHandle;
            Intrinsics.checkNotNull((Object)string);
            Status status = mqttService.acknowledgeMessageArrival(string, messageId);
            return status == Status.OK;
        }
        return false;
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void setManualAcks(boolean manualAcks) {
        throw new UnsupportedOperationException();
    }

    public void reconnect() throws MqttException {
    }

    private final void connectAction(Bundle data) {
        IMqttToken token2 = this.connectToken;
        MqttTokenAndroid mqttTokenAndroid = (MqttTokenAndroid)token2;
        Intrinsics.checkNotNull((Object)mqttTokenAndroid);
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        mqttTokenAndroid.setDelegate(new MqttConnectTokenAndroid(bundle.getBoolean("sessionPresent")));
        this.removeMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void disconnected(Bundle data) {
        IMqttToken token2;
        this.clientHandle = null;
        IMqttToken iMqttToken = token2 = this.removeMqttToken(data);
        if (iMqttToken != null) {
            IMqttToken it = iMqttToken;
            boolean bl = false;
            ((MqttTokenAndroid)it).notifyComplete();
        }
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback it = (MqttCallback)element$iv;
            boolean bl = false;
            it.connectionLost(null);
        }
    }

    private final void connectionLostAction(Bundle data) {
        Parcelable parcelable;
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        Bundle bundle2 = bundle;
        String key$iv = ".exception";
        boolean $i$f$parcelable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            parcelable = (Parcelable)$this$parcelable$iv.getParcelable(key$iv, Object.class);
        } else {
            Parcelable parcelable2 = $this$parcelable$iv.getParcelable(key$iv);
            if (!(parcelable2 instanceof Object)) {
                parcelable2 = null;
            }
            parcelable = (Parcelable)((Object)parcelable2);
        }
        Exception reason = (Exception)parcelable;
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback it = (MqttCallback)element$iv;
            boolean bl = false;
            it.connectionLost((Throwable)reason);
        }
    }

    private final void connectExtendedAction(Bundle data) {
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        boolean reconnect2 = bundle.getBoolean(".reconnect", false);
        String serverURI = data.getString(".serverURI");
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback callback = (MqttCallback)element$iv;
            boolean bl = false;
            if (!(callback instanceof MqttCallbackExtended)) continue;
            ((MqttCallbackExtended)callback).connectComplete(reconnect2, serverURI);
        }
    }

    private final void simpleAction(IMqttToken token2, Bundle data) {
        if (token2 != null) {
            Status status;
            Serializable serializable;
            Bundle bundle = data;
            String key$iv = ".callbackStatus";
            boolean $i$f$serializable = false;
            if (Build.VERSION.SDK_INT >= 33) {
                serializable = $this$serializable$iv.getSerializable(key$iv, Status.class);
            } else {
                Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
                if (!(serializable2 instanceof Status)) {
                    serializable2 = null;
                }
                serializable = (Serializable)((Object)((Status)((Object)serializable2)));
            }
            if ((status = (Status)((Object)serializable)) == Status.OK) {
                ((MqttTokenAndroid)token2).notifyComplete();
            } else {
                Throwable exceptionThrown;
                Serializable serializable3;
                Serializable serializable4;
                key$iv = data;
                String key$iv2 = ".errorMessage";
                boolean $i$f$serializable2 = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    serializable4 = $this$serializable$iv.getSerializable(key$iv2, String.class);
                } else {
                    Serializable serializable5 = $this$serializable$iv.getSerializable(key$iv2);
                    if (!(serializable5 instanceof String)) {
                        serializable5 = null;
                    }
                    serializable4 = (Serializable)((Object)((String)((Object)serializable5)));
                }
                String errorMessage = (String)((Object)serializable4);
                key$iv2 = data;
                String key$iv3 = ".exception";
                boolean $i$f$serializable3 = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    serializable3 = $this$serializable$iv.getSerializable(key$iv3, Throwable.class);
                } else {
                    Serializable serializable6 = $this$serializable$iv.getSerializable(key$iv3);
                    if (!(serializable6 instanceof Throwable)) {
                        serializable6 = null;
                    }
                    serializable3 = (Throwable)serializable6;
                }
                if ((exceptionThrown = (Throwable)serializable3) == null && errorMessage != null) {
                    exceptionThrown = new Throwable(errorMessage);
                } else if (exceptionThrown == null) {
                    Set set = data.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"data.keySet()");
                    String bundleToString2 = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(data){
                        final /* synthetic */ Bundle $data;
                        {
                            this.$data = $data;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(String key) {
                            return key + "=" + this.$data.getString(key);
                        }
                    }), (int)24, null);
                    exceptionThrown = new Throwable("No Throwable given\n" + bundleToString2);
                }
                ((MqttTokenAndroid)token2).notifyFailure(exceptionThrown);
            }
        } else {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("simpleAction : token is null");
        }
    }

    private final void sendAction(Bundle data) {
        IMqttToken token2 = this.getMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void subscribeAction(Bundle data) {
        IMqttToken token2 = this.removeMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void unSubscribeAction(Bundle data) {
        IMqttToken token2 = this.removeMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void messageDeliveredAction(Bundle data) {
        Serializable serializable;
        IMqttToken token2 = this.removeMqttToken(data);
        Bundle bundle = data;
        String key$iv = ".callbackStatus";
        boolean $i$f$serializable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable = $this$serializable$iv.getSerializable(key$iv, Status.class);
        } else {
            Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
            if (!(serializable2 instanceof Status)) {
                serializable2 = null;
            }
            serializable = (Serializable)((Object)((Status)((Object)serializable2)));
        }
        Status status = (Status)((Object)serializable);
        if (token2 != null && status == Status.OK && token2 instanceof IMqttDeliveryToken) {
            Iterable $this$forEach$iv = this.callbacksList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MqttCallback callback = (MqttCallback)element$iv;
                boolean bl = false;
                callback.deliveryComplete((IMqttDeliveryToken)token2);
            }
        }
    }

    private final void messageArrivedAction(Bundle data) {
        Parcelable parcelable;
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        String string = bundle.getString("messageId");
        Intrinsics.checkNotNull((Object)string);
        String messageId = string;
        String destinationName = data.getString("destinationName");
        Bundle bundle2 = data;
        String key$iv = ".PARCEL";
        boolean $i$f$parcelable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            parcelable = (Parcelable)$this$parcelable$iv.getParcelable(key$iv, ParcelableMqttMessage.class);
        } else {
            Parcelable parcelable2 = $this$parcelable$iv.getParcelable(key$iv);
            if (!(parcelable2 instanceof ParcelableMqttMessage)) {
                parcelable2 = null;
            }
            parcelable = (ParcelableMqttMessage)parcelable2;
        }
        Intrinsics.checkNotNull((Object)parcelable);
        ParcelableMqttMessage message = (ParcelableMqttMessage)parcelable;
        try {
            if (this.messageAck == Ack.AUTO_ACK) {
                $this$forEach$iv = this.callbacksList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MqttCallback callback = (MqttCallback)element$iv;
                    boolean bl = false;
                    callback.messageArrived(destinationName, (MqttMessage)message);
                }
                MqttService mqttService = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService);
                String string2 = this.clientHandle;
                Intrinsics.checkNotNull((Object)string2);
                mqttService.acknowledgeMessageArrival(string2, messageId);
            } else {
                message.setMessageId(messageId);
                $this$forEach$iv = this.callbacksList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MqttCallback callback = (MqttCallback)element$iv;
                    boolean bl = false;
                    callback.messageArrived(destinationName, (MqttMessage)message);
                }
            }
        }
        catch (Exception e) {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("messageArrivedAction failed: " + e);
        }
    }

    private final void traceAction(Bundle data) {
        block7: {
            MqttTraceHandler mqttTraceHandler = this.traceCallback;
            if (mqttTraceHandler == null) break block7;
            MqttTraceHandler it = mqttTraceHandler;
            boolean bl = false;
            Bundle bundle = data;
            Intrinsics.checkNotNull((Object)bundle);
            String severity = bundle.getString(".traceSeverity");
            String message = data.getString(".errorMessage");
            String string = severity;
            if (Intrinsics.areEqual((Object)string, (Object)"debug")) {
                it.traceDebug(message);
            } else if (Intrinsics.areEqual((Object)string, (Object)"error")) {
                it.traceError(message);
            } else {
                Serializable serializable;
                Bundle bundle2 = data;
                String key$iv = ".exception";
                boolean $i$f$serializable = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    serializable = $this$serializable$iv.getSerializable(key$iv, Exception.class);
                } else {
                    Serializable serializable2 = $this$serializable$iv.getSerializable(key$iv);
                    if (!(serializable2 instanceof Exception)) {
                        serializable2 = null;
                    }
                    serializable = (Exception)serializable2;
                }
                Exception e = (Exception)serializable;
                it.traceException(message, e);
            }
        }
    }

    private final synchronized void storeToken(IMqttToken token2) {
        block3: {
            Object v1;
            block2: {
                IMqttToken iMqttToken = token2;
                if (iMqttToken == null) break block3;
                IMqttToken it = iMqttToken;
                boolean bl = false;
                Iterable iterable = this.tokenList;
                for (Object t : iterable) {
                    IMqttToken it2 = (IMqttToken)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2, (Object)token2)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            IMqttToken tokenFound = v1;
            if (tokenFound == null) {
                this.tokenList.add(token2);
                Timber.Forest.d(token2 + " size=" + this.tokenList.size(), new Object[0]);
            }
        }
    }

    private final synchronized IMqttToken removeMqttToken(Bundle data) {
        String activityToken = data.getString(".activityToken");
        if (activityToken != null && !Intrinsics.areEqual((Object)activityToken, (Object)"null")) {
            Object v0;
            block2: {
                Iterable iterable = this.tokenList;
                for (Object t : iterable) {
                    IMqttToken it = (IMqttToken)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.toString(), (Object)activityToken)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            IMqttToken token2 = v0;
            TypeIntrinsics.asMutableCollection((Object)this.tokenList).remove(token2);
            Timber.Forest.d("search=" + activityToken + " " + this.tokenList.size(), new Object[0]);
            return token2;
        }
        return null;
    }

    private final synchronized IMqttToken getMqttToken(Bundle data) {
        Object v0;
        block1: {
            String activityToken = data.getString(".activityToken");
            Iterable iterable = this.tokenList;
            for (Object t : iterable) {
                IMqttToken it = (IMqttToken)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.toString(), (Object)activityToken)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        IMqttToken token2 = v0;
        return token2;
    }

    public final void setForegroundService(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.foregroundServiceNotification = notification;
    }

    public void setBufferOpts(@NotNull DisconnectedBufferOptions bufferOpts) {
        Intrinsics.checkNotNullParameter((Object)bufferOpts, (String)"bufferOpts");
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.setBufferOpts(string, bufferOpts);
    }

    public int getBufferedMessageCount() {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getBufferedMessageCount(string);
    }

    @NotNull
    public MqttMessage getBufferedMessage(int bufferIndex) {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getBufferedMessage(string, bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.deleteBufferedMessage(string, bufferIndex);
    }

    public int getInFlightMessageCount() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SSLSocketFactory getSSLSocketFactory(@Nullable InputStream keyStore, @NotNull String password) throws MqttSecurityException {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            SSLSocketFactory sslSockFactory = null;
            KeyStore keyStore2 = KeyStore.getInstance("BKS");
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"getInstance(\"BKS\")");
            KeyStore ts = keyStore2;
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            ts.load(keyStore, cArray);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(ts);
            TrustManager[] tm = tmf.getTrustManagers();
            SSLContext sSLContext = SSLContext.getInstance("TLSv1");
            Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"getInstance(\"TLSv1\")");
            SSLContext ctx = sSLContext;
            ctx.init(null, tm, null);
            SSLSocketFactory sSLSocketFactory = ctx.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"ctx.socketFactory");
            sslSockFactory = sSLSocketFactory;
        }
        catch (KeyStoreException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (IOException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        return var3_3;
    }

    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterResources() {
        if (this.receiverRegistered) {
            MqttAndroidClient mqttAndroidClient = this;
            synchronized (mqttAndroidClient) {
                boolean bl = false;
                this.context.unregisterReceiver((BroadcastReceiver)this);
                this.receiverRegistered = false;
                Unit unit = Unit.INSTANCE;
            }
            if (this.serviceBound) {
                try {
                    this.context.unbindService((ServiceConnection)this.serviceConnection);
                    this.serviceBound = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public final void registerResources() {
        if (!this.receiverRegistered) {
            this.registerReceiver(this);
        }
    }

    @JvmOverloads
    public MqttAndroidClient(@NotNull Context context, @NotNull String serverURI, @NotNull String clientId, @NotNull Ack ackType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)((Object)ackType), (String)"ackType");
        this(context, serverURI, clientId, ackType, null, 16, null);
    }

    @JvmOverloads
    public MqttAndroidClient(@NotNull Context context, @NotNull String serverURI, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this(context, serverURI, clientId, null, null, 24, null);
    }

    public static final /* synthetic */ boolean access$getReceiverRegistered$p(MqttAndroidClient $this) {
        return $this.receiverRegistered;
    }

    public static final /* synthetic */ void access$registerReceiver(MqttAndroidClient $this, BroadcastReceiver receiver) {
        $this.registerReceiver(receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient$Companion;", "", "()V", "FOREGROUND_ID", "", "SERVICE_NAME", "", "kotlin.jvm.PlatformType", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient$MyServiceConnection;", "Landroid/content/ServiceConnection;", "(Linfo/mqtt/android/service/MqttAndroidClient;)V", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "binder", "Landroid/os/IBinder;", "onServiceDisconnected", "serviceLibrary_release"})
    private final class MyServiceConnection
    implements ServiceConnection {
        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder binder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            if (MqttServiceBinder.class.isAssignableFrom(binder.getClass())) {
                MqttAndroidClient.this.mqttService = ((MqttServiceBinder)binder).getService();
                MqttAndroidClient.this.serviceBound = true;
                MqttAndroidClient.this.doConnect();
            }
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Timber.Forest.d("Service disconnected", new Object[0]);
            MqttAndroidClient.this.mqttService = null;
        }
    }
}

