/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.room;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import info.mqtt.android.service.room.MqMessageDao;
import info.mqtt.android.service.room.MqMessageDao_Impl;
import info.mqtt.android.service.room.MqMessageDatabase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MqMessageDatabase_Impl
extends MqMessageDatabase {
    private volatile MqMessageDao _mqMessageDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `MqMessageEntity` (`messageId` TEXT NOT NULL, `clientHandle` TEXT NOT NULL, `topic` TEXT NOT NULL, `mqttMessage` TEXT NOT NULL, `qos` INTEGER NOT NULL, `retained` INTEGER NOT NULL, `duplicate` INTEGER NOT NULL, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`messageId`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_MqMessageEntity_clientHandle` ON `MqMessageEntity` (`clientHandle`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '1569b25bb8b179d5ea5abec331608dd1')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `MqMessageEntity`");
                if (MqMessageDatabase_Impl.this.mCallbacks != null) {
                    int _size = MqMessageDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MqMessageDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (MqMessageDatabase_Impl.this.mCallbacks != null) {
                    int _size = MqMessageDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MqMessageDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                MqMessageDatabase_Impl.this.mDatabase = _db;
                MqMessageDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (MqMessageDatabase_Impl.this.mCallbacks != null) {
                    int _size = MqMessageDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MqMessageDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsMqMessageEntity = new HashMap<String, TableInfo.Column>(8);
                _columnsMqMessageEntity.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 1, null, 1));
                _columnsMqMessageEntity.put("clientHandle", new TableInfo.Column("clientHandle", "TEXT", true, 0, null, 1));
                _columnsMqMessageEntity.put("topic", new TableInfo.Column("topic", "TEXT", true, 0, null, 1));
                _columnsMqMessageEntity.put("mqttMessage", new TableInfo.Column("mqttMessage", "TEXT", true, 0, null, 1));
                _columnsMqMessageEntity.put("qos", new TableInfo.Column("qos", "INTEGER", true, 0, null, 1));
                _columnsMqMessageEntity.put("retained", new TableInfo.Column("retained", "INTEGER", true, 0, null, 1));
                _columnsMqMessageEntity.put("duplicate", new TableInfo.Column("duplicate", "INTEGER", true, 0, null, 1));
                _columnsMqMessageEntity.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysMqMessageEntity = new HashSet(0);
                HashSet<TableInfo.Index> _indicesMqMessageEntity = new HashSet<TableInfo.Index>(1);
                _indicesMqMessageEntity.add(new TableInfo.Index("index_MqMessageEntity_clientHandle", false, Arrays.asList("clientHandle"), Arrays.asList("ASC")));
                TableInfo _infoMqMessageEntity = new TableInfo("MqMessageEntity", _columnsMqMessageEntity, _foreignKeysMqMessageEntity, _indicesMqMessageEntity);
                TableInfo _existingMqMessageEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"MqMessageEntity");
                if (!_infoMqMessageEntity.equals((Object)_existingMqMessageEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "MqMessageEntity(info.mqtt.android.service.room.entity.MqMessageEntity).\n Expected:\n" + _infoMqMessageEntity + "\n Found:\n" + _existingMqMessageEntity);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "1569b25bb8b179d5ea5abec331608dd1", "9ccd73a516869ab5a16d53d895bdefd1");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"MqMessageEntity"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `MqMessageEntity`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(MqMessageDao.class, MqMessageDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqMessageDao persistenceDao() {
        if (this._mqMessageDao != null) {
            return this._mqMessageDao;
        }
        MqMessageDatabase_Impl mqMessageDatabase_Impl = this;
        synchronized (mqMessageDatabase_Impl) {
            if (this._mqMessageDao == null) {
                this._mqMessageDao = new MqMessageDao_Impl(this);
            }
            return this._mqMessageDao;
        }
    }
}

