/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import info.mqtt.android.service.MqttConnection;
import info.mqtt.android.service.MqttServiceBinder;
import info.mqtt.android.service.MqttTraceHandler;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.Status;
import info.mqtt.android.service.room.MqMessageDatabase;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 p2\u00020\u00012\u00020\u0002:\u0002pqB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bJ\u001e\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\bJ\"\u0010'\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010\bJ\u0016\u0010+\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J*\u0010.\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\bJ\"\u0010.\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\bJ\u0016\u00102\u001a\u0002032\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J\u000e\u00104\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\bJ(\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010;\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u000e\u0010<\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\bJ\u0019\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>2\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0002\u0010@J\u000e\u0010A\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\bJ\u0010\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020DH\u0002J\u000e\u0010E\u001a\u00020\u00052\u0006\u0010C\u001a\u00020DJ\b\u0010F\u001a\u00020\"H\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020\"H\u0016J\b\u0010L\u001a\u00020\"H\u0016J\"\u0010M\u001a\u00020-2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010N\u001a\u00020-2\u0006\u0010O\u001a\u00020-H\u0016JD\u0010P\u001a\u0004\u0018\u00010?2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00052\b\u00101\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\bJ2\u0010P\u001a\u0004\u0018\u00010?2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010W\u001a\u0002032\b\u00101\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\bJ\u000e\u0010X\u001a\u00020\"2\u0006\u0010C\u001a\u00020DJ\b\u0010Y\u001a\u00020\"H\u0002J\u0018\u0010Z\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\b\u0010[\u001a\u0004\u0018\u00010\\J\u0010\u0010]\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\bJS\u0010^\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\b0>2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0>2\b\u00101\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\b2\u000e\u0010`\u001a\n\u0012\u0004\u0012\u00020a\u0018\u00010>\u00a2\u0006\u0002\u0010bJ=\u0010^\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\b0>2\b\u0010T\u001a\u0004\u0018\u00010c2\b\u00101\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\b\u00a2\u0006\u0002\u0010dJ0\u0010^\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010T\u001a\u00020U2\b\u00101\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\bJ\u001a\u0010e\u001a\u00020\"2\u0006\u0010f\u001a\u00020\b2\b\u0010W\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010g\u001a\u00020\"2\b\u0010W\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010h\u001a\u00020\"2\b\u0010W\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010i\u001a\u00020\"2\b\u0010W\u001a\u0004\u0018\u00010\b2\u000e\u0010j\u001a\n\u0018\u00010kj\u0004\u0018\u0001`lH\u0016J\b\u0010m\u001a\u00020\"H\u0002J5\u0010n\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\b0>2\b\u00101\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010oJ(\u0010n\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0018\u00010\u001bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Linfo/mqtt/android/service/MqttService;", "Landroid/app/Service;", "Linfo/mqtt/android/service/MqttTraceHandler;", "()V", "backgroundDataEnabled", "", "connections", "", "", "Linfo/mqtt/android/service/MqttConnection;", "isTraceEnabled", "()Z", "setTraceEnabled", "(Z)V", "messageDatabase", "Linfo/mqtt/android/service/room/MqMessageDatabase;", "getMessageDatabase", "()Linfo/mqtt/android/service/room/MqMessageDatabase;", "setMessageDatabase", "(Linfo/mqtt/android/service/room/MqMessageDatabase;)V", "mqttServiceBinder", "Linfo/mqtt/android/service/MqttServiceBinder;", "getMqttServiceBinder", "()Linfo/mqtt/android/service/MqttServiceBinder;", "setMqttServiceBinder", "(Linfo/mqtt/android/service/MqttServiceBinder;)V", "networkConnectionMonitor", "Linfo/mqtt/android/service/MqttService$NetworkConnectionIntentReceiver;", "traceCallbackId", "acknowledgeMessageArrival", "Linfo/mqtt/android/service/Status;", "clientHandle", "id", "callbackToActivity", "", "status", "dataBundle", "Landroid/os/Bundle;", "close", "connect", "connectOptions", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "activityToken", "deleteBufferedMessage", "bufferIndex", "", "disconnect", "quiesceTimeout", "", "invocationContext", "getBufferedMessage", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "getBufferedMessageCount", "getClient", "serverURI", "clientId", "contextId", "persistence", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "getConnection", "getInFlightMessageCount", "getPendingDeliveryTokens", "", "Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "(Ljava/lang/String;)[Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "isConnected", "isInternetAvailable", "context", "Landroid/content/Context;", "isOnline", "notifyClientsOffline", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onStartCommand", "flags", "startId", "publish", "topic", "payload", "", "qos", "Linfo/mqtt/android/service/QoS;", "retained", "message", "reconnect", "registerBroadcastReceivers", "setBufferOpts", "bufferOpts", "Lorg/eclipse/paho/client/mqttv3/DisconnectedBufferOptions;", "setTraceCallbackId", "subscribe", "topicFilters", "messageListeners", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "(Ljava/lang/String;[Ljava/lang/String;[Linfo/mqtt/android/service/QoS;Ljava/lang/String;Ljava/lang/String;[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)V", "", "(Ljava/lang/String;[Ljava/lang/String;[ILjava/lang/String;Ljava/lang/String;)V", "traceCallback", "severity", "traceDebug", "traceError", "traceException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "unregisterBroadcastReceivers", "unsubscribe", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Companion", "NetworkConnectionIntentReceiver", "serviceLibrary_release"})
@SuppressLint(value={"Registered"})
public final class MqttService
extends Service
implements MqttTraceHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, MqttConnection> connections = new ConcurrentHashMap();
    public MqMessageDatabase messageDatabase;
    @Nullable
    private String traceCallbackId;
    private boolean isTraceEnabled;
    @Nullable
    private NetworkConnectionIntentReceiver networkConnectionMonitor;
    private volatile boolean backgroundDataEnabled = true;
    @Nullable
    private MqttServiceBinder mqttServiceBinder;
    @NotNull
    private static final String MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID = MqttService.class.getSimpleName() + ".FOREGROUND_SERVICE_NOTIFICATION_ID";
    @NotNull
    private static final String MQTT_FOREGROUND_SERVICE_NOTIFICATION = MqttService.class.getSimpleName() + ".FOREGROUND_SERVICE_NOTIFICATION";

    @NotNull
    public final MqMessageDatabase getMessageDatabase() {
        MqMessageDatabase mqMessageDatabase = this.messageDatabase;
        if (mqMessageDatabase != null) {
            return mqMessageDatabase;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"messageDatabase");
        return null;
    }

    public final void setMessageDatabase(@NotNull MqMessageDatabase mqMessageDatabase) {
        Intrinsics.checkNotNullParameter((Object)((Object)mqMessageDatabase), (String)"<set-?>");
        this.messageDatabase = mqMessageDatabase;
    }

    public final boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public final void setTraceEnabled(boolean bl) {
        this.isTraceEnabled = bl;
    }

    @Nullable
    public final MqttServiceBinder getMqttServiceBinder() {
        return this.mqttServiceBinder;
    }

    public final void setMqttServiceBinder(@Nullable MqttServiceBinder mqttServiceBinder) {
        this.mqttServiceBinder = mqttServiceBinder;
    }

    public void onCreate() {
        super.onCreate();
        this.mqttServiceBinder = new MqttServiceBinder(this);
        this.setMessageDatabase(MqMessageDatabase.Companion.getDatabase$default(MqMessageDatabase.Companion, (Context)this, null, 2, null));
    }

    public void onDestroy() {
        for (MqttConnection client : this.connections.values()) {
            client.disconnect(null, null);
        }
        if (this.mqttServiceBinder != null) {
            this.mqttServiceBinder = null;
        }
        this.unregisterBroadcastReceivers();
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String activityToken = intent.getStringExtra(".activityToken");
        MqttServiceBinder mqttServiceBinder = this.mqttServiceBinder;
        Intrinsics.checkNotNull((Object)((Object)mqttServiceBinder));
        mqttServiceBinder.setActivityToken(activityToken);
        return (IBinder)this.mqttServiceBinder;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        this.registerBroadcastReceivers();
        if (Build.VERSION.SDK_INT >= 26) {
            Notification foregroundServiceNotification;
            Intent intent2 = intent;
            Notification notification = foregroundServiceNotification = intent2 != null ? (Notification)intent2.getParcelableExtra(MQTT_FOREGROUND_SERVICE_NOTIFICATION) : null;
            if (foregroundServiceNotification != null) {
                this.startForeground(intent.getIntExtra(MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID, 1), foregroundServiceNotification);
            }
        }
        return 1;
    }

    public final void callbackToActivity(@NotNull String clientHandle, @NotNull Status status, @NotNull Bundle dataBundle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)dataBundle, (String)"dataBundle");
        Intent callbackIntent = new Intent(".callbackToActivity.v0");
        String it = clientHandle;
        boolean bl = false;
        callbackIntent.putExtra(".clientHandle", it);
        callbackIntent.putExtra(".callbackStatus", (Serializable)((Object)status));
        it = dataBundle;
        boolean bl2 = false;
        callbackIntent.putExtras((Bundle)it);
        LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(callbackIntent);
    }

    @NotNull
    public final String getClient(@NotNull String serverURI, @NotNull String clientId, @NotNull String contextId, @Nullable MqttClientPersistence persistence) {
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)contextId, (String)"contextId");
        String clientHandle = serverURI + ':' + clientId + ':' + contextId;
        if (!this.connections.containsKey(clientHandle)) {
            MqttConnection client = new MqttConnection(this, serverURI, clientId, persistence, clientHandle);
            this.connections.put(clientHandle, client);
        }
        return clientHandle;
    }

    public final void connect(@NotNull String clientHandle, @Nullable MqttConnectOptions connectOptions, @Nullable String activityToken) throws MqttException {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(client, connectOptions, activityToken, null){
            int label;
            final /* synthetic */ MqttConnection $client;
            final /* synthetic */ MqttConnectOptions $connectOptions;
            final /* synthetic */ String $activityToken;
            {
                this.$client = $client;
                this.$connectOptions = $connectOptions;
                this.$activityToken = $activityToken;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$client.connect(this.$connectOptions, null, this.$activityToken);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void reconnect(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.traceDebug("Reconnect to server, client size=" + this.connections.size());
        for (MqttConnection client : this.connections.values()) {
            this.traceDebug("Reconnect Client:" + client.getClientId() + '/' + client.getServerURI());
            if (!this.isOnline(context)) continue;
            client.reconnect(context);
        }
    }

    public final void close(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.close();
    }

    public final void disconnect(@NotNull String clientHandle, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.disconnect(invocationContext, activityToken);
        this.connections.remove(clientHandle);
        this.stopSelf();
    }

    public final void disconnect(@NotNull String clientHandle, long quiesceTimeout, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.disconnect(quiesceTimeout, invocationContext, activityToken);
        this.connections.remove(clientHandle);
        this.stopSelf();
    }

    public final boolean isConnected(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).isConnected();
    }

    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String clientHandle, @NotNull String topic, @NotNull byte[] payload, @NotNull QoS qos, boolean retained, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        return mqttConnection.publish(topic, payload, qos, retained, invocationContext, string);
    }

    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String clientHandle, @NotNull String topic, @NotNull MqttMessage message, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        return this.getConnection(clientHandle).publish(topic, message, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String topic, @NotNull QoS qos, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).subscribe(topic, qos, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String[] topic, @Nullable int[] qos, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).subscribe(topic, qos, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String[] topicFilters, @NotNull QoS[] qos, @Nullable String invocationContext, @Nullable String activityToken, @Nullable IMqttMessageListener[] messageListeners) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        mqttConnection.subscribe(topicFilters, qos, invocationContext, string, messageListeners);
    }

    public final void unsubscribe(@NotNull String clientHandle, @NotNull String topic, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).unsubscribe(topic, invocationContext, activityToken);
    }

    public final void unsubscribe(@NotNull String clientHandle, @NotNull String[] topic, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        mqttConnection.unsubscribe(topic, invocationContext, string);
    }

    @NotNull
    public final IMqttDeliveryToken[] getPendingDeliveryTokens(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).getPendingDeliveryTokens();
    }

    private final MqttConnection getConnection(String clientHandle) {
        MqttConnection mqttConnection = this.connections.get(clientHandle);
        if (mqttConnection == null) {
            throw new IllegalArgumentException("Invalid ClientHandle");
        }
        return mqttConnection;
    }

    @NotNull
    public final Status acknowledgeMessageArrival(@NotNull String clientHandle, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getMessageDatabase().discardArrived(clientHandle, id) ? Status.OK : Status.ERROR;
    }

    public final void setTraceCallbackId(@Nullable String traceCallbackId) {
        this.traceCallbackId = traceCallbackId;
    }

    @Override
    public void traceDebug(@Nullable String message) {
        this.traceCallback("debug", message);
    }

    @Override
    public void traceError(@Nullable String message) {
        this.traceCallback("error", message);
    }

    private final void traceCallback(String severity, String message) {
        block1: {
            String string = this.traceCallbackId;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (this.isTraceEnabled) {
                Bundle dataBundle = new Bundle();
                dataBundle.putString(".callbackAction", "trace");
                dataBundle.putString(".traceSeverity", severity);
                dataBundle.putString(".errorMessage", message);
                this.callbackToActivity(it, Status.ERROR, dataBundle);
            }
        }
    }

    @Override
    public void traceException(@Nullable String message, @Nullable Exception e) {
        block0: {
            String string = this.traceCallbackId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Bundle dataBundle = new Bundle();
            dataBundle.putString(".callbackAction", "trace");
            dataBundle.putString(".traceSeverity", "exception");
            dataBundle.putString(".errorMessage", message);
            dataBundle.putSerializable(".exception", (Serializable)e);
            this.callbackToActivity(it, Status.ERROR, dataBundle);
        }
    }

    private final void registerBroadcastReceivers() {
        if (this.networkConnectionMonitor == null) {
            this.networkConnectionMonitor = new NetworkConnectionIntentReceiver();
            this.registerReceiver(this.networkConnectionMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private final void unregisterBroadcastReceivers() {
        if (this.networkConnectionMonitor != null) {
            this.unregisterReceiver(this.networkConnectionMonitor);
            this.networkConnectionMonitor = null;
        }
    }

    public final boolean isOnline(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isInternetAvailable(context);
    }

    private final void notifyClientsOffline() {
        for (MqttConnection connection : this.connections.values()) {
            connection.offline();
        }
    }

    private final boolean isInternetAvailable(Context context) {
        boolean result;
        block8: {
            boolean bl;
            ConnectivityManager connectivityManager;
            block7: {
                result = false;
                Object object = context.getSystemService("connectivity");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
                connectivityManager = (ConnectivityManager)object;
                if (Build.VERSION.SDK_INT < 23) break block7;
                Network network = connectivityManager.getActiveNetwork();
                if (network == null) {
                    return false;
                }
                Network networkCapabilities = network;
                NetworkCapabilities networkCapabilities2 = connectivityManager.getNetworkCapabilities(networkCapabilities);
                if (networkCapabilities2 == null) {
                    return false;
                }
                NetworkCapabilities actNw = networkCapabilities2;
                result = actNw.hasTransport(1) ? true : (actNw.hasTransport(0) ? true : actNw.hasTransport(3));
                break block8;
            }
            ConnectivityManager $this$isInternetAvailable_u24lambda_u2d5 = connectivityManager;
            boolean bl2 = false;
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) break block8;
            NetworkInfo $this$isInternetAvailable_u24lambda_u2d5_u24lambda_u2d4 = networkInfo;
            boolean bl3 = false;
            switch ($this$isInternetAvailable_u24lambda_u2d5_u24lambda_u2d4.getType()) {
                case 1: {
                    bl = true;
                    break;
                }
                case 0: {
                    bl = true;
                    break;
                }
                case 9: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            result = bl;
        }
        return result;
    }

    public final void setBufferOpts(@NotNull String clientHandle, @Nullable DisconnectedBufferOptions bufferOpts) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.setBufferOpts(bufferOpts);
    }

    public final int getBufferedMessageCount(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        return client.getBufferedMessageCount();
    }

    @NotNull
    public final MqttMessage getBufferedMessage(@NotNull String clientHandle, int bufferIndex) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        return client.getBufferedMessage(bufferIndex);
    }

    public final void deleteBufferedMessage(@NotNull String clientHandle, int bufferIndex) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.deleteBufferedMessage(bufferIndex);
    }

    public final int getInFlightMessageCount(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        return client.getInFlightMessageCount();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Linfo/mqtt/android/service/MqttService$NetworkConnectionIntentReceiver;", "Landroid/content/BroadcastReceiver;", "(Linfo/mqtt/android/service/MqttService;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "serviceLibrary_release"})
    private final class NetworkConnectionIntentReceiver
    extends BroadcastReceiver {
        @SuppressLint(value={"Wakelock"})
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            MqttService.this.traceDebug("Internal network status receive.");
            Object object = MqttService.this.getSystemService("power");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
            PowerManager pm = (PowerManager)object;
            PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT:tag");
            wl.acquire(600000L);
            MqttService.this.traceDebug("Reconnect for Network recovery.");
            if (MqttService.this.isOnline(context)) {
                MqttService.this.traceDebug("Online,reconnect.");
                MqttService.this.reconnect(context);
            } else {
                MqttService.this.notifyClientsOffline();
            }
            wl.release();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Linfo/mqtt/android/service/MqttService$Companion;", "", "()V", "MQTT_FOREGROUND_SERVICE_NOTIFICATION", "", "getMQTT_FOREGROUND_SERVICE_NOTIFICATION", "()Ljava/lang/String;", "MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID", "getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID() {
            return MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID;
        }

        @NotNull
        public final String getMQTT_FOREGROUND_SERVICE_NOTIFICATION() {
            return MQTT_FOREGROUND_SERVICE_NOTIFICATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

