/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.room;

import android.content.Context;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.room.Converters;
import info.mqtt.android.service.room.MqMessageDao;
import info.mqtt.android.service.room.entity.MqMessageEntity;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\b\u0010\b\u001a\u00020\tH&J\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Linfo/mqtt/android/service/room/MqMessageDatabase;", "Landroidx/room/RoomDatabase;", "()V", "discardArrived", "", "clientHandle", "", "id", "persistenceDao", "Linfo/mqtt/android/service/room/MqMessageDao;", "storeArrived", "topic", "message", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "Companion", "serviceLibrary_release"})
@Database(entities={MqMessageEntity.class}, version=1)
@TypeConverters(value={Converters.class})
public abstract class MqMessageDatabase
extends RoomDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MQ_DB_VERSION = 1;
    @Nullable
    private static MqMessageDatabase db;

    @NotNull
    public abstract MqMessageDao persistenceDao();

    @NotNull
    public final String storeArrived(@NotNull String clientHandle, @NotNull String topic, @NotNull MqttMessage message) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String id = string;
        MqMessageEntity messageArrived = new MqMessageEntity(id, clientHandle, topic, new MqttMessage(message.getPayload()), QoS.Companion.valueOf(message.getQos()), message.isRetained(), message.isDuplicate(), System.currentTimeMillis());
        this.persistenceDao().insert(messageArrived);
        return id;
    }

    public final boolean discardArrived(@NotNull String clientHandle, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.persistenceDao().deleteId(clientHandle, id) == 1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Linfo/mqtt/android/service/room/MqMessageDatabase$Companion;", "", "()V", "MQ_DB_VERSION", "", "db", "Linfo/mqtt/android/service/room/MqMessageDatabase;", "getDatabase", "context", "Landroid/content/Context;", "storageName", "", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final synchronized MqMessageDatabase getDatabase(@NotNull Context context, @NotNull String storageName) {
            MqMessageDatabase mqMessageDatabase;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)storageName, (String)"storageName");
            MqMessageDatabase mqMessageDatabase2 = db;
            if (mqMessageDatabase2 != null) {
                MqMessageDatabase it = mqMessageDatabase2;
                boolean bl = false;
                mqMessageDatabase = it;
            } else {
                Companion $this$getDatabase_u24lambda_u2d1 = this;
                boolean bl = false;
                db = (MqMessageDatabase)Room.databaseBuilder((Context)context.getApplicationContext(), MqMessageDatabase.class, (String)storageName).allowMainThreadQueries().build();
                MqMessageDatabase mqMessageDatabase3 = db;
                mqMessageDatabase = mqMessageDatabase3;
                Intrinsics.checkNotNull((Object)((Object)mqMessageDatabase3));
            }
            return mqMessageDatabase;
        }

        public static /* synthetic */ MqMessageDatabase getDatabase$default(Companion companion, Context context, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "messageMQ";
            }
            return companion.getDatabase(context, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

