/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.ping;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import android.os.SystemClock;
import info.mqtt.android.service.MqttService;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Linfo/mqtt/android/service/ping/AlarmPingSender;", "Lorg/eclipse/paho/client/mqttv3/MqttPingSender;", "service", "Linfo/mqtt/android/service/MqttService;", "(Linfo/mqtt/android/service/MqttService;)V", "alarmReceiver", "Landroid/content/BroadcastReceiver;", "clientComms", "Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;", "hasStarted", "", "pendingIntent", "Landroid/app/PendingIntent;", "pendingIntentFlags", "", "getService", "()Linfo/mqtt/android/service/MqttService;", "backgroundExecute", "comms", "init", "", "schedule", "delayInMilliseconds", "", "start", "stop", "AlarmReceiver", "Companion", "serviceLibrary_release"})
public final class AlarmPingSender
implements MqttPingSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MqttService service;
    @Nullable
    private ClientComms clientComms;
    @Nullable
    private BroadcastReceiver alarmReceiver;
    @Nullable
    private PendingIntent pendingIntent;
    private final int pendingIntentFlags;
    private volatile boolean hasStarted;
    private static final long TIMEOUT = 600000L;

    public AlarmPingSender(@NotNull MqttService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.pendingIntentFlags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
    }

    @NotNull
    public final MqttService getService() {
        return this.service;
    }

    public void init(@NotNull ClientComms comms) {
        Intrinsics.checkNotNullParameter((Object)comms, (String)"comms");
        this.clientComms = comms;
        this.alarmReceiver = new AlarmReceiver();
    }

    public void start() {
        ClientComms clientComms = this.clientComms;
        Intrinsics.checkNotNull((Object)clientComms);
        String action = Intrinsics.stringPlus((String)".pingSender.", (Object)clientComms.getClient().getClientId());
        Timber.Forest.d(Intrinsics.stringPlus((String)"Register AlarmReceiver to MqttService", (Object)action), new Object[0]);
        this.service.registerReceiver(this.alarmReceiver, new IntentFilter(action));
        this.pendingIntent = PendingIntent.getBroadcast((Context)((Context)this.service), (int)0, (Intent)new Intent(action), (int)this.pendingIntentFlags);
        ClientComms clientComms2 = this.clientComms;
        Intrinsics.checkNotNull((Object)clientComms2);
        this.schedule(clientComms2.getKeepAlive());
        this.hasStarted = true;
    }

    public void stop() {
        ClientComms clientComms = this.clientComms;
        Intrinsics.checkNotNull((Object)clientComms);
        Timber.Forest.d(Intrinsics.stringPlus((String)"Unregister AlarmReceiver to MqttService ", (Object)clientComms.getClient().getClientId()), new Object[0]);
        if (this.hasStarted) {
            if (this.pendingIntent != null) {
                Object object = this.service.getSystemService("alarm");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.AlarmManager");
                }
                AlarmManager alarmManager = (AlarmManager)object;
                alarmManager.cancel(this.pendingIntent);
            }
            this.hasStarted = false;
            try {
                this.service.unregisterReceiver(this.alarmReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void schedule(long delayInMilliseconds) {
        long nextAlarmInMilliseconds = SystemClock.elapsedRealtime() + delayInMilliseconds;
        Timber.Forest.d("Schedule next alarm at " + nextAlarmInMilliseconds + " ms", new Object[0]);
        Object object = this.service.getSystemService("alarm");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.AlarmManager");
        }
        AlarmManager alarmManager = (AlarmManager)object;
        if (Build.VERSION.SDK_INT >= 23) {
            Timber.Forest.d(Intrinsics.stringPlus((String)"Alarm schedule using setExactAndAllowWhileIdle, next: ", (Object)delayInMilliseconds), new Object[0]);
            alarmManager.setExactAndAllowWhileIdle(2, nextAlarmInMilliseconds, this.pendingIntent);
        } else {
            Timber.Forest.d(Intrinsics.stringPlus((String)"Alarm schedule using setExact, delay: ", (Object)delayInMilliseconds), new Object[0]);
        }
        alarmManager.setExact(2, nextAlarmInMilliseconds, this.pendingIntent);
    }

    public final boolean backgroundExecute(@Nullable ClientComms comms) {
        Ref.BooleanRef success = new Ref.BooleanRef();
        ClientComms clientComms = comms;
        IMqttToken token2 = (IMqttToken)(clientComms == null ? null : clientComms.checkForActivity(new IMqttActionListener(success){
            final /* synthetic */ Ref.BooleanRef $success;
            {
                this.$success = $success;
            }

            public void onSuccess(@NotNull IMqttToken asyncActionToken) {
                Intrinsics.checkNotNullParameter((Object)asyncActionToken, (String)"asyncActionToken");
                this.$success.element = true;
            }

            public void onFailure(@Nullable IMqttToken asyncActionToken, @Nullable Throwable exception) {
                Timber.Forest.d("Ping task : Failed.", new Object[0]);
                this.$success.element = false;
            }
        }));
        try {
            if (token2 != null) {
                token2.waitForCompletion();
            } else {
                Timber.Forest.d("Ping background : Ping command was not sent by the client.", new Object[0]);
            }
        }
        catch (MqttException e) {
            Timber.Forest.d(Intrinsics.stringPlus((String)"Ping background : Ignore MQTT exception : ", (Object)e.getMessage()), new Object[0]);
        }
        catch (Exception ex) {
            Timber.Forest.d(Intrinsics.stringPlus((String)"Ping background : Ignore unknown exception : ", (Object)ex.getMessage()), new Object[0]);
        }
        return success.element;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Linfo/mqtt/android/service/ping/AlarmPingSender$AlarmReceiver;", "Landroid/content/BroadcastReceiver;", "(Linfo/mqtt/android/service/ping/AlarmPingSender;)V", "wakeLockTag", "", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "serviceLibrary_release"})
    public final class AlarmReceiver
    extends BroadcastReceiver {
        @NotNull
        private final String wakeLockTag;

        public AlarmReceiver() {
            Intrinsics.checkNotNullParameter((Object)AlarmPingSender.this, (String)"this$0");
            ClientComms clientComms = AlarmPingSender.this.clientComms;
            Intrinsics.checkNotNull((Object)clientComms);
            this.wakeLockTag = Intrinsics.stringPlus((String)".client.", (Object)clientComms.getClient().getClientId());
        }

        @SuppressLint(value={"Wakelock"})
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            Object object = AlarmPingSender.this.getService().getSystemService("power");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.os.PowerManager");
            }
            PowerManager pm = (PowerManager)object;
            PowerManager.WakeLock wakelock = pm.newWakeLock(1, this.wakeLockTag);
            wakelock.acquire(600000L);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(wakelock, AlarmPingSender.this, null){
                Object L$0;
                long J$0;
                int label;
                final /* synthetic */ PowerManager.WakeLock $wakelock;
                final /* synthetic */ AlarmPingSender this$0;
                {
                    this.$wakelock = $wakelock;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = this.$wakelock;
                            var4_5 = this.this$0;
                            $i$f$measureTimeMillis = false;
                            start$iv = System.currentTimeMillis();
                            $i$a$-measureTimeMillis-AlarmPingSender$AlarmReceiver$onReceive$1$1 = false;
                            this.L$0 = var2_3;
                            this.J$0 = start$iv;
                            this.label = 1;
                            v0 = BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(var4_5, null){
                                int label;
                                final /* synthetic */ AlarmPingSender this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            return Boxing.boxBoolean((boolean)this.this$0.backgroundExecute(AlarmPingSender.access$getClientComms$p(this.this$0)));
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null).await((Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            $i$f$measureTimeMillis = false;
                            $i$a$-measureTimeMillis-AlarmPingSender$AlarmReceiver$onReceive$1$1 = false;
                            start$iv = this.J$0;
                            var2_3 = (PowerManager.WakeLock)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            Timber.Forest.d(Intrinsics.stringPlus((String)"Request done ", (Object)Boxing.boxBoolean((boolean)((response = ((Boolean)v0).booleanValue()) != false))), new Object[0]);
                            if (var2_3.isHeld()) {
                                var2_3.release();
                            }
                            it = var2_4 = System.currentTimeMillis() - start$iv;
                            $i$a$-also-AlarmPingSender$AlarmReceiver$onReceive$1$2 = false;
                            Timber.Forest.d("Completed in " + it + " ms", new Object[0]);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Linfo/mqtt/android/service/ping/AlarmPingSender$Companion;", "", "()V", "TIMEOUT", "", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

