/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import info.mqtt.android.service.MqttConnection;
import info.mqtt.android.service.MqttServiceBinder;
import info.mqtt.android.service.MqttTraceHandler;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.Status;
import info.mqtt.android.service.room.MqMessageDatabase;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 m2\u00020\u00012\u00020\u0002:\u0002mnB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\u001e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020#2\u0006\u0010 \u001a\u00020\bJ\"\u0010(\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\bJ\u0016\u0010,\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\u0006\u0010-\u001a\u00020.J*\u0010/\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010\bJ\"\u0010/\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\b\u00102\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010\bJ\u0016\u00103\u001a\u0002042\u0006\u0010 \u001a\u00020\b2\u0006\u0010-\u001a\u00020.J\u000e\u00105\u001a\u00020.2\u0006\u0010 \u001a\u00020\bJ(\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\b2\b\u0010:\u001a\u0004\u0018\u00010;J\u0010\u0010<\u001a\u00020\t2\u0006\u0010 \u001a\u00020\bH\u0002J\u000e\u0010=\u001a\u00020.2\u0006\u0010 \u001a\u00020\bJ\u0019\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010 \u001a\u00020\b\u00a2\u0006\u0002\u0010AJ\u000e\u0010B\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\bJ\b\u0010C\u001a\u00020#H\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020#H\u0016J\b\u0010I\u001a\u00020#H\u0016J\"\u0010J\u001a\u00020.2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u00020.H\u0016JD\u0010M\u001a\u0004\u0018\u00010@2\u0006\u0010 \u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u00052\b\u00102\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010\bJ2\u0010M\u001a\u0004\u0018\u00010@2\u0006\u0010 \u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\u0006\u0010T\u001a\u0002042\b\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\bJ\u0006\u0010U\u001a\u00020#J\b\u0010V\u001a\u00020#H\u0002J\u0018\u0010W\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\b\u0010X\u001a\u0004\u0018\u00010YJ\u0010\u0010Z\u001a\u00020#2\b\u0010\u001d\u001a\u0004\u0018\u00010\bJS\u0010[\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\b0?2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0?2\b\u00102\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010\b2\u000e\u0010]\u001a\n\u0012\u0004\u0012\u00020^\u0018\u00010?\u00a2\u0006\u0002\u0010_J=\u0010[\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\b0?2\b\u0010Q\u001a\u0004\u0018\u00010`2\b\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\b\u00a2\u0006\u0002\u0010aJ0\u0010[\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\u0006\u0010Q\u001a\u00020R2\b\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\bJ\u001a\u0010b\u001a\u00020#2\u0006\u0010c\u001a\u00020\b2\b\u0010T\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010d\u001a\u00020#2\b\u0010T\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010e\u001a\u00020#2\b\u0010T\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010f\u001a\u00020#2\b\u0010T\u001a\u0004\u0018\u00010\b2\u000e\u0010g\u001a\n\u0018\u00010hj\u0004\u0018\u0001`iH\u0016J\b\u0010j\u001a\u00020#H\u0002J5\u0010k\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\b0?2\b\u00102\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010lJ(\u0010k\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\b\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000b\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Linfo/mqtt/android/service/MqttService;", "Landroid/app/Service;", "Linfo/mqtt/android/service/MqttTraceHandler;", "()V", "backgroundDataEnabled", "", "connections", "", "", "Linfo/mqtt/android/service/MqttConnection;", "isOnline", "()Z", "isTraceEnabled", "setTraceEnabled", "(Z)V", "messageDatabase", "Linfo/mqtt/android/service/room/MqMessageDatabase;", "getMessageDatabase", "()Linfo/mqtt/android/service/room/MqMessageDatabase;", "setMessageDatabase", "(Linfo/mqtt/android/service/room/MqMessageDatabase;)V", "mqttServiceBinder", "Linfo/mqtt/android/service/MqttServiceBinder;", "getMqttServiceBinder", "()Linfo/mqtt/android/service/MqttServiceBinder;", "setMqttServiceBinder", "(Linfo/mqtt/android/service/MqttServiceBinder;)V", "networkConnectionMonitor", "Linfo/mqtt/android/service/MqttService$NetworkConnectionIntentReceiver;", "traceCallbackId", "acknowledgeMessageArrival", "Linfo/mqtt/android/service/Status;", "clientHandle", "id", "callbackToActivity", "", "status", "dataBundle", "Landroid/os/Bundle;", "close", "connect", "connectOptions", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "activityToken", "deleteBufferedMessage", "bufferIndex", "", "disconnect", "quiesceTimeout", "", "invocationContext", "getBufferedMessage", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "getBufferedMessageCount", "getClient", "serverURI", "clientId", "contextId", "persistence", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "getConnection", "getInFlightMessageCount", "getPendingDeliveryTokens", "", "Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "(Ljava/lang/String;)[Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "isConnected", "notifyClientsOffline", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onStartCommand", "flags", "startId", "publish", "topic", "payload", "", "qos", "Linfo/mqtt/android/service/QoS;", "retained", "message", "reconnect", "registerBroadcastReceivers", "setBufferOpts", "bufferOpts", "Lorg/eclipse/paho/client/mqttv3/DisconnectedBufferOptions;", "setTraceCallbackId", "subscribe", "topicFilters", "messageListeners", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "(Ljava/lang/String;[Ljava/lang/String;[Linfo/mqtt/android/service/QoS;Ljava/lang/String;Ljava/lang/String;[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)V", "", "(Ljava/lang/String;[Ljava/lang/String;[ILjava/lang/String;Ljava/lang/String;)V", "traceCallback", "severity", "traceDebug", "traceError", "traceException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "unregisterBroadcastReceivers", "unsubscribe", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Companion", "NetworkConnectionIntentReceiver", "serviceLibrary_release"})
@SuppressLint(value={"Registered"})
public final class MqttService
extends Service
implements MqttTraceHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, MqttConnection> connections = new ConcurrentHashMap();
    public MqMessageDatabase messageDatabase;
    @Nullable
    private String traceCallbackId;
    private boolean isTraceEnabled;
    @Nullable
    private NetworkConnectionIntentReceiver networkConnectionMonitor;
    private volatile boolean backgroundDataEnabled = true;
    @Nullable
    private MqttServiceBinder mqttServiceBinder;
    @NotNull
    private static final String MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID = Intrinsics.stringPlus((String)MqttService.class.getSimpleName(), (Object)".FOREGROUND_SERVICE_NOTIFICATION_ID");
    @NotNull
    private static final String MQTT_FOREGROUND_SERVICE_NOTIFICATION = Intrinsics.stringPlus((String)MqttService.class.getSimpleName(), (Object)".FOREGROUND_SERVICE_NOTIFICATION");

    @NotNull
    public final MqMessageDatabase getMessageDatabase() {
        MqMessageDatabase mqMessageDatabase = this.messageDatabase;
        if (mqMessageDatabase != null) {
            return mqMessageDatabase;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"messageDatabase");
        return null;
    }

    public final void setMessageDatabase(@NotNull MqMessageDatabase mqMessageDatabase) {
        Intrinsics.checkNotNullParameter((Object)((Object)mqMessageDatabase), (String)"<set-?>");
        this.messageDatabase = mqMessageDatabase;
    }

    public final boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public final void setTraceEnabled(boolean bl) {
        this.isTraceEnabled = bl;
    }

    @Nullable
    public final MqttServiceBinder getMqttServiceBinder() {
        return this.mqttServiceBinder;
    }

    public final void setMqttServiceBinder(@Nullable MqttServiceBinder mqttServiceBinder) {
        this.mqttServiceBinder = mqttServiceBinder;
    }

    public void onCreate() {
        super.onCreate();
        this.mqttServiceBinder = new MqttServiceBinder(this);
        this.setMessageDatabase(MqMessageDatabase.Companion.getDatabase$default(MqMessageDatabase.Companion, (Context)this, null, 2, null));
    }

    public void onDestroy() {
        for (MqttConnection client : this.connections.values()) {
            client.disconnect(null, null);
        }
        if (this.mqttServiceBinder != null) {
            this.mqttServiceBinder = null;
        }
        this.unregisterBroadcastReceivers();
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String activityToken = intent.getStringExtra(".activityToken");
        MqttServiceBinder mqttServiceBinder = this.mqttServiceBinder;
        Intrinsics.checkNotNull((Object)((Object)mqttServiceBinder));
        mqttServiceBinder.setActivityToken(activityToken);
        return (IBinder)this.mqttServiceBinder;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        this.registerBroadcastReceivers();
        if (Build.VERSION.SDK_INT >= 26) {
            Notification foregroundServiceNotification;
            Intent intent2 = intent;
            Notification notification = foregroundServiceNotification = intent2 == null ? null : (Notification)intent2.getParcelableExtra(MQTT_FOREGROUND_SERVICE_NOTIFICATION);
            if (foregroundServiceNotification != null) {
                this.startForeground(intent.getIntExtra(MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID, 1), foregroundServiceNotification);
            }
        }
        return 1;
    }

    public final void callbackToActivity(@NotNull String clientHandle, @NotNull Status status, @NotNull Bundle dataBundle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)dataBundle, (String)"dataBundle");
        Intent callbackIntent = new Intent(".callbackToActivity.v0");
        String it = clientHandle;
        boolean bl = false;
        callbackIntent.putExtra(".clientHandle", it);
        callbackIntent.putExtra(".callbackStatus", (Serializable)((Object)status));
        it = dataBundle;
        boolean bl2 = false;
        callbackIntent.putExtras((Bundle)it);
        LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(callbackIntent);
    }

    @NotNull
    public final String getClient(@NotNull String serverURI, @NotNull String clientId, @NotNull String contextId, @Nullable MqttClientPersistence persistence) {
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)contextId, (String)"contextId");
        String clientHandle = serverURI + ':' + clientId + ':' + contextId;
        if (!this.connections.containsKey(clientHandle)) {
            MqttConnection client = new MqttConnection(this, serverURI, clientId, persistence, clientHandle);
            this.connections.put(clientHandle, client);
        }
        return clientHandle;
    }

    public final void connect(@NotNull String clientHandle, @Nullable MqttConnectOptions connectOptions, @Nullable String activityToken) throws MqttException {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.connect(connectOptions, null, activityToken);
    }

    public final void reconnect() {
        this.traceDebug(Intrinsics.stringPlus((String)"Reconnect to server, client size=", (Object)this.connections.size()));
        for (MqttConnection client : this.connections.values()) {
            this.traceDebug("Reconnect Client:" + client.getClientId() + '/' + client.getServerURI());
            if (!this.isOnline()) continue;
            client.reconnect();
        }
    }

    public final void close(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.close();
    }

    public final void disconnect(@NotNull String clientHandle, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.disconnect(invocationContext, activityToken);
        this.connections.remove(clientHandle);
        this.stopSelf();
    }

    public final void disconnect(@NotNull String clientHandle, long quiesceTimeout, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.disconnect(quiesceTimeout, invocationContext, activityToken);
        this.connections.remove(clientHandle);
        this.stopSelf();
    }

    public final boolean isConnected(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).isConnected();
    }

    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String clientHandle, @NotNull String topic, @NotNull byte[] payload, @NotNull QoS qos, boolean retained, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        return mqttConnection.publish(topic, payload, qos, retained, invocationContext, string);
    }

    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String clientHandle, @NotNull String topic, @NotNull MqttMessage message, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        return this.getConnection(clientHandle).publish(topic, message, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String topic, @NotNull QoS qos, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).subscribe(topic, qos, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String[] topic, @Nullable int[] qos, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).subscribe(topic, qos, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String[] topicFilters, @NotNull QoS[] qos, @Nullable String invocationContext, @Nullable String activityToken, @Nullable IMqttMessageListener[] messageListeners) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        mqttConnection.subscribe(topicFilters, qos, invocationContext, string, messageListeners);
    }

    public final void unsubscribe(@NotNull String clientHandle, @NotNull String topic, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).unsubscribe(topic, invocationContext, activityToken);
    }

    public final void unsubscribe(@NotNull String clientHandle, @NotNull String[] topic, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        mqttConnection.unsubscribe(topic, invocationContext, string);
    }

    @NotNull
    public final IMqttDeliveryToken[] getPendingDeliveryTokens(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).getPendingDeliveryTokens();
    }

    private final MqttConnection getConnection(String clientHandle) {
        MqttConnection mqttConnection = this.connections.get(clientHandle);
        if (mqttConnection == null) {
            throw new IllegalArgumentException("Invalid ClientHandle");
        }
        return mqttConnection;
    }

    @NotNull
    public final Status acknowledgeMessageArrival(@NotNull String clientHandle, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getMessageDatabase().discardArrived(clientHandle, id) ? Status.OK : Status.ERROR;
    }

    public final void setTraceCallbackId(@Nullable String traceCallbackId) {
        this.traceCallbackId = traceCallbackId;
    }

    @Override
    public void traceDebug(@Nullable String message) {
        this.traceCallback("debug", message);
    }

    @Override
    public void traceError(@Nullable String message) {
        this.traceCallback("error", message);
    }

    private final void traceCallback(String severity, String message) {
        String string = this.traceCallbackId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (this.isTraceEnabled()) {
                Bundle dataBundle = new Bundle();
                dataBundle.putString(".callbackAction", "trace");
                dataBundle.putString(".traceSeverity", severity);
                dataBundle.putString(".errorMessage", message);
                this.callbackToActivity(it, Status.ERROR, dataBundle);
            }
        }
    }

    @Override
    public void traceException(@Nullable String message, @Nullable Exception e) {
        String string = this.traceCallbackId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Bundle dataBundle = new Bundle();
            dataBundle.putString(".callbackAction", "trace");
            dataBundle.putString(".traceSeverity", "exception");
            dataBundle.putString(".errorMessage", message);
            dataBundle.putSerializable(".exception", (Serializable)e);
            this.callbackToActivity(it, Status.ERROR, dataBundle);
        }
    }

    private final void registerBroadcastReceivers() {
        if (this.networkConnectionMonitor == null) {
            this.networkConnectionMonitor = new NetworkConnectionIntentReceiver();
            this.registerReceiver(this.networkConnectionMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private final void unregisterBroadcastReceivers() {
        if (this.networkConnectionMonitor != null) {
            this.unregisterReceiver(this.networkConnectionMonitor);
            this.networkConnectionMonitor = null;
        }
    }

    public final boolean isOnline() {
        Object object = this.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected() && this.backgroundDataEnabled;
    }

    private final void notifyClientsOffline() {
        for (MqttConnection connection : this.connections.values()) {
            connection.offline();
        }
    }

    public final void setBufferOpts(@NotNull String clientHandle, @Nullable DisconnectedBufferOptions bufferOpts) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.setBufferOpts(bufferOpts);
    }

    public final int getBufferedMessageCount(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        return client.getBufferedMessageCount();
    }

    @NotNull
    public final MqttMessage getBufferedMessage(@NotNull String clientHandle, int bufferIndex) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        return client.getBufferedMessage(bufferIndex);
    }

    public final void deleteBufferedMessage(@NotNull String clientHandle, int bufferIndex) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.deleteBufferedMessage(bufferIndex);
    }

    public final int getInFlightMessageCount(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        return client.getInFlightMessageCount();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Linfo/mqtt/android/service/MqttService$NetworkConnectionIntentReceiver;", "Landroid/content/BroadcastReceiver;", "(Linfo/mqtt/android/service/MqttService;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "serviceLibrary_release"})
    private final class NetworkConnectionIntentReceiver
    extends BroadcastReceiver {
        public NetworkConnectionIntentReceiver() {
            Intrinsics.checkNotNullParameter((Object)MqttService.this, (String)"this$0");
        }

        @SuppressLint(value={"Wakelock"})
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            MqttService.this.traceDebug("Internal network status receive.");
            Object object = MqttService.this.getSystemService("power");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.os.PowerManager");
            }
            PowerManager pm = (PowerManager)object;
            PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT:tag");
            wl.acquire(600000L);
            MqttService.this.traceDebug("Reconnect for Network recovery.");
            if (MqttService.this.isOnline()) {
                MqttService.this.traceDebug("Online,reconnect.");
                MqttService.this.reconnect();
            } else {
                MqttService.this.notifyClientsOffline();
            }
            wl.release();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Linfo/mqtt/android/service/MqttService$Companion;", "", "()V", "MQTT_FOREGROUND_SERVICE_NOTIFICATION", "", "getMQTT_FOREGROUND_SERVICE_NOTIFICATION", "()Ljava/lang/String;", "MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID", "getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID() {
            return MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID;
        }

        @NotNull
        public final String getMQTT_FOREGROUND_SERVICE_NOTIFICATION() {
            return MQTT_FOREGROUND_SERVICE_NOTIFICATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

