/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.SparseArray;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import info.mqtt.android.service.Ack;
import info.mqtt.android.service.MqttConnectTokenAndroid;
import info.mqtt.android.service.MqttDeliveryTokenAndroid;
import info.mqtt.android.service.MqttService;
import info.mqtt.android.service.MqttServiceBinder;
import info.mqtt.android.service.MqttTokenAndroid;
import info.mqtt.android.service.MqttTraceHandler;
import info.mqtt.android.service.ParcelableMqttMessage;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.Status;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u0087\u00012\u00020\u00012\u00020\u0002:\u0004\u0087\u0001\u0088\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\rJ\b\u0010.\u001a\u00020,H\u0016J\b\u0010/\u001a\u00020\u0012H\u0016J\u001c\u0010/\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016J\u0010\u0010/\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u000fH\u0016J$\u0010/\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u000f2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016J\u0012\u00104\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00107\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00108\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020\u0018H\u0016J\b\u0010;\u001a\u00020\u0012H\u0016J\u001c\u0010;\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020=H\u0016J\"\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020=2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010-\u001a\u000202H\u0016J\b\u0010>\u001a\u00020,H\u0016J\u0010\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u00020,2\u0006\u0010<\u001a\u00020=2\u0006\u0010?\u001a\u00020=H\u0016J\u0012\u0010@\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\b\u0010A\u001a\u00020,H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010:\u001a\u00020\u0018H\u0016J\b\u0010D\u001a\u00020\u0018H\u0016J\b\u0010E\u001a\u00020\u0006H\u0016J\b\u0010F\u001a\u00020\u0018H\u0016J\u0014\u0010G\u001a\u0004\u0018\u00010\u00122\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0013\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IH\u0016\u00a2\u0006\u0002\u0010KJ\u0018\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020\u0006J\b\u0010Q\u001a\u00020\u0006H\u0016J\b\u0010R\u001a\u00020\u001fH\u0016J\u0012\u0010S\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0018\u0010T\u001a\u00020,2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010U\u001a\u00020\u0018H\u0016J\u0010\u0010V\u001a\u00020,2\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010W\u001a\u00020,2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010X\u001a\u00020YH\u0016J(\u0010Z\u001a\u00020J2\u0006\u0010[\u001a\u00020\u00062\u0006\u0010\\\u001a\u00020]2\u0006\u0010U\u001a\u00020\u00182\u0006\u0010^\u001a\u00020\u001fH\u0016J<\u0010Z\u001a\u00020J2\u0006\u0010[\u001a\u00020\u00062\u0006\u0010\\\u001a\u00020]2\u0006\u0010U\u001a\u00020\u00182\u0006\u0010^\u001a\u00020\u001f2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016J\u0018\u0010Z\u001a\u00020J2\u0006\u0010[\u001a\u00020\u00062\u0006\u0010_\u001a\u00020CH\u0016J,\u0010Z\u001a\u00020J2\u0006\u0010[\u001a\u00020\u00062\u0006\u0010_\u001a\u00020C2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016J\b\u0010`\u001a\u00020,H\u0016J\u0010\u0010a\u001a\u00020,2\u0006\u0010b\u001a\u00020\u0001H\u0002J\u0006\u0010c\u001a\u00020,J\u0010\u0010d\u001a\u00020\u001f2\u0006\u0010e\u001a\u00020JH\u0016J\u0014\u0010f\u001a\u0004\u0018\u00010\u00122\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u0010g\u001a\u00020,2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010h\u001a\u00020,2\u0006\u0010i\u001a\u00020jH\u0016J\u0010\u0010k\u001a\u00020,2\u0006\u0010-\u001a\u00020\rH\u0016J\u0016\u0010l\u001a\u00020,2\u0006\u0010m\u001a\u00020\u00162\u0006\u0010n\u001a\u00020\u0018J\u0010\u0010o\u001a\u00020,2\u0006\u0010p\u001a\u00020\u001fH\u0016J\u0010\u0010q\u001a\u00020,2\b\u0010&\u001a\u0004\u0018\u00010'J\u000e\u0010r\u001a\u00020,2\u0006\u0010(\u001a\u00020\u001fJ\u001a\u0010s\u001a\u00020,2\b\u0010e\u001a\u0004\u0018\u00010\u00122\u0006\u00105\u001a\u000206H\u0002J\u0012\u0010t\u001a\u00020\u00062\b\u0010e\u001a\u0004\u0018\u00010\u0012H\u0002J#\u0010u\u001a\u00020\u00122\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00060I2\u0006\u0010U\u001a\u00020vH\u0016\u00a2\u0006\u0002\u0010wJ7\u0010u\u001a\u00020\u00122\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00060I2\u0006\u0010U\u001a\u00020v2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016\u00a2\u0006\u0002\u0010xJE\u0010u\u001a\u00020\u00122\f\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00060I2\u0006\u0010U\u001a\u00020v2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u0001022\f\u0010z\u001a\b\u0012\u0004\u0012\u00020{0IH\u0016\u00a2\u0006\u0002\u0010|J1\u0010u\u001a\u00020\u00122\f\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00060I2\u0006\u0010U\u001a\u00020v2\f\u0010z\u001a\b\u0012\u0004\u0012\u00020{0IH\u0016\u00a2\u0006\u0002\u0010}J\u0018\u0010u\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\u00062\u0006\u0010U\u001a\u00020\u0018H\u0016J,\u0010u\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\u00062\u0006\u0010U\u001a\u00020\u00182\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016J4\u0010u\u001a\u00020\u00122\u0006\u0010~\u001a\u00020\u00062\u0006\u0010U\u001a\u00020\u00182\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u0001022\u0006\u0010\u007f\u001a\u00020{H\u0016J \u0010u\u001a\u00020\u00122\u0006\u0010~\u001a\u00020\u00062\u0006\u0010U\u001a\u00020\u00182\u0006\u0010\u007f\u001a\u00020{H\u0016J\u0011\u0010\u0080\u0001\u001a\u00020,2\u0006\u00105\u001a\u000206H\u0002J\u0013\u0010\u0081\u0001\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0011\u0010\u0082\u0001\u001a\u00020,2\u0006\u00105\u001a\u000206H\u0002J\u0007\u0010\u0083\u0001\u001a\u00020,J\u001d\u0010\u0084\u0001\u001a\u00020\u00122\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00060IH\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J1\u0010\u0084\u0001\u001a\u00020\u00122\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00060I2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016\u00a2\u0006\u0003\u0010\u0086\u0001J\u0011\u0010\u0084\u0001\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\u0006H\u0016J%\u0010\u0084\u0001\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u0001012\b\u0010-\u001a\u0004\u0018\u000102H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00060\"R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0089\u0001"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient;", "Landroid/content/BroadcastReceiver;", "Lorg/eclipse/paho/client/mqttv3/IMqttAsyncClient;", "context", "Landroid/content/Context;", "serverURI", "", "clientId", "ackType", "Linfo/mqtt/android/service/Ack;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Linfo/mqtt/android/service/Ack;)V", "callbacksList", "Ljava/util/ArrayList;", "Lorg/eclipse/paho/client/mqttv3/MqttCallback;", "clientConnectOptions", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "clientHandle", "connectToken", "Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "getContext", "()Landroid/content/Context;", "foregroundServiceNotification", "Landroid/app/Notification;", "foregroundServiceNotificationId", "", "messageAck", "mqttService", "Linfo/mqtt/android/service/MqttService;", "persistence", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "receiverRegistered", "", "serviceBound", "serviceConnection", "Linfo/mqtt/android/service/MqttAndroidClient$MyServiceConnection;", "tokenMap", "Landroid/util/SparseArray;", "tokenNumber", "traceCallback", "Linfo/mqtt/android/service/MqttTraceHandler;", "traceEnabled", "acknowledgeMessage", "messageId", "addCallback", "", "callback", "close", "connect", "userContext", "", "Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;", "options", "connectAction", "data", "Landroid/os/Bundle;", "connectExtendedAction", "connectionLostAction", "deleteBufferedMessage", "bufferIndex", "disconnect", "quiesceTimeout", "", "disconnectForcibly", "disconnectTimeout", "disconnected", "doConnect", "getBufferedMessage", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "getBufferedMessageCount", "getClientId", "getInFlightMessageCount", "getMqttToken", "getPendingDeliveryTokens", "", "Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "()[Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "getSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "keyStore", "Ljava/io/InputStream;", "password", "getServerURI", "isConnected", "messageArrivedAction", "messageArrivedComplete", "qos", "messageDeliveredAction", "onReceive", "intent", "Landroid/content/Intent;", "publish", "topic", "payload", "", "retained", "message", "reconnect", "registerReceiver", "receiver", "registerResources", "removeMessage", "token", "removeMqttToken", "sendAction", "setBufferOpts", "bufferOpts", "Lorg/eclipse/paho/client/mqttv3/DisconnectedBufferOptions;", "setCallback", "setForegroundService", "notification", "id", "setManualAcks", "manualAcks", "setTraceCallback", "setTraceEnabled", "simpleAction", "storeToken", "subscribe", "", "([Ljava/lang/String;[I)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;[ILjava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "topicFilters", "messageListeners", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "([Ljava/lang/String;[ILjava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;[I[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "topicFilter", "messageListener", "subscribeAction", "traceAction", "unSubscribeAction", "unregisterResources", "unsubscribe", "([Ljava/lang/String;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "([Ljava/lang/String;Ljava/lang/Object;Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;)Lorg/eclipse/paho/client/mqttv3/IMqttToken;", "Companion", "MyServiceConnection", "serviceLibrary_release"})
public final class MqttAndroidClient
extends BroadcastReceiver
implements IMqttAsyncClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String serverURI;
    @NotNull
    private final String clientId;
    @NotNull
    private final MyServiceConnection serviceConnection;
    @NotNull
    private final SparseArray<IMqttToken> tokenMap;
    @NotNull
    private final Ack messageAck;
    @Nullable
    private MqttService mqttService;
    @Nullable
    private String clientHandle;
    private int tokenNumber;
    @Nullable
    private MqttClientPersistence persistence;
    @Nullable
    private MqttConnectOptions clientConnectOptions;
    @Nullable
    private IMqttToken connectToken;
    @NotNull
    private ArrayList<MqttCallback> callbacksList;
    @Nullable
    private MqttTraceHandler traceCallback;
    private boolean traceEnabled;
    private volatile boolean receiverRegistered;
    private volatile boolean serviceBound;
    private int foregroundServiceNotificationId;
    @Nullable
    private Notification foregroundServiceNotification;
    private static final String SERVICE_NAME = MqttService.class.getName();
    private static final ExecutorService pool = Executors.newCachedThreadPool();

    public MqttAndroidClient(@NotNull Context context, @NotNull String serverURI, @NotNull String clientId, @NotNull Ack ackType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)((Object)ackType), (String)"ackType");
        this.context = context;
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.serviceConnection = new MyServiceConnection();
        this.tokenMap = new SparseArray();
        this.messageAck = ackType;
        this.callbacksList = new ArrayList();
        this.foregroundServiceNotificationId = -1;
    }

    public /* synthetic */ MqttAndroidClient(Context context, String string, String string2, Ack ack, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ack = Ack.AUTO_ACK;
        }
        this(context, string, string2, ack);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        if (this.clientHandle == null) return false;
        if (this.mqttService == null) return false;
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        if (!mqttService.isConnected(string)) return false;
        return true;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @NotNull
    public String getServerURI() {
        return this.serverURI;
    }

    public void close() {
        MqttService mqttService = this.mqttService;
        if (mqttService != null) {
            MqttService it = mqttService;
            boolean bl = false;
            if (this.clientHandle == null) {
                String string = this.getContext().getApplicationInfo().packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.applicationInfo.packageName");
                this.clientHandle = it.getClient(this.serverURI, this.clientId, string, this.persistence);
            }
            String string = this.clientHandle;
            Intrinsics.checkNotNull((Object)string);
            it.close(string);
        }
    }

    @NotNull
    public IMqttToken connect() {
        return this.connect(null, null);
    }

    @NotNull
    public IMqttToken connect(@NotNull MqttConnectOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.connect(options, null, null);
    }

    @NotNull
    public IMqttToken connect(@Nullable Object userContext, @Nullable IMqttActionListener callback) {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @NotNull
    public IMqttToken connect(@NotNull MqttConnectOptions options, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        this.clientConnectOptions = options;
        this.connectToken = token2;
        if (this.mqttService == null) {
            ComponentName service;
            Intent serviceStartIntent;
            block9: {
                serviceStartIntent = new Intent();
                serviceStartIntent.setClassName(this.context, SERVICE_NAME);
                service = null;
                if (Build.VERSION.SDK_INT >= 26 && this.foregroundServiceNotification != null) {
                    serviceStartIntent.putExtra(MqttService.Companion.getMQTT_FOREGROUND_SERVICE_NOTIFICATION(), (Parcelable)this.foregroundServiceNotification);
                    serviceStartIntent.putExtra(MqttService.Companion.getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID(), this.foregroundServiceNotificationId);
                    service = this.context.startForegroundService(serviceStartIntent);
                } else {
                    try {
                        service = this.context.startService(serviceStartIntent);
                    }
                    catch (IllegalStateException ex) {
                        IMqttActionListener listener2;
                        IMqttActionListener iMqttActionListener = listener2 = token2.getActionCallback();
                        if (iMqttActionListener == null) break block9;
                        iMqttActionListener.onFailure(token2, (Throwable)ex);
                    }
                }
            }
            if (service == null) {
                IMqttActionListener listener3;
                IMqttActionListener iMqttActionListener = listener3 = token2.getActionCallback();
                if (iMqttActionListener != null) {
                    iMqttActionListener.onFailure(token2, (Throwable)new RuntimeException(Intrinsics.stringPlus((String)"cannot start service ", (Object)SERVICE_NAME)));
                }
            }
            this.context.bindService(serviceStartIntent, (ServiceConnection)this.serviceConnection, 1);
            if (!this.receiverRegistered) {
                this.registerReceiver(this);
            }
        } else {
            pool.execute(() -> MqttAndroidClient.connect$lambda-1(this));
        }
        return token2;
    }

    private final void registerReceiver(BroadcastReceiver receiver) {
        IntentFilter filter = new IntentFilter();
        filter.addAction(".callbackToActivity.v0");
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver(receiver, filter);
        this.receiverRegistered = true;
    }

    private final void doConnect() {
        block3: {
            if (this.clientHandle == null) {
                MqttService mqttService = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService);
                String string = this.context.getApplicationInfo().packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.applicationInfo.packageName");
                this.clientHandle = mqttService.getClient(this.serverURI, this.clientId, string, this.persistence);
            }
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.setTraceEnabled(this.traceEnabled);
            MqttService mqttService2 = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService2);
            mqttService2.setTraceCallbackId(this.clientHandle);
            String activityToken = this.storeToken(this.connectToken);
            try {
                MqttService mqttService3 = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService3);
                String string = this.clientHandle;
                Intrinsics.checkNotNull((Object)string);
                mqttService3.connect(string, this.clientConnectOptions, activityToken);
            }
            catch (MqttException e) {
                IMqttActionListener listener2;
                IMqttToken iMqttToken = this.connectToken;
                Intrinsics.checkNotNull((Object)iMqttToken);
                IMqttActionListener iMqttActionListener = listener2 = iMqttToken.getActionCallback();
                if (iMqttActionListener == null) break block3;
                iMqttActionListener.onFailure(this.connectToken, (Throwable)e);
            }
        }
    }

    @NotNull
    public IMqttToken disconnect() {
        IMqttToken token2 = new MqttTokenAndroid(this, null, null, null, 8, null);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, null, activityToken);
        return token2;
    }

    @NotNull
    public IMqttToken disconnect(long quiesceTimeout) {
        IMqttToken token2 = new MqttTokenAndroid(this, null, null, null, 8, null);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, quiesceTimeout, null, activityToken);
        return token2;
    }

    @NotNull
    public IMqttToken disconnect(@Nullable Object userContext, @Nullable IMqttActionListener callback) {
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, null, activityToken);
        return token2;
    }

    @NotNull
    public IMqttToken disconnect(long quiesceTimeout, @Nullable Object userContext, @NotNull IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.disconnect(string, quiesceTimeout, null, activityToken);
        return token2;
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull byte[] payload, int qos, boolean retained) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull MqttMessage message) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.publish(topic, message, null, null);
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull byte[] payload, int qos, boolean retained, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        MqttDeliveryTokenAndroid token2 = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        IMqttDeliveryToken internalToken = mqttService.publish(string, topic, payload, QoS.Companion.valueOf(qos), retained, null, activityToken);
        token2.setDelegate((IMqttToken)internalToken);
        return token2;
    }

    @NotNull
    public IMqttDeliveryToken publish(@NotNull String topic, @NotNull MqttMessage message, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MqttDeliveryTokenAndroid token2 = new MqttDeliveryTokenAndroid(this, userContext, callback, message);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        IMqttDeliveryToken internalToken = mqttService.publish(string, topic, message, null, activityToken);
        token2.setDelegate((IMqttToken)internalToken);
        return token2;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topic, int qos) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.subscribe(topic, qos, null, null);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topic, @NotNull int[] qos) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        return this.subscribe(topic, qos, null, null);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topic, int qos, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        String[] stringArray = new String[]{topic};
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, stringArray);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.subscribe(string, topic, QoS.Companion.valueOf(qos), null, activityToken);
        return token2;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topic, @NotNull int[] qos, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, topic);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.subscribe(string, topic, qos, null, activityToken);
        return token2;
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topicFilter, int qos, @Nullable Object userContext, @Nullable IMqttActionListener callback, @NotNull IMqttMessageListener messageListener) {
        Intrinsics.checkNotNullParameter((Object)topicFilter, (String)"topicFilter");
        Intrinsics.checkNotNullParameter((Object)messageListener, (String)"messageListener");
        Object[] objectArray = new String[]{topicFilter};
        String[] stringArray = objectArray;
        objectArray = new int[1];
        objectArray[0] = (String)qos;
        Object[] objectArray2 = objectArray;
        objectArray = new IMqttMessageListener[]{messageListener};
        return this.subscribe(stringArray, (int[])objectArray2, userContext, callback, (IMqttMessageListener[])objectArray);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String topicFilter, int qos, @NotNull IMqttMessageListener messageListener) {
        Intrinsics.checkNotNullParameter((Object)topicFilter, (String)"topicFilter");
        Intrinsics.checkNotNullParameter((Object)messageListener, (String)"messageListener");
        return this.subscribe(topicFilter, qos, null, null, messageListener);
    }

    @NotNull
    public IMqttToken subscribe(@NotNull String[] topicFilters, @NotNull int[] qos, @NotNull IMqttMessageListener[] messageListeners) {
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)messageListeners, (String)"messageListeners");
        return this.subscribe(topicFilters, qos, null, null, messageListeners);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IMqttToken subscribe(@NotNull String[] topicFilters, @NotNull int[] qos, @Nullable Object userContext, @Nullable IMqttActionListener callback, @NotNull IMqttMessageListener[] messageListeners) {
        void $this$toTypedArray$iv;
        Collection<QoS> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        Intrinsics.checkNotNullParameter((Object)messageListeners, (String)"messageListeners");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, topicFilters);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        int[] nArray = qos;
        String[] stringArray = topicFilters;
        String string2 = string;
        MqttService mqttService2 = mqttService;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var17_20 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(QoS.Companion.valueOf((int)it));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        QoS[] qoSArray = thisCollection$iv.toArray(new QoS[0]);
        if (qoSArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        mqttService2.subscribe(string2, stringArray, qoSArray, null, activityToken, messageListeners);
        return token2;
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.unsubscribe(topic, null, null);
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String[] topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.unsubscribe(topic, null, null);
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String topic, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.unsubscribe(string, topic, null, activityToken);
        return token2;
    }

    @NotNull
    public IMqttToken unsubscribe(@NotNull String[] topic, @Nullable Object userContext, @Nullable IMqttActionListener callback) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        IMqttToken token2 = new MqttTokenAndroid(this, userContext, callback, null, 8, null);
        String activityToken = this.storeToken(token2);
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.unsubscribe(string, topic, null, activityToken);
        return token2;
    }

    public boolean removeMessage(@NotNull IMqttDeliveryToken token2) throws MqttException {
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        return false;
    }

    @NotNull
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getPendingDeliveryTokens(string);
    }

    public void setCallback(@NotNull MqttCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacksList.clear();
        this.callbacksList.add(callback);
    }

    public final void addCallback(@NotNull MqttCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacksList.add(callback);
    }

    public final void setTraceCallback(@Nullable MqttTraceHandler traceCallback) {
        this.traceCallback = traceCallback;
    }

    public final void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        MqttService mqttService = this.mqttService;
        if (mqttService != null) {
            mqttService.setTraceEnabled(traceEnabled);
        }
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Bundle data;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Bundle bundle = data = intent.getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        String handleFromIntent = bundle.getString(".clientHandle");
        if (handleFromIntent == null || !Intrinsics.areEqual((Object)handleFromIntent, (Object)this.clientHandle)) {
            return;
        }
        String action = data.getString(".callbackAction");
        if (Intrinsics.areEqual((Object)"connect", (Object)action)) {
            this.connectAction(data);
        } else if (Intrinsics.areEqual((Object)"connectExtended", (Object)action)) {
            this.connectExtendedAction(data);
        } else if (Intrinsics.areEqual((Object)"messageArrived", (Object)action)) {
            this.messageArrivedAction(data);
        } else if (Intrinsics.areEqual((Object)"subscribe", (Object)action)) {
            this.subscribeAction(data);
        } else if (Intrinsics.areEqual((Object)"unsubscribe", (Object)action)) {
            this.unSubscribeAction(data);
        } else if (Intrinsics.areEqual((Object)"send", (Object)action)) {
            this.sendAction(data);
        } else if (Intrinsics.areEqual((Object)"messageDelivered", (Object)action)) {
            this.messageDeliveredAction(data);
        } else if (Intrinsics.areEqual((Object)"onConnectionLost", (Object)action)) {
            this.connectionLostAction(data);
        } else if (Intrinsics.areEqual((Object)"disconnect", (Object)action)) {
            this.disconnected(data);
        } else if (Intrinsics.areEqual((Object)"trace", (Object)action)) {
            this.traceAction(data);
        } else {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("Callback action doesn't exist.");
        }
    }

    public final boolean acknowledgeMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        if (this.messageAck == Ack.MANUAL_ACK) {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            String string = this.clientHandle;
            Intrinsics.checkNotNull((Object)string);
            Status status = mqttService.acknowledgeMessageArrival(string, messageId);
            return status == Status.OK;
        }
        return false;
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void setManualAcks(boolean manualAcks) {
        throw new UnsupportedOperationException();
    }

    public void reconnect() throws MqttException {
    }

    private final void connectAction(Bundle data) {
        IMqttToken token2 = this.connectToken;
        MqttTokenAndroid mqttTokenAndroid = (MqttTokenAndroid)token2;
        Intrinsics.checkNotNull((Object)mqttTokenAndroid);
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        mqttTokenAndroid.setDelegate(new MqttConnectTokenAndroid(bundle.getBoolean("sessionPresent")));
        this.removeMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void disconnected(Bundle data) {
        IMqttToken token2;
        this.clientHandle = null;
        IMqttToken iMqttToken = token2 = this.removeMqttToken(data);
        if (iMqttToken != null) {
            IMqttToken it = iMqttToken;
            boolean bl = false;
            ((MqttTokenAndroid)it).notifyComplete();
        }
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback it = (MqttCallback)element$iv;
            boolean bl = false;
            it.connectionLost(null);
        }
    }

    private final void connectionLostAction(Bundle data) {
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        Exception reason = (Exception)bundle.getSerializable(".exception");
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback it = (MqttCallback)element$iv;
            boolean bl = false;
            it.connectionLost((Throwable)reason);
        }
    }

    private final void connectExtendedAction(Bundle data) {
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        boolean reconnect2 = bundle.getBoolean(".reconnect", false);
        String serverURI = data.getString(".serverURI");
        Iterable $this$forEach$iv = this.callbacksList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttCallback callback = (MqttCallback)element$iv;
            boolean bl = false;
            if (!(callback instanceof MqttCallbackExtended)) continue;
            ((MqttCallbackExtended)callback).connectComplete(reconnect2, serverURI);
        }
    }

    private final void simpleAction(IMqttToken token2, Bundle data) {
        if (token2 != null) {
            Status status = (Status)((Object)data.getSerializable(".callbackStatus"));
            if (status == Status.OK) {
                ((MqttTokenAndroid)token2).notifyComplete();
            } else {
                String errorMessage = (String)((Object)data.getSerializable(".errorMessage"));
                Throwable exceptionThrown = (Throwable)data.getSerializable(".exception");
                if (exceptionThrown == null && errorMessage != null) {
                    exceptionThrown = new Throwable(errorMessage);
                } else if (exceptionThrown == null) {
                    Set set = data.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"data.keySet()");
                    String bundleToString2 = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(data){
                        final /* synthetic */ Bundle $data;
                        {
                            this.$data = $data;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(String key) {
                            return key + '=' + this.$data.get(key);
                        }
                    }), (int)24, null);
                    exceptionThrown = new Throwable(Intrinsics.stringPlus((String)"No Throwable given\n", (Object)bundleToString2));
                }
                ((MqttTokenAndroid)token2).notifyFailure(exceptionThrown);
            }
        } else {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError("simpleAction : token is null");
        }
    }

    private final void sendAction(Bundle data) {
        IMqttToken token2 = this.getMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void subscribeAction(Bundle data) {
        IMqttToken token2 = this.removeMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void unSubscribeAction(Bundle data) {
        IMqttToken token2 = this.removeMqttToken(data);
        this.simpleAction(token2, data);
    }

    private final void messageDeliveredAction(Bundle data) {
        IMqttToken token2 = this.removeMqttToken(data);
        Status status = (Status)((Object)data.getSerializable(".callbackStatus"));
        if (token2 != null && status == Status.OK && token2 instanceof IMqttDeliveryToken) {
            Iterable $this$forEach$iv = this.callbacksList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MqttCallback callback = (MqttCallback)element$iv;
                boolean bl = false;
                callback.deliveryComplete((IMqttDeliveryToken)token2);
            }
        }
    }

    private final void messageArrivedAction(Bundle data) {
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        String string = bundle.getString("messageId");
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data!!.getString(MqttSer\u2026ts.CALLBACK_MESSAGE_ID)!!");
        String messageId = string2;
        String destinationName = data.getString("destinationName");
        Parcelable parcelable = data.getParcelable(".PARCEL");
        Intrinsics.checkNotNull((Object)parcelable);
        Parcelable parcelable2 = parcelable;
        Intrinsics.checkNotNullExpressionValue((Object)parcelable2, (String)"data.getParcelable(MqttS\u2026ALLBACK_MESSAGE_PARCEL)!!");
        ParcelableMqttMessage message = (ParcelableMqttMessage)parcelable2;
        try {
            Iterable $this$forEach$iv;
            if (this.messageAck == Ack.AUTO_ACK) {
                $this$forEach$iv = this.callbacksList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MqttCallback callback = (MqttCallback)element$iv;
                    boolean bl = false;
                    callback.messageArrived(destinationName, (MqttMessage)message);
                }
                MqttService mqttService = this.mqttService;
                Intrinsics.checkNotNull((Object)mqttService);
                String string3 = this.clientHandle;
                Intrinsics.checkNotNull((Object)string3);
                mqttService.acknowledgeMessageArrival(string3, messageId);
            } else {
                message.setMessageId(messageId);
                $this$forEach$iv = this.callbacksList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MqttCallback callback = (MqttCallback)element$iv;
                    boolean bl = false;
                    callback.messageArrived(destinationName, (MqttMessage)message);
                }
            }
        }
        catch (Exception e) {
            MqttService mqttService = this.mqttService;
            Intrinsics.checkNotNull((Object)mqttService);
            mqttService.traceError(Intrinsics.stringPlus((String)"messageArrivedAction failed: ", (Object)e));
        }
    }

    private final void traceAction(Bundle data) {
        MqttTraceHandler mqttTraceHandler = this.traceCallback;
        if (mqttTraceHandler != null) {
            MqttTraceHandler it = mqttTraceHandler;
            boolean bl = false;
            Bundle bundle = data;
            Intrinsics.checkNotNull((Object)bundle);
            String severity = bundle.getString(".traceSeverity");
            String message = data.getString(".errorMessage");
            String string = severity;
            if (Intrinsics.areEqual((Object)string, (Object)"debug")) {
                it.traceDebug(message);
            } else if (Intrinsics.areEqual((Object)string, (Object)"error")) {
                it.traceError(message);
            } else {
                Exception e = (Exception)data.getSerializable(".exception");
                it.traceException(message, e);
            }
        }
    }

    private final synchronized String storeToken(IMqttToken token2) {
        this.tokenMap.put(this.tokenNumber, (Object)token2);
        int n = this.tokenNumber;
        this.tokenNumber = n + 1;
        return String.valueOf(n);
    }

    private final synchronized IMqttToken removeMqttToken(Bundle data) {
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        String activityToken = bundle.getString(".activityToken");
        if (activityToken != null) {
            int tokenNumber = Integer.parseInt(activityToken);
            IMqttToken token2 = (IMqttToken)this.tokenMap.get(tokenNumber);
            this.tokenMap.delete(tokenNumber);
            return token2;
        }
        return null;
    }

    private final synchronized IMqttToken getMqttToken(Bundle data) {
        String activityToken;
        Bundle bundle = data;
        Intrinsics.checkNotNull((Object)bundle);
        String string = activityToken = bundle.getString(".activityToken");
        Intrinsics.checkNotNull((Object)string);
        return (IMqttToken)this.tokenMap.get(Integer.parseInt(string));
    }

    public final void setForegroundService(@NotNull Notification notification, int id) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.foregroundServiceNotification = notification;
        this.foregroundServiceNotificationId = id;
    }

    public void setBufferOpts(@NotNull DisconnectedBufferOptions bufferOpts) {
        Intrinsics.checkNotNullParameter((Object)bufferOpts, (String)"bufferOpts");
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.setBufferOpts(string, bufferOpts);
    }

    public int getBufferedMessageCount() {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getBufferedMessageCount(string);
    }

    @NotNull
    public MqttMessage getBufferedMessage(int bufferIndex) {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        return mqttService.getBufferedMessage(string, bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        MqttService mqttService = this.mqttService;
        Intrinsics.checkNotNull((Object)mqttService);
        String string = this.clientHandle;
        Intrinsics.checkNotNull((Object)string);
        mqttService.deleteBufferedMessage(string, bufferIndex);
    }

    public int getInFlightMessageCount() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SSLSocketFactory getSSLSocketFactory(@Nullable InputStream keyStore, @NotNull String password) throws MqttSecurityException {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            Object sslSockFactory = null;
            KeyStore keyStore2 = KeyStore.getInstance("BKS");
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"getInstance(\"BKS\")");
            KeyStore ts = keyStore2;
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            ts.load(keyStore, cArray);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(ts);
            TrustManager[] tm = tmf.getTrustManagers();
            Object object = SSLContext.getInstance("TLSv1");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(\"TLSv1\")");
            SSLContext ctx = object;
            ctx.init(null, tm, null);
            object = ctx.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.socketFactory");
            sslSockFactory = object;
        }
        catch (KeyStoreException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (IOException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new MqttSecurityException((Throwable)e);
        }
        return var3_3;
    }

    public void disconnectForcibly() throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterResources() {
        if (this.receiverRegistered) {
            synchronized (this) {
                boolean bl = false;
                LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver((BroadcastReceiver)this);
                this.receiverRegistered = false;
                Unit unit = Unit.INSTANCE;
            }
            if (this.serviceBound) {
                try {
                    this.context.unbindService((ServiceConnection)this.serviceConnection);
                    this.serviceBound = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public final void registerResources() {
        if (!this.receiverRegistered) {
            this.registerReceiver(this);
        }
    }

    private static final void connect$lambda-1(MqttAndroidClient this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.doConnect();
        if (!this$0.receiverRegistered) {
            this$0.registerReceiver(this$0);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient$MyServiceConnection;", "Landroid/content/ServiceConnection;", "(Linfo/mqtt/android/service/MqttAndroidClient;)V", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "binder", "Landroid/os/IBinder;", "onServiceDisconnected", "serviceLibrary_release"})
    private final class MyServiceConnection
    implements ServiceConnection {
        public MyServiceConnection() {
            Intrinsics.checkNotNullParameter((Object)((Object)MqttAndroidClient.this), (String)"this$0");
        }

        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder binder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            if (MqttServiceBinder.class.isAssignableFrom(binder.getClass())) {
                MqttAndroidClient.this.mqttService = ((MqttServiceBinder)binder).getService();
                MqttAndroidClient.this.serviceBound = true;
                MqttAndroidClient.this.doConnect();
            }
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            MqttAndroidClient.this.mqttService = null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Linfo/mqtt/android/service/MqttAndroidClient$Companion;", "", "()V", "SERVICE_NAME", "", "kotlin.jvm.PlatformType", "pool", "Ljava/util/concurrent/ExecutorService;", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

