/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.buffer.BarBuffer;
import info.appdev.charting.data.BarData;
import info.appdev.charting.data.BarEntry;
import info.appdev.charting.interfaces.dataprovider.BarDataProvider;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import info.appdev.charting.renderer.HorizontalBarChartRenderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J@\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011\u00a8\u0006*"}, d2={"Linfo/appdev/charting/renderer/RoundedHorizontalBarChartRenderer;", "Linfo/appdev/charting/renderer/HorizontalBarChartRenderer;", "dataProvider", "Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "mBarShadowRectBuffer", "Landroid/graphics/RectF;", "roundedShadowRadius", "", "getRoundedShadowRadius", "()F", "setRoundedShadowRadius", "(F)V", "roundedPositiveDataSetRadius", "getRoundedPositiveDataSetRadius", "setRoundedPositiveDataSetRadius", "roundedNegativeDataSetRadius", "getRoundedNegativeDataSetRadius", "setRoundedNegativeDataSetRadius", "drawDataSet", "", "canvas", "Landroid/graphics/Canvas;", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IBarDataSet;", "index", "", "roundRect", "Landroid/graphics/Path;", "rect", "rx", "ry", "tl", "", "tr", "br", "bl", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nRoundedHorizontalBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedHorizontalBarChartRenderer.kt\ninfo/appdev/charting/renderer/RoundedHorizontalBarChartRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1#2:289\n*E\n"})
public final class RoundedHorizontalBarChartRenderer
extends HorizontalBarChartRenderer {
    @NotNull
    private final RectF mBarShadowRectBuffer;
    private float roundedShadowRadius;
    private float roundedPositiveDataSetRadius;
    private float roundedNegativeDataSetRadius;

    public RoundedHorizontalBarChartRenderer(@NotNull BarDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(dataProvider, animator, viewPortHandler);
        this.mBarShadowRectBuffer = new RectF();
        this.getPaintValues().setTextAlign(Paint.Align.LEFT);
    }

    public final float getRoundedShadowRadius() {
        return this.roundedShadowRadius;
    }

    public final void setRoundedShadowRadius(float f) {
        this.roundedShadowRadius = f;
    }

    public final float getRoundedPositiveDataSetRadius() {
        return this.roundedPositiveDataSetRadius;
    }

    public final void setRoundedPositiveDataSetRadius(float f) {
        this.roundedPositiveDataSetRadius = f;
    }

    public final float getRoundedNegativeDataSetRadius() {
        return this.roundedNegativeDataSetRadius;
    }

    public final void setRoundedNegativeDataSetRadius(float f) {
        this.roundedNegativeDataSetRadius = f;
    }

    @Override
    protected void drawDataSet(@NotNull Canvas canvas, @NotNull IBarDataSet dataSet, int index) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        this.initBuffers();
        Transformer trans = this.getDataProvider().getTransformer(dataSet.getAxisDependency());
        this.getBarBorderPaint().setColor(dataSet.getBarBorderColor());
        this.getBarBorderPaint().setStrokeWidth(NumberUtilsKt.convertDpToPixel(dataSet.getBarBorderWidth()));
        this.getShadowPaint().setColor(dataSet.getBarShadowColor());
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        if (this.getDataProvider().isDrawBarShadow()) {
            boolean isSingleColor;
            this.getShadowPaint().setColor(dataSet.getBarShadowColor());
            BarData barData = this.getDataProvider().getBarData();
            if (barData != null) {
                BarData barData2 = barData;
                boolean bl = false;
                float barWidth = barData2.getBarWidth();
                float barWidthHalf = barWidth / 2.0f;
                float x = 0.0f;
                int i = 0;
                double count = Math.min((double)((int)((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
                while ((double)i < count) {
                    if ((BarEntry)dataSet.getEntryForIndex(i) != null) {
                        BarEntry barEntry;
                        boolean bl2 = false;
                        x = barEntry.getX();
                        this.mBarShadowRectBuffer.top = x - barWidthHalf;
                        this.mBarShadowRectBuffer.bottom = x + barWidthHalf;
                    }
                    Transformer transformer = trans;
                    Intrinsics.checkNotNull((Object)transformer);
                    transformer.rectValueToPixel(this.mBarShadowRectBuffer);
                    if (!this.getViewPortHandler().isInBoundsTop(this.mBarShadowRectBuffer.bottom)) {
                        ++i;
                        continue;
                    }
                    if (this.getViewPortHandler().isInBoundsBottom(this.mBarShadowRectBuffer.top)) {
                        this.mBarShadowRectBuffer.left = this.getViewPortHandler().contentLeft();
                        this.mBarShadowRectBuffer.right = this.getViewPortHandler().contentRight();
                        if (this.roundedShadowRadius > 0.0f) {
                            canvas.drawRoundRect(this.getBarRect(), this.roundedShadowRadius, this.roundedShadowRadius, this.getShadowPaint());
                        } else {
                            canvas.drawRect(this.mBarShadowRectBuffer, this.getShadowPaint());
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            BarBuffer barBuffer = this.getBarBuffers().get(index);
            Intrinsics.checkNotNull((Object)barBuffer);
            BarBuffer buffer = barBuffer;
            buffer.setPhases(phaseX, phaseY);
            buffer.setDataSet(index);
            buffer.setInverted(this.getDataProvider().isInverted(dataSet.getAxisDependency()));
            BarData barData3 = this.getDataProvider().getBarData();
            if (barData3 != null) {
                BarData it = barData3;
                boolean bl = false;
                buffer.setBarWidth(it.getBarWidth());
            }
            buffer.feed(dataSet);
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(buffer.getBuffer());
            if (dataSet.getColors().size() > 1) {
                j = 0;
                while (j < buffer.size()) {
                    if (!this.getViewPortHandler().isInBoundsTop(buffer.getBuffer()[j + 3])) {
                        j += 4;
                        continue;
                    }
                    if (this.getViewPortHandler().isInBoundsBottom(buffer.getBuffer()[j + 1])) {
                        if (this.getDataProvider().isDrawBarShadow()) {
                            if (this.roundedShadowRadius > 0.0f) {
                                canvas.drawRoundRect(new RectF(buffer.getBuffer()[j], this.getViewPortHandler().contentTop(), buffer.getBuffer()[j + 2], this.getViewPortHandler().contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.getShadowPaint());
                            } else {
                                canvas.drawRect(buffer.getBuffer()[j], this.getViewPortHandler().contentTop(), buffer.getBuffer()[j + 2], this.getViewPortHandler().contentBottom(), this.getShadowPaint());
                            }
                        }
                        this.getPaintRender().setColor(dataSet.getColorByIndex(j / 4));
                        if (this.roundedPositiveDataSetRadius > 0.0f) {
                            canvas.drawRoundRect(new RectF(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.getPaintRender());
                        } else {
                            canvas.drawRect(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3], this.getPaintRender());
                        }
                        j += 4;
                        continue;
                    }
                    break;
                }
            } else {
                this.getPaintRender().setColor(dataSet.getColor());
                j = 0;
                while (j < buffer.size()) {
                    if (!this.getViewPortHandler().isInBoundsTop(buffer.getBuffer()[j + 3])) {
                        j += 4;
                        continue;
                    }
                    if (this.getViewPortHandler().isInBoundsBottom(buffer.getBuffer()[j + 1])) {
                        if (this.getDataProvider().isDrawBarShadow()) {
                            if (this.roundedShadowRadius > 0.0f) {
                                canvas.drawRoundRect(new RectF(buffer.getBuffer()[j], this.getViewPortHandler().contentTop(), buffer.getBuffer()[j + 2], this.getViewPortHandler().contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.getShadowPaint());
                            } else {
                                canvas.drawRect(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3], this.getPaintRender());
                            }
                        }
                        if (this.roundedPositiveDataSetRadius > 0.0f) {
                            canvas.drawRoundRect(new RectF(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.getPaintRender());
                        } else {
                            canvas.drawRect(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3], this.getPaintRender());
                        }
                        j += 4;
                        continue;
                    }
                    break;
                }
            }
            boolean bl = isSingleColor = dataSet.getColors().size() == 1;
            if (isSingleColor) {
                this.getPaintRender().setColor(dataSet.getColorByIndex(index));
            }
            int j = 0;
            while (j < buffer.size()) {
                if (!this.getViewPortHandler().isInBoundsTop(buffer.getBuffer()[j + 3])) {
                    j += 4;
                    continue;
                }
                if (!this.getViewPortHandler().isInBoundsBottom(buffer.getBuffer()[j + 1])) break;
                if (!isSingleColor) {
                    this.getPaintRender().setColor(dataSet.getColorByIndex(j / 4));
                }
                if ((BarEntry)dataSet.getEntryForIndex(j / 4) != null) {
                    BarEntry barEntry;
                    boolean bl3 = false;
                    if (barEntry.getY() < 0.0f && this.roundedNegativeDataSetRadius > 0.0f) {
                        Path path2 = this.roundRect(new RectF(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3]), this.roundedNegativeDataSetRadius, this.roundedNegativeDataSetRadius, true, true, true, true);
                        canvas.drawPath(path2, this.getPaintRender());
                    } else if (barEntry.getY() > 0.0f && this.roundedPositiveDataSetRadius > 0.0f) {
                        Path path2 = this.roundRect(new RectF(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, true, true, true, true);
                        canvas.drawPath(path2, this.getPaintRender());
                    } else {
                        canvas.drawRect(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3], this.getPaintRender());
                    }
                }
                j += 4;
            }
        }
    }

    private final Path roundRect(RectF rect, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        float rx2 = rx;
        float ry2 = ry;
        float top = rect.top;
        float left = rect.left;
        float right = rect.right;
        float bottom = rect.bottom;
        Path path = new Path();
        if (rx2 < 0.0f) {
            rx2 = 0.0f;
        }
        if (ry2 < 0.0f) {
            ry2 = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx2 > width / (float)2) {
            rx2 = width / (float)2;
        }
        if (ry2 > height / (float)2) {
            ry2 = height / (float)2;
        }
        float widthMinusCorners = width - (float)2 * rx2;
        float heightMinusCorners = height - (float)2 * ry2;
        path.moveTo(right, top + ry2);
        if (tr) {
            path.rQuadTo(0.0f, -ry2, -rx2, -ry2);
        } else {
            path.rLineTo(0.0f, -ry2);
            path.rLineTo(-rx2, 0.0f);
        }
        path.rLineTo(-widthMinusCorners, 0.0f);
        if (tl) {
            path.rQuadTo(-rx2, 0.0f, -rx2, ry2);
        } else {
            path.rLineTo(-rx2, 0.0f);
            path.rLineTo(0.0f, ry2);
        }
        path.rLineTo(0.0f, heightMinusCorners);
        if (bl) {
            path.rQuadTo(0.0f, ry2, rx2, ry2);
        } else {
            path.rLineTo(0.0f, ry2);
            path.rLineTo(rx2, 0.0f);
        }
        path.rLineTo(widthMinusCorners, 0.0f);
        if (br) {
            path.rQuadTo(rx2, 0.0f, rx2, -ry2);
        } else {
            path.rLineTo(rx2, 0.0f);
            path.rLineTo(0.0f, -ry2);
        }
        path.rLineTo(0.0f, -heightMinusCorners);
        path.close();
        return path;
    }
}

