/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import info.appdev.charting.data.BarLineScatterCandleBubbleDataSet;
import info.appdev.charting.data.BubbleEntry;
import info.appdev.charting.data.DataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.interfaces.datasets.IBubbleDataSet;
import info.appdev.charting.utils.NumberUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0000H\u0004R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR$\u0010 \u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R$\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000f\u00a8\u0006%"}, d2={"Linfo/appdev/charting/data/BubbleDataSet;", "Linfo/appdev/charting/data/BarLineScatterCandleBubbleDataSet;", "Linfo/appdev/charting/data/BubbleEntry;", "Linfo/appdev/charting/interfaces/datasets/IBubbleDataSet;", "yVals", "", "label", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "mMaxSize", "", "getMMaxSize", "()F", "setMMaxSize", "(F)V", "mNormalizeSize", "", "getMNormalizeSize", "()Z", "setMNormalizeSize", "(Z)V", "mHighlightCircleWidth", "calcMinMax", "", "entry", "copy", "Linfo/appdev/charting/data/DataSet;", "bubbleDataSet", "maxSize", "getMaxSize", "value", "isNormalizeSizeEnabled", "setNormalizeSizeEnabled", "highlightCircleWidth", "getHighlightCircleWidth", "setHighlightCircleWidth", "chartLib_release"})
public class BubbleDataSet
extends BarLineScatterCandleBubbleDataSet<BubbleEntry>
implements IBubbleDataSet {
    private float mMaxSize;
    private boolean mNormalizeSize;
    private float mHighlightCircleWidth;

    public BubbleDataSet(@NotNull List<BubbleEntry> yVals, @NotNull String label) {
        Intrinsics.checkNotNullParameter(yVals, (String)"yVals");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        super(yVals, label);
        this.mNormalizeSize = true;
        this.mHighlightCircleWidth = 2.5f;
    }

    protected final float getMMaxSize() {
        return this.mMaxSize;
    }

    protected final void setMMaxSize(float f) {
        this.mMaxSize = f;
    }

    protected final boolean getMNormalizeSize() {
        return this.mNormalizeSize;
    }

    protected final void setMNormalizeSize(boolean bl) {
        this.mNormalizeSize = bl;
    }

    @Override
    protected void calcMinMax(@NotNull BubbleEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        super.calcMinMax((Entry)entry);
        float size = entry.getSize();
        if (size > this.mMaxSize) {
            this.mMaxSize = size;
        }
    }

    @Override
    @NotNull
    public DataSet<BubbleEntry> copy() {
        List entries = new ArrayList();
        int n = ((Collection)this.getMEntries()).size();
        for (int i = 0; i < n; ++i) {
            entries.add(((BubbleEntry)this.getMEntries().get(i)).copy());
        }
        BubbleDataSet copied = new BubbleDataSet(entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected final void copy(@NotNull BubbleDataSet bubbleDataSet) {
        Intrinsics.checkNotNullParameter((Object)bubbleDataSet, (String)"bubbleDataSet");
        bubbleDataSet.mHighlightCircleWidth = this.mHighlightCircleWidth;
        bubbleDataSet.mNormalizeSize = this.mNormalizeSize;
    }

    @Override
    public float getMaxSize() {
        return this.mMaxSize;
    }

    @Override
    public boolean isNormalizeSizeEnabled() {
        return this.mNormalizeSize;
    }

    public void setNormalizeSizeEnabled(boolean value) {
        this.mNormalizeSize = value;
    }

    @Override
    public float getHighlightCircleWidth() {
        return this.mHighlightCircleWidth;
    }

    @Override
    public void setHighlightCircleWidth(float value) {
        this.mHighlightCircleWidth = NumberUtilsKt.convertDpToPixel(value);
    }
}

