/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import info.appdev.charting.data.BarEntry;
import info.appdev.charting.data.BarLineScatterCandleBubbleData;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import info.appdev.charting.interfaces.datasets.IDataSet;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u001d\b\u0016\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0007B\u0017\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\tJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Linfo/appdev/charting/data/BarData;", "Linfo/appdev/charting/data/BarLineScatterCandleBubbleData;", "Linfo/appdev/charting/interfaces/datasets/IBarDataSet;", "<init>", "()V", "dataSets", "", "([Linfo/appdev/charting/interfaces/datasets/IBarDataSet;)V", "", "(Ljava/util/List;)V", "barWidth", "", "getBarWidth", "()F", "setBarWidth", "(F)V", "groupBars", "", "fromX", "groupSpace", "barSpace", "getGroupWidth", "chartLib_release"})
public final class BarData
extends BarLineScatterCandleBubbleData<IBarDataSet> {
    private float barWidth;

    public final float getBarWidth() {
        return this.barWidth;
    }

    public final void setBarWidth(float f) {
        this.barWidth = f;
    }

    public BarData() {
        this.barWidth = 0.85f;
    }

    public BarData(IBarDataSet ... dataSets) {
        Intrinsics.checkNotNullParameter((Object)dataSets, (String)"dataSets");
        super((IDataSet[])Arrays.copyOf(dataSets, dataSets.length));
        this.barWidth = 0.85f;
    }

    public BarData(@NotNull List<IBarDataSet> dataSets) {
        Intrinsics.checkNotNullParameter(dataSets, (String)"dataSets");
        super(dataSets);
        this.barWidth = 0.85f;
    }

    public final void groupBars(float fromX, float groupSpace, float barSpace) {
        float fromX2 = fromX;
        int setCount = this.getDataSets().size();
        if (setCount <= 1) {
            throw new RuntimeException("BarData needs to hold at least 2 BarDataSets to allow grouping.");
        }
        IBarDataSet iBarDataSet = (IBarDataSet)this.getMaxEntryCountSet();
        int maxEntryCount = iBarDataSet != null ? iBarDataSet.getEntryCount() : 0;
        float groupSpaceWidthHalf = groupSpace / 2.0f;
        float barSpaceHalf = barSpace / 2.0f;
        float barWidthHalf = this.barWidth / 2.0f;
        float interval = this.getGroupWidth(groupSpace, barSpace);
        for (int i = 0; i < maxEntryCount; ++i) {
            float start = fromX2;
            fromX2 += groupSpaceWidthHalf;
            for (IBarDataSet set : this.getDataSets()) {
                BarEntry entry;
                fromX2 += barSpaceHalf;
                fromX2 += barWidthHalf;
                if (i < set.getEntryCount() && (entry = (BarEntry)set.getEntryForIndex(i)) != null) {
                    entry.setX(fromX2);
                }
                fromX2 += barWidthHalf;
                fromX2 += barSpaceHalf;
            }
            float end = fromX2 += groupSpaceWidthHalf;
            float innerInterval = end - start;
            float diff = interval - innerInterval;
            double d = diff;
            if (0.0 <= d ? d <= 0.0 : false) continue;
            fromX2 += diff;
        }
        this.notifyDataChanged();
    }

    public final float getGroupWidth(float groupSpace, float barSpace) {
        return (float)this.getDataSets().size() * (this.barWidth + barSpace) + groupSpace;
    }
}

