/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.utils;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.provider.MediaStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nJB\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Linfo/appdev/charting/utils/SaveUtils;", "", "<init>", "()V", "saveToPath", "", "title", "", "pathOnSD", "chartBitmap", "Landroid/graphics/Bitmap;", "saveToGallery", "fileName", "subFolderPath", "fileDescription", "format", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "context", "Landroid/content/Context;", "chartLib_release"})
public final class SaveUtils {
    @NotNull
    public static final SaveUtils INSTANCE = new SaveUtils();

    private SaveUtils() {
    }

    public final boolean saveToPath(@Nullable String title, @Nullable String pathOnSD, @NotNull Bitmap chartBitmap) {
        Intrinsics.checkNotNullParameter((Object)chartBitmap, (String)"chartBitmap");
        OutputStream stream = null;
        try {
            stream = new FileOutputStream(Environment.getExternalStorageDirectory().getPath() + pathOnSD + "/" + title + ".png");
            chartBitmap.compress(Bitmap.CompressFormat.PNG, 40, stream);
            ((FileOutputStream)stream).close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final boolean saveToGallery(@NotNull String fileName, @Nullable String subFolderPath, @Nullable String fileDescription, @NotNull Bitmap.CompressFormat format, int quality, @NotNull Bitmap chartBitmap, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)chartBitmap, (String)"chartBitmap");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object fileName2 = fileName;
        int quality2 = quality;
        if (!(0 <= quality2 ? quality2 < 101 : false)) {
            quality2 = 50;
        }
        long currentTime = System.currentTimeMillis();
        File extBaseDir = Environment.getExternalStorageDirectory();
        File file = new File(extBaseDir.getAbsolutePath() + "/DCIM/" + subFolderPath);
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        String mimeType = null;
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                mimeType = "image/png";
                if (StringsKt.endsWith$default((String)fileName2, (String)".png", (boolean)false, (int)2, null)) break;
                fileName2 = (String)fileName2 + ".png";
                break;
            }
            case 2: {
                mimeType = "image/webp";
                if (StringsKt.endsWith$default((String)fileName2, (String)".webp", (boolean)false, (int)2, null)) break;
                fileName2 = (String)fileName2 + ".webp";
                break;
            }
            case 3: {
                mimeType = "image/jpeg";
                if (StringsKt.endsWith$default((String)fileName2, (String)".jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName2, (String)".jpeg", (boolean)false, (int)2, null)) break;
                fileName2 = (String)fileName2 + ".jpg";
                break;
            }
            default: {
                mimeType = "image/jpeg";
                if (StringsKt.endsWith$default((String)fileName2, (String)".jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName2, (String)".jpeg", (boolean)false, (int)2, null)) break;
                fileName2 = (String)fileName2 + ".jpg";
            }
        }
        String filePath = file.getAbsolutePath() + "/" + (String)fileName2;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            chartBitmap.compress(format, quality2, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        long size = new File(filePath).length();
        ContentValues values = new ContentValues(8);
        values.put("title", (String)fileName2);
        values.put("_display_name", (String)fileName2);
        values.put("date_added", Long.valueOf(currentTime));
        values.put("mime_type", mimeType);
        values.put("description", fileDescription);
        values.put("orientation", Integer.valueOf(0));
        values.put("_data", filePath);
        values.put("_size", Long.valueOf(size));
        return context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values) != null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitmap.CompressFormat.values().length];
            try {
                nArray[Bitmap.CompressFormat.PNG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.WEBP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.JPEG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

