/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import info.appdev.charting.charts.RadarChart;
import info.appdev.charting.components.LimitLine;
import info.appdev.charting.components.YAxis;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.RadarData;
import info.appdev.charting.interfaces.datasets.IRadarDataSet;
import info.appdev.charting.renderer.YAxisRenderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.PointFKt;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Linfo/appdev/charting/renderer/YAxisRendererRadarChart;", "Linfo/appdev/charting/renderer/YAxisRenderer;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "yAxis", "Linfo/appdev/charting/components/YAxis;", "chart", "Linfo/appdev/charting/charts/RadarChart;", "<init>", "(Linfo/appdev/charting/utils/ViewPortHandler;Linfo/appdev/charting/components/YAxis;Linfo/appdev/charting/charts/RadarChart;)V", "renderLimitLinesPathBuffer", "Landroid/graphics/Path;", "computeAxisValues", "", "min", "", "max", "renderAxisLabels", "canvas", "Landroid/graphics/Canvas;", "renderLimitLines", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nYAxisRendererRadarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAxisRendererRadarChart.kt\ninfo/appdev/charting/renderer/YAxisRendererRadarChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class YAxisRendererRadarChart
extends YAxisRenderer {
    @NotNull
    private final RadarChart chart;
    @NotNull
    private final Path renderLimitLinesPathBuffer;

    public YAxisRendererRadarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull YAxis yAxis, @NotNull RadarChart chart) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)yAxis, (String)"yAxis");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(viewPortHandler, yAxis, null);
        this.chart = chart;
        this.renderLimitLinesPathBuffer = new Path();
    }

    @Override
    protected void computeAxisValues(float min, float max) {
        boolean centeringEnabled;
        int n;
        double intervalMagnitude;
        int intervalSigDigit;
        int labelCount = this.getAxis().getLabelCount();
        double range = Math.abs((double)(max - min));
        if (labelCount == 0 || range <= 0.0 || Double.isInfinite(range)) {
            this.getAxis().setEntries(new float[0]);
            this.getAxis().setCenteredEntries(new float[0]);
            this.getAxis().setEntryCount(0);
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = NumberUtilsKt.roundToNextSignificant(rawInterval);
        if (this.getAxis().isGranularity()) {
            double d = interval = interval < (double)this.getAxis().getGranularity() ? (double)this.getAxis().getGranularity() : interval;
        }
        if ((intervalSigDigit = (int)(interval / (intervalMagnitude = (double)NumberUtilsKt.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(interval)))))) > 5) {
            interval = Math.floor(10.0 * intervalMagnitude) == 0.0 ? interval : Math.floor(10.0 * intervalMagnitude);
        }
        int n2 = n = (centeringEnabled = this.getAxis().isCenterAxisLabelsEnabled()) ? 1 : 0;
        if (this.getAxis().isForceLabels()) {
            float step = (float)range / (float)(labelCount - 1);
            this.getAxis().setEntryCount(labelCount);
            if (this.getAxis().getEntries().length < labelCount) {
                this.getAxis().setEntries(new float[labelCount]);
            }
            float v = min;
            for (int i = 0; i < labelCount; ++i) {
                this.getAxis().getEntries()[i] = v;
                v += step;
            }
            n = labelCount;
        } else {
            double first;
            double d = first = interval == 0.0 ? 0.0 : Math.ceil((double)min / interval) * interval;
            if (centeringEnabled) {
                first -= interval;
            }
            double last = interval == 0.0 ? 0.0 : Math.nextUp(Math.floor((double)max / interval) * interval);
            double f = 0.0;
            if (!(interval == 0.0)) {
                for (f = first; f <= last; f += interval) {
                    ++n;
                }
            }
            this.getAxis().setEntryCount(++n);
            if (this.getAxis().getEntries().length < n) {
                this.getAxis().setEntries(new float[n]);
            }
            f = first;
            for (int i = 0; i < n; ++i) {
                if (f == 0.0) {
                    f = 0.0;
                }
                this.getAxis().getEntries()[i] = (float)f;
                f += interval;
            }
        }
        if (interval < 1.0) {
            this.getAxis().setDecimals((int)Math.ceil(-Math.log10(interval)));
        } else {
            this.getAxis().setDecimals(0);
        }
        if (centeringEnabled) {
            if (this.getAxis().getCenteredEntries().length < n) {
                this.getAxis().setCenteredEntries(new float[n]);
            }
            float offset = (this.getAxis().getEntries()[1] - this.getAxis().getEntries()[0]) / 2.0f;
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                this.getAxis().getCenteredEntries()[i] = this.getAxis().getEntries()[i] + offset;
            }
        }
        this.getAxis().setMAxisMinimum(this.getAxis().getEntries()[0]);
        this.getAxis().setMAxisMaximum(this.getAxis().getEntries()[n - 1]);
        this.getAxis().setAxisRange((float)Math.abs((double)(this.getAxis().getMAxisMaximum() - this.getAxis().getMAxisMinimum())));
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.getYAxis().isEnabled() || !this.getYAxis().isDrawLabelsEnabled()) {
            return;
        }
        this.getPaintAxisLabels().setTypeface(this.getYAxis().getTypeface());
        this.getPaintAxisLabels().setTextSize(this.getYAxis().getTextSize());
        this.getPaintAxisLabels().setColor(this.getYAxis().getTextColor());
        PointF center = this.chart.getCenterOffsets();
        PointF pOut = null;
        pOut = PointF.Companion.getInstance(0.0f, 0.0f);
        float factor = this.chart.getFactor();
        int from = this.getYAxis().isDrawBottomYLabelEntryEnabled() ? 0 : 1;
        int to = this.getYAxis().isDrawTopYLabelEntryEnabled() ? this.getYAxis().getEntryCount() : this.getYAxis().getEntryCount() - 1;
        float xOffset = this.getYAxis().getLabelXOffset();
        for (int j = from; j < to; ++j) {
            String it;
            float r = (this.getYAxis().getEntries()[j] - this.getYAxis().getMAxisMinimum()) * factor;
            pOut = PointFKt.getPosition(center, r, this.chart.getRotationAngle());
            String label = this.getYAxis().getFormattedLabel(j);
            if (label == null) continue;
            boolean bl = false;
            canvas.drawText(it, pOut.getX() + xOffset, pOut.getY(), this.getPaintAxisLabels());
        }
        PointF.Companion.recycleInstance(center);
        PointF.Companion.recycleInstance(pOut);
    }

    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        List<LimitLine> limitLines = this.getYAxis().getLimitLines();
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        PointF center = this.chart.getCenterOffsets();
        PointF pOut = null;
        pOut = PointF.Companion.getInstance(0.0f, 0.0f);
        int n = ((Collection)limitLines).size();
        for (int i = 0; i < n; ++i) {
            LimitLine limitLine = limitLines.get(i);
            if (!limitLine.isEnabled()) continue;
            this.getLimitLinePaint().setColor(limitLine.getLineColor());
            this.getLimitLinePaint().setPathEffect((PathEffect)limitLine.getDashPathEffect());
            this.getLimitLinePaint().setStrokeWidth(limitLine.getLineWidth());
            float r = (limitLine.getLimit() - this.chart.getYChartMin()) * factor;
            Path limitPath = this.renderLimitLinesPathBuffer;
            limitPath.reset();
            Object object = (RadarData)this.chart.getData();
            if (object != null && (object = (IRadarDataSet)((ChartData)object).getMaxEntryCountSet()) != null) {
                Object maxEntryCountSet = object;
                boolean bl = false;
                int n2 = maxEntryCountSet.getEntryCount();
                for (int j = 0; j < n2; ++j) {
                    pOut = PointFKt.getPosition(center, r, sliceAngle * (float)j + this.chart.getRotationAngle());
                    if (j == 0) {
                        limitPath.moveTo(pOut.getX(), pOut.getY());
                        continue;
                    }
                    limitPath.lineTo(pOut.getX(), pOut.getY());
                }
            }
            limitPath.close();
            canvas.drawPath(limitPath, this.getLimitLinePaint());
        }
        PointF.Companion.recycleInstance(center);
        PointF.Companion.recycleInstance(pOut);
    }
}

