/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.utils;

import android.graphics.Paint;
import android.graphics.Rect;
import info.appdev.charting.utils.FSize;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\t\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0002\u001a\u0012\u0010\r\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\t\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u000e\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000f\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"calcTextWidth", "", "Landroid/graphics/Paint;", "demoText", "", "mCalcTextHeightRect", "Landroid/graphics/Rect;", "calcTextHeight", "mFontMetrics", "Landroid/graphics/Paint$FontMetrics;", "getLineHeight", "", "fontMetrics", "getLineSpacing", "calcTextSize", "Linfo/appdev/charting/utils/FSize;", "mCalcTextSizeRect", "", "outputFSize", "chartLib_release"})
public final class PaintUtilsKt {
    @NotNull
    private static final Rect mCalcTextHeightRect = new Rect();
    @NotNull
    private static final Paint.FontMetrics mFontMetrics = new Paint.FontMetrics();
    @NotNull
    private static final Rect mCalcTextSizeRect = new Rect();

    public static final int calcTextWidth(@NotNull Paint $this$calcTextWidth, @Nullable String demoText) {
        Intrinsics.checkNotNullParameter((Object)$this$calcTextWidth, (String)"<this>");
        return (int)$this$calcTextWidth.measureText(demoText);
    }

    public static final int calcTextHeight(@NotNull Paint $this$calcTextHeight, @NotNull String demoText) {
        Intrinsics.checkNotNullParameter((Object)$this$calcTextHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)demoText, (String)"demoText");
        Rect r = mCalcTextHeightRect;
        r.set(0, 0, 0, 0);
        $this$calcTextHeight.getTextBounds(demoText, 0, demoText.length(), r);
        return r.height();
    }

    public static final float getLineHeight(@NotNull Paint $this$getLineHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineHeight, (String)"<this>");
        return PaintUtilsKt.getLineHeight($this$getLineHeight, mFontMetrics);
    }

    public static final float getLineHeight(@NotNull Paint $this$getLineHeight, @NotNull Paint.FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        $this$getLineHeight.getFontMetrics(fontMetrics);
        return fontMetrics.descent - fontMetrics.ascent;
    }

    public static final float getLineSpacing(@NotNull Paint $this$getLineSpacing) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineSpacing, (String)"<this>");
        return PaintUtilsKt.getLineSpacing($this$getLineSpacing, mFontMetrics);
    }

    public static final float getLineSpacing(@NotNull Paint $this$getLineSpacing, @NotNull Paint.FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineSpacing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        $this$getLineSpacing.getFontMetrics(fontMetrics);
        return fontMetrics.ascent - fontMetrics.top + fontMetrics.bottom;
    }

    @NotNull
    public static final FSize calcTextSize(@NotNull Paint $this$calcTextSize, @NotNull String demoText) {
        Intrinsics.checkNotNullParameter((Object)$this$calcTextSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)demoText, (String)"demoText");
        FSize result = FSize.Companion.getInstance(0.0f, 0.0f);
        PaintUtilsKt.calcTextSize($this$calcTextSize, demoText, result);
        return result;
    }

    public static final void calcTextSize(@NotNull Paint $this$calcTextSize, @NotNull String demoText, @NotNull FSize outputFSize) {
        Intrinsics.checkNotNullParameter((Object)$this$calcTextSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)demoText, (String)"demoText");
        Intrinsics.checkNotNullParameter((Object)outputFSize, (String)"outputFSize");
        Rect r = mCalcTextSizeRect;
        r.set(0, 0, 0, 0);
        $this$calcTextSize.getTextBounds(demoText, 0, demoText.length(), r);
        outputFSize.setWidth(r.width());
        outputFSize.setHeight(r.height());
    }
}

