/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import info.appdev.charting.data.BaseDataSet;
import info.appdev.charting.data.BaseEntry;
import info.appdev.charting.data.Entry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0001EB\u001f\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010%J\u0015\u0010!\u001a\u00020 2\u0006\u0010$\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010%J\u0010\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000H&J\u0014\u0010.\u001a\u00020 2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004J\n\u00100\u001a\u00020\bH\u0096\u0080\u0004J\u0006\u00101\u001a\u00020\bJ\u0015\u00102\u001a\u00020 2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\b\u00103\u001a\u00020 H\u0016J\u0015\u00104\u001a\u0002052\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106J\u0015\u00107\u001a\u0002052\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106J\u0015\u00108\u001a\u00020(2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00109J)\u0010:\u001a\u0004\u0018\u00018\u00002\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00102\b\u0010=\u001a\u0004\u0018\u00010>H\u0016\u00a2\u0006\u0002\u0010?J\u001f\u0010:\u001a\u0004\u0018\u00018\u00002\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010@J\u0017\u0010A\u001a\u0004\u0018\u00018\u00002\u0006\u0010B\u001a\u00020(H\u0016\u00a2\u0006\u0002\u0010CJ\"\u00108\u001a\u00020(2\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00102\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010;\u001a\u00020\u0010H\u0016R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R$\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R0\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\f\"\u0004\b-\u0010\u000e\u00a8\u0006F"}, d2={"Linfo/appdev/charting/data/DataSet;", "T", "Linfo/appdev/charting/data/Entry;", "Linfo/appdev/charting/data/BaseDataSet;", "Ljava/io/Serializable;", "mEntries", "", "label", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "getMEntries", "()Ljava/util/List;", "setMEntries", "(Ljava/util/List;)V", "value", "", "yMax", "getYMax", "()F", "setYMax", "(F)V", "yMin", "getYMin", "setYMin", "xMax", "getXMax", "setXMax", "xMin", "getXMin", "setXMin", "calcMinMax", "", "calcMinMaxY", "fromX", "toX", "entry", "(Linfo/appdev/charting/data/Entry;)V", "calcMinMaxX", "entryCount", "", "getEntryCount", "()I", "entries", "getEntries", "setEntries", "copy", "dataSet", "toString", "toSimpleString", "addEntryOrdered", "clear", "addEntry", "", "(Linfo/appdev/charting/data/Entry;)Z", "removeEntry", "getEntryIndex", "(Linfo/appdev/charting/data/Entry;)I", "getEntryForXValue", "xValue", "closestToY", "rounding", "Linfo/appdev/charting/data/DataSet$Rounding;", "(FFLinfo/appdev/charting/data/DataSet$Rounding;)Linfo/appdev/charting/data/Entry;", "(FF)Linfo/appdev/charting/data/Entry;", "getEntryForIndex", "index", "(I)Linfo/appdev/charting/data/Entry;", "getEntriesForXValue", "Rounding", "chartLib_release"})
public abstract class DataSet<T extends Entry>
extends BaseDataSet<T>
implements Serializable {
    @NotNull
    private List<T> mEntries;
    private float yMax;
    private float yMin;
    private float xMax;
    private float xMin;

    public DataSet(@NotNull List<T> mEntries, @NotNull String label) {
        Intrinsics.checkNotNullParameter(mEntries, (String)"mEntries");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        super(label);
        this.mEntries = mEntries;
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        this.calcMinMax();
    }

    public /* synthetic */ DataSet(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(list, string);
    }

    @NotNull
    protected final List<T> getMEntries() {
        return this.mEntries;
    }

    protected final void setMEntries(@NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mEntries = list;
    }

    @Override
    public float getYMax() {
        return this.yMax;
    }

    protected void setYMax(float f) {
        this.yMax = f;
    }

    @Override
    public float getYMin() {
        return this.yMin;
    }

    protected void setYMin(float f) {
        this.yMin = f;
    }

    @Override
    public float getXMax() {
        return this.xMax;
    }

    protected void setXMax(float f) {
        this.xMax = f;
    }

    @Override
    public float getXMin() {
        return this.xMin;
    }

    protected void setXMin(float f) {
        this.xMin = f;
    }

    @Override
    public void calcMinMax() {
        this.setYMax(-3.4028235E38f);
        this.setYMin(Float.MAX_VALUE);
        this.setXMax(-3.4028235E38f);
        this.setXMin(Float.MAX_VALUE);
        if (this.mEntries.isEmpty()) {
            return;
        }
        for (Entry e : this.mEntries) {
            this.calcMinMax(e);
        }
    }

    @Override
    public void calcMinMaxY(float fromX, float toX) {
        this.setYMax(-3.4028235E38f);
        this.setYMin(Float.MAX_VALUE);
        if (this.mEntries.isEmpty()) {
            return;
        }
        int indexFrom = this.getEntryIndex(fromX, Float.NaN, Rounding.DOWN);
        int indexTo = this.getEntryIndex(toX, Float.NaN, Rounding.UP);
        if (indexTo < indexFrom) {
            return;
        }
        int i = indexFrom;
        if (i <= indexTo) {
            while (true) {
                this.calcMinMaxY((Entry)this.mEntries.get(i));
                if (i == indexTo) break;
                ++i;
            }
        }
    }

    protected void calcMinMax(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        this.calcMinMaxX(entry);
        this.calcMinMaxY(entry);
    }

    protected final void calcMinMaxX(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        if (((Entry)entry).getX() < this.getXMin()) {
            this.setXMin(((Entry)entry).getX());
        }
        if (((Entry)entry).getX() > this.getXMax()) {
            this.setXMax(((Entry)entry).getX());
        }
    }

    protected void calcMinMaxY(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        if (((BaseEntry)entry).getY() < this.getYMin()) {
            this.setYMin(((BaseEntry)entry).getY());
        }
        if (((BaseEntry)entry).getY() > this.getYMax()) {
            this.setYMax(((BaseEntry)entry).getY());
        }
    }

    @Override
    public int getEntryCount() {
        return this.mEntries.size();
    }

    @NotNull
    public final List<T> getEntries() {
        return this.mEntries;
    }

    public final void setEntries(@NotNull List<T> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.mEntries = entries;
        this.notifyDataChanged();
    }

    @Nullable
    public abstract DataSet<T> copy();

    @Override
    protected final void copy(@NotNull DataSet<?> dataSet) {
        Intrinsics.checkNotNullParameter(dataSet, (String)"dataSet");
        super.copy((BaseDataSet)dataSet);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.toSimpleString());
        int n = ((Collection)this.mEntries).size();
        for (int i = 0; i < n; ++i) {
            buffer.append(((Entry)this.mEntries.get(i)).toString()).append(" ");
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String toSimpleString() {
        return "DataSet, label: " + this.getLabel() + ", entries: " + this.mEntries.size();
    }

    @Override
    public void addEntryOrdered(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        this.calcMinMax(entry);
        if (!this.mEntries.isEmpty() && ((Entry)this.mEntries.get(this.mEntries.size() - 1)).getX() > ((Entry)entry).getX()) {
            int closestIndex = this.getEntryIndex(((Entry)entry).getX(), ((BaseEntry)entry).getY(), Rounding.UP);
            this.mEntries.add(closestIndex, entry);
        } else {
            this.mEntries.add(entry);
        }
    }

    @Override
    public void clear() {
        this.mEntries.clear();
        this.notifyDataChanged();
    }

    @Override
    public boolean addEntry(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        this.calcMinMax(entry);
        return this.getEntries().add(entry);
    }

    @Override
    public boolean removeEntry(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        boolean removed = this.mEntries.remove(entry);
        if (removed) {
            this.calcMinMax();
        }
        return removed;
    }

    @Override
    public int getEntryIndex(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        return this.mEntries.indexOf(entry);
    }

    @Override
    @Nullable
    public T getEntryForXValue(float xValue, float closestToY, @Nullable Rounding rounding) {
        int index = this.getEntryIndex(xValue, closestToY, rounding);
        if (index > -1) {
            return (T)((Entry)this.mEntries.get(index));
        }
        return null;
    }

    @Override
    @Nullable
    public T getEntryForXValue(float xValue, float closestToY) {
        return this.getEntryForXValue(xValue, closestToY, Rounding.CLOSEST);
    }

    @Override
    @Nullable
    public T getEntryForIndex(int index) {
        if (index < 0) {
            Timber.Forest.e("index " + index + " is < 0 for getEntryForIndex", new Object[0]);
            return null;
        }
        if (index >= this.mEntries.size()) {
            Timber.Forest.e("index " + index + " / " + this.mEntries.size() + " is out of range for getEntryForIndex", new Object[0]);
            return null;
        }
        return (T)((Entry)this.mEntries.get(index));
    }

    @Override
    public int getEntryIndex(float xValue, float closestToY, @Nullable Rounding rounding) {
        int high;
        if (this.mEntries.isEmpty()) {
            return -1;
        }
        int low = 0;
        int closest = high = this.mEntries.size() - 1;
        while (low < high) {
            int m = low + (high - low) / 2;
            Entry currentEntry = (Entry)this.mEntries.get(m);
            Entry nextEntry = (Entry)this.mEntries.get(m + 1);
            float d1 = currentEntry.getX() - xValue;
            float d2 = nextEntry.getX() - xValue;
            float ad1 = Math.abs(d1);
            float ad2 = Math.abs(d2);
            if (ad2 < ad1) {
                low = m + 1;
            } else if (ad1 < ad2) {
                high = m;
            } else if ((double)d1 >= 0.0) {
                high = m;
            } else if ((double)d1 < 0.0) {
                low = m + 1;
            }
            closest = high;
        }
        Entry closestEntry = (Entry)this.mEntries.get(closest);
        float closestXValue = closestEntry.getX();
        if (rounding == Rounding.UP) {
            if (closestXValue < xValue && closest < this.mEntries.size() - 1) {
                ++closest;
            }
        } else if (rounding == Rounding.DOWN && closestXValue > xValue && closest > 0) {
            --closest;
        }
        if (!Float.isNaN(closestToY)) {
            Entry value;
            while (closest > 0 && ((Entry)this.mEntries.get(closest - 1)).getX() == closestXValue) {
                --closest;
            }
            float closestYValue = closestEntry.getY();
            int closestYIndex = closest;
            while (++closest < this.mEntries.size() && (value = (Entry)this.mEntries.get(closest)).getX() == closestXValue) {
                if (!(Math.abs(((BaseEntry)value).getY() - closestToY) <= Math.abs(closestYValue - closestToY))) continue;
                closestYValue = closestToY;
                closestYIndex = closest;
            }
            closest = closestYIndex;
        }
        return closest;
    }

    @Override
    @NotNull
    public List<T> getEntriesForXValue(float xValue) {
        List entries = new ArrayList();
        int low = 0;
        int high = this.mEntries.size() - 1;
        while (low <= high) {
            int m = (high + low) / 2;
            Entry entry = (Entry)this.mEntries.get(m);
            if (xValue == entry.getX()) {
                while (m > 0 && ((Entry)this.mEntries.get(m - 1)).getX() == xValue) {
                    --m;
                }
                high = this.mEntries.size();
                while (m < high && (entry = (Entry)this.mEntries.get(m)).getX() == xValue) {
                    entries.add(entry);
                    ++m;
                }
                break;
            }
            if (xValue > entry.getX()) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return entries;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Linfo/appdev/charting/data/DataSet$Rounding;", "", "<init>", "(Ljava/lang/String;I)V", "UP", "DOWN", "CLOSEST", "chartLib_release"})
    public static final class Rounding
    extends Enum<Rounding> {
        public static final /* enum */ Rounding UP = new Rounding();
        public static final /* enum */ Rounding DOWN = new Rounding();
        public static final /* enum */ Rounding CLOSEST = new Rounding();
        private static final /* synthetic */ Rounding[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Rounding[] values() {
            return (Rounding[])$VALUES.clone();
        }

        public static Rounding valueOf(String value) {
            return Enum.valueOf(Rounding.class, value);
        }

        @NotNull
        public static EnumEntries<Rounding> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = roundingArray = new Rounding[]{Rounding.UP, Rounding.DOWN, Rounding.CLOSEST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

