/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.charts;

import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import info.appdev.charting.charts.BarChart;
import info.appdev.charting.components.Legend;
import info.appdev.charting.components.XAxis;
import info.appdev.charting.components.YAxis;
import info.appdev.charting.data.BarData;
import info.appdev.charting.data.BarEntry;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.highlight.HorizontalBarHighlighter;
import info.appdev.charting.highlight.IHighlighter;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import info.appdev.charting.renderer.HorizontalBarChartRenderer;
import info.appdev.charting.renderer.XAxisRendererHorizontalBarChart;
import info.appdev.charting.renderer.YAxisRendererHorizontalBarChart;
import info.appdev.charting.utils.HorizontalViewPortHandler;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.TransformerHorizontalBarChart;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u001e\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u0010\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020(H\u0016J\u0010\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020(H\u0016J\u0018\u00103\u001a\u00020\u000f2\u0006\u00102\u001a\u00020(2\u0006\u00100\u001a\u00020(H\u0016J\u001a\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020(2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001a\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020(2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\"\u00108\u001a\u00020\u000f2\u0006\u00107\u001a\u00020(2\u0006\u00105\u001a\u00020(2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010*\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010,\u00a8\u00069"}, d2={"Linfo/appdev/charting/charts/HorizontalBarChart;", "Linfo/appdev/charting/charts/BarChart;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mOffsetsBuffer", "Landroid/graphics/RectF;", "calculateLegendOffsets", "", "offsets", "calculateOffsets", "prepareValuePxMatrix", "getMarkerPosition", "", "high", "Linfo/appdev/charting/highlight/Highlight;", "getBarBounds", "barEntry", "Linfo/appdev/charting/data/BarEntry;", "outputRect", "getPositionBuffer", "getGetPositionBuffer", "()[F", "setGetPositionBuffer", "([F)V", "getPosition", "Linfo/appdev/charting/utils/PointF;", "e", "Linfo/appdev/charting/data/Entry;", "axis", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "getHighlightByTouchPoint", "x", "", "y", "lowestVisibleX", "getLowestVisibleX", "()F", "highestVisibleX", "getHighestVisibleX", "setVisibleXRangeMaximum", "maxXRange", "setVisibleXRangeMinimum", "minXRange", "setVisibleXRange", "setVisibleYRangeMaximum", "maxYRange", "setVisibleYRangeMinimum", "minYRange", "setVisibleYRange", "chartLib_release"})
public class HorizontalBarChart
extends BarChart {
    @NotNull
    private final RectF mOffsetsBuffer;
    @NotNull
    private float[] getPositionBuffer;

    public HorizontalBarChart(@Nullable Context context) {
        super(context);
        this.setViewPortHandler(new HorizontalViewPortHandler());
        super.init();
        this.setMLeftAxisTransformer(new TransformerHorizontalBarChart(this.getViewPortHandler()));
        this.setMRightAxisTransformer(new TransformerHorizontalBarChart(this.getViewPortHandler()));
        this.setDataRenderer(new HorizontalBarChartRenderer(this, this.getMAnimator(), this.getViewPortHandler()));
        this.setHighlighter(new HorizontalBarHighlighter(this));
        this.setAxisRendererLeft(new YAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMAxisLeft(), this.getMLeftAxisTransformer()));
        this.setAxisRendererRight(new YAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMAxisRight(), this.getMRightAxisTransformer()));
        this.setXAxisRenderer(new XAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMXAxis(), this.getMLeftAxisTransformer()));
        this.mOffsetsBuffer = new RectF();
        this.getPositionBuffer = new float[2];
    }

    public HorizontalBarChart(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setViewPortHandler(new HorizontalViewPortHandler());
        super.init();
        this.setMLeftAxisTransformer(new TransformerHorizontalBarChart(this.getViewPortHandler()));
        this.setMRightAxisTransformer(new TransformerHorizontalBarChart(this.getViewPortHandler()));
        this.setDataRenderer(new HorizontalBarChartRenderer(this, this.getMAnimator(), this.getViewPortHandler()));
        this.setHighlighter(new HorizontalBarHighlighter(this));
        this.setAxisRendererLeft(new YAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMAxisLeft(), this.getMLeftAxisTransformer()));
        this.setAxisRendererRight(new YAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMAxisRight(), this.getMRightAxisTransformer()));
        this.setXAxisRenderer(new XAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMXAxis(), this.getMLeftAxisTransformer()));
        this.mOffsetsBuffer = new RectF();
        this.getPositionBuffer = new float[2];
    }

    public HorizontalBarChart(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setViewPortHandler(new HorizontalViewPortHandler());
        super.init();
        this.setMLeftAxisTransformer(new TransformerHorizontalBarChart(this.getViewPortHandler()));
        this.setMRightAxisTransformer(new TransformerHorizontalBarChart(this.getViewPortHandler()));
        this.setDataRenderer(new HorizontalBarChartRenderer(this, this.getMAnimator(), this.getViewPortHandler()));
        this.setHighlighter(new HorizontalBarHighlighter(this));
        this.setAxisRendererLeft(new YAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMAxisLeft(), this.getMLeftAxisTransformer()));
        this.setAxisRendererRight(new YAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMAxisRight(), this.getMRightAxisTransformer()));
        this.setXAxisRenderer(new XAxisRendererHorizontalBarChart(this.getViewPortHandler(), this.getMXAxis(), this.getMLeftAxisTransformer()));
        this.mOffsetsBuffer = new RectF();
        this.getPositionBuffer = new float[2];
    }

    @Override
    protected void calculateLegendOffsets(@NotNull RectF offsets) {
        Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
        offsets.left = 0.0f;
        offsets.right = 0.0f;
        offsets.top = 0.0f;
        offsets.bottom = 0.0f;
        if (!this.getLegend().isEnabled() || this.getLegend().isDrawInsideEnabled()) {
            return;
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$2[this.getLegend().getOrientation().ordinal()]) {
            case 1: {
                switch (WhenMappings.$EnumSwitchMapping$1[this.getLegend().getHorizontalAlignment().ordinal()]) {
                    case 1: {
                        offsets.left += Math.min(this.getLegend().getNeededWidth(), this.getViewPortHandler().getChartWidth() * this.getLegend().getMaxSizePercent()) + this.getLegend().getXOffset();
                        break block0;
                    }
                    case 2: {
                        offsets.right += Math.min(this.getLegend().getNeededWidth(), this.getViewPortHandler().getChartWidth() * this.getLegend().getMaxSizePercent()) + this.getLegend().getXOffset();
                        break block0;
                    }
                    case 3: {
                        switch (WhenMappings.$EnumSwitchMapping$0[this.getLegend().getVerticalAlignment().ordinal()]) {
                            case 1: {
                                offsets.top += Math.min(this.getLegend().getNeededHeight(), this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent()) + this.getLegend().getYOffset();
                                break;
                            }
                            case 2: {
                                offsets.bottom += Math.min(this.getLegend().getNeededHeight(), this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent()) + this.getLegend().getYOffset();
                            }
                        }
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.getLegend().getVerticalAlignment().ordinal()]) {
                    case 1: {
                        offsets.top += Math.min(this.getLegend().getNeededHeight(), this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent()) + this.getLegend().getYOffset();
                        if (!this.getMAxisLeft().isEnabled() || !this.getMAxisLeft().isDrawLabelsEnabled()) break block0;
                        offsets.top += this.getMAxisLeft().getRequiredHeightSpace(this.getAxisRendererLeft().getPaintAxisLabels());
                        break;
                    }
                    case 2: {
                        offsets.bottom += Math.min(this.getLegend().getNeededHeight(), this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent()) + this.getLegend().getYOffset();
                        if (!this.getMAxisRight().isEnabled() || !this.getMAxisRight().isDrawLabelsEnabled()) break block0;
                        offsets.bottom += this.getMAxisRight().getRequiredHeightSpace(this.getAxisRendererRight().getPaintAxisLabels());
                    }
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void calculateOffsets() {
        float offsetLeft = 0.0f;
        float offsetRight = 0.0f;
        float offsetTop = 0.0f;
        float offsetBottom = 0.0f;
        this.calculateLegendOffsets(this.mOffsetsBuffer);
        offsetLeft += this.mOffsetsBuffer.left;
        offsetTop += this.mOffsetsBuffer.top;
        offsetRight += this.mOffsetsBuffer.right;
        offsetBottom += this.mOffsetsBuffer.bottom;
        if (this.getMAxisLeft().needsOffset()) {
            offsetTop += this.getMAxisLeft().getRequiredHeightSpace(this.getAxisRendererLeft().getPaintAxisLabels());
        }
        if (this.getMAxisRight().needsOffset()) {
            offsetBottom += this.getMAxisRight().getRequiredHeightSpace(this.getAxisRendererRight().getPaintAxisLabels());
        }
        float xLabelWidth = this.getMXAxis().getMLabelWidth();
        if (this.getMXAxis().isEnabled()) {
            XAxis.XAxisPosition xAxisPosition = this.getMXAxis().getPosition();
            switch (xAxisPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$3[xAxisPosition.ordinal()]) {
                case 1: {
                    offsetLeft += xLabelWidth;
                    break;
                }
                case 2: {
                    offsetRight += xLabelWidth;
                    break;
                }
                case 3: {
                    offsetLeft += xLabelWidth;
                    offsetRight += xLabelWidth;
                    break;
                }
                case 4: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 5: {
                    throw new NotImplementedError(null, 1, null);
                }
                case -1: {
                    Timber.Forest.w("XAxisPosition is null", new Object[0]);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        float minOffset = NumberUtilsKt.convertDpToPixel(this.getMinOffset());
        ViewPortHandler.restrainViewPort$default(this.getViewPortHandler(), Math.max(minOffset, offsetLeft += this.getExtraLeftOffset()), Math.max(minOffset, offsetTop += this.getExtraTopOffset()), Math.max(minOffset, offsetRight += this.getExtraRightOffset()), Math.max(minOffset, offsetBottom += this.getExtraBottomOffset()), false, 16, null);
        if (this.isLogging()) {
            Timber.Forest.i("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom, new Object[0]);
            Timber.Forest.i("Content: " + this.getViewPortHandler().getContentRect(), new Object[0]);
        }
        this.prepareOffsetMatrix();
        this.prepareValuePxMatrix();
    }

    @Override
    protected void prepareValuePxMatrix() {
        this.getMRightAxisTransformer().prepareMatrixValuePx(this.getMAxisRight().getMAxisMinimum(), this.getMAxisRight().getAxisRange(), this.getMXAxis().getAxisRange(), this.getMXAxis().getMAxisMinimum());
        this.getMLeftAxisTransformer().prepareMatrixValuePx(this.getMAxisLeft().getMAxisMinimum(), this.getMAxisLeft().getAxisRange(), this.getMXAxis().getAxisRange(), this.getMXAxis().getMAxisMinimum());
    }

    @Override
    @NotNull
    protected float[] getMarkerPosition(@NotNull Highlight high) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        float[] fArray = new float[]{high.getDrawY(), high.getDrawX()};
        return fArray;
    }

    @Override
    public void getBarBounds(@NotNull BarEntry barEntry, @NotNull RectF outputRect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)barEntry, (String)"barEntry");
            Intrinsics.checkNotNullParameter((Object)outputRect, (String)"outputRect");
            BarData barData = (BarData)this.getMData();
            if (barData == null) break block0;
            BarData data = barData;
            boolean bl = false;
            IBarDataSet set = (IBarDataSet)data.getDataSetForEntry(barEntry);
            float y = barEntry.getY();
            float x = barEntry.getX();
            float barWidth = data.getBarWidth();
            float top = x - barWidth / 2.0f;
            float bottom = x + barWidth / 2.0f;
            float left = y >= 0.0f ? y : 0.0f;
            float right = y <= 0.0f ? y : 0.0f;
            outputRect.set(left, top, right, bottom);
            IBarDataSet iBarDataSet = set;
            Intrinsics.checkNotNull((Object)iBarDataSet);
            this.getTransformer(iBarDataSet.getAxisDependency()).rectValueToPixel(outputRect);
        }
    }

    @NotNull
    protected final float[] getGetPositionBuffer() {
        return this.getPositionBuffer;
    }

    protected final void setGetPositionBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.getPositionBuffer = fArray;
    }

    @Override
    @Nullable
    public PointF getPosition(@Nullable Entry e, @Nullable YAxis.AxisDependency axis) {
        if (e == null) {
            return null;
        }
        float[] vals = this.getPositionBuffer;
        vals[0] = e.getY();
        vals[1] = e.getX();
        this.getTransformer(axis).pointValuesToPixel(vals);
        return PointF.Companion.getInstance(vals[0], vals[1]);
    }

    @Override
    @Nullable
    public Highlight getHighlightByTouchPoint(float x, float y) {
        if (this.getMData() == null) {
            if (this.isLogging()) {
                Timber.Forest.e("Can't select by touch. No data set.", new Object[0]);
            }
            return null;
        }
        IHighlighter iHighlighter = this.getHighlighter();
        return iHighlighter != null ? iHighlighter.getHighlight(y, x) : null;
    }

    @Override
    public float getLowestVisibleX() {
        this.getTransformer(YAxis.AxisDependency.LEFT).getValuesByTouchPoint(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentBottom(), this.getPosForGetLowestVisibleX());
        return (float)Math.max((double)this.getMXAxis().getMAxisMinimum(), this.getPosForGetLowestVisibleX().getY());
    }

    @Override
    public float getHighestVisibleX() {
        this.getTransformer(YAxis.AxisDependency.LEFT).getValuesByTouchPoint(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentTop(), this.getPosForGetHighestVisibleX());
        return (float)Math.min((double)this.getMXAxis().getMAxisMaximum(), this.getPosForGetHighestVisibleX().getY());
    }

    @Override
    public void setVisibleXRangeMaximum(float maxXRange) {
        float xScale = this.getMXAxis().getAxisRange() / maxXRange;
        this.getViewPortHandler().setMinimumScaleY(xScale);
    }

    @Override
    public void setVisibleXRangeMinimum(float minXRange) {
        float xScale = this.getMXAxis().getAxisRange() / minXRange;
        this.getViewPortHandler().setMaximumScaleY(xScale);
    }

    @Override
    public void setVisibleXRange(float minXRange, float maxXRange) {
        float minScale = this.getMXAxis().getAxisRange() / minXRange;
        float maxScale = this.getMXAxis().getAxisRange() / maxXRange;
        this.getViewPortHandler().setMinMaxScaleY(minScale, maxScale);
    }

    @Override
    public void setVisibleYRangeMaximum(float maxYRange, @Nullable YAxis.AxisDependency axis) {
        float yScale = this.getAxisRange(axis) / maxYRange;
        this.getViewPortHandler().setMinimumScaleX(yScale);
    }

    @Override
    public void setVisibleYRangeMinimum(float minYRange, @Nullable YAxis.AxisDependency axis) {
        float yScale = this.getAxisRange(axis) / minYRange;
        this.getViewPortHandler().setMaximumScaleX(yScale);
    }

    @Override
    public void setVisibleYRange(float minYRange, float maxYRange, @Nullable YAxis.AxisDependency axis) {
        float minScale = this.getAxisRange(axis) / minYRange;
        float maxScale = this.getAxisRange(axis) / maxYRange;
        this.getViewPortHandler().setMinMaxScaleX(minScale, maxScale);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[Legend.LegendVerticalAlignment.values().length];
            try {
                nArray[Legend.LegendVerticalAlignment.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendVerticalAlignment.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Legend.LegendHorizontalAlignment.values().length];
            try {
                nArray[Legend.LegendHorizontalAlignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Legend.LegendOrientation.values().length];
            try {
                nArray[Legend.LegendOrientation.VERTICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendOrientation.HORIZONTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[XAxis.XAxisPosition.values().length];
            try {
                nArray[XAxis.XAxisPosition.BOTTOM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.TOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTH_SIDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.TOP_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM_INSIDE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

