/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.interfaces.datasets.ILineScatterCandleRadarDataSet;
import info.appdev.charting.renderer.BarLineScatterCandleBubbleRenderer;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Linfo/appdev/charting/renderer/LineScatterCandleRadarRenderer;", "Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "highlightLinePath", "Landroid/graphics/Path;", "drawHighlightLines", "", "canvas", "Landroid/graphics/Canvas;", "x", "", "y", "set", "Linfo/appdev/charting/interfaces/datasets/ILineScatterCandleRadarDataSet;", "chartLib_release"})
public abstract class LineScatterCandleRadarRenderer
extends BarLineScatterCandleBubbleRenderer {
    @NotNull
    private final Path highlightLinePath;

    public LineScatterCandleRadarRenderer(@NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.highlightLinePath = new Path();
    }

    protected final void drawHighlightLines(@NotNull Canvas canvas, float x, float y, @NotNull ILineScatterCandleRadarDataSet<?> set) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.getPaintHighlight().setColor(set.getHighLightColor());
        this.getPaintHighlight().setStrokeWidth(set.getHighlightLineWidth());
        this.getPaintHighlight().setPathEffect((PathEffect)set.getDashPathEffectHighlight());
        if (set.isVerticalHighlightIndicatorEnabled()) {
            this.highlightLinePath.reset();
            this.highlightLinePath.moveTo(x, this.getViewPortHandler().contentTop());
            this.highlightLinePath.lineTo(x, this.getViewPortHandler().contentBottom());
            canvas.drawPath(this.highlightLinePath, this.getPaintHighlight());
        }
        if (set.isHorizontalHighlightIndicatorEnabled()) {
            this.highlightLinePath.reset();
            this.highlightLinePath.moveTo(this.getViewPortHandler().contentLeft(), y);
            this.highlightLinePath.lineTo(this.getViewPortHandler().contentRight(), y);
            canvas.drawPath(this.highlightLinePath, this.getPaintHighlight());
        }
    }
}

