/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data.filter;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Linfo/appdev/charting/data/filter/ApproximatorN;", "", "<init>", "()V", "reduceWithDouglasPeucker", "", "points", "resultCount", "", "Line", "Companion", "chartLib_release"})
public final class ApproximatorN {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final float[] reduceWithDouglasPeucker(@NotNull float[] points, float resultCount) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        int pointCount = points.length / 2;
        if (resultCount <= 2.0f || resultCount >= (float)pointCount) {
            return points;
        }
        boolean[] keep = new boolean[pointCount];
        keep[0] = true;
        keep[pointCount - 1] = true;
        int currentStoredPoints = 2;
        ArrayList<Line> queue = new ArrayList<Line>();
        Line line = new Line(0, pointCount - 1, points);
        queue.add(line);
        do {
            Line right;
            Object e = queue.remove(queue.size() - 1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"removeAt(...)");
            line = (Line)e;
            keep[line.getIndex()] = true;
            if ((float)(++currentStoredPoints) == resultCount) break;
            Line left = new Line(line.getStart(), line.getIndex(), points);
            if (left.getIndex() > 0) {
                int insertionIndex = ApproximatorN.Companion.insertionIndex(left, queue);
                queue.add(insertionIndex, left);
            }
            if ((right = new Line(line.getIndex(), line.getEnd(), points)).getIndex() <= 0) continue;
            int insertionIndex = ApproximatorN.Companion.insertionIndex(right, queue);
            queue.add(insertionIndex, right);
        } while (queue.isEmpty());
        float[] reducedEntries = new float[currentStoredPoints * 2];
        int i = 0;
        int i2 = 0;
        int r2 = 0;
        while (i < currentStoredPoints) {
            if (keep[i]) {
                reducedEntries[i2++] = points[r2];
                reducedEntries[i2++] = points[r2 + 1];
            }
            ++i;
            r2 += 2;
        }
        return reducedEntries;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0010j\b\u0012\u0004\u0012\u00020\u000e`\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Linfo/appdev/charting/data/filter/ApproximatorN$Companion;", "", "<init>", "()V", "distanceToLine", "", "ptX", "ptY", "fromLinePoint1", "", "fromLinePoint2", "insertionIndex", "", "line", "Linfo/appdev/charting/data/filter/ApproximatorN$Line;", "queue", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "chartLib_release"})
    public static final class Companion {
        private Companion() {
        }

        private final float distanceToLine(float ptX, float ptY, float[] fromLinePoint1, float[] fromLinePoint2) {
            float dx = fromLinePoint2[0] - fromLinePoint1[0];
            float dy = fromLinePoint2[1] - fromLinePoint1[1];
            float dividend = Math.abs(dy * ptX - dx * ptY - fromLinePoint1[0] * fromLinePoint2[1] + fromLinePoint2[0] * fromLinePoint1[1]);
            double divisor = Math.sqrt(dx * dx + dy * dy);
            return (float)((double)dividend / divisor);
        }

        private final int insertionIndex(Line line, ArrayList<Line> queue) {
            int min = 0;
            int max = queue.size();
            while (!queue.isEmpty()) {
                Line midLine;
                int midIndex = min + (max - min) / 2;
                Intrinsics.checkNotNullExpressionValue((Object)queue.get(midIndex), (String)"get(...)");
                if (midLine.equals(line)) {
                    return midIndex;
                }
                if (line.lessThan(midLine)) {
                    max = midIndex;
                    continue;
                }
                min = midIndex + 1;
            }
            return min;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\f\u00a8\u0006\u001c"}, d2={"Linfo/appdev/charting/data/filter/ApproximatorN$Line;", "", "start", "", "end", "points", "", "<init>", "(II[F)V", "getStart", "()I", "setStart", "(I)V", "getEnd", "setEnd", "distance", "", "getDistance", "()F", "setDistance", "(F)V", "index", "getIndex", "setIndex", "equals", "", "rhs", "lessThan", "chartLib_release"})
    private static final class Line {
        private int start;
        private int end;
        private float distance;
        private int index;

        public Line(int start, int end, @NotNull float[] points) {
            Intrinsics.checkNotNullParameter((Object)points, (String)"points");
            this.start = start;
            this.end = end;
            float[] fArray = new float[]{points[this.start * 2], points[this.start * 2 + 1]};
            float[] startPoint = fArray;
            float[] fArray2 = new float[]{points[this.end * 2], points[this.end * 2 + 1]};
            float[] endPoint = fArray2;
            if (this.end > this.start + 1) {
                int i = this.start + 1;
                int i2 = i * 2;
                while (i < this.end) {
                    float distance = Companion.distanceToLine(points[i2], points[i2 + 1], startPoint, endPoint);
                    if (distance > this.distance) {
                        this.index = i;
                        this.distance = distance;
                    }
                    ++i;
                    i2 += 2;
                }
            }
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        public final float getDistance() {
            return this.distance;
        }

        public final void setDistance(float f) {
            this.distance = f;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final boolean equals(@NotNull Line rhs) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return this.start == rhs.start && this.end == rhs.end && this.index == rhs.index;
        }

        public final boolean lessThan(@NotNull Line rhs) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return this.distance < rhs.distance;
        }
    }
}

