/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import androidx.annotation.ColorInt;
import info.appdev.charting.charts.ScatterChart;
import info.appdev.charting.data.DataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.LineScatterCandleRadarDataSet;
import info.appdev.charting.interfaces.datasets.IScatterDataSet;
import info.appdev.charting.renderer.scatter.ChevronDownShapeRenderer;
import info.appdev.charting.renderer.scatter.ChevronUpShapeRenderer;
import info.appdev.charting.renderer.scatter.CircleShapeRenderer;
import info.appdev.charting.renderer.scatter.CrossShapeRenderer;
import info.appdev.charting.renderer.scatter.IShapeRenderer;
import info.appdev.charting.renderer.scatter.SquareShapeRenderer;
import info.appdev.charting.renderer.scatter.TriangleShapeRenderer;
import info.appdev.charting.renderer.scatter.XShapeRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001-B!\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0010\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0004J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00148\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R$\u0010%\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R(\u0010*\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u000f\"\u0004\b,\u0010\u0011\u00a8\u0006."}, d2={"Linfo/appdev/charting/data/ScatterDataSet;", "Linfo/appdev/charting/data/LineScatterCandleRadarDataSet;", "Linfo/appdev/charting/data/Entry;", "Linfo/appdev/charting/interfaces/datasets/IScatterDataSet;", "yVals", "", "label", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "shapeSize", "", "mShapeRenderer", "Linfo/appdev/charting/renderer/scatter/IShapeRenderer;", "getMShapeRenderer", "()Linfo/appdev/charting/renderer/scatter/IShapeRenderer;", "setMShapeRenderer", "(Linfo/appdev/charting/renderer/scatter/IShapeRenderer;)V", "mScatterShapeHoleRadius", "mScatterShapeHoleColor", "", "copy", "Linfo/appdev/charting/data/DataSet;", "", "scatterDataSet", "setScatterShape", "shape", "Linfo/appdev/charting/charts/ScatterChart$ScatterShape;", "value", "scatterShapeSize", "getScatterShapeSize", "()F", "setScatterShapeSize", "(F)V", "scatterShapeHoleRadius", "getScatterShapeHoleRadius", "setScatterShapeHoleRadius", "scatterShapeHoleColor", "getScatterShapeHoleColor", "()I", "setScatterShapeHoleColor", "(I)V", "shapeRenderer", "getShapeRenderer", "setShapeRenderer", "Companion", "chartLib_release"})
public class ScatterDataSet
extends LineScatterCandleRadarDataSet<Entry>
implements IScatterDataSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float shapeSize;
    @Nullable
    private IShapeRenderer mShapeRenderer;
    private float mScatterShapeHoleRadius;
    @ColorInt
    private int mScatterShapeHoleColor;

    public ScatterDataSet(@Nullable List<Entry> yVals, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        super(yVals, label);
        this.shapeSize = 15.0f;
        this.mShapeRenderer = new SquareShapeRenderer();
        this.mScatterShapeHoleColor = 0x112233;
    }

    public /* synthetic */ ScatterDataSet(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(list, string);
    }

    @Nullable
    protected final IShapeRenderer getMShapeRenderer() {
        return this.mShapeRenderer;
    }

    protected final void setMShapeRenderer(@Nullable IShapeRenderer iShapeRenderer) {
        this.mShapeRenderer = iShapeRenderer;
    }

    @Override
    @NotNull
    public DataSet<Entry> copy() {
        List entries = new ArrayList();
        List list = this.getMEntries();
        if (list != null) {
            List it = list;
            boolean bl = false;
            int n = ((Collection)it).size();
            for (int i = 0; i < n; ++i) {
                entries.add(((Entry)it.get(i)).copy());
            }
        }
        ScatterDataSet copied = new ScatterDataSet(entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected final void copy(@NotNull ScatterDataSet scatterDataSet) {
        Intrinsics.checkNotNullParameter((Object)scatterDataSet, (String)"scatterDataSet");
        super.copy(scatterDataSet);
        scatterDataSet.shapeSize = this.shapeSize;
        scatterDataSet.mShapeRenderer = this.mShapeRenderer;
        scatterDataSet.mScatterShapeHoleRadius = this.mScatterShapeHoleRadius;
        scatterDataSet.mScatterShapeHoleColor = this.mScatterShapeHoleColor;
    }

    public final void setScatterShape(@NotNull ScatterChart.ScatterShape shape) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        this.mShapeRenderer = Companion.getRendererForShape(shape);
    }

    @Override
    public float getScatterShapeSize() {
        return this.shapeSize;
    }

    public void setScatterShapeSize(float value) {
        this.shapeSize = value;
    }

    @Override
    public float getScatterShapeHoleRadius() {
        return this.mScatterShapeHoleRadius;
    }

    public void setScatterShapeHoleRadius(float value) {
        this.mScatterShapeHoleRadius = value;
    }

    @Override
    public int getScatterShapeHoleColor() {
        return this.mScatterShapeHoleColor;
    }

    public void setScatterShapeHoleColor(int value) {
        this.mScatterShapeHoleColor = value;
    }

    @Override
    @Nullable
    public IShapeRenderer getShapeRenderer() {
        return this.mShapeRenderer;
    }

    public void setShapeRenderer(@Nullable IShapeRenderer value) {
        this.mShapeRenderer = value;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Linfo/appdev/charting/data/ScatterDataSet$Companion;", "", "<init>", "()V", "getRendererForShape", "Linfo/appdev/charting/renderer/scatter/IShapeRenderer;", "shape", "Linfo/appdev/charting/charts/ScatterChart$ScatterShape;", "chartLib_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final IShapeRenderer getRendererForShape(@NotNull ScatterChart.ScatterShape shape) {
            Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
            return switch (WhenMappings.$EnumSwitchMapping$0[shape.ordinal()]) {
                case 1 -> new SquareShapeRenderer();
                case 2 -> new CircleShapeRenderer();
                case 3 -> new TriangleShapeRenderer();
                case 4 -> new CrossShapeRenderer();
                case 5 -> new XShapeRenderer();
                case 6 -> new ChevronUpShapeRenderer();
                case 7 -> new ChevronDownShapeRenderer();
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ScatterChart.ScatterShape.values().length];
                try {
                    nArray[ScatterChart.ScatterShape.SQUARE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScatterChart.ScatterShape.CIRCLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScatterChart.ScatterShape.TRIANGLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScatterChart.ScatterShape.CROSS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScatterChart.ScatterShape.X.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScatterChart.ScatterShape.CHEVRON_UP.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScatterChart.ScatterShape.CHEVRON_DOWN.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

