/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import android.graphics.DashPathEffect;
import info.appdev.charting.data.BarLineScatterCandleBubbleDataSet;
import info.appdev.charting.data.BaseDataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.interfaces.datasets.ILineScatterCandleRadarDataSet;
import info.appdev.charting.utils.NumberUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0010\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001f\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\fJ\u000e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\fJ\u001e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0014J\u0006\u0010,\u001a\u00020 J\u0014\u0010.\u001a\u00020 2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0019@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010%\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018R\u0011\u0010-\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000e\u00a8\u00060"}, d2={"Linfo/appdev/charting/data/LineScatterCandleRadarDataSet;", "T", "Linfo/appdev/charting/data/Entry;", "Linfo/appdev/charting/data/BarLineScatterCandleBubbleDataSet;", "Linfo/appdev/charting/interfaces/datasets/ILineScatterCandleRadarDataSet;", "yVals", "", "label", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "value", "", "isVerticalHighlightIndicatorEnabled", "()Z", "setVerticalHighlightIndicatorEnabled", "(Z)V", "isHorizontalHighlightIndicatorEnabled", "setHorizontalHighlightIndicatorEnabled", "mHighlightLineWidth", "", "getMHighlightLineWidth", "()F", "setMHighlightLineWidth", "(F)V", "Landroid/graphics/DashPathEffect;", "dashPathEffectHighlight", "getDashPathEffectHighlight", "()Landroid/graphics/DashPathEffect;", "setDashPathEffectHighlight", "(Landroid/graphics/DashPathEffect;)V", "setDrawHorizontalHighlightIndicator", "", "enabled", "setDrawVerticalHighlightIndicator", "setDrawHighlightIndicators", "width", "highlightLineWidth", "getHighlightLineWidth", "setHighlightLineWidth", "enableDashedHighlightLine", "lineLength", "spaceLength", "phase", "disableDashedHighlightLine", "isDashedHighlightLineEnabled", "copy", "lineScatterCandleRadarDataSet", "chartLib_release"})
public abstract class LineScatterCandleRadarDataSet<T extends Entry>
extends BarLineScatterCandleBubbleDataSet<T>
implements ILineScatterCandleRadarDataSet<T> {
    private boolean isVerticalHighlightIndicatorEnabled;
    private boolean isHorizontalHighlightIndicatorEnabled;
    private float mHighlightLineWidth;
    @Nullable
    private DashPathEffect dashPathEffectHighlight;

    public LineScatterCandleRadarDataSet(@Nullable List<T> yVals, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        super(yVals, label);
        this.isVerticalHighlightIndicatorEnabled = true;
        this.isHorizontalHighlightIndicatorEnabled = true;
        this.mHighlightLineWidth = NumberUtilsKt.convertDpToPixel(0.5f);
    }

    @Override
    public boolean isVerticalHighlightIndicatorEnabled() {
        return this.isVerticalHighlightIndicatorEnabled;
    }

    protected void setVerticalHighlightIndicatorEnabled(boolean bl) {
        this.isVerticalHighlightIndicatorEnabled = bl;
    }

    @Override
    public boolean isHorizontalHighlightIndicatorEnabled() {
        return this.isHorizontalHighlightIndicatorEnabled;
    }

    protected void setHorizontalHighlightIndicatorEnabled(boolean bl) {
        this.isHorizontalHighlightIndicatorEnabled = bl;
    }

    protected final float getMHighlightLineWidth() {
        return this.mHighlightLineWidth;
    }

    protected final void setMHighlightLineWidth(float f) {
        this.mHighlightLineWidth = f;
    }

    @Override
    @Nullable
    public DashPathEffect getDashPathEffectHighlight() {
        return this.dashPathEffectHighlight;
    }

    protected void setDashPathEffectHighlight(@Nullable DashPathEffect dashPathEffect) {
        this.dashPathEffectHighlight = dashPathEffect;
    }

    public final void setDrawHorizontalHighlightIndicator(boolean enabled) {
        this.setHorizontalHighlightIndicatorEnabled(enabled);
    }

    public final void setDrawVerticalHighlightIndicator(boolean enabled) {
        this.setVerticalHighlightIndicatorEnabled(enabled);
    }

    public final void setDrawHighlightIndicators(boolean enabled) {
        this.setDrawVerticalHighlightIndicator(enabled);
        this.setDrawHorizontalHighlightIndicator(enabled);
    }

    @Override
    public float getHighlightLineWidth() {
        return this.mHighlightLineWidth;
    }

    public void setHighlightLineWidth(float width) {
        this.mHighlightLineWidth = NumberUtilsKt.convertDpToPixel(width);
    }

    public final void enableDashedHighlightLine(float lineLength, float spaceLength, float phase) {
        float[] fArray = new float[]{lineLength, spaceLength};
        this.setDashPathEffectHighlight(new DashPathEffect(fArray, phase));
    }

    public final void disableDashedHighlightLine() {
        this.setDashPathEffectHighlight(null);
    }

    public final boolean isDashedHighlightLineEnabled() {
        return this.getDashPathEffectHighlight() != null;
    }

    @Override
    protected final void copy(@NotNull LineScatterCandleRadarDataSet<?> lineScatterCandleRadarDataSet) {
        Intrinsics.checkNotNullParameter(lineScatterCandleRadarDataSet, (String)"lineScatterCandleRadarDataSet");
        super.copy((BaseDataSet)lineScatterCandleRadarDataSet);
        lineScatterCandleRadarDataSet.setHorizontalHighlightIndicatorEnabled(this.isHorizontalHighlightIndicatorEnabled());
        lineScatterCandleRadarDataSet.setVerticalHighlightIndicatorEnabled(this.isVerticalHighlightIndicatorEnabled());
        lineScatterCandleRadarDataSet.mHighlightLineWidth = this.mHighlightLineWidth;
        lineScatterCandleRadarDataSet.setDashPathEffectHighlight(this.getDashPathEffectHighlight());
    }
}

