/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import info.appdev.charting.components.AxisBase;
import info.appdev.charting.renderer.Renderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0014J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u000202H&J\u0010\u00103\u001a\u00020)2\u0006\u00101\u001a\u000202H&J\u0010\u00104\u001a\u00020)2\u0006\u00101\u001a\u000202H&J\u0010\u00105\u001a\u00020)2\u0006\u00101\u001a\u000202H&J\u000e\u00106\u001a\u00020)2\u0006\u00107\u001a\u000208R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R$\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u001a\u0010\"\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u001a\u0010%\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018\u00a8\u00069"}, d2={"Linfo/appdev/charting/renderer/AxisRenderer;", "Linfo/appdev/charting/renderer/Renderer;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "transformer", "Linfo/appdev/charting/utils/Transformer;", "axis", "Linfo/appdev/charting/components/AxisBase;", "<init>", "(Linfo/appdev/charting/utils/ViewPortHandler;Linfo/appdev/charting/utils/Transformer;Linfo/appdev/charting/components/AxisBase;)V", "getTransformer", "()Linfo/appdev/charting/utils/Transformer;", "setTransformer", "(Linfo/appdev/charting/utils/Transformer;)V", "getAxis", "()Linfo/appdev/charting/components/AxisBase;", "setAxis", "(Linfo/appdev/charting/components/AxisBase;)V", "value", "Landroid/graphics/Paint;", "paintGrid", "getPaintGrid", "()Landroid/graphics/Paint;", "setPaintGrid", "(Landroid/graphics/Paint;)V", "paintAxisLabels", "getPaintAxisLabels", "setPaintAxisLabels", "paintAxisLine", "getPaintAxisLine", "setPaintAxisLine", "limitLinePaint", "getLimitLinePaint", "setLimitLinePaint", "limitRangePaint", "getLimitRangePaint", "setLimitRangePaint", "limitRangePaintFill", "getLimitRangePaintFill", "setLimitRangePaintFill", "computeAxis", "", "min", "", "max", "inverted", "", "computeAxisValues", "renderAxisLabels", "canvas", "Landroid/graphics/Canvas;", "renderGridLines", "renderAxisLine", "renderLimitLines", "setTextColor", "color", "", "chartLib_release"})
public abstract class AxisRenderer
extends Renderer {
    @Nullable
    private Transformer transformer;
    @NotNull
    private AxisBase axis;
    @NotNull
    private Paint paintGrid;
    @NotNull
    private Paint paintAxisLabels;
    @NotNull
    private Paint paintAxisLine;
    @NotNull
    private Paint limitLinePaint;
    @NotNull
    private Paint limitRangePaint;
    @NotNull
    private Paint limitRangePaintFill;

    /*
     * WARNING - void declaration
     */
    public AxisRenderer(@NotNull ViewPortHandler viewPortHandler, @Nullable Transformer transformer, @NotNull AxisBase axis) {
        void $this$limitRangePaintFill_u24lambda_u240;
        Paint $this$limitRangePaint_u24lambda_u240;
        Paint $this$limitLinePaint_u24lambda_u240;
        Paint $this$paintAxisLine_u24lambda_u240;
        Paint $this$paintGrid_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        super(viewPortHandler);
        this.transformer = transformer;
        this.axis = axis;
        Paint paint2 = paint = new Paint();
        AxisRenderer axisRenderer = this;
        boolean bl = false;
        $this$paintGrid_u24lambda_u240.setColor(-7829368);
        $this$paintGrid_u24lambda_u240.setStrokeWidth(1.0f);
        $this$paintGrid_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$paintGrid_u24lambda_u240.setAlpha(90);
        axisRenderer.paintGrid = paint;
        this.paintAxisLabels = new Paint(1);
        $this$paintGrid_u24lambda_u240 = paint = new Paint();
        axisRenderer = this;
        boolean bl2 = false;
        $this$paintAxisLine_u24lambda_u240.setColor(-16777216);
        $this$paintAxisLine_u24lambda_u240.setStrokeWidth(1.0f);
        $this$paintAxisLine_u24lambda_u240.setStyle(Paint.Style.STROKE);
        axisRenderer.paintAxisLine = paint;
        $this$paintAxisLine_u24lambda_u240 = paint = new Paint(1);
        axisRenderer = this;
        boolean bl3 = false;
        $this$limitLinePaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        axisRenderer.limitLinePaint = paint;
        $this$limitLinePaint_u24lambda_u240 = paint = new Paint(1);
        axisRenderer = this;
        boolean bl4 = false;
        $this$limitRangePaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        axisRenderer.limitRangePaint = paint;
        $this$limitRangePaint_u24lambda_u240 = paint = new Paint(1);
        axisRenderer = this;
        boolean bl5 = false;
        $this$limitRangePaintFill_u24lambda_u240.setStyle(Paint.Style.FILL);
        axisRenderer.limitRangePaintFill = paint;
    }

    @Nullable
    public final Transformer getTransformer() {
        return this.transformer;
    }

    public final void setTransformer(@Nullable Transformer transformer) {
        this.transformer = transformer;
    }

    @NotNull
    protected final AxisBase getAxis() {
        return this.axis;
    }

    protected final void setAxis(@NotNull AxisBase axisBase) {
        Intrinsics.checkNotNullParameter((Object)axisBase, (String)"<set-?>");
        this.axis = axisBase;
    }

    @NotNull
    public final Paint getPaintGrid() {
        return this.paintGrid;
    }

    protected final void setPaintGrid(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintGrid = paint;
    }

    @NotNull
    public final Paint getPaintAxisLabels() {
        return this.paintAxisLabels;
    }

    protected final void setPaintAxisLabels(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintAxisLabels = paint;
    }

    @NotNull
    public final Paint getPaintAxisLine() {
        return this.paintAxisLine;
    }

    protected final void setPaintAxisLine(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintAxisLine = paint;
    }

    @NotNull
    protected final Paint getLimitLinePaint() {
        return this.limitLinePaint;
    }

    protected final void setLimitLinePaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.limitLinePaint = paint;
    }

    @NotNull
    protected final Paint getLimitRangePaint() {
        return this.limitRangePaint;
    }

    protected final void setLimitRangePaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.limitRangePaint = paint;
    }

    @NotNull
    protected final Paint getLimitRangePaintFill() {
        return this.limitRangePaintFill;
    }

    protected final void setLimitRangePaintFill(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.limitRangePaintFill = paint;
    }

    public void computeAxis(float min, float max, boolean inverted) {
        float minLocal = 0.0f;
        minLocal = min;
        float maxLocal = 0.0f;
        maxLocal = max;
        if (this.getViewPortHandler().contentWidth() > 10.0f && !this.getViewPortHandler().isFullyZoomedOutY()) {
            Transformer transformer = this.transformer;
            if (transformer != null) {
                Transformer it = transformer;
                boolean bl = false;
                PointD p1 = it.getValuesByTouchPoint(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentTop());
                PointD p2 = it.getValuesByTouchPoint(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentBottom());
                if (!inverted) {
                    minLocal = (float)p2.getY();
                    maxLocal = (float)p1.getY();
                } else {
                    minLocal = (float)p1.getY();
                    maxLocal = (float)p2.getY();
                }
                PointD.Companion.recycleInstance(p1);
                PointD.Companion.recycleInstance(p2);
            }
        }
        this.computeAxisValues(minLocal, maxLocal);
    }

    protected void computeAxisValues(float min, float max) {
        int i;
        int n;
        double intervalMagnitude;
        int intervalSigDigit;
        int labelCount = this.axis.getLabelCount();
        double range = Math.abs((double)(max - min));
        if (labelCount == 0 || range <= 0.0 || Double.isInfinite(range)) {
            this.axis.setEntries(new float[0]);
            this.axis.setCenteredEntries(new float[0]);
            this.axis.setEntryCount(0);
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = NumberUtilsKt.roundToNextSignificant(rawInterval);
        if (this.axis.isGranularityEnabled()) {
            double d = interval = interval < (double)this.axis.getGranularity() ? (double)this.axis.getGranularity() : interval;
        }
        if ((intervalSigDigit = (int)(interval / (intervalMagnitude = (double)NumberUtilsKt.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(interval)))))) > 5) {
            interval = Math.floor(10.0 * intervalMagnitude) == 0.0 ? interval : Math.floor(10.0 * intervalMagnitude);
        }
        int n2 = n = this.axis.isCenterAxisLabelsEnabled() ? 1 : 0;
        if (this.axis.isForceLabelsEnabled()) {
            interval = (float)range / (float)(labelCount - 1);
            if (this.axis.isGranularityEnabled()) {
                interval = interval < (double)this.axis.getGranularity() ? (double)this.axis.getGranularity() : interval;
            }
            this.axis.setEntryCount(labelCount);
            this.axis.setEntries(new float[labelCount]);
            float v = min;
            for (i = 0; i < labelCount; ++i) {
                this.axis.getEntries()[i] = v;
                v += (float)interval;
            }
            n = labelCount;
        } else {
            double first;
            double d = first = interval == 0.0 ? 0.0 : Math.ceil((double)min / interval) * interval;
            if (this.axis.isCenterAxisLabelsEnabled()) {
                first -= interval;
            }
            double last = interval == 0.0 ? 0.0 : Math.nextUp(Math.floor((double)max / interval) * interval);
            double f = 0.0;
            if (!(interval == 0.0) && !(last == first)) {
                for (f = first; f <= last; f += interval) {
                    ++n;
                }
            } else if (last == first && n == 0) {
                n = 1;
            }
            this.axis.setEntryCount(n);
            this.axis.setEntries(new float[n]);
            f = first;
            for (int i2 = 0; i2 < n; ++i2) {
                if (f == 0.0) {
                    f = 0.0;
                }
                this.axis.getEntries()[i2] = (float)f;
                f += interval;
            }
        }
        if (interval < 1.0) {
            this.axis.setMDecimals((int)Math.ceil(-Math.log10(interval)));
        } else {
            this.axis.setMDecimals(0);
        }
        if (this.axis.isCenterAxisLabelsEnabled()) {
            if (this.axis.getCenteredEntries().length < n) {
                this.axis.setCenteredEntries(new float[n]);
            }
            float offset = (float)interval / 2.0f;
            int n3 = n;
            for (i = 0; i < n3; ++i) {
                this.axis.getCenteredEntries()[i] = this.axis.getEntries()[i] + offset;
            }
        }
    }

    public abstract void renderAxisLabels(@NotNull Canvas var1);

    public abstract void renderGridLines(@NotNull Canvas var1);

    public abstract void renderAxisLine(@NotNull Canvas var1);

    public abstract void renderLimitLines(@NotNull Canvas var1);

    public final void setTextColor(int color) {
        this.axis.setTextColor(color);
    }
}

