/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.charts.Chart;
import info.appdev.charting.charts.CombinedChart;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.CombinedData;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.renderer.BarChartRenderer;
import info.appdev.charting.renderer.BubbleChartRenderer;
import info.appdev.charting.renderer.CandleStickChartRenderer;
import info.appdev.charting.renderer.DataRenderer;
import info.appdev.charting.renderer.LineChartRenderer;
import info.appdev.charting.renderer.ScatterChartRenderer;
import info.appdev.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J#\u0010#\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020)J\u0014\u0010-\u001a\u00020\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u000fR\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\r\u00a8\u0006/"}, d2={"Linfo/appdev/charting/renderer/CombinedChartRenderer;", "Linfo/appdev/charting/renderer/DataRenderer;", "chart", "Linfo/appdev/charting/charts/CombinedChart;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/charts/CombinedChart;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "dataRenderers", "", "getDataRenderers", "()Ljava/util/List;", "setDataRenderers", "(Ljava/util/List;)V", "weakChart", "Ljava/lang/ref/WeakReference;", "Linfo/appdev/charting/charts/Chart;", "getWeakChart", "()Ljava/lang/ref/WeakReference;", "setWeakChart", "(Ljava/lang/ref/WeakReference;)V", "createRenderers", "", "initBuffers", "drawData", "canvas", "Landroid/graphics/Canvas;", "drawValues", "drawExtras", "mHighlightBuffer", "Linfo/appdev/charting/highlight/Highlight;", "getMHighlightBuffer", "setMHighlightBuffer", "drawHighlighted", "indices", "", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "getSubRenderer", "index", "", "subRenderers", "", "getSubRenderers", "setSubRenderers", "renderers", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nCombinedChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedChartRenderer.kt\ninfo/appdev/charting/renderer/CombinedChartRenderer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,119:1\n37#2,2:120\n*S KotlinDebug\n*F\n+ 1 CombinedChartRenderer.kt\ninfo/appdev/charting/renderer/CombinedChartRenderer\n*L\n95#1:120,2\n*E\n"})
public class CombinedChartRenderer
extends DataRenderer {
    @NotNull
    private List<DataRenderer> dataRenderers;
    @NotNull
    private WeakReference<Chart<?>> weakChart;
    @NotNull
    private List<Highlight> mHighlightBuffer;

    public CombinedChartRenderer(@NotNull CombinedChart chart, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataRenderers = new ArrayList(5);
        this.weakChart = new WeakReference<CombinedChart>(chart);
        this.mHighlightBuffer = new ArrayList();
        this.createRenderers();
    }

    @NotNull
    protected final List<DataRenderer> getDataRenderers() {
        return this.dataRenderers;
    }

    protected final void setDataRenderers(@NotNull List<DataRenderer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dataRenderers = list;
    }

    @NotNull
    protected final WeakReference<Chart<?>> getWeakChart() {
        return this.weakChart;
    }

    protected final void setWeakChart(@NotNull WeakReference<Chart<?>> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.weakChart = weakReference;
    }

    public final void createRenderers() {
        block9: {
            List<CombinedChart.DrawOrder> orders;
            this.dataRenderers.clear();
            CombinedChart combinedChart = (CombinedChart)this.weakChart.get();
            if (combinedChart == null) {
                return;
            }
            CombinedChart chart = combinedChart;
            List<CombinedChart.DrawOrder> list = orders = chart.getDrawOrder();
            if (list == null) break block9;
            List<CombinedChart.DrawOrder> it = list;
            boolean bl = false;
            block7: for (CombinedChart.DrawOrder order : it) {
                switch (WhenMappings.$EnumSwitchMapping$0[order.ordinal()]) {
                    case 1: {
                        this.dataRenderers.add(new BarChartRenderer(chart, this.getAnimator(), this.getViewPortHandler()));
                        continue block7;
                    }
                    case 2: {
                        if (chart.getBubbleData() == null) continue block7;
                        this.dataRenderers.add(new BubbleChartRenderer(chart, this.getAnimator(), this.getViewPortHandler()));
                        continue block7;
                    }
                    case 3: {
                        this.dataRenderers.add(new LineChartRenderer(chart, this.getAnimator(), this.getViewPortHandler()));
                        continue block7;
                    }
                    case 4: {
                        if (chart.getCandleData() == null) continue block7;
                        this.dataRenderers.add(new CandleStickChartRenderer(chart, this.getAnimator(), this.getViewPortHandler()));
                        continue block7;
                    }
                    case 5: {
                        if (chart.getScatterData() == null) continue block7;
                        this.dataRenderers.add(new ScatterChartRenderer(chart, this.getAnimator(), this.getViewPortHandler()));
                        continue block7;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void initBuffers() {
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.initBuffers();
        }
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.drawData(canvas);
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.drawValues(canvas);
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.drawExtras(canvas);
        }
    }

    @NotNull
    protected final List<Highlight> getMHighlightBuffer() {
        return this.mHighlightBuffer;
    }

    protected final void setMHighlightBuffer(@NotNull List<Highlight> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mHighlightBuffer = list;
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        Chart chart = (Chart)this.weakChart.get();
        if (chart == null) {
            return;
        }
        Chart chart2 = chart;
        for (DataRenderer renderer : this.dataRenderers) {
            int n;
            ChartData data = null;
            if (renderer instanceof BarChartRenderer) {
                data = ((BarChartRenderer)renderer).getDataProvider().getBarData();
            } else if (renderer instanceof LineChartRenderer) {
                data = ((LineChartRenderer)renderer).getDataProvider().getLineData();
            } else if (renderer instanceof CandleStickChartRenderer) {
                data = ((CandleStickChartRenderer)renderer).getDataProvider().getCandleData();
            } else if (renderer instanceof ScatterChartRenderer) {
                data = ((ScatterChartRenderer)renderer).getDataProvider().getScatterData();
            } else if (renderer instanceof BubbleChartRenderer) {
                data = ((BubbleChartRenderer)renderer).getDataProvider().getBubbleData();
            }
            if (data == null) {
                n = -1;
            } else {
                Object t = chart2.getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type info.appdev.charting.data.CombinedData");
                n = CollectionsKt.indexOf(((CombinedData)t).getAllData(), (Object)data);
            }
            int dataIndex = n;
            this.mHighlightBuffer.clear();
            for (Highlight h : indices) {
                if (h.getDataIndex() != dataIndex && h.getDataIndex() != -1) continue;
                this.mHighlightBuffer.add(h);
            }
            Collection $this$toTypedArray$iv = this.mHighlightBuffer;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            renderer.drawHighlighted(canvas, thisCollection$iv.toArray(new Highlight[0]));
        }
    }

    @Nullable
    public final DataRenderer getSubRenderer(int index) {
        return index >= this.dataRenderers.size() || index < 0 ? null : this.dataRenderers.get(index);
    }

    @NotNull
    public final List<DataRenderer> getSubRenderers() {
        return this.dataRenderers;
    }

    public final void setSubRenderers(@NotNull List<DataRenderer> renderers) {
        Intrinsics.checkNotNullParameter(renderers, (String)"renderers");
        this.dataRenderers = renderers;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CombinedChart.DrawOrder.values().length];
            try {
                nArray[CombinedChart.DrawOrder.BAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.BUBBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.CANDLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.SCATTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

