/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.components;

import android.content.Context;
import android.graphics.Canvas;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import info.appdev.charting.charts.Chart;
import info.appdev.charting.components.IMarker;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.utils.PointF;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R0\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Linfo/appdev/charting/components/MarkerView;", "Landroid/widget/RelativeLayout;", "Linfo/appdev/charting/components/IMarker;", "context", "Landroid/content/Context;", "layoutResource", "", "<init>", "(Landroid/content/Context;I)V", "mOffset", "Linfo/appdev/charting/utils/PointF;", "mOffset2", "mWeakChart", "Ljava/lang/ref/WeakReference;", "Linfo/appdev/charting/charts/Chart;", "setupLayoutResource", "", "offset", "getOffset", "()Linfo/appdev/charting/utils/PointF;", "setOffset", "(Linfo/appdev/charting/utils/PointF;)V", "chart", "chartView", "getChartView", "()Linfo/appdev/charting/charts/Chart;", "setChartView", "(Linfo/appdev/charting/charts/Chart;)V", "getOffsetForDrawingAtPoint", "posX", "", "posY", "refreshContent", "entry", "Linfo/appdev/charting/data/Entry;", "highlight", "Linfo/appdev/charting/highlight/Highlight;", "draw", "canvas", "Landroid/graphics/Canvas;", "chartLib_release"})
public class MarkerView
extends RelativeLayout
implements IMarker {
    @NotNull
    private PointF mOffset = new PointF();
    @NotNull
    private final PointF mOffset2 = new PointF();
    @Nullable
    private WeakReference<Chart<?>> mWeakChart;

    public MarkerView(@Nullable Context context, int layoutResource) {
        super(context);
        this.setupLayoutResource(layoutResource);
    }

    private final void setupLayoutResource(int layoutResource) {
        View inflated = LayoutInflater.from((Context)this.getContext()).inflate(layoutResource, (ViewGroup)this);
        inflated.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        inflated.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        inflated.layout(0, 0, inflated.getMeasuredWidth(), inflated.getMeasuredHeight());
    }

    @Override
    @NotNull
    public PointF getOffset() {
        return this.mOffset;
    }

    public void setOffset(@NotNull PointF offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.mOffset = offset;
    }

    @Nullable
    public final Chart<?> getChartView() {
        Chart chart;
        if (this.mWeakChart == null) {
            chart = null;
        } else {
            WeakReference<Chart<?>> weakReference = this.mWeakChart;
            Intrinsics.checkNotNull(weakReference);
            chart = (Chart)weakReference.get();
        }
        return chart;
    }

    public final void setChartView(@Nullable Chart<?> chart) {
        this.mWeakChart = new WeakReference(chart);
    }

    @Override
    @NotNull
    public PointF getOffsetForDrawingAtPoint(float posX, float posY) {
        PointF offset = this.getOffset();
        this.mOffset2.setX(offset.getX());
        this.mOffset2.setY(offset.getY());
        Chart<?> chart = this.getChartView();
        float width = this.getWidth();
        float height = this.getHeight();
        if (posX + this.mOffset2.getX() < 0.0f) {
            this.mOffset2.setX(-posX);
        } else if (chart != null && posX + width + this.mOffset2.getX() > (float)chart.getWidth()) {
            this.mOffset2.setX((float)chart.getWidth() - posX - width);
        }
        if (posY + this.mOffset2.getY() < 0.0f) {
            this.mOffset2.setY(-posY);
        } else if (chart != null && posY + height + this.mOffset2.getY() > (float)chart.getHeight()) {
            this.mOffset2.setY((float)chart.getHeight() - posY - height);
        }
        return this.mOffset2;
    }

    @Override
    public void refreshContent(@NotNull Entry entry, @NotNull Highlight highlight) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
        this.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        this.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    @Override
    public void draw(@NotNull Canvas canvas, float posX, float posY) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        PointF offset = this.getOffsetForDrawingAtPoint(posX, posY);
        int saveId = canvas.save();
        canvas.translate(posX + offset.getX(), posY + offset.getY());
        this.draw(canvas);
        canvas.restoreToCount(saveId);
    }
}

