/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.components;

import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import info.appdev.charting.components.ComponentBase;
import info.appdev.charting.components.LimitLine;
import info.appdev.charting.utils.UtilsKtKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001<B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u001e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003J\u0006\u00108\u001a\u000204R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010.\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010;\u00a8\u0006="}, d2={"Linfo/appdev/charting/components/LimitRange;", "Linfo/appdev/charting/components/ComponentBase;", "firstLimit", "", "secondLimit", "<init>", "(FF)V", "label", "", "(FFLjava/lang/String;)V", "limit", "Linfo/appdev/charting/components/LimitRange$Range;", "getLimit", "()Linfo/appdev/charting/components/LimitRange$Range;", "mLineWidth", "lineColor", "", "getLineColor", "()I", "setLineColor", "(I)V", "rangeColor", "getRangeColor", "setRangeColor", "textStyle", "Landroid/graphics/Paint$Style;", "getTextStyle", "()Landroid/graphics/Paint$Style;", "setTextStyle", "(Landroid/graphics/Paint$Style;)V", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "value", "Landroid/graphics/DashPathEffect;", "dashPathEffect", "getDashPathEffect", "()Landroid/graphics/DashPathEffect;", "labelPosition", "Linfo/appdev/charting/components/LimitLine$LimitLabelPosition;", "getLabelPosition", "()Linfo/appdev/charting/components/LimitLine$LimitLabelPosition;", "setLabelPosition", "(Linfo/appdev/charting/components/LimitLine$LimitLabelPosition;)V", "width", "lineWidth", "getLineWidth", "()F", "setLineWidth", "(F)V", "enableDashedLine", "", "lineLength", "spaceLength", "phase", "disableDashedLine", "isDashedLineEnabled", "", "()Z", "Range", "chartLib_release"})
public final class LimitRange
extends ComponentBase {
    @NotNull
    private final Range limit;
    private float mLineWidth;
    private int lineColor = Color.rgb((int)237, (int)91, (int)91);
    private int rangeColor = Color.rgb((int)128, (int)128, (int)128);
    @Nullable
    private Paint.Style textStyle = Paint.Style.FILL;
    @Nullable
    private String label = "";
    @Nullable
    private DashPathEffect dashPathEffect;
    @Nullable
    private LimitLine.LimitLabelPosition labelPosition = LimitLine.LimitLabelPosition.RIGHT_TOP;

    @NotNull
    public final Range getLimit() {
        return this.limit;
    }

    public final int getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(int n) {
        this.lineColor = n;
    }

    public final int getRangeColor() {
        return this.rangeColor;
    }

    public final void setRangeColor(int n) {
        this.rangeColor = n;
    }

    @Nullable
    public final Paint.Style getTextStyle() {
        return this.textStyle;
    }

    public final void setTextStyle(@Nullable Paint.Style style) {
        this.textStyle = style;
    }

    @Nullable
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@Nullable String string) {
        this.label = string;
    }

    @Nullable
    public final DashPathEffect getDashPathEffect() {
        return this.dashPathEffect;
    }

    @Nullable
    public final LimitLine.LimitLabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public final void setLabelPosition(@Nullable LimitLine.LimitLabelPosition limitLabelPosition) {
        this.labelPosition = limitLabelPosition;
    }

    public LimitRange(float firstLimit, float secondLimit) {
        this.limit = new Range(firstLimit, secondLimit);
    }

    public LimitRange(float firstLimit, float secondLimit, @Nullable String label) {
        this.limit = new Range(firstLimit, secondLimit);
        this.label = label;
    }

    public final float getLineWidth() {
        return this.mLineWidth;
    }

    public final void setLineWidth(float width) {
        float width2 = width;
        if (width2 > 12.0f) {
            width2 = 12.0f;
        }
        this.mLineWidth = UtilsKtKt.convertDpToPixel(width2);
    }

    public final void enableDashedLine(float lineLength, float spaceLength, float phase) {
        float[] fArray = new float[]{lineLength, spaceLength};
        this.dashPathEffect = new DashPathEffect(fArray, phase);
    }

    public final void disableDashedLine() {
        this.dashPathEffect = null;
    }

    public final boolean isDashedLineEnabled() {
        return this.dashPathEffect != null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Linfo/appdev/charting/components/LimitRange$Range;", "", "r1", "", "r2", "<init>", "(FF)V", "low", "getLow", "()F", "high", "getHigh", "chartLib_release"})
    public static final class Range {
        private final float low;
        private final float high;

        public Range(float r1, float r2) {
            if (r1 < r2) {
                this.low = r1;
                this.high = r2;
            } else {
                this.low = r2;
                this.high = r1;
            }
        }

        public final float getLow() {
            return this.low;
        }

        public final float getHigh() {
            return this.high;
        }
    }
}

