package info.appdev.charting.renderer

import android.graphics.Canvas
import android.graphics.Path
import info.appdev.charting.animation.ChartAnimator
import info.appdev.charting.interfaces.datasets.ILineScatterCandleRadarDataSet
import info.appdev.charting.utils.ViewPortHandler

abstract class LineScatterCandleRadarRenderer(animator: ChartAnimator, viewPortHandler: ViewPortHandler) :
    BarLineScatterCandleBubbleRenderer(animator, viewPortHandler) {
    /**
     * path that is used for drawing highlight-lines (drawLines(...) cannot be used because of dashes)
     */
    private val highlightLinePath = Path()

    /**
     * Draws vertical & horizontal highlight-lines if enabled.
     *
     * @param canvas
     * @param x x-position of the highlight line intersection
     * @param y y-position of the highlight line intersection
     * @param set the currently drawn dataset
     */
    protected fun drawHighlightLines(canvas: Canvas, x: Float, y: Float, set: ILineScatterCandleRadarDataSet<*>) {
        // set color and stroke-width

        paintHighlight.color = set.highLightColor
        paintHighlight.strokeWidth = set.highlightLineWidth

        // draw highlighted lines (if enabled)
        paintHighlight.pathEffect = set.dashPathEffectHighlight

        // draw vertical highlight lines
        if (set.isVerticalHighlightIndicatorEnabled) {
            // create vertical path

            highlightLinePath.reset()
            highlightLinePath.moveTo(x, viewPortHandler.contentTop())
            highlightLinePath.lineTo(x, viewPortHandler.contentBottom())

            canvas.drawPath(highlightLinePath, paintHighlight)
        }

        // draw horizontal highlight lines
        if (set.isHorizontalHighlightIndicatorEnabled) {
            // create horizontal path

            highlightLinePath.reset()
            highlightLinePath.moveTo(viewPortHandler.contentLeft(), y)
            highlightLinePath.lineTo(viewPortHandler.contentRight(), y)

            canvas.drawPath(highlightLinePath, paintHighlight)
        }
    }
}
