/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.github.mikephil.charting.formatter.DefaultValueFormatter;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.MPPointF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0016\u0010&\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u0016\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020(J\u000e\u0010+\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u0016\u0010+\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020(J\u0016\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001e\u0010,\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020-J\b\u00108\u001a\u000205H\u0002J\u001e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0012J&\u00109\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020:J\u0016\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0012J&\u0010F\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u0005J>\u0010O\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020H2\u0006\u0010P\u001a\u00020#2\u0006\u0010K\u001a\u00020\u00122\u0006\u0010L\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010Q\u001a\u00020:2\u0006\u0010R\u001a\u00020\u0012J\u001e\u0010S\u001a\u00020-2\u0006\u0010T\u001a\u00020\u00122\u0006\u0010U\u001a\u00020\u00122\u0006\u0010V\u001a\u00020\u0012J\u001e\u0010W\u001a\u00020-2\u0006\u0010T\u001a\u00020\u00122\u0006\u0010U\u001a\u00020\u00122\u0006\u0010X\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\u0010R\u0017\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\u0014R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u0010E\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/github/mikephil/charting/utils/Utils;", "", "<init>", "()V", "minimumFlingVelocity", "", "getMinimumFlingVelocity", "()I", "setMinimumFlingVelocity", "(I)V", "maximumFlingVelocity", "getMaximumFlingVelocity", "setMaximumFlingVelocity", "DEG2RAD", "", "getDEG2RAD", "()D", "FDEG2RAD", "", "getFDEG2RAD", "()F", "DOUBLE_EPSILON", "getDOUBLE_EPSILON$annotations", "getDOUBLE_EPSILON", "FLOAT_EPSILON", "getFLOAT_EPSILON$annotations", "getFLOAT_EPSILON", "init", "", "context", "Landroid/content/Context;", "calcTextWidth", "paint", "Landroid/graphics/Paint;", "demoText", "", "mCalcTextHeightRect", "Landroid/graphics/Rect;", "calcTextHeight", "mFontMetrics", "Landroid/graphics/Paint$FontMetrics;", "getLineHeight", "fontMetrics", "getLineSpacing", "calcTextSize", "Lcom/github/mikephil/charting/utils/FSize;", "mCalcTextSizeRect", "outputFSize", "POW_10", "", "getPOW_10", "()[I", "defaultValueFormatter", "Lcom/github/mikephil/charting/formatter/IValueFormatter;", "getDefaultValueFormatter", "()Lcom/github/mikephil/charting/formatter/IValueFormatter;", "generateDefaultValueFormatter", "getPosition", "Lcom/github/mikephil/charting/utils/MPPointF;", "center", "dist", "angle", "outputPoint", "velocityTrackerPointerUpCleanUpIfNecessary", "ev", "Landroid/view/MotionEvent;", "tracker", "Landroid/view/VelocityTracker;", "getNormalizedAngle", "mDrawableBoundsCache", "drawImage", "canvas", "Landroid/graphics/Canvas;", "drawable", "Landroid/graphics/drawable/Drawable;", "x", "y", "mDrawTextRectBuffer", "mFontMetricsBuffer", "drawXAxisValue", "text", "anchor", "angleDegrees", "getSizeOfRotatedRectangleByDegrees", "rectangleWidth", "rectangleHeight", "degrees", "getSizeOfRotatedRectangleByRadians", "radians", "MPChartLib_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    private static int minimumFlingVelocity = 50;
    private static int maximumFlingVelocity = 8000;
    private static final double DEG2RAD = Math.PI / 180;
    private static final float FDEG2RAD = (float)Math.PI / 180;
    private static final double DOUBLE_EPSILON = Double.longBitsToDouble(1L);
    private static final float FLOAT_EPSILON = Float.intBitsToFloat(1);
    @NotNull
    private static final Rect mCalcTextHeightRect = new Rect();
    @NotNull
    private static final Paint.FontMetrics mFontMetrics = new Paint.FontMetrics();
    @NotNull
    private static final Rect mCalcTextSizeRect = new Rect();
    @NotNull
    private static final int[] POW_10;
    @NotNull
    private static final IValueFormatter defaultValueFormatter;
    @NotNull
    private static final Rect mDrawableBoundsCache;
    @NotNull
    private static final Rect mDrawTextRectBuffer;
    @NotNull
    private static final Paint.FontMetrics mFontMetricsBuffer;

    private Utils() {
    }

    public final int getMinimumFlingVelocity() {
        return minimumFlingVelocity;
    }

    public final void setMinimumFlingVelocity(int n) {
        minimumFlingVelocity = n;
    }

    public final int getMaximumFlingVelocity() {
        return maximumFlingVelocity;
    }

    public final void setMaximumFlingVelocity(int n) {
        maximumFlingVelocity = n;
    }

    public final double getDEG2RAD() {
        return DEG2RAD;
    }

    public final float getFDEG2RAD() {
        return FDEG2RAD;
    }

    public final double getDOUBLE_EPSILON() {
        return DOUBLE_EPSILON;
    }

    public static /* synthetic */ void getDOUBLE_EPSILON$annotations() {
    }

    public final float getFLOAT_EPSILON() {
        return FLOAT_EPSILON;
    }

    public static /* synthetic */ void getFLOAT_EPSILON$annotations() {
    }

    public final void init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        minimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        maximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    public final int calcTextWidth(@NotNull Paint paint, @Nullable String demoText) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        return (int)paint.measureText(demoText);
    }

    public final int calcTextHeight(@NotNull Paint paint, @NotNull String demoText) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)demoText, (String)"demoText");
        Rect r = mCalcTextHeightRect;
        r.set(0, 0, 0, 0);
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        return r.height();
    }

    public final float getLineHeight(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        return this.getLineHeight(paint, mFontMetrics);
    }

    public final float getLineHeight(@NotNull Paint paint, @NotNull Paint.FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        paint.getFontMetrics(fontMetrics);
        return fontMetrics.descent - fontMetrics.ascent;
    }

    public final float getLineSpacing(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        return this.getLineSpacing(paint, mFontMetrics);
    }

    public final float getLineSpacing(@NotNull Paint paint, @NotNull Paint.FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        paint.getFontMetrics(fontMetrics);
        return fontMetrics.ascent - fontMetrics.top + fontMetrics.bottom;
    }

    @NotNull
    public final FSize calcTextSize(@NotNull Paint paint, @NotNull String demoText) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)demoText, (String)"demoText");
        FSize result = FSize.Companion.getInstance(0.0f, 0.0f);
        this.calcTextSize(paint, demoText, result);
        return result;
    }

    public final void calcTextSize(@NotNull Paint paint, @NotNull String demoText, @NotNull FSize outputFSize) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)demoText, (String)"demoText");
        Intrinsics.checkNotNullParameter((Object)outputFSize, (String)"outputFSize");
        Rect r = mCalcTextSizeRect;
        r.set(0, 0, 0, 0);
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        outputFSize.setWidth(r.width());
        outputFSize.setHeight(r.height());
    }

    @NotNull
    public final int[] getPOW_10() {
        return POW_10;
    }

    @NotNull
    public final IValueFormatter getDefaultValueFormatter() {
        return defaultValueFormatter;
    }

    private final IValueFormatter generateDefaultValueFormatter() {
        return new DefaultValueFormatter(1);
    }

    @NotNull
    public final MPPointF getPosition(@NotNull MPPointF center, float dist, float angle) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        MPPointF p = MPPointF.Companion.getInstance(0.0f, 0.0f);
        this.getPosition(center, dist, angle, p);
        return p;
    }

    public final void getPosition(@NotNull MPPointF center, float dist, float angle, @NotNull MPPointF outputPoint) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)outputPoint, (String)"outputPoint");
        outputPoint.setX((float)((double)center.getX() + (double)dist * Math.cos(Math.toRadians(angle))));
        outputPoint.setY((float)((double)center.getY() + (double)dist * Math.sin(Math.toRadians(angle))));
    }

    public final void velocityTrackerPointerUpCleanUpIfNecessary(@NotNull MotionEvent ev, @NotNull VelocityTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        tracker.computeCurrentVelocity(1000, (float)maximumFlingVelocity);
        int upIndex = ev.getActionIndex();
        int id1 = ev.getPointerId(upIndex);
        float x1 = tracker.getXVelocity(id1);
        float y1 = tracker.getYVelocity(id1);
        int i = 0;
        int count = ev.getPointerCount();
        while (i < count) {
            float y;
            if (i == upIndex) {
                ++i;
                continue;
            }
            int id2 = ev.getPointerId(i);
            float x = x1 * tracker.getXVelocity(id2);
            float dot = x + (y = y1 * tracker.getYVelocity(id2));
            if (dot < 0.0f) {
                tracker.clear();
                break;
            }
            ++i;
        }
    }

    public final float getNormalizedAngle(float angle) {
        float angle2;
        for (angle2 = angle; angle2 < 0.0f; angle2 += 360.0f) {
        }
        return angle2 % 360.0f;
    }

    public final void drawImage(@NotNull Canvas canvas, @NotNull Drawable drawable, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        MPPointF drawOffset = MPPointF.Companion.getInstance();
        drawOffset.setX((float)x - (float)(width / 2));
        drawOffset.setY((float)y - (float)(height / 2));
        drawable.copyBounds(mDrawableBoundsCache);
        drawable.setBounds(Utils.mDrawableBoundsCache.left, Utils.mDrawableBoundsCache.top, Utils.mDrawableBoundsCache.left + width, Utils.mDrawableBoundsCache.top + width);
        int saveId = canvas.save();
        canvas.translate(drawOffset.getX(), drawOffset.getY());
        drawable.draw(canvas);
        canvas.restoreToCount(saveId);
    }

    public final void drawXAxisValue(@NotNull Canvas canvas, @NotNull String text, float x, float y, @NotNull Paint paint, @NotNull MPPointF anchor, float angleDegrees) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        float drawOffsetX = 0.0f;
        float drawOffsetY = 0.0f;
        float lineHeight = paint.getFontMetrics(mFontMetricsBuffer);
        paint.getTextBounds(text, 0, text.length(), mDrawTextRectBuffer);
        drawOffsetX -= (float)Utils.mDrawTextRectBuffer.left;
        drawOffsetY -= Utils.mFontMetricsBuffer.ascent;
        Paint.Align originalTextAlign = paint.getTextAlign();
        paint.setTextAlign(Paint.Align.LEFT);
        if (!(angleDegrees == 0.0f)) {
            drawOffsetX -= (float)mDrawTextRectBuffer.width() * 0.5f;
            drawOffsetY -= lineHeight * 0.5f;
            float translateX = x;
            float translateY = y;
            if (!(anchor.getX() == 0.5f) || !(anchor.getY() == 0.5f)) {
                FSize rotatedSize = this.getSizeOfRotatedRectangleByDegrees(mDrawTextRectBuffer.width(), lineHeight, angleDegrees);
                translateX -= rotatedSize.getWidth() * (anchor.getX() - 0.5f);
                translateY -= rotatedSize.getHeight() * (anchor.getY() - 0.5f);
                FSize.Companion.recycleInstance(rotatedSize);
            }
            canvas.save();
            canvas.translate(translateX, translateY);
            canvas.rotate(angleDegrees);
            canvas.drawText(text, drawOffsetX, drawOffsetY, paint);
            canvas.restore();
        } else {
            if (!(anchor.getX() == 0.0f) || !(anchor.getY() == 0.0f)) {
                drawOffsetX -= (float)mDrawTextRectBuffer.width() * anchor.getX();
                drawOffsetY -= lineHeight * anchor.getY();
            }
            canvas.drawText(text, drawOffsetX += x, drawOffsetY += y, paint);
        }
        paint.setTextAlign(originalTextAlign);
    }

    @NotNull
    public final FSize getSizeOfRotatedRectangleByDegrees(float rectangleWidth, float rectangleHeight, float degrees) {
        float radians = degrees * FDEG2RAD;
        return this.getSizeOfRotatedRectangleByRadians(rectangleWidth, rectangleHeight, radians);
    }

    @NotNull
    public final FSize getSizeOfRotatedRectangleByRadians(float rectangleWidth, float rectangleHeight, float radians) {
        return FSize.Companion.getInstance(Math.abs(rectangleWidth * (float)Math.cos(radians)) + Math.abs(rectangleHeight * (float)Math.sin(radians)), Math.abs(rectangleWidth * (float)Math.sin(radians)) + Math.abs(rectangleHeight * (float)Math.cos(radians)));
    }

    static {
        int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        POW_10 = nArray;
        defaultValueFormatter = INSTANCE.generateDefaultValueFormatter();
        mDrawableBoundsCache = new Rect();
        mDrawTextRectBuffer = new Rect();
        mFontMetricsBuffer = new Paint.FontMetrics();
    }
}

