/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.renderer.scatter.IShapeRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/github/mikephil/charting/renderer/ScatterChartRenderer;", "Lcom/github/mikephil/charting/renderer/LineScatterCandleRadarRenderer;", "dataProvider", "Lcom/github/mikephil/charting/interfaces/dataprovider/ScatterDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/ScatterDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "pixelBuffer", "", "getPixelBuffer", "()[F", "setPixelBuffer", "([F)V", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IScatterDataSet;", "drawValues", "drawExtras", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "MPChartLib_release"})
public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    @JvmField
    @NotNull
    public ScatterDataProvider dataProvider;
    @NotNull
    private float[] pixelBuffer;

    public ScatterChartRenderer(@NotNull ScatterDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.pixelBuffer = new float[2];
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block1: {
            ScatterData scatterData;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            ScatterData scatterData2 = scatterData = this.dataProvider.getScatterData();
            if (scatterData2 == null) break block1;
            ScatterData it = scatterData2;
            boolean bl = false;
            List list = it.getDataSets();
            Intrinsics.checkNotNull(list);
            for (IScatterDataSet set : list) {
                if (!set.isVisible()) continue;
                this.drawDataSet(canvas, set);
            }
        }
    }

    @NotNull
    public final float[] getPixelBuffer() {
        return this.pixelBuffer;
    }

    public final void setPixelBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.pixelBuffer = fArray;
    }

    protected final void drawDataSet(@NotNull Canvas canvas, @NotNull IScatterDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        ViewPortHandler viewPortHandler = this.viewPortHandler;
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.animator.getPhaseY();
        IShapeRenderer renderer = dataSet.getShapeRenderer();
        if (renderer == null) {
            Timber.Forest.i("There's no IShapeRenderer specified for ScatterDataSet", new Object[0]);
            return;
        }
        int max = (int)Math.min(Math.ceil((float)dataSet.getEntryCount() * this.animator.getPhaseX()), (double)dataSet.getEntryCount());
        for (int i = 0; i < max; ++i) {
            Object entry;
            if (dataSet.getEntryForIndex(i) == null) continue;
            boolean bl = false;
            this.pixelBuffer[0] = ((Entry)entry).getX();
            this.pixelBuffer[1] = ((BaseEntry)entry).getY() * phaseY;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(this.pixelBuffer);
            if (!viewPortHandler.isInBoundsRight(this.pixelBuffer[0])) break;
            if (!viewPortHandler.isInBoundsLeft(this.pixelBuffer[0]) || !viewPortHandler.isInBoundsY(this.pixelBuffer[1])) continue;
            this.getPaintRender().setColor(dataSet.getColorByIndex(i / 2));
            renderer.renderShape(canvas, dataSet, this.viewPortHandler, this.pixelBuffer[0], this.pixelBuffer[1], this.getPaintRender());
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block8;
            ScatterData scatterData = this.dataProvider.getScatterData();
            if (scatterData != null) {
                ScatterData scatterData2 = scatterData;
                boolean bl = false;
                int n = scatterData2.getDataSetCount();
                for (int i = 0; i < n; ++i) {
                    List list = scatterData2.getDataSets();
                    Intrinsics.checkNotNull(list);
                    IScatterDataSet dataSet = (IScatterDataSet)list.get(i);
                    if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                    this.applyValueTextStyle(dataSet);
                    this.getXBounds().set(this.dataProvider, dataSet);
                    Transformer transformer = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                    Intrinsics.checkNotNull((Object)transformer);
                    float[] positions = transformer.generateTransformedValuesScatter(dataSet, this.animator.getPhaseX(), this.animator.getPhaseY(), this.getXBounds().getMin(), this.getXBounds().getMax());
                    float shapeSize = UtilsKtKt.convertDpToPixel(dataSet.getScatterShapeSize());
                    MPPointF iconsOffset = MPPointF.Companion.getInstance(dataSet.getIconsOffset());
                    iconsOffset.setX(UtilsKtKt.convertDpToPixel(iconsOffset.getX()));
                    iconsOffset.setY(UtilsKtKt.convertDpToPixel(iconsOffset.getY()));
                    int j = 0;
                    while (j < positions.length && this.viewPortHandler.isInBoundsRight(positions[j])) {
                        if (!this.viewPortHandler.isInBoundsLeft(positions[j]) || !this.viewPortHandler.isInBoundsY(positions[j + 1])) {
                            j += 2;
                            continue;
                        }
                        if (dataSet.getEntryForIndex(j / 2 + this.getXBounds().getMin()) != null) {
                            Object entry;
                            boolean bl2 = false;
                            if (dataSet.isDrawValues()) {
                                this.drawValue(canvas, dataSet.getValueFormatter(), ((BaseEntry)entry).getY(), (Entry)entry, i, positions[j], positions[j + 1] - shapeSize, dataSet.getValueTextColor(j / 2 + this.getXBounds().getMin()));
                            }
                            if (((BaseEntry)entry).getIcon() != null && dataSet.isDrawIcons()) {
                                Drawable icon = ((BaseEntry)entry).getIcon();
                                if (icon != null) {
                                    Drawable it;
                                    boolean bl3 = false;
                                    Utils.INSTANCE.drawImage(canvas, it, (int)(positions[j] + iconsOffset.getX()), (int)(positions[j + 1] + iconsOffset.getY()));
                                }
                            }
                        }
                        j += 2;
                    }
                    MPPointF.Companion.recycleInstance(iconsOffset);
                }
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        ScatterData scatterData = this.dataProvider.getScatterData();
        for (Highlight high : indices) {
            Object entry;
            IScatterDataSet set;
            ScatterData scatterData2 = scatterData;
            IScatterDataSet iScatterDataSet = set = scatterData2 != null ? (IScatterDataSet)scatterData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlightEnabled()) continue;
            if (set.getEntryForXValue(high.getX(), high.getY()) == null) continue;
            boolean bl = false;
            if (!this.isInBoundsX(entry, set)) continue;
            Transformer transformer = this.dataProvider.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD pix = transformer.getPixelForValues(((Entry)entry).getX(), ((BaseEntry)entry).getY() * this.animator.getPhaseY());
            high.setDraw((float)pix.getX(), (float)pix.getY());
            this.drawHighlightLines(canvas, (float)pix.getX(), (float)pix.getY(), set);
        }
    }
}

