/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.animation;

import android.animation.TimeInterpolator;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\bV\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\\B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\nR\u0017\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\nR\u0017\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\nR\u0017\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0016\u0010\nR\u0017\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0019\u0010\nR\u0017\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001c\u0010\nR\u0017\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0003\u001a\u0004\b\u001f\u0010\nR\u0017\u0010 \u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0003\u001a\u0004\b\"\u0010\nR\u0017\u0010#\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u0003\u001a\u0004\b%\u0010\nR\u0017\u0010&\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u0003\u001a\u0004\b(\u0010\nR\u0017\u0010)\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0003\u001a\u0004\b+\u0010\nR\u0017\u0010,\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010\u0003\u001a\u0004\b.\u0010\nR\u0017\u0010/\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0003\u001a\u0004\b1\u0010\nR\u0017\u00102\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u0003\u001a\u0004\b4\u0010\nR\u0017\u00105\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u0010\u0003\u001a\u0004\b7\u0010\nR\u0017\u00108\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010\u0003\u001a\u0004\b:\u0010\nR\u0017\u0010;\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b<\u0010\u0003\u001a\u0004\b=\u0010\nR\u0017\u0010>\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b?\u0010\u0003\u001a\u0004\b@\u0010\nR\u0017\u0010A\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bB\u0010\u0003\u001a\u0004\bC\u0010\nR\u0017\u0010D\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bE\u0010\u0003\u001a\u0004\bF\u0010\nR\u0017\u0010G\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bH\u0010\u0003\u001a\u0004\bI\u0010\nR\u0017\u0010J\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bK\u0010\u0003\u001a\u0004\bL\u0010\nR\u0017\u0010M\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bN\u0010\u0003\u001a\u0004\bO\u0010\nR\u0017\u0010P\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bQ\u0010\u0003\u001a\u0004\bR\u0010\nR\u0017\u0010S\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bT\u0010\u0003\u001a\u0004\bU\u0010\nR\u0017\u0010V\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bW\u0010\u0003\u001a\u0004\bX\u0010\nR\u0017\u0010Y\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\bZ\u0010\u0003\u001a\u0004\b[\u0010\n\u00a8\u0006]"}, d2={"Lcom/github/mikephil/charting/animation/Easing;", "", "<init>", "()V", "DOUBLE_PI", "", "linear", "Lcom/github/mikephil/charting/animation/Easing$EasingFunction;", "getLinear$annotations", "getLinear", "()Lcom/github/mikephil/charting/animation/Easing$EasingFunction;", "easeInQuad", "getEaseInQuad$annotations", "getEaseInQuad", "easeOutQuad", "getEaseOutQuad$annotations", "getEaseOutQuad", "easeInOutQuad", "getEaseInOutQuad$annotations", "getEaseInOutQuad", "easeInCubic", "getEaseInCubic$annotations", "getEaseInCubic", "easeOutCubic", "getEaseOutCubic$annotations", "getEaseOutCubic", "easeInOutCubic", "getEaseInOutCubic$annotations", "getEaseInOutCubic", "easeInQuart", "getEaseInQuart$annotations", "getEaseInQuart", "easeOutQuart", "getEaseOutQuart$annotations", "getEaseOutQuart", "easeInOutQuart", "getEaseInOutQuart$annotations", "getEaseInOutQuart", "easeInSine", "getEaseInSine$annotations", "getEaseInSine", "easeOutSine", "getEaseOutSine$annotations", "getEaseOutSine", "easeInOutSine", "getEaseInOutSine$annotations", "getEaseInOutSine", "easeInExpo", "getEaseInExpo$annotations", "getEaseInExpo", "easeOutExpo", "getEaseOutExpo$annotations", "getEaseOutExpo", "easeInOutExpo", "getEaseInOutExpo$annotations", "getEaseInOutExpo", "easeInCirc", "getEaseInCirc$annotations", "getEaseInCirc", "easeOutCirc", "getEaseOutCirc$annotations", "getEaseOutCirc", "easeInOutCirc", "getEaseInOutCirc$annotations", "getEaseInOutCirc", "easeInElastic", "getEaseInElastic$annotations", "getEaseInElastic", "easeOutElastic", "getEaseOutElastic$annotations", "getEaseOutElastic", "easeInOutElastic", "getEaseInOutElastic$annotations", "getEaseInOutElastic", "easeInBack", "getEaseInBack$annotations", "getEaseInBack", "easeOutBack", "getEaseOutBack$annotations", "getEaseOutBack", "easeInOutBack", "getEaseInOutBack$annotations", "getEaseInOutBack", "easeInBounce", "getEaseInBounce$annotations", "getEaseInBounce", "easeOutBounce", "getEaseOutBounce$annotations", "getEaseOutBounce", "easeInOutBounce", "getEaseInOutBounce$annotations", "getEaseInOutBounce", "EasingFunction", "MPChartLib_release"})
@RequiresApi(value=11)
public final class Easing {
    @NotNull
    public static final Easing INSTANCE = new Easing();
    private static final float DOUBLE_PI = (float)Math.PI * 2;
    @NotNull
    private static final EasingFunction linear = new EasingFunction(){

        public float getInterpolation(float input) {
            return input;
        }
    };
    @NotNull
    private static final EasingFunction easeInQuad = new EasingFunction(){

        public float getInterpolation(float input) {
            return input * input;
        }
    };
    @NotNull
    private static final EasingFunction easeOutQuad = new EasingFunction(){

        public float getInterpolation(float input) {
            return -input * (input - 2.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInOutQuad = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2 = input;
            if ((input2 *= 2.0f) < 1.0f) {
                return 0.5f * input2 * input2;
            }
            return -0.5f * ((input2 += -1.0f) * (input2 - 2.0f) - 1.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInCubic = new EasingFunction(){

        public float getInterpolation(float input) {
            return (float)Math.pow(input, 3.0);
        }
    };
    @NotNull
    private static final EasingFunction easeOutCubic = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2;
            float f = input2 = input;
            input2 = f + -1.0f;
            return (float)Math.pow(input2, 3.0) + 1.0f;
        }
    };
    @NotNull
    private static final EasingFunction easeInOutCubic = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2 = input;
            if ((input2 *= 2.0f) < 1.0f) {
                return 0.5f * (float)Math.pow(input2, 3.0);
            }
            return 0.5f * ((float)Math.pow(input2 -= 2.0f, 3.0) + 2.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInQuart = new EasingFunction(){

        public float getInterpolation(float input) {
            return (float)Math.pow(input, 4.0);
        }
    };
    @NotNull
    private static final EasingFunction easeOutQuart = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2;
            float f = input2 = input;
            input2 = f + -1.0f;
            return -((float)Math.pow(input2, 4.0) - 1.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInOutQuart = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2 = input;
            if ((input2 *= 2.0f) < 1.0f) {
                return 0.5f * (float)Math.pow(input2, 4.0);
            }
            return -0.5f * ((float)Math.pow(input2 -= 2.0f, 4.0) - 2.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInSine = new EasingFunction(){

        public float getInterpolation(float input) {
            return -((float)Math.cos((double)input * 1.5707963267948966)) + 1.0f;
        }
    };
    @NotNull
    private static final EasingFunction easeOutSine = new EasingFunction(){

        public float getInterpolation(float input) {
            return (float)Math.sin((double)input * 1.5707963267948966);
        }
    };
    @NotNull
    private static final EasingFunction easeInOutSine = new EasingFunction(){

        public float getInterpolation(float input) {
            return -0.5f * ((float)Math.cos(Math.PI * (double)input) - 1.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInExpo = new EasingFunction(){

        public float getInterpolation(float input) {
            return input == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * (input - 1.0f));
        }
    };
    @NotNull
    private static final EasingFunction easeOutExpo = new EasingFunction(){

        public float getInterpolation(float input) {
            return input == 1.0f ? 1.0f : -((float)Math.pow(2.0, -10.0f * (input + 1.0f)));
        }
    };
    @NotNull
    private static final EasingFunction easeInOutExpo = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2 = input;
            if (input2 == 0.0f) {
                return 0.0f;
            }
            if (input2 == 1.0f) {
                return 1.0f;
            }
            if ((input2 *= 2.0f) < 1.0f) {
                return 0.5f * (float)Math.pow(2.0, 10.0f * (input2 - 1.0f));
            }
            double d = 2.0;
            double d2 = -10.0f * (input2 += -1.0f);
            return 0.5f * (-((float)Math.pow(d, d2)) + 2.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInCirc = new EasingFunction(){

        public float getInterpolation(float input) {
            return -((float)Math.sqrt(1.0f - input * input) - 1.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeOutCirc = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2;
            float f = input2 = input;
            input2 = f + -1.0f;
            return (float)Math.sqrt(1.0f - input2 * input2);
        }
    };
    @NotNull
    private static final EasingFunction easeInOutCirc = new EasingFunction(){

        /*
         * WARNING - void declaration
         */
        public float getInterpolation(float input) {
            void it;
            float input2 = 0.0f;
            input2 = input;
            if ((input2 *= 2.0f) < 1.0f) {
                return -0.5f * ((float)Math.sqrt(1.0f - input2 * input2) - 1.0f);
            }
            float f = 2.0f;
            float f2 = 1.0f;
            float f3 = 0.5f;
            boolean bl = false;
            float f4 = input2 -= it;
            return f3 * ((float)Math.sqrt(f2 - f4 * input2) + 1.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInElastic = new EasingFunction(){

        /*
         * WARNING - void declaration
         */
        public float getInterpolation(float input) {
            void it;
            float input2 = 0.0f;
            input2 = input;
            if (input2 == 0.0f) {
                return 0.0f;
            }
            if (input2 == 1.0f) {
                return 1.0f;
            }
            float p = 0.3f;
            float s = p / ((float)Math.PI * 2) * (float)Math.asin(1.0);
            double d = 2.0;
            float f = 1.0f;
            float f2 = 10.0f;
            boolean bl = false;
            float f3 = input2 -= it;
            double d2 = f2 * f3;
            return -((float)Math.pow(d, d2) * (float)Math.sin((input2 - s) * ((float)Math.PI * 2) / p));
        }
    };
    @NotNull
    private static final EasingFunction easeOutElastic = new EasingFunction(){

        public float getInterpolation(float input) {
            if (input == 0.0f) {
                return 0.0f;
            }
            if (input == 1.0f) {
                return 1.0f;
            }
            float p = 0.3f;
            float s = p / ((float)Math.PI * 2) * (float)Math.asin(1.0);
            return 1.0f + (float)Math.pow(2.0, -10.0f * input) * (float)Math.sin((input - s) * ((float)Math.PI * 2) / p);
        }
    };
    @NotNull
    private static final EasingFunction easeInOutElastic = new EasingFunction(){

        /*
         * WARNING - void declaration
         */
        public float getInterpolation(float input) {
            float input2 = 0.0f;
            input2 = input;
            if (input2 == 0.0f) {
                return 0.0f;
            }
            if ((input2 *= 2.0f) == 2.0f) {
                return 1.0f;
            }
            float p = 2.2222223f;
            float s = 0.07161972f * (float)Math.asin(1.0);
            if (input2 < 1.0f) {
                void it;
                double d = 2.0;
                float f = 1.0f;
                float f2 = 10.0f;
                float f3 = -0.5f;
                boolean bl = false;
                float f4 = input2 -= it;
                double d2 = f2 * f4;
                return f3 * ((float)Math.pow(d, d2) * (float)Math.sin((input2 * 1.0f - s) * ((float)Math.PI * 2) * p));
            }
            double d = 2.0;
            float it = 1.0f;
            float f = -10.0f;
            float f5 = 0.5f;
            float f6 = 1.0f;
            boolean bl = false;
            float f7 = input2 -= it;
            double d3 = f * f7;
            return f6 + f5 * (float)Math.pow(d, d3) * (float)Math.sin((input2 * 1.0f - s) * ((float)Math.PI * 2) * p);
        }
    };
    @NotNull
    private static final EasingFunction easeInBack = new EasingFunction(){

        public float getInterpolation(float input) {
            float s = 1.70158f;
            return input * input * ((s + 1.0f) * input - s);
        }
    };
    @NotNull
    private static final EasingFunction easeOutBack = new EasingFunction(){

        public float getInterpolation(float input) {
            float input2 = input;
            float s = 1.70158f;
            float f = input2;
            input2 = f + -1.0f;
            return input2 * input2 * ((s + 1.0f) * input2 + s) + 1.0f;
        }
    };
    @NotNull
    private static final EasingFunction easeInOutBack = new EasingFunction(){

        /*
         * WARNING - void declaration
         */
        public float getInterpolation(float input) {
            float input2 = 0.0f;
            input2 = input;
            float s = 0.0f;
            s = 1.70158f;
            if ((input2 *= 2.0f) < 1.0f) {
                void it;
                float f = 1.525f;
                float f2 = input2 * input2;
                float f3 = 0.5f;
                boolean bl = false;
                float f4 = s *= it;
                return f3 * (f2 * ((f4 + 1.0f) * input2 - s));
            }
            float it = 2.0f;
            float f = 0.5f;
            boolean bl = false;
            float f5 = input2 -= it;
            it = 1.525f;
            boolean bl2 = false;
            float f6 = s *= it;
            return f * ((f5 *= input2) * ((f6 + 1.0f) * input2 + s) + 2.0f);
        }
    };
    @NotNull
    private static final EasingFunction easeInBounce = new EasingFunction(){

        public float getInterpolation(float input) {
            return 1.0f - Easing.INSTANCE.getEaseOutBounce().getInterpolation(1.0f - input);
        }
    };
    @NotNull
    private static final EasingFunction easeOutBounce = new EasingFunction(){

        /*
         * WARNING - void declaration
         */
        public float getInterpolation(float input) {
            float input2 = 0.0f;
            input2 = input;
            float s = 7.5625f;
            if (input2 < 0.36363637f) {
                return s * input2 * input2;
            }
            if (input2 < 0.72727275f) {
                void it;
                float f = 2.75f;
                float f2 = 1.5f;
                float f3 = s;
                boolean bl = false;
                float f4 = input2 -= it;
                return f3 * (f2 / f4) * input2 + 0.75f;
            }
            if (input2 < 0.90909094f) {
                float it = 2.75f;
                float f = 2.25f;
                float f5 = s;
                boolean bl = false;
                float f6 = input2 -= it;
                return f5 * (f / f6) * input2 + 0.9375f;
            }
            float it = 2.75f;
            float f = 2.625f;
            float f7 = s;
            boolean bl = false;
            float f8 = input2 -= it;
            return f7 * (f / f8) * input2 + 0.984375f;
        }
    };
    @NotNull
    private static final EasingFunction easeInOutBounce = new EasingFunction(){

        public float getInterpolation(float input) {
            if (input < 0.5f) {
                return Easing.INSTANCE.getEaseInBounce().getInterpolation(input * 2.0f) * 0.5f;
            }
            return Easing.INSTANCE.getEaseOutBounce().getInterpolation(input * 2.0f - 1.0f) * 0.5f + 0.5f;
        }
    };

    private Easing() {
    }

    @NotNull
    public final EasingFunction getLinear() {
        return linear;
    }

    public static /* synthetic */ void getLinear$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInQuad() {
        return easeInQuad;
    }

    public static /* synthetic */ void getEaseInQuad$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutQuad() {
        return easeOutQuad;
    }

    public static /* synthetic */ void getEaseOutQuad$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutQuad() {
        return easeInOutQuad;
    }

    public static /* synthetic */ void getEaseInOutQuad$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInCubic() {
        return easeInCubic;
    }

    public static /* synthetic */ void getEaseInCubic$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutCubic() {
        return easeOutCubic;
    }

    public static /* synthetic */ void getEaseOutCubic$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutCubic() {
        return easeInOutCubic;
    }

    public static /* synthetic */ void getEaseInOutCubic$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInQuart() {
        return easeInQuart;
    }

    public static /* synthetic */ void getEaseInQuart$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutQuart() {
        return easeOutQuart;
    }

    public static /* synthetic */ void getEaseOutQuart$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutQuart() {
        return easeInOutQuart;
    }

    public static /* synthetic */ void getEaseInOutQuart$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInSine() {
        return easeInSine;
    }

    public static /* synthetic */ void getEaseInSine$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutSine() {
        return easeOutSine;
    }

    public static /* synthetic */ void getEaseOutSine$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutSine() {
        return easeInOutSine;
    }

    public static /* synthetic */ void getEaseInOutSine$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInExpo() {
        return easeInExpo;
    }

    public static /* synthetic */ void getEaseInExpo$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutExpo() {
        return easeOutExpo;
    }

    public static /* synthetic */ void getEaseOutExpo$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutExpo() {
        return easeInOutExpo;
    }

    public static /* synthetic */ void getEaseInOutExpo$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInCirc() {
        return easeInCirc;
    }

    public static /* synthetic */ void getEaseInCirc$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutCirc() {
        return easeOutCirc;
    }

    public static /* synthetic */ void getEaseOutCirc$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutCirc() {
        return easeInOutCirc;
    }

    public static /* synthetic */ void getEaseInOutCirc$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInElastic() {
        return easeInElastic;
    }

    public static /* synthetic */ void getEaseInElastic$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutElastic() {
        return easeOutElastic;
    }

    public static /* synthetic */ void getEaseOutElastic$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutElastic() {
        return easeInOutElastic;
    }

    public static /* synthetic */ void getEaseInOutElastic$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInBack() {
        return easeInBack;
    }

    public static /* synthetic */ void getEaseInBack$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutBack() {
        return easeOutBack;
    }

    public static /* synthetic */ void getEaseOutBack$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutBack() {
        return easeInOutBack;
    }

    public static /* synthetic */ void getEaseInOutBack$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInBounce() {
        return easeInBounce;
    }

    public static /* synthetic */ void getEaseInBounce$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseOutBounce() {
        return easeOutBounce;
    }

    public static /* synthetic */ void getEaseOutBounce$annotations() {
    }

    @NotNull
    public final EasingFunction getEaseInOutBounce() {
        return easeInOutBounce;
    }

    public static /* synthetic */ void getEaseInOutBounce$annotations() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lcom/github/mikephil/charting/animation/Easing$EasingFunction;", "Landroid/animation/TimeInterpolator;", "getInterpolation", "", "input", "MPChartLib_release"})
    public static interface EasingFunction
    extends TimeInterpolator {
        public float getInterpolation(float var1);
    }
}

