/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.utils.UtilsKtKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0002EFB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u001a\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\b\u0010.\u001a\u00020(H\u0002JH\u0010/\u001a\u00020(2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u0002052\u0006\u00108\u001a\u0002052\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u000205J(\u0010<\u001a\u00020(2\u0006\u00100\u001a\u0002012\u0006\u0010=\u001a\u00020>2\u0006\u00102\u001a\u0002032\b\u0010?\u001a\u0004\u0018\u00010@J\b\u0010D\u001a\u00020(H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010#\u001a\u0004\u0018\u00010\u00032\b\u0010#\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010)\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0014\u0010A\u001a\u00020B8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010C\u00a8\u0006G"}, d2={"Lcom/github/mikephil/charting/utils/Fill;", "", "startColor", "", "endColor", "<init>", "(II)V", "type", "Lcom/github/mikephil/charting/utils/Fill$Type;", "getType", "()Lcom/github/mikephil/charting/utils/Fill$Type;", "setType", "(Lcom/github/mikephil/charting/utils/Fill$Type;)V", "mColor", "Ljava/lang/Integer;", "mFinalColor", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "gradientColors", "", "getGradientColors", "()[I", "setGradientColors", "([I)V", "gradientPositions", "", "getGradientPositions", "()[F", "setGradientPositions", "([F)V", "mAlpha", "color", "getColor", "()Ljava/lang/Integer;", "setColor", "(Ljava/lang/Integer;)V", "", "alpha", "getAlpha", "()I", "setAlpha", "(I)V", "calculateFinalColor", "fillRect", "c", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "left", "", "top", "right", "bottom", "gradientDirection", "Lcom/github/mikephil/charting/utils/Fill$Direction;", "mRoundedBarRadius", "fillPath", "path", "Landroid/graphics/Path;", "clipRect", "Landroid/graphics/RectF;", "isClipPathSupported", "", "()Z", "ensureClipPathSupported", "Type", "Direction", "MPChartLib_release"})
public class Fill {
    @NotNull
    private Type type = Type.LINEAR_GRADIENT;
    @Nullable
    private Integer mColor;
    @Nullable
    private Integer mFinalColor;
    @Nullable
    private Drawable drawable;
    @Nullable
    private int[] gradientColors;
    @Nullable
    private float[] gradientPositions;
    private int mAlpha = 255;

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.type = type;
    }

    @Nullable
    protected final Drawable getDrawable() {
        return this.drawable;
    }

    protected final void setDrawable(@Nullable Drawable drawable) {
        this.drawable = drawable;
    }

    @Nullable
    public final int[] getGradientColors() {
        return this.gradientColors;
    }

    public final void setGradientColors(@Nullable int[] nArray) {
        this.gradientColors = nArray;
    }

    @Nullable
    public final float[] getGradientPositions() {
        return this.gradientPositions;
    }

    public final void setGradientPositions(@Nullable float[] fArray) {
        this.gradientPositions = fArray;
    }

    public Fill(int startColor, int endColor) {
        int[] nArray = new int[]{startColor, endColor};
        this.gradientColors = nArray;
    }

    @Nullable
    public final Integer getColor() {
        return this.mColor;
    }

    public final void setColor(@Nullable Integer color) {
        this.mColor = color;
        this.calculateFinalColor();
    }

    public final void setGradientColors(int startColor, int endColor) {
        int[] nArray = new int[]{startColor, endColor};
        this.gradientColors = nArray;
    }

    public final int getAlpha() {
        return this.mAlpha;
    }

    public final void setAlpha(int alpha) {
        this.mAlpha = alpha;
        this.calculateFinalColor();
    }

    private final void calculateFinalColor() {
        if (this.mColor == null) {
            this.mFinalColor = null;
        } else {
            Integer n = this.mColor;
            Intrinsics.checkNotNull((Object)n);
            int alpha = (int)Math.floor((double)(n >> 24) / 255.0 * ((double)this.mAlpha / 255.0) * 255.0);
            Integer n2 = this.mColor;
            Intrinsics.checkNotNull((Object)n2);
            this.mFinalColor = alpha << 24 | n2 & 0xFFFFFF;
        }
    }

    public final void fillRect(@NotNull Canvas c, @NotNull Paint paint, float left, float top, float right, float bottom, @Nullable Direction gradientDirection, float mRoundedBarRadius) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        switch (WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                if (this.mFinalColor == null) {
                    return;
                }
                if (this.isClipPathSupported()) {
                    int save = c.save();
                    c.clipRect(left, top, right, bottom);
                    Integer n = this.mFinalColor;
                    Intrinsics.checkNotNull((Object)n);
                    c.drawColor(n.intValue());
                    c.restoreToCount(save);
                    break;
                }
                Paint.Style previous = paint.getStyle();
                int previousColor = paint.getColor();
                paint.setStyle(Paint.Style.FILL);
                Integer n = this.mFinalColor;
                Intrinsics.checkNotNull((Object)n);
                paint.setColor(n.intValue());
                c.drawRoundRect(new RectF(left, top, right, bottom), mRoundedBarRadius, mRoundedBarRadius, paint);
                paint.setColor(previousColor);
                paint.setStyle(previous);
                break;
            }
            case 3: {
                float f = (int)(gradientDirection == Direction.RIGHT ? right : left);
                float f2 = (int)(gradientDirection == Direction.UP ? bottom : top);
                Direction direction = gradientDirection;
                float f3 = (int)(switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                    case 1 -> left;
                    case 2 -> right;
                    default -> left;
                });
                Direction direction2 = gradientDirection;
                float f4 = (int)(switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                    case 3 -> top;
                    case 4 -> bottom;
                    default -> top;
                });
                Intrinsics.checkNotNull((Object)this.gradientColors);
                LinearGradient gradient = new LinearGradient(f, f2, f3, f4, this.gradientColors, this.gradientPositions, Shader.TileMode.MIRROR);
                paint.setShader((Shader)gradient);
                c.drawRoundRect(new RectF(left, top, right, bottom), mRoundedBarRadius, mRoundedBarRadius, paint);
                break;
            }
            case 4: {
                if (this.drawable == null) {
                    return;
                }
                Drawable drawable = this.drawable;
                Intrinsics.checkNotNull((Object)drawable);
                drawable.setBounds((int)left, (int)top, (int)right, (int)bottom);
                Drawable drawable2 = this.drawable;
                Intrinsics.checkNotNull((Object)drawable2);
                drawable2.draw(c);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void fillPath(@NotNull Canvas c, @NotNull Path path, @NotNull Paint paint, @Nullable RectF clipRect) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        switch (WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                if (this.mFinalColor == null) {
                    return;
                }
                if (clipRect != null && this.isClipPathSupported()) {
                    int save = c.save();
                    c.clipPath(path);
                    Integer n = this.mFinalColor;
                    Intrinsics.checkNotNull((Object)n);
                    c.drawColor(n.intValue());
                    c.restoreToCount(save);
                    break;
                }
                Paint.Style previous = paint.getStyle();
                int previousColor = paint.getColor();
                paint.setStyle(Paint.Style.FILL);
                Integer n = this.mFinalColor;
                Intrinsics.checkNotNull((Object)n);
                paint.setColor(n.intValue());
                c.drawPath(path, paint);
                paint.setColor(previousColor);
                paint.setStyle(previous);
                break;
            }
            case 3: {
                float f = c.getWidth();
                float f2 = c.getHeight();
                Intrinsics.checkNotNull((Object)this.gradientColors);
                LinearGradient gradient = new LinearGradient(0.0f, 0.0f, f, f2, this.gradientColors, this.gradientPositions, Shader.TileMode.MIRROR);
                paint.setShader((Shader)gradient);
                c.drawPath(path, paint);
                break;
            }
            case 4: {
                if (this.drawable == null) {
                    return;
                }
                this.ensureClipPathSupported();
                int save = c.save();
                c.clipPath(path);
                Drawable drawable = this.drawable;
                Intrinsics.checkNotNull((Object)drawable);
                RectF rectF = clipRect;
                RectF rectF2 = clipRect;
                RectF rectF3 = clipRect;
                RectF rectF4 = clipRect;
                drawable.setBounds(rectF == null ? 0 : (int)rectF.left, rectF2 == null ? 0 : (int)rectF2.top, rectF3 == null ? c.getWidth() : (int)rectF3.right, rectF4 == null ? c.getHeight() : (int)rectF4.bottom);
                Drawable drawable2 = this.drawable;
                Intrinsics.checkNotNull((Object)drawable2);
                drawable2.draw(c);
                c.restoreToCount(save);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean isClipPathSupported() {
        return UtilsKtKt.getSDKInt() >= 18;
    }

    private final void ensureClipPathSupported() {
        if (UtilsKtKt.getSDKInt() < 18) {
            throw new RuntimeException("Fill-drawables not (yet) supported below API level 18, this code was run on API level ${getSDKInt()}");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/github/mikephil/charting/utils/Fill$Direction;", "", "<init>", "(Ljava/lang/String;I)V", "DOWN", "UP", "RIGHT", "LEFT", "MPChartLib_release"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction DOWN = new Direction();
        public static final /* enum */ Direction UP = new Direction();
        public static final /* enum */ Direction RIGHT = new Direction();
        public static final /* enum */ Direction LEFT = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.DOWN, Direction.UP, Direction.RIGHT, Direction.LEFT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/github/mikephil/charting/utils/Fill$Type;", "", "<init>", "(Ljava/lang/String;I)V", "EMPTY", "COLOR", "LINEAR_GRADIENT", "DRAWABLE", "MPChartLib_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type EMPTY = new Type();
        public static final /* enum */ Type COLOR = new Type();
        public static final /* enum */ Type LINEAR_GRADIENT = new Type();
        public static final /* enum */ Type DRAWABLE = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.EMPTY, Type.COLOR, Type.LINEAR_GRADIENT, Type.DRAWABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Type.values().length];
            try {
                nArray[Type.EMPTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.COLOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LINEAR_GRADIENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.DRAWABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

