/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer.scatter;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.scatter.IShapeRenderer;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/github/mikephil/charting/renderer/scatter/TriangleShapeRenderer;", "Lcom/github/mikephil/charting/renderer/scatter/IShapeRenderer;", "<init>", "()V", "trianglePathBuffer", "Landroid/graphics/Path;", "getTrianglePathBuffer", "()Landroid/graphics/Path;", "setTrianglePathBuffer", "(Landroid/graphics/Path;)V", "renderShape", "", "canvas", "Landroid/graphics/Canvas;", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IScatterDataSet;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "posX", "", "posY", "renderPaint", "Landroid/graphics/Paint;", "MPChartLib_release"})
public class TriangleShapeRenderer
implements IShapeRenderer {
    @NotNull
    private Path trianglePathBuffer = new Path();

    @NotNull
    protected final Path getTrianglePathBuffer() {
        return this.trianglePathBuffer;
    }

    protected final void setTrianglePathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.trianglePathBuffer = path;
    }

    @Override
    public void renderShape(@NotNull Canvas canvas, @NotNull IScatterDataSet dataSet, @Nullable ViewPortHandler viewPortHandler, float posX, float posY, @NotNull Paint renderPaint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Intrinsics.checkNotNullParameter((Object)renderPaint, (String)"renderPaint");
        float shapeSize = UtilsKtKt.convertDpToPixel(dataSet.getScatterShapeSize());
        float shapeHalf = shapeSize / 2.0f;
        float shapeHoleSizeHalf = UtilsKtKt.convertDpToPixel(dataSet.getScatterShapeHoleRadius());
        float shapeHoleSize = shapeHoleSizeHalf * 2.0f;
        float shapeStrokeSize = (shapeSize - shapeHoleSize) / 2.0f;
        int shapeHoleColor = dataSet.getScatterShapeHoleColor();
        renderPaint.setStyle(Paint.Style.FILL);
        Path tri = this.trianglePathBuffer;
        tri.reset();
        tri.moveTo(posX, posY - shapeHalf);
        tri.lineTo(posX + shapeHalf, posY + shapeHalf);
        tri.lineTo(posX - shapeHalf, posY + shapeHalf);
        if ((double)shapeSize > 0.0) {
            tri.lineTo(posX, posY - shapeHalf);
            tri.moveTo(posX - shapeHalf + shapeStrokeSize, posY + shapeHalf - shapeStrokeSize);
            tri.lineTo(posX + shapeHalf - shapeStrokeSize, posY + shapeHalf - shapeStrokeSize);
            tri.lineTo(posX, posY - shapeHalf + shapeStrokeSize);
            tri.lineTo(posX - shapeHalf + shapeStrokeSize, posY + shapeHalf - shapeStrokeSize);
        }
        tri.close();
        canvas.drawPath(tri, renderPaint);
        tri.reset();
        if ((double)shapeSize > 0.0 && shapeHoleColor != 0x112233) {
            renderPaint.setColor(shapeHoleColor);
            tri.moveTo(posX, posY - shapeHalf + shapeStrokeSize);
            tri.lineTo(posX + shapeHalf - shapeStrokeSize, posY + shapeHalf - shapeStrokeSize);
            tri.lineTo(posX - shapeHalf + shapeStrokeSize, posY + shapeHalf - shapeStrokeSize);
            tri.close();
            canvas.drawPath(tri, renderPaint);
            tri.reset();
        }
    }
}

