/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import com.github.mikephil.charting.renderer.XAxisRenderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0014J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J(\u0010#\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u000bH\u0014J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/github/mikephil/charting/renderer/XAxisRendererHorizontalBarChart;", "Lcom/github/mikephil/charting/renderer/XAxisRenderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "xAxis", "Lcom/github/mikephil/charting/components/XAxis;", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/XAxis;Lcom/github/mikephil/charting/utils/Transformer;)V", "renderLimitLinesPathBuffer", "Landroid/graphics/Path;", "getRenderLimitLinesPathBuffer", "()Landroid/graphics/Path;", "setRenderLimitLinesPathBuffer", "(Landroid/graphics/Path;)V", "computeAxis", "", "min", "", "max", "inverted", "", "computeSize", "renderAxisLabels", "canvas", "Landroid/graphics/Canvas;", "drawLabels", "pos", "anchor", "Lcom/github/mikephil/charting/utils/MPPointF;", "gridClippingRect", "Landroid/graphics/RectF;", "getGridClippingRect", "()Landroid/graphics/RectF;", "drawGridLine", "x", "y", "gridLinePath", "renderAxisLine", "renderLimitLines", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nXAxisRendererHorizontalBarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XAxisRendererHorizontalBarChart.kt\ncom/github/mikephil/charting/renderer/XAxisRendererHorizontalBarChart\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,305:1\n27#2,7:306\n*S KotlinDebug\n*F\n+ 1 XAxisRendererHorizontalBarChart.kt\ncom/github/mikephil/charting/renderer/XAxisRendererHorizontalBarChart\n*L\n225#1:306,7\n*E\n"})
public class XAxisRendererHorizontalBarChart
extends XAxisRenderer {
    @NotNull
    private Path renderLimitLinesPathBuffer;

    public XAxisRendererHorizontalBarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull XAxis xAxis, @Nullable Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"xAxis");
        super(viewPortHandler, xAxis, trans);
        this.renderLimitLinesPathBuffer = new Path();
    }

    @NotNull
    protected final Path getRenderLimitLinesPathBuffer() {
        return this.renderLimitLinesPathBuffer;
    }

    protected final void setRenderLimitLinesPathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.renderLimitLinesPathBuffer = path;
    }

    @Override
    public void computeAxis(float min, float max, boolean inverted) {
        float minLocal = min;
        float maxLocal = max;
        if (this.viewPortHandler.contentWidth() > 10.0f && !this.viewPortHandler.isFullyZoomedOutY()) {
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD p1 = transformer.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentBottom());
            Transformer transformer2 = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer2);
            MPPointD p2 = transformer2.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop());
            if (inverted) {
                minLocal = (float)p2.getY();
                maxLocal = (float)p1.getY();
            } else {
                minLocal = (float)p1.getY();
                maxLocal = (float)p2.getY();
            }
            MPPointD.Companion.recycleInstance(p1);
            MPPointD.Companion.recycleInstance(p2);
        }
        this.computeAxisValues(minLocal, maxLocal);
    }

    @Override
    protected void computeSize() {
        this.getPaintAxisLabels().setTypeface(this.getXAxis().getTypeface());
        this.getPaintAxisLabels().setTextSize(this.getXAxis().getTextSize());
        String longest = this.getXAxis().getLongestLabel();
        FSize labelSize = Utils.INSTANCE.calcTextSize(this.getPaintAxisLabels(), longest);
        float labelWidth = (int)(labelSize.getWidth() + this.getXAxis().getXOffset() * 3.5f);
        float labelHeight = labelSize.getHeight();
        FSize labelRotatedSize = Utils.INSTANCE.getSizeOfRotatedRectangleByDegrees(labelWidth, labelHeight, this.getXAxis().getLabelRotationAngle());
        this.getXAxis().mLabelWidth = MathKt.roundToInt((float)labelRotatedSize.getWidth());
        this.getXAxis().mLabelHeight = MathKt.roundToInt((float)labelRotatedSize.getHeight());
        FSize.Companion.recycleInstance(labelRotatedSize);
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.getXAxis().isEnabled() || !this.getXAxis().isDrawLabelsEnabled()) {
            return;
        }
        float xOffset = this.getXAxis().getXOffset();
        this.getPaintAxisLabels().setTypeface(this.getXAxis().getTypeface());
        this.getPaintAxisLabels().setTextSize(this.getXAxis().getTextSize());
        this.getPaintAxisLabels().setColor(this.getXAxis().getTextColor());
        MPPointF pointF = MPPointF.Companion.getInstance(0.0f, 0.0f);
        XAxis.XAxisPosition xAxisPosition = this.getXAxis().getPosition();
        switch (xAxisPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[xAxisPosition.ordinal()]) {
            case 1: {
                pointF.setX(0.0f);
                pointF.setY(0.5f);
                this.drawLabels(canvas, this.viewPortHandler.contentRight() + xOffset, pointF);
                break;
            }
            case 2: {
                pointF.setX(1.0f);
                pointF.setY(0.5f);
                this.drawLabels(canvas, this.viewPortHandler.contentRight() - xOffset, pointF);
                break;
            }
            case 3: {
                pointF.setX(1.0f);
                pointF.setY(0.5f);
                this.drawLabels(canvas, this.viewPortHandler.contentLeft() - xOffset, pointF);
                break;
            }
            case 4: {
                pointF.setX(1.0f);
                pointF.setY(0.5f);
                this.drawLabels(canvas, this.viewPortHandler.contentLeft() + xOffset, pointF);
                break;
            }
            default: {
                pointF.setX(0.0f);
                pointF.setY(0.5f);
                this.drawLabels(canvas, this.viewPortHandler.contentRight() + xOffset, pointF);
                pointF.setX(1.0f);
                pointF.setY(0.5f);
                this.drawLabels(canvas, this.viewPortHandler.contentLeft() - xOffset, pointF);
            }
        }
        MPPointF.Companion.recycleInstance(pointF);
    }

    @Override
    protected void drawLabels(@NotNull Canvas canvas, float pos, @NotNull MPPointF anchor) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        float labelRotationAngleDegrees = this.getXAxis().getLabelRotationAngle();
        boolean centeringEnabled = this.getXAxis().isCenterAxisLabelsEnabled();
        float[] positions = new float[this.getXAxis().entryCount * 2];
        XAxisRendererHorizontalBarChart $this$drawLabels_u24lambda_u240 = this;
        boolean bl = false;
        for (int i = 0; i < positions.length; i += 2) {
            positions[i + 1] = centeringEnabled ? $this$drawLabels_u24lambda_u240.getXAxis().getCenteredEntries()[i / 2] : $this$drawLabels_u24lambda_u240.getXAxis().getEntries()[i / 2];
        }
        Transformer transformer = this.getTransformer();
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(positions);
        for (int i = 0; i < positions.length; i += 2) {
            float y = positions[i + 1];
            if (!this.viewPortHandler.isInBoundsY(y)) continue;
            IAxisValueFormatter iAxisValueFormatter = this.getXAxis().getValueFormatter();
            String label = iAxisValueFormatter != null ? iAxisValueFormatter.getFormattedValue(this.getXAxis().getEntries()[i / 2], this.getXAxis()) : null;
            this.drawLabel(canvas, label, pos, y, anchor, labelRotationAngleDegrees);
        }
    }

    @Override
    @NotNull
    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.viewPortHandler.getContentRect());
        this.mGridClippingRect.inset(0.0f, -this.axis.getGridLineWidth());
        return this.mGridClippingRect;
    }

    @Override
    protected void drawGridLine(@NotNull Canvas canvas, float x, float y, @NotNull Path gridLinePath) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)gridLinePath, (String)"gridLinePath");
        gridLinePath.moveTo(this.viewPortHandler.contentRight(), y);
        gridLinePath.lineTo(this.viewPortHandler.contentLeft(), y);
        canvas.drawPath(gridLinePath, this.getPaintGrid());
        gridLinePath.reset();
    }

    @Override
    public void renderAxisLine(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.getXAxis().isDrawAxisLineEnabled() || !this.getXAxis().isEnabled()) {
            return;
        }
        this.getPaintAxisLine().setColor(this.getXAxis().getAxisLineColor());
        this.getPaintAxisLine().setStrokeWidth(this.getXAxis().getAxisLineWidth());
        if (this.getXAxis().getPosition() == XAxis.XAxisPosition.TOP || this.getXAxis().getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.getXAxis().getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.viewPortHandler.contentRight(), this.viewPortHandler.contentTop(), this.viewPortHandler.contentRight(), this.viewPortHandler.contentBottom(), this.getPaintAxisLine());
        }
        if (this.getXAxis().getPosition() == XAxis.XAxisPosition.BOTTOM || this.getXAxis().getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.getXAxis().getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop(), this.viewPortHandler.contentLeft(), this.viewPortHandler.contentBottom(), this.getPaintAxisLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        List<LimitLine> limitLines = this.getXAxis().getLimitLines();
        if (limitLines.isEmpty()) {
            return;
        }
        float[] pts = this.mRenderLimitLinesBuffer;
        pts[0] = 0.0f;
        pts[1] = 0.0f;
        Path limitLinePath = this.renderLimitLinesPathBuffer;
        limitLinePath.reset();
        int n = ((Collection)limitLines).size();
        for (int i = 0; i < n; ++i) {
            LimitLine limitLine = limitLines.get(i);
            if (!limitLine.isEnabled()) continue;
            Canvas $this$withSave$iv = canvas;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                LimitLine.LimitLabelPosition position;
                Canvas $this$renderLimitLines_u24lambda_u240 = $this$withSave$iv;
                boolean bl = false;
                this.mLimitLineClippingRect.set(this.viewPortHandler.getContentRect());
                this.mLimitLineClippingRect.inset(0.0f, -limitLine.getLineWidth());
                canvas.clipRect(this.mLimitLineClippingRect);
                this.limitLinePaint.setStyle(Paint.Style.STROKE);
                this.limitLinePaint.setColor(limitLine.getLineColor());
                this.limitLinePaint.setStrokeWidth(limitLine.getLineWidth());
                this.limitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
                pts[1] = limitLine.getLimit();
                Transformer transformer = this.getTransformer();
                Intrinsics.checkNotNull((Object)transformer);
                transformer.pointValuesToPixel(pts);
                limitLinePath.moveTo(this.viewPortHandler.contentLeft(), pts[1]);
                limitLinePath.lineTo(this.viewPortHandler.contentRight(), pts[1]);
                canvas.drawPath(limitLinePath, this.limitLinePaint);
                limitLinePath.reset();
                String label = limitLine.getLabel();
                if (label == null || Intrinsics.areEqual((Object)label, (Object)"")) continue;
                this.limitLinePaint.setStyle(limitLine.getTextStyle());
                this.limitLinePaint.setPathEffect(null);
                this.limitLinePaint.setColor(limitLine.getTextColor());
                this.limitLinePaint.setStrokeWidth(0.5f);
                this.limitLinePaint.setTextSize(limitLine.getTextSize());
                float labelLineHeight = Utils.INSTANCE.calcTextHeight(this.limitLinePaint, label);
                float xOffset = UtilsKtKt.convertDpToPixel(4.0f) + limitLine.getXOffset();
                float yOffset = limitLine.getLineWidth() + labelLineHeight + limitLine.getYOffset();
                LimitLine.LimitLabelPosition limitLabelPosition = position = limitLine.getLabelPosition();
                switch (limitLabelPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$1[limitLabelPosition.ordinal()]) {
                    case 1: {
                        this.limitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(label, this.viewPortHandler.contentRight() - xOffset, pts[1] - yOffset + labelLineHeight, this.limitLinePaint);
                        break;
                    }
                    case 2: {
                        this.limitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(label, this.viewPortHandler.contentRight() - xOffset, pts[1] + yOffset, this.limitLinePaint);
                        break;
                    }
                    case 3: {
                        this.limitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(label, this.viewPortHandler.contentLeft() + xOffset, pts[1] - yOffset + labelLineHeight, this.limitLinePaint);
                        break;
                    }
                    default: {
                        this.limitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(label, this.viewPortHandler.offsetLeft() + xOffset, pts[1] + yOffset, this.limitLinePaint);
                    }
                }
                continue;
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[XAxis.XAxisPosition.values().length];
            try {
                nArray[XAxis.XAxisPosition.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.TOP_INSIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LimitLine.LimitLabelPosition.values().length];
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.LEFT_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

