/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\rJ \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J#\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016\u00a2\u0006\u0002\u0010#J@\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020*H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/github/mikephil/charting/renderer/RoundedBarChartRenderer;", "Lcom/github/mikephil/charting/renderer/BarChartRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "mBarShadowRectBuffer", "Landroid/graphics/RectF;", "radius", "", "roundedShadowRadius", "roundedPositiveDataSetRadius", "roundedNegativeDataSetRadius", "setRoundedNegativeDataSetRadius", "", "roundedNegativeDataSet", "setRoundedShadowRadius", "roundedShadow", "setRoundedPositiveDataSetRadius", "roundedPositiveDataSet", "drawDataSet", "canvas", "Landroid/graphics/Canvas;", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "index", "", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "roundRect", "Landroid/graphics/Path;", "rect", "rx", "ry", "tl", "", "tr", "br", "bl", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nRoundedBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedBarChartRenderer.kt\ncom/github/mikephil/charting/renderer/RoundedBarChartRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
public final class RoundedBarChartRenderer
extends BarChartRenderer {
    @NotNull
    private final RectF mBarShadowRectBuffer;
    private final float radius;
    private float roundedShadowRadius;
    private float roundedPositiveDataSetRadius;
    private float roundedNegativeDataSetRadius;

    public RoundedBarChartRenderer(@NotNull BarDataProvider chart, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(chart, animator, viewPortHandler);
        this.mBarShadowRectBuffer = new RectF();
        this.radius = 20.0f;
    }

    public final void setRoundedNegativeDataSetRadius(float roundedNegativeDataSet) {
        this.roundedNegativeDataSetRadius = roundedNegativeDataSet;
    }

    public final void setRoundedShadowRadius(float roundedShadow) {
        this.roundedShadowRadius = roundedShadow;
    }

    public final void setRoundedPositiveDataSetRadius(float roundedPositiveDataSet) {
        this.roundedPositiveDataSetRadius = roundedPositiveDataSet;
    }

    @Override
    protected void drawDataSet(@NotNull Canvas canvas, @NotNull IBarDataSet dataSet, int index) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        this.initBuffers();
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        this.barBorderPaint.setColor(dataSet.getBarBorderColor());
        this.barBorderPaint.setStrokeWidth(UtilsKtKt.convertDpToPixel(dataSet.getBarBorderWidth()));
        this.shadowPaint.setColor(dataSet.getBarShadowColor());
        float phaseX = this.animator.getPhaseX();
        float phaseY = this.animator.getPhaseY();
        if (this.dataProvider.isDrawBarShadowEnabled()) {
            boolean isSingleColor;
            this.shadowPaint.setColor(dataSet.getBarShadowColor());
            BarData barData = this.dataProvider.getBarData();
            if (barData != null) {
                BarData barData2 = barData;
                boolean bl = false;
                float barWidth = barData2.getBarWidth();
                float barWidthHalf = barWidth / 2.0f;
                float x = 0.0f;
                int i = 0;
                double count = Math.min((double)((int)((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
                while ((double)i < count) {
                    if ((BarEntry)dataSet.getEntryForIndex(i) != null) {
                        BarEntry barEntry;
                        boolean bl2 = false;
                        x = barEntry.getX();
                        this.mBarShadowRectBuffer.left = x - barWidthHalf;
                        this.mBarShadowRectBuffer.right = x + barWidthHalf;
                    }
                    Transformer transformer = trans;
                    Intrinsics.checkNotNull((Object)transformer);
                    transformer.rectValueToPixel(this.mBarShadowRectBuffer);
                    if (!this.viewPortHandler.isInBoundsLeft(this.mBarShadowRectBuffer.right)) {
                        ++i;
                        continue;
                    }
                    if (this.viewPortHandler.isInBoundsRight(this.mBarShadowRectBuffer.left)) {
                        this.mBarShadowRectBuffer.top = this.viewPortHandler.contentTop();
                        this.mBarShadowRectBuffer.bottom = this.viewPortHandler.contentBottom();
                        if (this.roundedShadowRadius > 0.0f) {
                            canvas.drawRoundRect(this.barRect, this.roundedShadowRadius, this.roundedShadowRadius, this.shadowPaint);
                        } else {
                            canvas.drawRect(this.mBarShadowRectBuffer, this.shadowPaint);
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            Object e = this.barBuffers.get(index);
            Intrinsics.checkNotNull(e);
            BarBuffer buffer = (BarBuffer)e;
            buffer.setPhases(phaseX, phaseY);
            buffer.setDataSet(index);
            buffer.setInverted(this.dataProvider.isInverted(dataSet.getAxisDependency()));
            BarData barData3 = this.dataProvider.getBarData();
            if (barData3 != null) {
                BarData it = barData3;
                boolean bl = false;
                buffer.setBarWidth(it.getBarWidth());
            }
            buffer.feed(dataSet);
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(buffer.buffer);
            List<Integer> it = dataSet.getColors();
            boolean bl = false;
            if (it.size() > 1) {
                j = 0;
                while (j < buffer.size()) {
                    if (!this.viewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) {
                        j += 4;
                        continue;
                    }
                    if (this.viewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                        if (this.dataProvider.isDrawBarShadowEnabled()) {
                            if (this.roundedShadowRadius > 0.0f) {
                                canvas.drawRoundRect(new RectF(buffer.buffer[j], this.viewPortHandler.contentTop(), buffer.buffer[j + 2], this.viewPortHandler.contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.shadowPaint);
                            } else {
                                canvas.drawRect(buffer.buffer[j], this.viewPortHandler.contentTop(), buffer.buffer[j + 2], this.viewPortHandler.contentBottom(), this.shadowPaint);
                            }
                        }
                        this.getPaintRender().setColor(dataSet.getColorByIndex(j / 4));
                        if (this.roundedPositiveDataSetRadius > 0.0f) {
                            canvas.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.getPaintRender());
                        } else {
                            canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
                        }
                        j += 4;
                        continue;
                    }
                    break;
                }
            } else {
                this.getPaintRender().setColor(dataSet.getColor());
                j = 0;
                while (j < buffer.size()) {
                    if (!this.viewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) {
                        j += 4;
                        continue;
                    }
                    if (this.viewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                        if (this.dataProvider.isDrawBarShadowEnabled()) {
                            if (this.roundedShadowRadius > 0.0f) {
                                canvas.drawRoundRect(new RectF(buffer.buffer[j], this.viewPortHandler.contentTop(), buffer.buffer[j + 2], this.viewPortHandler.contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.shadowPaint);
                            } else {
                                canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
                            }
                        }
                        if (this.roundedPositiveDataSetRadius > 0.0f) {
                            canvas.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.getPaintRender());
                        } else {
                            canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
                        }
                        j += 4;
                        continue;
                    }
                    break;
                }
            }
            boolean bl3 = isSingleColor = dataSet.getColors().size() == 1;
            if (isSingleColor) {
                this.getPaintRender().setColor(dataSet.getColorByIndex(index));
            }
            int j = 0;
            while (j < buffer.size()) {
                if (!this.viewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) {
                    j += 4;
                    continue;
                }
                if (!this.viewPortHandler.isInBoundsRight(buffer.buffer[j])) break;
                if (!isSingleColor) {
                    this.getPaintRender().setColor(dataSet.getColorByIndex(j / 4));
                }
                this.getPaintRender().setShader((Shader)new LinearGradient(buffer.buffer[j], buffer.buffer[j + 3], buffer.buffer[j], buffer.buffer[j + 1], dataSet.getColorByIndex(j / 4), dataSet.getColorByIndex(j / 4), Shader.TileMode.MIRROR));
                this.getPaintRender().setShader((Shader)new LinearGradient(buffer.buffer[j], buffer.buffer[j + 3], buffer.buffer[j], buffer.buffer[j + 1], dataSet.getColorByIndex(j / 4), dataSet.getColorByIndex(j / 4), Shader.TileMode.MIRROR));
                if ((BarEntry)dataSet.getEntryForIndex(j / 4) != null) {
                    BarEntry barEntry;
                    boolean bl4 = false;
                    if (barEntry.getY() < 0.0f && this.roundedNegativeDataSetRadius > 0.0f) {
                        Path path2 = this.roundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedNegativeDataSetRadius, this.roundedNegativeDataSetRadius, true, true, true, true);
                        canvas.drawPath(path2, this.getPaintRender());
                    } else if (barEntry.getY() > 0.0f && this.roundedPositiveDataSetRadius > 0.0f) {
                        Path path2 = this.roundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, true, true, true, true);
                        canvas.drawPath(path2, this.getPaintRender());
                    } else {
                        canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
                    }
                }
                j += 4;
            }
        }
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            BarData barData = this.dataProvider.getBarData();
            if (barData == null) break block5;
            BarData barData2 = barData;
            boolean bl = false;
            for (Highlight high : indices) {
                BarEntry barEntry;
                IBarDataSet set = (IBarDataSet)barData2.getDataSetByIndex(high.getDataSetIndex());
                if (set == null || !set.isHighlightEnabled()) continue;
                if ((BarEntry)set.getEntryForXValue(high.getX(), high.getY()) == null) continue;
                boolean bl2 = false;
                if (!this.isInBoundsX((Entry)barEntry, set)) continue;
                Transformer trans = this.dataProvider.getTransformer(set.getAxisDependency());
                this.getPaintHighlight().setColor(set.getHighLightColor());
                this.getPaintHighlight().setAlpha(set.getHighLightAlpha());
                boolean isStack = high.getStackIndex() >= 0 && barEntry.isStacked();
                float y1 = 0.0f;
                float y2 = 0.0f;
                if (isStack) {
                    if (this.dataProvider.isHighlightFullBarEnabled()) {
                        y1 = barEntry.getPositiveSum();
                        y2 = -barEntry.getNegativeSum();
                    } else {
                        Range range = barEntry.getRanges()[high.getStackIndex()];
                        y1 = range.getFrom();
                        y2 = range.getTo();
                    }
                } else {
                    y1 = barEntry.getY();
                    y2 = 0.0f;
                }
                float f = barEntry.getX();
                float f2 = barData2.getBarWidth() / 2.0f;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                this.prepareBarHighlight(f, y1, y2, f2, transformer);
                this.setHighlightDrawPos(high, this.barRect);
                Path path2 = this.roundRect(new RectF(this.barRect.left, this.barRect.top, this.barRect.right, this.barRect.bottom), this.radius, this.radius, true, true, true, true);
                canvas.drawPath(path2, this.getPaintHighlight());
            }
        }
    }

    private final Path roundRect(RectF rect, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        float rx2 = rx;
        float ry2 = ry;
        float top = rect.top;
        float left = rect.left;
        float right = rect.right;
        float bottom = rect.bottom;
        Path path = new Path();
        if (rx2 < 0.0f) {
            rx2 = 0.0f;
        }
        if (ry2 < 0.0f) {
            ry2 = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx2 > width / (float)2) {
            rx2 = width / (float)2;
        }
        if (ry2 > height / (float)2) {
            ry2 = height / (float)2;
        }
        float widthMinusCorners = width - (float)2 * rx2;
        float heightMinusCorners = height - (float)2 * ry2;
        path.moveTo(right, top + ry2);
        if (tr) {
            path.rQuadTo(0.0f, -ry2, -rx2, -ry2);
        } else {
            path.rLineTo(0.0f, -ry2);
            path.rLineTo(-rx2, 0.0f);
        }
        path.rLineTo(-widthMinusCorners, 0.0f);
        if (tl) {
            path.rQuadTo(-rx2, 0.0f, -rx2, ry2);
        } else {
            path.rLineTo(-rx2, 0.0f);
            path.rLineTo(0.0f, ry2);
        }
        path.rLineTo(0.0f, heightMinusCorners);
        if (bl) {
            path.rQuadTo(0.0f, ry2, rx2, ry2);
        } else {
            path.rLineTo(0.0f, ry2);
            path.rLineTo(rx2, 0.0f);
        }
        path.rLineTo(widthMinusCorners, 0.0f);
        if (br) {
            path.rQuadTo(rx2, 0.0f, rx2, -ry2);
        } else {
            path.rLineTo(rx2, 0.0f);
            path.rLineTo(0.0f, -ry2);
        }
        path.rLineTo(0.0f, -heightMinusCorners);
        path.close();
        return path;
    }
}

